<?php
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("apotek/adapter/DaftarObatNarkotikAdapter.php");
	require_once("apotek/adapter/ObatPRAdapter.php");
	
	$daftar_obat_narkotik_table = new Table(
		array("Kode", "Nama Obat", "Jenis Obat"),
		"Depo Faramsi : Daftar Obat Narkotik",
		null,
		true
	);
	$daftar_obat_narkotik_table->setName("daftar_obat_narkotik");
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == 'daftar_obat_narkotik') {
		if (isset($_POST['command'])) {
			$daftar_obat_narkotik_adapter = new DaftarObatNarkotikAdapter();
			$daftar_obat_narkotik_dbtable = new DBTable($db, "smis_ap_irja_daftar_obat_narkotik");
			$daftar_obat_narkotik_dbresponder = new DBResponder(
				$daftar_obat_narkotik_dbtable,
				$daftar_obat_narkotik_table,
				$daftar_obat_narkotik_adapter
			);
			$data =  $daftar_obat_narkotik_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
	}
	
	// obat chooser:
	$obat_table = new Table(array("Kode", "Obat", "Jenis"));
	$obat_table->setName("don_obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new ObatPRAdapter();
	$obat_service_responder = new ServiceResponder(	$db, $obat_table, $obat_adapter, "get_daftar_barang_m");
	
	$super_command = new SuperCommand();
	$super_command->addResponder("don_obat", $obat_service_responder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	$daftar_obat_narkotik_table->addModal("id", "hidden", "", "");
	$daftar_obat_narkotik_table->addModal("id_obat", "hidden", "", "");
	$daftar_obat_narkotik_table->addModal("kode_obat", "hidden", "", "");
	$daftar_obat_narkotik_table->addModal("nama_obat", "chooser-daftar_obat_narkotik-don_obat", "Nama Obat", "", "", "y", true);
	$daftar_obat_narkotik_table->addModal("nama_jenis_obat", "text", "Jenis Obat", "", "", "y", true);
	
	$modal = $daftar_obat_narkotik_table->getModal();
	$modal->setTitle("Data Obat Narkotik");
	
	echo $modal->getHtml();
	echo $daftar_obat_narkotik_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function DONObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DONObatAction.prototype.constructor = DONObatAction;
	DONObatAction.prototype = new TableAction();
	DONObatAction.prototype.selected = function(json) {
		$("#daftar_obat_narkotik_id_obat").val(json.id);
		$("#daftar_obat_narkotik_kode_obat").val(json.kode);
		$("#daftar_obat_narkotik_nama_obat").val(json.nama);
		$("#daftar_obat_narkotik_nama_jenis_obat").val(json.nama_jenis_barang);
	};

	var daftar_obat_narkotik;
	var don_obat;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		don_obat = new DONObatAction(
			"don_obat",
			"apotek",
			"daftar_obat_narkotik",
			new Array()
		);
		don_obat.setSuperCommand("don_obat");
		var daftar_obat_narkotik_columns = new Array("id", "id_obat", "kode_obat", "nama_obat", "nama_jenis_obat");
		daftar_obat_narkotik = new TableAction(
			"daftar_obat_narkotik",
			"apotek",
			"daftar_obat_narkotik",
			daftar_obat_narkotik_columns
		);
		daftar_obat_narkotik.setSuperCommand("daftar_obat_narkotik");
		daftar_obat_narkotik.view();
	});
</script>