<?php 
	global $db;
	
	$form = new Form("form", "", "Apotek : Daftar Harga Obat");
	$embalase_text = new Text("dharga_obat_embalase", "dharga_obat_embalase", "0");
	$embalase_text->setTypical("money");
	$embalase_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\" ");
	$form->addElement("Embalase", $embalase_text);
	$tuslah_text = new Text("dharga_obat_tuslah", "dharga_obat_tuslah", "0");
	$tuslah_text->setTypical("money");
	$tuslah_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\" ");
	$form->addElement("Tuslah", $tuslah_text);
	$margin_text = new Text("dharga_obat_margin", "dharga_obat_margin", "0.2");
	$margin_text->setAtribute("disabled='disabled'");
	$form->addElement("Margin", $margin_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("dharga_obat.view()");
	$form->addElement("", $show_button);
	
	$table = new Table(
		array("No.", "Kode", "Nama Obat", "Jenis Obat", "Min. HPP", "Maks. HPP", "Margin", "Embalase", "Tuslah", "HJA"),
		"",
		null,
		true
	);
	$table->setName("dharga_obat");
	$table->setAction(false);
	
	if (isset($_POST['command'])) {
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("id", "id");
		$adapter->add("Kode", "kode_obat");
		$adapter->add("Nama Obat", "nama_obat");
		$adapter->add("Jenis Obat", "nama_jenis_obat");
		$adapter->add("Sisa", "sisa", "number");
		$adapter->add("Satuan", "satuan");
		$adapter->add("Jml. Terkecil", "konversi", "number");
		$adapter->add("Satuan Terkecil", "satuan_konversi");
		$adapter->add("Min. HPP", "min_hna", "money Rp. ");
		$adapter->add("Maks. HPP", "maks_hna", "money Rp. ");
		$adapter->add("Margin", "margin", "money Rp. ");
		$adapter->add("Embalase", "embalase", "money Rp. ");
		$adapter->add("Tuslah", "tuslah", "money Rp. ");
		$adapter->add("HJA", "hja", "money Rp. ");
		$dbtable = new DBTable($db, "smis_ap_irja_stok_obat");
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = " AND (kode_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '" . $_POST['kriteria'] . "')";
		}
		$query_value = "
			SELECT *
			FROM (
				SELECT smis_ap_irja_stok_obat.id_obat AS 'id', smis_ap_irja_stok_obat.kode_obat, 
					   smis_ap_irja_stok_obat.nama_obat, smis_ap_irja_stok_obat.nama_jenis_obat, SUM(smis_ap_irja_stok_obat.sisa) AS 'sisa', smis_ap_irja_stok_obat.satuan, smis_ap_irja_stok_obat.konversi, smis_ap_irja_stok_obat.satuan_konversi, MAX(smis_ap_irja_stok_obat.hna) AS 'maks_hna', MIN(smis_ap_irja_stok_obat.hna) AS 'min_hna', MAX(smis_ap_irja_stok_obat.hna) * " . $_POST['margin'] . " AS 'margin', " . $_POST['tuslah'] . " AS 'tuslah', " . $_POST['embalase'] . " AS 'embalase', (MAX(smis_ap_irja_stok_obat.hna) + MAX(smis_ap_irja_stok_obat.hna) * " . $_POST['margin'] . ") + " . $_POST['tuslah'] . " + " . $_POST['embalase'] . " AS 'hja'
				FROM smis_ap_irja_stok_obat LEFT JOIN smis_ap_irja_obat_masuk ON smis_ap_irja_stok_obat.id_obat_masuk = smis_ap_irja_obat_masuk.id
				WHERE smis_ap_irja_stok_obat.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.prop NOT LIKE 'del' AND smis_ap_irja_obat_masuk.status = 'sudah'
				GROUP BY id_obat, satuan, konversi, satuan_konversi
				ORDER BY nama_obat, nama_jenis_obat, satuan ASC
			) v_stok
			WHERE 1 " . $filter . "
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				" . $query_value . "
			) v_stok
			WHERE 1 " . $filter . "
		";
		$dbtable->setPreferredQuery(true, $query_value, $query_count);
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $form->getHtml();
	echo "<div id='table_content'>";
	echo $table->getHtml();
	echo "</div>";
	echo addJS("apotek/js/dharga_obat_action.js", false);	
	echo addJS("apotek/js/daftar_harga.js", false);
	echo addJS("framework/smis/js/table_action.js");
?>