<?php
require_once "smis-base/smis-include-synchronize-db.php";
require_once ("smis-base/smis-include-service-consumer.php");
require_once 'smis-libs-hrd/EmployeeResponder.php';
global $db;
$header=array ('Nama','Jabatan',"NIP" );
$dktable = new Table ( $header );
$dktable->setName ( "dokter" );
$dktable->setModel ( Table::$SELECT );
$dkadapter = new SimpleAdapter ();
$dkadapter->add ( "Jabatan", "nama_jabatan" );
$dkadapter->add ( "Nama", "nama" );
$dkadapter->add ( "NIP", "nip" );
$dokter = new EmployeeResponder ( $db, $dktable, $dkadapter, "dokter" );

$dktable = new Table ( $header );
$dktable->setName ( "perawat" );
$dktable->setModel ( Table::$SELECT );
$perawat = new EmployeeResponder ( $db, $dktable, $dkadapter, "perawat" );

$dktable = new Table ( $header );
$dktable->setName ( "supir" );
$dktable->setModel ( Table::$SELECT );
$supir = new EmployeeResponder ( $db, $dktable, $dkadapter, getSettings($db,"smis-ambulan-slug-supir","") );

$dktable = new Table ( array("Mobil","Plat","Keterangan") );
$dktable->setName ( "mobil_ambulan" );
$dktable->setModel ( Table::$SELECT );
$adapter=new SimpleAdapter();
$adapter->add("Mobil", "mobil");
$adapter->add("Plat", "nomor");
$adapter->add("Keterangan", "keterangan");
$dbtable=new DBTable($db, "smis_amb_mobil");
$mobil = new DBResponder ( $dbtable,$dktable, $adapter );

/* PASIEN */
$header=array ('Nama','NRM',"No Reg" );
$ptable = new Table ($header);
$ptable->setName ( "pasien" );
$ptable->setModel ( Table::$SELECT );
$padapter = new SimpleAdapter ();
$padapter->add ( "Nama", "nama_pasien" );
$padapter->add ( "NRM", "nrm", "digit8" );
$padapter->add ( "No Reg", "id" );
$presponder = new ServiceResponder ( $db, $ptable, $padapter, "get_registered" );

/* LOKASI */
$header=array ('Nama','Biaya',"Jasa Sopir" ,"Kondisi");
$lokasi = new Table ( $header );
$lokasi->setName ( "lokasi" );
$lokasi->setModel ( Table::$SELECT );
$padapter = new SimpleAdapter ();
$padapter->add ( "Nama", "lokasi" );
$padapter->add ( "Kondisi", "doa" );
$padapter->add ( "Biaya", "biaya", "money Rp." );
$padapter->add ( "Jasa Sopir", "jasa_supir", "money Rp." );
$lresponder = new ServiceResponder ( $db, $lokasi, $padapter, "get_ambulan" );

$super = new SuperCommand ();
$super->addResponder ( "dokter", $dokter );
$super->addResponder ( "perawat", $perawat );
$super->addResponder ( "supir", $supir );
$super->addResponder ( "pasien", $presponder );
$super->addResponder ( "lokasi", $lresponder );
$super->addResponder ( "mobil_ambulan", $mobil);
$init = $super->initialize ();
if ($init != null) {
	echo $init;
	return;
}
$header=array ('Tanggal','Supir','Biaya','Lokasi',"Kondisi");
$_synchronous=getSettings($db,"smis-ambulan-autosync-cashier","0")=="1";
$uitable=null;
$header=array ('Tanggal','Biaya','Keterangan');
if($_synchronous){
    $uitable = new TableSynchronous ( $header, "&nbsp;", NULL, true );
}else{
    $uitable = new Table ( $header, "&nbsp;", NULL, true );
}
$uitable->setName ( "ambulan" );
/* this is respond when system have to response */
if (isset ( $_POST ['command'] )) {
    
    $dbtable = new DBTable ( $db, "smis_amb_ambulan" );
    $dbtable->addCustomKriteria ( "noreg_pasien", " ='" . $_POST ['noreg_pasien'] . "'" );
    $adapter=null;
    $dbres=null;
    if($_synchronous){
        require_once "ambulatory/class/responder/AmbulanSynchronizeResponder.php";
        require_once "ambulatory/class/adapter/AmbulanSynchronizeAdapter.php";
        require_once "ambulatory/class/adapter/AmbulanTagihanAdapter.php";
        $sync_adapter=new AmbulanTagihanAdapter();
        $dbtable->activateTableSynchronous($_synchronous);
        $adapter = new AmbulanSynchronizeAdapter ();
        $dbres = new AmbulanSynchronizeResponder ( $dbtable, $uitable, $adapter,$sync_adapter );
    }else{
        require_once "ambulatory/class/responder/AmbulanResponder.php";
        require_once 'ambulatory/class/adapter/AmbulanAdapter.php';
        $adapter = new AmbulanAdapter ();
        $dbres = new AmbulanResponder ( $dbtable, $uitable, $adapter );
    }
    $data = $dbres->command ( $_POST ['command'] );
	echo json_encode ( $data );
	return;
}
$pemakaian=getSettings($db, "smis-rs-ambulan-mobil", "0")=="1";
$uitable->addModal ( "id", "hidden", "", "" );
$uitable->addModal ( "id_dokter", "hidden", "", "" );
$uitable->addModal ( "id_perawat", "hidden", "", "" );
$uitable->addModal ( "id_sopir", "hidden", "", "" );
$uitable->addModal ( "tanggal", "date", "Tanggal", "" );
if($pemakaian){
	$uitable->addModal ( "mobil", "chooser-ambulan-mobil_ambulan-Mobil", "Mobil", "" );
	$uitable->addModal ( "id_mobil", "hidden", "", "" );
}else{
	$uitable->addModal ( "mobil", "hidden", "", "" );
	$uitable->addModal ( "id_mobil", "hidden", "", "" );
}
$uitable->addModal ( "nama_sopir", "chooser-ambulan-supir-Supir", "Supir", "" );
$uitable->addModal ( "lokasi", "chooser-ambulan-lokasi", "Lokasi", "" );
$uitable->addModal ( "kondisi", "text", "Kondisi", "","y",NULL,true );
$uitable->addModal ( "gaji_sopir", "money", "Gaji Supir", "" );
$uitable->addModal ( "biaya_perjalanan", "money", "Biaya", "" );
$uitable->addModal ( "biaya_perawat", "money", "Biaya Perawat", "" );
$uitable->addModal ( "biaya_dokter", "money", "Biaya Dokter", "" );
$uitable->addModal ( "biaya_alat", "money", "Biaya Alat", "" );
$uitable->addModal ( "biaya_lain", "money", "Biaya Lain", "" );
$uitable->addModal ( "nama_dokter", "chooser-ambulan-dokter", "Dokter", "" );
$uitable->addModal ( "nama_perawat", "chooser-ambulan-perawat", "Perawat", "" );

$modal = $uitable->getModal ();
$modal->setTitle ( "Ambulance" );

$nrm = new Text ( "nrm_pasien", "nrm_pasien", "" );
$noreg = new Text ( "noreg_pasien", "noreg_pasien", "" );
$nama = new Text ( "nama_pasien", "nama_pasien", "" );
$action = new Button ( "", "", "Select" );
$action->setIsButton(Button::$ICONIC_TEXT);
$action->setClass(" btn-primary ");
$action->setIcon(" fa fa-check");
$action->setAction ( "ambulan.chooser('proyek_plpp','nama_pasien','pasien',pasien)" );
$nrm->setDisabled ( true );
$noreg->setDisabled ( true );
$nama->setDisabled ( true );

// form for proyek
$form = new Form ( "form_pasien", "", "Ambulan" );
$form->addElement ( "NRM", $nrm );
$form->addElement ( "No Registrasi", $noreg );
$form->addElement ( "Nama", $nama );
$form->addElement ( "", $action );
echo $form->getHtml ();

/* table of current content */
echo "<div id='table_content'>";
echo $uitable->getHtml ();
echo $modal->getHtml ();
echo "</div>";
echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
echo addJS ( "framework/smis/js/table_action.js" );
echo addCSS ( "framework/bootstrap/css/datepicker.css" );
echo addJS ( "ambulatory/resource/js/ambulan.js",false );

?>
