<?php
global $db;
require_once ("smis-framework/smis/database/DBParentChildResponder.php");
$parent_table = new Table ( array ('Tanggal',"Grup",'Nomor','Keterangan',"Debet","Kredit"), "Accounting : Transaksi Penyesuaian", NULL, true );
$parent_table->setName ( "memorial_parent" );
$parent_table->setActionName ( "memorial.parent" );

$child_table = new Table ( array ('No.','Nomor Account',"Account",'Keterangan',"Debet","Kredit"), "", NULL, true );
$child_table->setName ( "memorial_child" );
$child_table->setActionName ( "memorial.child" );
$child_table->setClass ( "well" );

/* this is respond when system have to response */
if (isset ( $_POST ['command'] )) {
	require_once ("accounting/class/adapter/AccountingChildSummaryAdapter.php");
	require_once ("accounting/class/adapter/ParentAdapter.php");
	require_once ("accounting/class/responder/DetailResponder.php");
	require_once ("accounting/class/responder/ParentResponder.php");
	
	// parent
	$parent_adapter = new ParentAdapter ();
	$parent_column = array ('id','tanggal','nomor',"keterangan","debet","kredit","grup");
	$parent_dbtable = new DBTable ( $db, "smis_ac_transaksi", $parent_column );
	$parent_dbtable->addCustomKriteria ( " jenis ", "='memorial'" );
	$parent_dbtable->addCustomKriteria ( " fix ", "='0'" );
	$parent_dbtable->setOrder(" DATE(tanggal) DESC, nomor DESC ");
	if(isset($_POST['filter_grup']) && $_POST['filter_grup']!=""){
        $parent_dbtable->addCustomKriteria ( " grup ", "='".$_POST['filter_grup']."'" );
    }
    
    $parent = new ParentResponder ( $parent_dbtable, $parent_table, $parent_adapter );	
	$parent->addColumnFixValue("jenis","memorial");
	
	
	
	// child
	$nama_account = "";
	if (isset ( $_POST ['nomor_account'] )) {
		$query = "SELECT nama FROM smis_ac_account WHERE nomor='" . $_POST ['nomor_account'] . "' ";
		$nama_account = $db->get_var ( $query );
	}	
	$child_adapter = new AccountingChildSummaryAdapter();
	$child_adapter->setUseNumber(true,"No.","back.");
	$child_adapter->addFixValue("Keterangan", "<strong>TOTAL</strong>");
	$child_adapter->addSummary("Debet", "debet","money Rp.");
	$child_adapter->addSummary("Kredit", "kredit","money Rp.");
	$child_adapter->add("Nomor Account", "nomor_account");
	$child_adapter->add("Account", "nama_account");
	$child_adapter->add("Keterangan", "keterangan");
	$child_adapter->add("Debet", "debet","money Rp.");
	$child_adapter->add("Kredit", "kredit","money Rp.");
	$child_dbtable = new DBTable ( $db, "smis_ac_transaksi_detail");
	$child = new DetailResponder ( $child_dbtable, $child_table, $child_adapter, "id_transaksi", $nama_account );
	
	$dbres = new DBParentChildResponder ( $parent, $child );
    if($dbres->isParentProcess($_POST ['super_command']) && $_POST['command']=="save" && $_POST['id']!="0" &&  $_POST['id']!=0){
        if(!isset($_POST['nomor']) || $_POST['nomor']==""){
            require_once "accounting/function/new_transaksi_harian.php";
            $format=new_transaksi_harian($db,$_POST['tanggal'],"MM");
            $parent->addColumnFixValue("nomor",$format);
        }
    }
	$data = $dbres->command ( $_POST ['super_command'], $_POST ['command'] );
	echo json_encode ( $data );
	return;
}

$dbtable=new DBTable($db,"smis_ac_grup");
$dbtable->setShowAll(true);
$list=$dbtable->view("",0);
$selectadapter=new SelectAdapter("nama","slug");
$grup=$selectadapter->getContent($list['data']);
$grup[]=array("name"=>"","value"=>"","default"=>1);

$parent_table->addModal("id","hidden","","");
$parent_table->addModal("tanggal","datetime","Tanggal",date("Y-m-d H:i:s"));
$parent_table->addModal("nomor","text","Nomor","","y",null,true);
$parent_table->addModal("grup","select","Grup",$grup);
$parent_table->addModal("keterangan","text","Keterangan","");

$modal_parent = $parent_table->getModal ();
$modal_parent->setTitle ( "Transaksi Memorial" );
$modal_parent->addBody ( "detail_memorial", $child_table );
$modal_parent->setClass ( Modal::$FULL_MODEL );

/* Child Modal */
$dbtable_account = new DBTable ( $db, "smis_ac_account" );
$dbtable_account->setShowAll ( true );
$dbtable_account->setOrder ( "nomor ASC" );
$data = $dbtable_account->view ( "", "0" );
$data_list = $data ['data'];

require_once 'accounting/class/adapter/AccountAdapter.php';
$account = new AccountAdapter();
$account_list = $account->getContent ( $data_list );

$child_table->addModal("id", "hidden", "", "");
$child_table->addModal("id_transaksi", "hidden", "", "");
$child_table->addModal("nomor_account", "select", "Nomor Akun", $account_list,"n",null,false,null,true,"nomor_account");
$child_table->addModal("keterangan", "text", "Keterangan", "","y",null,false,null,false,"debet");
$child_table->addModal("debet", "money", "Debet", "","y",null,false,null,false,"kredit");
$child_table->addModal("kredit", "money", "Kredit", "","y",null,false,null,false,"save");
$modal_child = $child_table->getModal ();
$modal_child->setTitle ( "Transaksi Memorial" );

$select=new Select("memorial_filter_grup","",$grup);
$button=new Button("","","");
$button->setIcon("fa fa-search");
$button->setAction("memorial.parent.view()");
$button->setClass("btn-primary");
$button->setIsButton(Button::$ICONIC);
$form=new Form("","","");
$form->addElement("Grup",$select,"");
$form->addElement("",$button,"");

echo $form->getHtml();
echo $parent_table->getHtml ();
echo $modal_parent->getHtml ();
echo $modal_child->getHtml ();
echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
echo addJS ( "framework/smis/js/table_action.js" );
echo addJS ( "framework/smis/js/child_parent.js" );
echo addCSS ( "framework/bootstrap/css/datepicker.css" );

?>
<script type="text/javascript">
var memorial;
$(document).ready(function(){
	$(".mydate").datepicker();
	$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
	$("#memorial_child_nomor_account").select2().on("select2-close", function () {
	    setTimeout(function() {
	        $('.select2-container-active').removeClass('select2-container-active');
	        $(':focus').blur();
	        $("#memorial_child_keterangan").focus();
	    }, 100);
	});
	var child_column=new Array('id','id_transaksi','nomor_account',"keterangan","debet","kredit");
	var parent_column=new Array('id','tanggal','nomor',"keterangan","grup");
	
	memorial=new ParentChildAction("memorial","accounting","memorial",parent_column,child_column,'id_transaksi');
	memorial.parent.view();
	memorial.child.setEnableAutofocus(true);
	memorial.child.setMultipleInput(true);
	memorial.child.setNextEnter();
	$('#memorial_child_add_form').on('shown.bs.modal', function() {
		$('#memorial_child_nomor_account').select2('open');
	});	
    
    memorial.parent.addViewData=function(add){
        add['filter_grup']=$("#memorial_filter_grup").val();
        return add;
    };

	memorial.child.save=function (){
		if(!this.cekSave()){
			return;
		}
		var self=this;
		var a=this.getSaveData();
		showLoading();
		$.ajax({url:"",data:a,type:'post',success:function(res){
			var json=getContent(res);
			if(json==null) {
				$("#"+self.prefix+"_add_form").smodal('hide');
				return;		
			}else if(json.success=="1"){
				$('#memorial_child_nomor_account').select2('open');
				self.view();
				self.clear();
			}
			dismissLoading();
			self.postAction(a['id']);
		}});
		this.aftersave();
	};
});
</script>