<?php
global $db;
$header=array ("No.","Grup","No. Ref",'Tanggal','Keterangan',"Account","Uraian","Debet","Kredit","Saldo Debet","Saldo Kredit" );
$uitable = new Report ($header);
$uitable->setAction(true);
$uitable->setAddButtonEnable(false);
$uitable->setEditButtonEnable(false);
$uitable->setDelButtonEnable(false);
$uitable->setReloadButtonEnable(false);
$uitable->setPrintButtonEnable(false);
$uitable->setDetailButtonEnable(true);
$uitable->setName ( "ledger" );
$uitable->setDiagram ( false );

/* this is respond when system have to response */
if (isset ( $_POST ['command'] )) {
	require_once "accounting/class/adapter/JournalAdapter.php";
	$qv = "SELECT smis_ac_transaksi.id AS id, 
			smis_ac_transaksi.tanggal AS tanggal, 
            smis_ac_transaksi.jenis AS jenis, 
			smis_ac_transaksi.nomor AS nomor, 
            smis_ac_transaksi.code AS code, 
			smis_ac_transaksi.keterangan AS keterangan, 
			smis_ac_transaksi_detail.id AS id_detail, 
			smis_ac_transaksi_detail.nomor_account AS nomor_account, 
			smis_ac_transaksi_detail.nama_account AS nama_account, 
			smis_ac_transaksi_detail.keterangan AS uraian, 
			smis_ac_transaksi_detail.debet AS debet, 
			smis_ac_transaksi_detail.kredit AS kredit,
            smis_ac_transaksi_detail.grup AS grup,
			smis_ac_transaksi.prop AS prop
			FROM smis_ac_transaksi
			LEFT JOIN smis_ac_transaksi_detail 
			ON smis_ac_transaksi.id = smis_ac_transaksi_detail.id_transaksi 
			";
	
	$qc = "SELECT count(*) as total
			FROM smis_ac_transaksi
			LEFT JOIN smis_ac_transaksi_detail 
			ON smis_ac_transaksi.id = smis_ac_transaksi_detail.id_transaksi ";
	
	$column = array ();
	$dbtable = new DBTable ( $db, "smis_ac_transaksi", $column );
	$dbtable->setPreferredQuery ( true, $qv, $qc );
	$dbtable->setUseWhereforView ( true );
	$dbtable->addCustomKriteria ( NULL, " ( smis_ac_transaksi.jenis = 'transaction' OR smis_ac_transaksi.jenis = 'saldo_awal' ) " );
	$dbtable->addCustomKriteria ( "smis_ac_transaksi.fix ", " ='0' " );
	$dbtable->addCustomKriteria ( "smis_ac_transaksi_detail.prop ", " NOT LIKE '%del%'" );
	
	if (isset ( $_POST ['account'] )) {
        if(isset($_POST['all_child']) && $_POST['all_child'] =="0"){
            $dbtable->addCustomKriteria ( "smis_ac_transaksi_detail.nomor_account ", " ='" . $_POST ['account'] . "'" );
        }else{
            $dbtable->addCustomKriteria ( "smis_ac_transaksi_detail.nomor_account ", " LIKE '" . $_POST ['account'] . "%'" );
        }
	}
    
    if(isset($_POST['filter_grup']) && $_POST['filter_grup']!=""){
        $dbtable->addCustomKriteria ( " smis_ac_transaksi_detail.grup ", "='".$_POST['filter_grup']."'" );
    }
    require_once "accounting/class/report/LedgerDBReport.php";
	$dbres = new LedgerDBReport ( $dbtable, $uitable, new JournalAdapter(), 'tanggal', DBReport::$DATE );
	$data = $dbres->command ( $_POST ['command'] );
    if($data!=null){
        echo json_encode ( $data, JSON_NUMERIC_CHECK );
	}
	return;
}

require_once "accounting/class/adapter/AccountAdapter.php";
$accountdb = new DBTable ( $db, "smis_ac_account" );
$accountdb->setOrder ( "nomor ASC;" );

$accountdb->setShowAll ( true );
$data = $accountdb->view ( "", "0" );
$adapter = new AccountAdapter ();
$option = $adapter->getContent ( $data ['data'] );

$all_child=new OptionBuilder();
$all_child->add("Include Child","1",'1');
$all_child->add("Exclude Child","0",'0');

$format=new OptionBuilder();
$format->add("Standard","standard",'1');
$format->add("Flowing","flowing",'0');


$dbtable=new DBTable($db,"smis_ac_grup");
$dbtable->setShowAll(true);
$list=$dbtable->view("",0);
$selectadapter=new SelectAdapter("nama","slug");
$grup=$selectadapter->getContent($list['data']);
$grup[]=array("name"=>"","value"=>"","default"=>1);

/* This is Modal Form and used for add and edit the table */
$uitable->addModal("filter_grup","select","Grup",$grup);
$uitable->addModal("account", "select", "Account", $option);
$uitable->addModal("all_child", "select", "Data Included", $all_child->getContent());
$uitable->addModal("format", "select", "Format", $format->getContent());
$modal = $uitable->getAdvanceModal ();
$modal->setTitle ( "Buku Besar" );

$button=new Button("","","");
$button->setAction("ledger.excel()");
$button->setIcon("fa fa-download");
$button->setClass("btn-primary");
$button->setIsButton(Button::$ICONIC);
$modal->getForm()->addElement("",$button);

$uitable->clearContent();


echo addJS ( "framework/smis/js/table_action.js" );
echo addJS ( "framework/smis/js/report_action.js" );
echo addJS ( "framework/bootstrap/js/bootstrap-datepicker.js" );
echo addJS ( "accounting/resource/js/ledger.js",false );
echo addCSS ( "framework/bootstrap/css/datepicker.css" );

echo $modal->getModalSkeleton();
echo $uitable->getHtml ();
?>
