<?php
	global $db;
	global $user;

	$table = new Table(array(), "", null, true);
	$table->setName("ij_aset_tetap");

	if (isset($_POST['command'])) {
		/// backend command handlers :
		if ($_POST['command'] == "save") {
			/// insert smis_ac_asset :
			$asset_dbtable = new DBTable($db, "smis_ac_asset");
			$data_asset = array(
				'id_barang'							=> $_POST['id_barang'],
				'kode_barang'						=> $_POST['kode_barang'],
				'nama_barang'						=> $_POST['nama_barang'],
				'jumlah'							=> $_POST['jumlah'],
				'nilai'								=> $_POST['nilai'],
				'umur_bulan'						=> $_POST['umur_bulan'],
				'umur_tahun'						=> $_POST['umur_tahun'],
				'metode_penyusutan'					=> $_POST['metode_penyusutan'],
				'ratio_penyusutan'					=> $_POST['ratio_penyusutan'],
				'tanggal_beli'						=> $_POST['tanggal_beli'],
				'tanggal_digunakan'					=> $_POST['tanggal_digunakan'],
				'kode_aktiva'						=> $_POST['kode_aktiva'],
				'tipe_aktiva'						=> $_POST['tipe_aktiva'],
				'no_akun_aktiva'					=> $_POST['no_akun_aktiva'],
				'nama_akun_aktiva'					=> $_POST['nama_akun_aktiva'],
				'no_akun_akum_penyusutan'			=> $_POST['no_akun_akumulasi_penyusutan'],
				'nama_akun_akum_penyusutan'			=> $_POST['nama_akun_akumulasi_penyusutan'],
				'no_akun_beban_penyusutan'			=> $_POST['no_akun_beban_penyusutan'],
				'nama_akun_beban_penyusutan'		=> $_POST['nama_akun_beban_penyusutan'],
				'aktiva_tidak_berwujud'				=> $_POST['aktiva_tidak_berwujud'],
				'catatan'							=> $_POST['catatan'],
				'operator'							=> $_POST['operator']
			);
			$asset_dbtable->insert($data_asset);
			$id_asset = $asset_dbtable->get_inserted_id();

			/// insert smis_ac_pengeluaran_asset :
			$pengeluaran_asset_dbtable = new DBTable($db, "smis_ac_pengeluaran_asset");
			$detail = $_POST['detail'];
			if (count($detail) > 0) {
				foreach ($detail as $d) {
					$data_pengeluaran_asset = array(
						'id_asset' 		=> $id_asset,
						'no_akun'		=> $d['no_akun'],
						'nama_akun'		=> $d['nama_akun'],
						'tanggal'		=> $d['tanggal'],
						'keterangan'	=> $d['keterangan'],
						'jumlah'		=> $d['nilai']
					);
					$pengeluaran_asset_dbtable->insert($data_pengeluaran_asset);
				}
			}

			/// insert smis_ac_transaksi :
			require_once "accounting/function/new_transaksi.php";
			$prefix = getSettings($db, "accounting-prefix-id-transaksi", "");
			$id_transaksi = new_transaksi($db, $prefix . "-FIXED-ASSET-");
			$transaksi_dbtable = new DBTable($db, "smis_ac_transaksi");
			$data_transaksi = array(
				'id'			=> $id_transaksi,
				'jenis' 		=> "transaction",
				'tanggal'		=> $_POST['tanggal_beli'],
				'tanggal_input'	=> date('Y-m-d H:i:s'),
				'nomor'			=> $_POST['kode_aktiva'],
				'keterangan'	=> "Pembelian Aset Tetap " . $_POST['nama_barang'],
				'debet'			=> $_POST['nilai'],
				'kredit'		=> $_POST['nilai'],
				'grup'			=> getSettings($db, "accounting-default-unit", ""),
				'operator'		=> $_POST['operator'],
				'id_notify'		=> $id_asset,
				'code'			=> "asset-" . $id_asset,
				'j_jurnal'		=> "fixed_asset",
				'no_akun'		=> $_POST['no_akun_aktiva'],
				'nama_akun'		=> $_POST['nama_akun_aktiva']
			);
			$transaksi_dbtable->insert($data_transaksi);

			/// insert smis_ac_transaksi_detail :
			$transaksi_detaiL_dbtable = new DBTable($db, "smis_ac_transaksi_detail");
			$data_transaksi_detail = array(
				'id_transaksi'	=> $id_transaksi,
				'nomor_account'	=> $_POST['no_akun_aktiva'],
				'nama_account'	=> $_POST['nama_akun_aktiva'],
				'keterangan'	=> "Aktiva " . $_POST['nama_barang'],
				'debet'			=> $_POST['nilai'],
				'kredit'		=> 0,
				'c_user'		=> $_POST['operator'],
				'grup'			=> getSettings($db, "accounting-default-unit", "")
			);
			$transaksi_detaiL_dbtable->insert($data_transaksi_detail);
			if (count($detail) > 0) {
				foreach ($detail as $d) {
					$data_transaksi_detail = array(
						'id_transaksi'	=> $id_transaksi,
						'nomor_account'	=> $d['no_akun'],
						'nama_account'	=> $d['nama_akun'],
						'keterangan'	=> "Aktiva " . $_POST['nama_barang'] . " - " . $d['keterangan'],
						'debet'			=> 0,
						'kredit'		=> $d['nilai'],
						'c_user'		=> $_POST['operator'],
						'grup'			=> getSettings($db, "accounting-default-unit", "")
					);
					$transaksi_detaiL_dbtable->insert($data_transaksi_detail);
				}
			}

			$result = array(
				'result'	=> "success",
				'id'		=> $id_asset
			);
			echo json_encode($result);
		}
		return;
	}

	/// header components :
	$table ->addModal("id", "hidden", "", "");
	$table ->addModal("kode_aktiva", "text", "Kode Aktiva", "", "y", null, false);
	$tipe_aktiva_option = new OptionBuilder();
	$tipe_aktiva_option->addSingle("Bangunan");
	$tipe_aktiva_option->addSingle("Tanah");
	$tipe_aktiva_option->addSingle("Kendaraan");
	$tipe_aktiva_option->addSingle("Barang Elektronik");
	$tipe_aktiva_option->addSingle("Lainnya");
	$table->addModal("tipe_aktiva", "select", "Tipe Aktiva", $tipe_aktiva_option->getContent(), "y", null, false);
	$table->addModal("tanggal_beli", "idatetime", "Tgl. Beli", date("d-m-Y H:i"), "n", null, false);
	$table->addModal("tanggal_digunakan", "idatetime", "Tgl. Digunakan", date("d-m-Y H:i"), "n", null, false);
	
	$dbtable_barang = new DBTable($db, "smis_pr_barang");
	$dbtable_barang->setShowAll(true);
	$dbtable_barang->setOrder("nama ASC");
	$dbtable_barang->addCustomKriteria("inventaris", "='1'");
	$data = $dbtable_barang->view("", "0");
	$data_list = $data['data'];
	$asset_option[] = array(
		"name" 		=> "",
		"value"		=> "",
		"default"	=> "1"
	);
	foreach ($data_list as $x) {
		$asset_option[] = array(
			"name"	=> $x->id . " - " . $x->kode . " - " . $x->nama,
			"value"	=> $x->nama
		);
	}
	$table->addModal("id_barang", "hidden", "", "", "n", null, true);
	$table->addModal("kode_barang", "hidden", "", "", "n", null, true);
	$table->addModal("nama_barang", "select", "Keterangan", $asset_option, "n", null, false);
	
	$table->addModal("jumlah", "text", "Kuantitas", "1", "n", null, false);
	$table->addModal("nilai", "hidden", "", "", "n", null, false);
	$table->addModal("operator", "text", "Petugas Entri", $user->getNameOnly(), "n", null, true);
	$form_header = $table->getModal()->getForm();

	/// tab umum components :
	$table = new Table(array(), "", null, true);
	$table->setName("ij_aset_tetap");
	$table->addModal("umur_bulan", "text", "Umur Bulan Aktiva", "", "n", null, false);
	$table->addModal("umur_tahun", "text", "Umur Tahun Aktiva", "", "n", null, false);
	
	$metode_option = new OptionBuilder();
	$metode_option->add("", "", "1");
    $metode_option->addSingle("Straight Line");
    $metode_option->addSingle("Double Declining Balance");
    $metode_option->addSingle("Angka Tahun");
	$table->addModal("metode_penyusutan", "select", "Metode Penyusutan", $metode_option->getContent(), "n", null, false);
	$table->addModal("ratio_penyusutan", "text", "Rasio Penyusutan (%)", "", "n", null, false);

	$dbtable_account = new DBTable($db, "smis_ac_account");
	$dbtable_account->setShowAll(true);
	$dbtable_account->setOrder("nomor ASC");
	$dbtable_account->addCustomKriteria("have_child", "='0'");
	$data = $dbtable_account->view("", "0");
	$data_list = $data['data'];
	$akun_option = array();
	$akun_option[] = array(
		"name" 		=> "",
		"value"		=> "",
		"default"	=> "1"
	);
	foreach ($data_list as $x) {
		if (trim($x->nama_tipe) == "Kas & Setara Kas" && $x->have_child == 0) {
			$akun_option[] = array(
				"name"	=> $x->nomor . " - " . $x->nama,
				"value"	=> $x->nomor
			);
		}
	}
	$table->addModal("akun_aktiva", "select", "Akun Aktiva", $akun_option, "n", null, false);
	$table->addModal("nama_akun_aktiva", "hidden", "", "", "n", null, true);
	$table->addModal("no_akun_akumulasi_penyusutan", "select", "Akun Akum. Penyusutan", $akun_option, "n", null, false);
	$table->addModal("nama_akun_akumulasi_penyusutan", "hidden", "", "", "n", null, true);
	$table->addModal("no_akun_beban_penyusutan", "select", "Akun Akum. Penyusutan", $akun_option, "n", null, false);
	$table->addModal("nama_akun_beban_penyusutan", "hidden", "", "", "n", null, true);
	$wujud_option = new OptionBuilder();
	$wujud_option->add("Berwujud", "0", "1");
	$wujud_option->add("Tidak Berwujud", "1");
	$table->addModal("tidak_berwujud", "select", "Berwujud/Tidak Berwujud", $wujud_option->getContent(), "n", null, false);
	$form_umum = $table->getModal()->getForm();

	/// tab pengeluaran components :
	$table = new Table(array("No.", "No. Akun", "Tanggal", "Keterangan", "Nilai"), "", null, true);
	$table->setName("ij_aset_tetap_pengeluaran");
	$table->setReloadButtonEnable(false);
	$table->setPrintButtonEnable(false);
	$table->setFooterVisible(false);

	/// tab catatan components :
	$catatan_textarea = new TextArea("ij_aset_tetap_catatan", "ij_aset_tetap_catatan", "");
	$catatan_textarea->setLine(10);

	$tabulator = new Tabulator("asset", "asset", Tabulator::$POTRAIT);
	$tabulator->add("asset_umum", "Umum", "<div class='clear'>" . $form_umum->getHtml() . "</div>", Tabulator::$TYPE_HTML, "fa fa-list");
	$tabulator->add("asset_pengeluaran", "Pengeluaran", "<div class='clear'>" . $table->getHtml() . "</div>", Tabulator::$TYPE_HTML, "fa fa-money");
	$tabulator->add("asset_catatan", "Catatan", "<div class='clear'>" . $catatan_textarea->getHtml() . "</div>", Tabulator::$TYPE_HTML, "fa fa-file");

	/// modal pengeluaran components :
	$modal = new Modal("ij_aset_tetap_pengeluaran_add_form", "smis_form_container", "ij_aset_tetap_pengeluaran");
	$modal->setTitle("Data Pengeluaran");
	$row_num_hidden = new Hidden("ij_aset_tetap_pengeluaran_row_num", "ij_aset_tetap_pengeluaran_row_num", "");
	$modal->addElement("", $row_num_hidden);
	$nama_akun_hidden = new Hidden("ij_aset_tetap_pengeluaran_nama_akun", "ij_aset_tetap_pengeluaran_nama_akun", "");
	$modal->addElement("", $nama_akun_hidden);
	$no_akun_select = new Select("ij_aset_tetap_pengeluaran_no_akun", "ij_aset_tetap_pengeluaran_no_akun", $akun_option);
	$modal->addElement("Akun", $no_akun_select);
	$tanggal_text = new Text("ij_aset_tetap_pengeluaran_tanggal", "ij_aset_tetap_pengeluaran_tanggal", "");
	$tanggal_text->setClass("mydatetime");
	$tanggal_text->setAtribute("data-date-format='dd-mm-yyyy HH:ii:ss'");
	$modal->addElement("Tanggal", $tanggal_text);
	$keterangan_text = new Text("ij_aset_tetap_pengeluaran_keterangan", "ij_aset_tetap_pengeluaran_keterangan", "");
	$modal->addElement("Keterangan", $keterangan_text);
	$jumlah_text = new Text("ij_aset_tetap_pengeluaran_jumlah", "ij_aset_tetap_pengeluaran_jumlah", "");
	$jumlah_text->setTypical("money");
	$jumlah_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
	$modal->addElement("Nilai", $jumlah_text);
	$button = new Button("ij_aset_tetap_pengeluaran_save_button", "ij_aset_tetap_pengeluaran_save_button", "Save");
	$button->setClass("btn btn-primary");
	$button->setAction("ij_aset_tetap_pengeluaran.save()");
	$button->setIcon("fa fa-save");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$modal->addFooter($button);

	$button = new Button("ij_aset_tetap_save_button", "ij_aset_tetap_save_button", "Save");
	$button->setClass("btn btn-primary");
	$button->setAction("ij_aset_tetap.save_jurnal()");
	$button->setIcon("fa fa-save");
	$button->setIsButton(Button::$ICONIC_TEXT);
 
	echo $form_header->getHtml();
	echo "<div class='clear'>";
	echo $tabulator->getHtml();
	echo "</div>";
	echo "<div class='clear'>";
	echo $button->getHtml();
	echo "</div>";
	echo $modal->getHtml();
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
	echo addJS("framework/smis/js/table_action.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("framework/bootstrap/js/bootstrap-select.js");
	echo addCSS("framework/bootstrap/css/bootstrap-select.css");
?>
<script type="text/javascript">
	function getDateTimeValue(val) {
		var parts = val.split(" ");
		var date_part = parts[0].split("-");
		var date = date_part[2] + "-" + date_part[1] + "-" + date_part[0];
		return date + " " + parts[1];
	}

	var row_num;
	var ij_aset_tetap;
	var ij_aset_tetap_pengeluaran;

	$(document).ready(function() {
		row_num = 1;

    	$(".mydatetime").datetimepicker({ minuteStep: 1});

    	/// select2 component action handlers :
    	$("#ij_aset_tetap_nama_barang").select2().on("select2-close", function () {
	        var txt = $(this).select2('data').text;
	        var parts = txt.split(" - ", 3);
	        var id = parts[0].trim();
	        var kode = parts[1].trim();
	        $("#ij_aset_tetap_id_barang").val(id);
	        $("#ij_aset_tetap_kode_barang").val(kode);
	    });
	    $("#ij_aset_tetap_akun_aktiva").select2().on("select2-close", function () {
	        var txt = $(this).select2('data').text;
	        var idx = txt.indexOf(" - ")+3;
	        var new_txt = txt.substr(idx);
	        $("#ij_aset_tetap_nama_akun_aktiva").val(new_txt);
	    });
	    $("#ij_aset_tetap_no_akun_akumulasi_penyusutan").select2().on("select2-close", function () {
	        var txt = $(this).select2('data').text;
	        var idx = txt.indexOf(" - ")+3;
	        var new_txt = txt.substr(idx);
	        $("#ij_aset_tetap_nama_akun_akumulasi_penyusutan").val(new_txt);
	    });
	    $("#ij_aset_tetap_no_akun_beban_penyusutan").select2().on("select2-close", function () {
	        var txt = $(this).select2('data').text;
	        var idx = txt.indexOf(" - ")+3;
	        var new_txt = txt.substr(idx);
	        $("#ij_aset_tetap_nama_akun_beban_penyusutan").val(new_txt);
	    });
	    $("#ij_aset_tetap_pengeluaran_no_akun").select2().on("select2-close", function () {
	        var txt = $(this).select2('data').text;
	        var idx = txt.indexOf(" - ")+3;
	        var new_txt = txt.substr(idx);
	        $("#ij_aset_tetap_pengeluaran_nama_akun").val(new_txt);
	    });

	    /// asset action handlers :
	    ij_aset_tetap = new TableAction(
	    	"ij_aset_tetap",
	    	"accounting",
	    	"ij_aset_tetap",
	    	new Array()
	    );
	    ij_aset_tetap.getSaveData = function() {
	    	var data = this.getRegulerData();
	    	data['command'] = "save";
	    	
	    	// header info :
	    	var kode_aktiva = $("#ij_aset_tetap_kode_aktiva").val();
	    	var tanggal_beli = getDateTimeValue($("#ij_aset_tetap_tanggal_beli").val());
	    	var tanggal_digunakan = getDateTimeValue($("#ij_aset_tetap_tanggal_digunakan").val());
	    	var id_barang = $("#ij_aset_tetap_id_barang").val();
	    	var kode_barang = $("#ij_aset_tetap_kode_barang").val();
	    	var nama_barang = $("#ij_aset_tetap_nama_barang").val();
	    	var jumlah = $("#ij_aset_tetap_jumlah").val();
	    	var nilai = $("#ij_aset_tetap_nilai").val();
	    	var operator = $("#ij_aset_tetap_operator").val();
	    	var umur_bulan = $("#ij_aset_tetap_umur_bulan").val();
	    	var umur_tahun = $("#ij_aset_tetap_umur_tahun").val();
	    	var metode_penyusutan = $("#ij_aset_tetap_metode_penyusutan").val();
	    	var ratio_penyusutan = $("#ij_aset_tetap_ratio_penyusutan").val();
	    	var tipe_aktiva = $("#ij_aset_tetap_tipe_aktiva").val();
	    	var no_akun_aktiva = $("#ij_aset_tetap_akun_aktiva").val();
	    	var nama_akun_aktiva = $("#ij_aset_tetap_nama_akun_aktiva").val();
	    	var no_akun_akumulasi_penyusutan = $("#ij_aset_tetap_no_akun_akumulasi_penyusutan").val();
	    	var nama_akun_akumulasi_penyusutan = $("#ij_aset_tetap_nama_akun_akumulasi_penyusutan").val();
	    	var no_akun_beban_penyusutan = $("#ij_aset_tetap_no_akun_beban_penyusutan").val();
	    	var nama_akun_beban_penyusutan = $("#ij_aset_tetap_nama_akun_beban_penyusutan").val();
	    	var aktiva_tidak_berwujud = $("#ij_aset_tetap_tidak_berwujud").val();
	    	var catatan = $("#ij_aset_tetap_catatan").val();

	    	// detail info :
	    	var detail = {};
	    	var num_row = $("tr.data_aset_tetap_pengeluaran").length;
	    	for (var i = 0; i < num_row; i++) {
	    		$("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#nomor").html(i + 1);
	    		var no_akun = $("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#no_akun").text();
	    		var nama_akun = $("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#nama_akun").text();
	    		var tanggal = $("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#tanggal").text();
	    		var keterangan = $("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#keterangan").text();
	    		var v_jumlah = parseFloat($("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#jumlah").text());

	    		detail[i] = {
	    			'no_akun' 		: no_akun,
	    			'nama_akun'		: nama_akun,
	    			'tanggal'		: tanggal,
	    			'keterangan'	: keterangan,
	    			'nilai'			: v_jumlah
	    		};
	    	}

	    	data['kode_aktiva'] = kode_aktiva;
	    	data['tanggal_beli'] = tanggal_beli;
	    	data['tanggal_digunakan'] = tanggal_digunakan;
	    	data['id_barang'] = id_barang;
	    	data['kode_barang'] = kode_barang;
	    	data['nama_barang'] = nama_barang;
	    	data['jumlah'] = jumlah;
	    	data['nilai'] = nilai;
	    	data['operator'] = operator;
	    	data['umur_bulan'] = umur_bulan;
	    	data['umur_tahun'] = umur_tahun;
	    	data['metode_penyusutan'] = metode_penyusutan;
	    	data['ratio_penyusutan'] = ratio_penyusutan;
	    	data['tipe_aktiva'] = tipe_aktiva;
	    	data['no_akun_aktiva'] = no_akun_aktiva;
	    	data['nama_akun_aktiva'] = nama_akun_aktiva;
	    	data['no_akun_akumulasi_penyusutan'] = no_akun_akumulasi_penyusutan;
	    	data['nama_akun_akumulasi_penyusutan'] = nama_akun_akumulasi_penyusutan;
	    	data['no_akun_beban_penyusutan'] = no_akun_beban_penyusutan;
	    	data['nama_akun_beban_penyusutan'] = nama_akun_beban_penyusutan;
	    	data['aktiva_tidak_berwujud'] = aktiva_tidak_berwujud;
	    	data['catatan'] = catatan;
	    	data['detail'] = detail;

	    	return data;
	    };
	    ij_aset_tetap.validate = function() {
	    	var valid = true;
	    	var invalid_msg = "";

	    	var kode_aktiva = $("#ij_aset_tetap_kode_aktiva").val();
	    	var tanggal_beli = $("#ij_aset_tetap_tanggal_beli").val();
	    	var tanggal_digunakan = $("#ij_aset_tetap_tanggal_digunakan").val();
	    	var nama_barang = $("#ij_aset_tetap_nama_barang").val();
	    	var jumlah = $("#ij_aset_tetap_jumlah").val();
	    	var umur_bulan = $("#ij_aset_tetap_umur_bulan").val();
	    	var umur_tahun = $("#ij_aset_tetap_umur_tahun").val();
	    	var metode_penyusutan = $("#ij_aset_tetap_metode_penyusutan").val();
	    	var ratio_penyusutan = $("#ij_aset_tetap_ratio_penyusutan").val();
	    	var tipe_aktiva = $("#ij_aset_tetap_tipe_aktiva").val();
	    	var no_akun_aktiva = $("#ij_aset_tetap_akun_aktiva").val();
	    	var no_akun_akumulasi_penyusutan = $("#ij_aset_tetap_no_akun_akumulasi_penyusutan").val();
	    	var no_akun_beban_penyusutan = $("#ij_aset_tetap_no_akun_beban_penyusutan").val();
	    	var catatan = $("#ij_aset_tetap_catatan").val();
	    	var num_row = $("tr.data_aset_tetap_pengeluaran").length;

	    	$(".error_field").removeClass("error_field");

	    	if (kode_aktiva == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Kode Aktiva</strong> tidak boleh kosong";
				$("#ij_aset_tetap_kode_aktiva").addClass("error_field");
	    	}
	    	if (tanggal_beli == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Tanggal Beli</strong> tidak boleh kosong";
				$("#ij_aset_tetap_tanggal_beli").addClass("error_field");
	    	}
	    	if (tanggal_digunakan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Tanggal Digunakan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_tanggal_digunakan").addClass("error_field");
	    	}
	    	if (nama_barang == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Keterangan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_nama_barang").addClass("error_field");
	    	}
	    	if (jumlah == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Kuantitas</strong> tidak boleh kosong";
				$("#ij_aset_tetap_jumlah").addClass("error_field");
	    	}
	    	if (umur_bulan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Umur Bulan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_umur_bulan").addClass("error_field");
	    	}
	    	if (umur_tahun == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Umur Tahun</strong> tidak boleh kosong";
				$("#ij_aset_tetap_umur_tahun").addClass("error_field");
	    	}
	    	if (metode_penyusutan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Metode Penyusutan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_metode_penyusutan").addClass("error_field");
	    	}
	    	if (ratio_penyusutan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Rasio Penyusutan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_ratio_penyusutan").addClass("error_field");
	    	}
	    	if (tipe_aktiva == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Tipe Aktiva</strong> tidak boleh kosong";
				$("#ij_aset_tetap_tipe_aktiva").addClass("error_field");
	    	}
	    	if (no_akun_aktiva == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Akun Aktiva</strong> tidak boleh kosong";
				$("#ij_aset_tetap_akun_aktiva").addClass("error_field");
	    	}
	    	if (no_akun_akumulasi_penyusutan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Akun Akum. Penyusutan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_no_akun_akumulasi_penyusutan").addClass("error_field");
	    	}
	    	if (no_akun_beban_penyusutan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Akun Beban Penyusutan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_no_akun_beban_penyusutan").addClass("error_field");
	    	}
	    	if (catatan == "") {
	    		valid = false;
	    		invalid_msg += "</br><strong>Catatan</strong> tidak boleh kosong";
				$("#ij_aset_tetap_catatan").addClass("error_field");
	    	}
	    	if (num_row == 0) {
	    		valid = false;
	    		invalid_msg += "</br><strong>Pengeluaran</strong> tidak boleh kosong";
	    	}

	    	if (invalid_msg != "")
	    		bootbox.alert(invalid_msg);

	    	return valid;
	    };
	    ij_aset_tetap.save_jurnal = function() {
	    	var self = this;
	    	if (!this.validate())
	    		return;
	    	var data = this.getSaveData();
	    	$.post(
	    		"",
	    		data,
	    		function(response) {
	    			var json = JSON.parse(response);
	    			if (json == null) return;
	    			self.clear();
	    		}
	    	);
	    };
	    ij_aset_tetap.clear = function() {
	    	$("#ij_aset_tetap_kode_aktiva").val("");
	    	$("#ij_aset_tetap_id_barang").val("");
	    	$("#ij_aset_tetap_kode_barang").val("");
	    	$("#ij_aset_tetap_nama_barang").val("");
	    	$("#ij_aset_tetap_jumlah").val("1");
	    	$("#ij_aset_tetap_nilai").val("");
	    	$("#ij_aset_tetap_umur_bulan").val("");
	    	$("#ij_aset_tetap_umur_tahun").val("");
	    	$("#ij_aset_tetap_metode_penyusutan").val("");
	    	$("#ij_aset_tetap_ratio_penyusutan").val("");
	    	$("#ij_aset_tetap_tipe_aktiva").val("");
	    	$("#ij_aset_tetap_akun_aktiva").val("");
	    	$("#ij_aset_tetap_nama_akun_aktiva").val("");
	    	$("#ij_aset_tetap_no_akun_akumulasi_penyusutan").val("");
	    	$("#ij_aset_tetap_nama_akun_akumulasi_penyusutan").val("");
	    	$("#ij_aset_tetap_no_akun_beban_penyusutan").val("");
	    	$("#ij_aset_tetap_nama_akun_beban_penyusutan").val("");
	    	$("#ij_aset_tetap_tidak_berwujud").val("0");
	    	$("#ij_aset_tetap_catatan").val("");
	    	$("#ij_aset_tetap_pengeluaran_list").html("<tr id='ij_aset_tetap_pengeluaran_temp'><td colspan='6'><center>DATA BELUM DITAMBAHKAN</center></td></tr>");
	    	row_num = 1;
	    };

	    /// pengeluaran asset action handlers :
	    ij_aset_tetap_pengeluaran = new TableAction(
	    	"ij_aset_tetap_pengeluaran",
	    	"accounting",
	    	"ij_aset_tetap",
	    	new Array('jumlah', 'row_num', 'no_akun', 'nama_akun', 'keterangan', 'tanggal')
	    );
	    ij_aset_tetap_pengeluaran.clear = function() {
	    	var tanggal_beli = $("#ij_aset_tetap_tanggal_beli").val();

	    	$("#ij_aset_tetap_pengeluaran_row_num").val("");
	    	$("#ij_aset_tetap_pengeluaran_tanggal").val(tanggal_beli);
	    	$("#ij_aset_tetap_pengeluaran_keterangan").val("");
	    	$("#ij_aset_tetap_pengeluaran_jumlah").val("0,00");
	    };
	    ij_aset_tetap_pengeluaran.getSaveData = function() {
	    	var data = {
	    		'row_num' 		: $("#ij_aset_tetap_pengeluaran_row_num").val(),
	    		'no_akun' 		: $("#ij_aset_tetap_pengeluaran_no_akun").val(),
	    		'nama_akun' 	: $("#ij_aset_tetap_pengeluaran_nama_akun").val(),
	    		'tanggal' 		: $("#ij_aset_tetap_pengeluaran_tanggal").val(),
	    		'keterangan' 	: $("#ij_aset_tetap_pengeluaran_keterangan").val(),
	    		'jumlah' 		: $("#ij_aset_tetap_pengeluaran_jumlah").val().replace(/[^0-9-,]/g, '').replace(",", "."),
	    		'f_jumlah' 		: $("#ij_aset_tetap_pengeluaran_jumlah").val(),
	    	};
	    	return data;
	    };
	    ij_aset_tetap_pengeluaran.save = function() {
	    	var data = this.getSaveData();
	    	if (data['row_num'] == "") {
	    		var html = 
		    		"<tr class='data_aset_tetap_pengeluaran' id='data_aset_tetap_pengeluaran_" + row_num + "'>" +
		    			"<td id='nomor'></td>" +
		    			"<td id='no_akun'>" + data['no_akun'] + "</td>" +
		    			"<td id='nama_akun' style='display: none;'>" + data['nama_akun'] + "</td>" +
		    			"<td id='tanggal'>" + data['tanggal'] + "</td>" +
		    			"<td id='keterangan'>" + data['keterangan'] + "</td>" +
		    			"<td id='f_jumlah'><div align='right'>" + data['f_jumlah'] + "</div></td>" +
		    			"<td id='jumlah' style='display: none;'>" + data['jumlah'] + "</td>" +
		    			"<td>" +
		    				"<div class='btn-group noprint'>" +
								"<a href='#' onclick='ij_aset_tetap_pengeluaran.edit(" + row_num + ")' data-content='Ubah' data-toggle='popover' class='input btn btn-warning'>" + 
									"<i class='icon-edit icon-white'></i>" +
								"</a>" +
								"<a href='#' onclick='ij_aset_tetap_pengeluaran.delete(" + row_num + ")' data-content='Hapus' data-toggle='popover' class='input btn btn-danger'>" + 
									"<i class='icon-remove icon-white'></i>" + 
								"</a>" +
							"</div>" +
		    			"</td>" +
		    		"</tr>";
		    	$("#ij_aset_tetap_pengeluaran_list").append(html);
		    	row_num++;
	    		$("#ij_aset_tetap_pengeluaran_temp").remove();
	    	} else {
	    		$("tr#data_aset_tetap_pengeluaran_" + data['row_num'] + " td#no_akun").html(data['no_akun']);
		    	$("tr#data_aset_tetap_pengeluaran_" + data['row_num'] + " td#nama_akun").html(data['nama_akun']);
		    	$("tr#data_aset_tetap_pengeluaran_" + data['row_num'] + " td#tanggal").html(data['tanggal']);
		    	$("tr#data_aset_tetap_pengeluaran_" + data['row_num'] + " td#keterangan").html(data['keterangan']);
		    	$("tr#data_aset_tetap_pengeluaran_" + data['row_num'] + " td#jumlah").html(data['jumlah']);
		    	$("tr#data_aset_tetap_pengeluaran_" + data['row_num'] + " td#f_jumlah").html("<div align='right'>" + data['f_jumlah'] + "</div>");
	    	}
			this.refreshNumber();
			$("#ij_aset_tetap_pengeluaran_add_form").smodal("hide");
	    };
	    ij_aset_tetap_pengeluaran.refreshNumber = function() {
	    	var total = 0;
	    	var num_row = $("tr.data_aset_tetap_pengeluaran").length;
	    	for (var i = 0; i < num_row; i++) {
	    		$("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#nomor").html(i + 1);
	    		var nilai = parseFloat($("tr.data_aset_tetap_pengeluaran:eq(" + i + ") td#jumlah").text());
	    		total += nilai;
	    	}
	    	$("#ij_aset_tetap_nilai").val(total);
	    };
	    ij_aset_tetap_pengeluaran.edit = function(r_num) {
	    	var no_akun = $("tr#data_aset_tetap_pengeluaran_" + r_num + " td#no_akun").html();
	    	var nama_akun = $("tr#data_aset_tetap_pengeluaran_" + r_num + " td#nama_akun").html();
	    	var tanggal = $("tr#data_aset_tetap_pengeluaran_" + r_num + " td#tanggal").html();
	    	var keterangan = $("tr#data_aset_tetap_pengeluaran_" + r_num + " td#keterangan").html();
	    	var jumlah = $("tr#data_aset_tetap_pengeluaran_" + r_num + " td#f_jumlah").text();

	    	$("#ij_aset_tetap_pengeluaran_row_num").val(r_num);
	    	$("#ij_aset_tetap_pengeluaran_no_akun").val(no_akun);
	    	$("#ij_aset_tetap_pengeluaran_nama_akun").val(nama_akun);
	    	$("#ij_aset_tetap_pengeluaran_tanggal").val(tanggal);
	    	$("#ij_aset_tetap_pengeluaran_keterangan").val(keterangan);
	    	$("#ij_aset_tetap_pengeluaran_jumlah").val(jumlah);
	    	$("#ij_aset_tetap_pengeluaran_add_form").smodal("show");
	    };
	    ij_aset_tetap_pengeluaran.delete = function(r_num) {
	    	$("tr#data_aset_tetap_pengeluaran_" + r_num).remove();
	    	var num_row = $("tr.data_aset_tetap_pengeluaran").length;
	    	if (num_row == 0)
	    		$("#ij_aset_tetap_pengeluaran_list").html("<tr id='ij_aset_tetap_pengeluaran_temp'><td colspan='6'><center>DATA BELUM DITAMBAHKAN</center></td></tr>");	
	    	this.refreshNumber();	
	    };

	    /// initiate pengeluaran row with a dummy row :
		$("#ij_aset_tetap_pengeluaran_list").html("<tr id='ij_aset_tetap_pengeluaran_temp'><td colspan='6'><center>DATA BELUM DITAMBAHKAN</center></td></tr>");
	});
</script>
<style type="text/css">
	.smis_form > div label {
	    float: left;
	    width: 300px;
	    height: 20px;
	    margin-top: 12px;
	}
	#ij_aset_tetap_catatan {
		width: 100%;
	}
	#asset_header > div {
		min-height: 30% !important;
	}
	#ij_aset_tetap_pengeluaran_add_form_form > div label {
	    width: 100px !important;
	    margin-left: 50px !important;
	}
</style>