<?php
    require_once("smis-framework/smis/api/SettingsBuilder.php");
    require_once("smis-base/smis-include-service-consumer.php");
    require_once("accounting/class/settings/AkuntingSettingsBuilder.php");
    global $db;
    
    $accountingSettingsBuilder = new AkuntingSettingsBuilder( $db, "accounting", "accounting", "map_akun_persediaan", "Map Akun Persediaan" );
    
    if ($accountingSettingsBuilder->isGroupAdded("persediaan", "Medis", "fa fa-file")) {
        $accountingSettingsBuilder->addCurrent("akun-persediaan-obat", "Akun Persediaan Obat", "", "chooser-map_akun_persediaan-akun_persediaan_obat-Akun Persediaan Obat");
        $accountingSettingsBuilder->addSuperCommandAction("akun_persediaan_obat", "kode_akun_persediaan");
        $accountingSettingsBuilder->addSuperCommandArray("akun_persediaan_obat", "akun-persediaan-obat", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-persediaan-alkes", "Akun Persediaan Alkes", "", "chooser-map_akun_persediaan-akun_persediaan_alkes-Akun Persediaan Alkes");
        $accountingSettingsBuilder->addSuperCommandAction("akun_persediaan_alkes", "kode_akun_persediaan");
        $accountingSettingsBuilder->addSuperCommandArray("akun_persediaan_alkes", "akun-persediaan-alkes", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-biaya-barang-nonmedis", "Akun Biaya Barang Non-Medis", "", "chooser-map_akun_persediaan-akun_biaya_barang_nonmedis-Akun Biaya Barang Non-Medis");
        $accountingSettingsBuilder->addSuperCommandAction("akun_biaya_barang_nonmedis", "kode_akun_beban");
        $accountingSettingsBuilder->addSuperCommandArray("akun_biaya_barang_nonmedis", "akun-biaya-barang-nonmedis", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-ppn-masukan-atas-pembelian", "Akun PPN Masukan Atas Pembelian", "", "chooser-map_akun_persediaan-akun_ppn_masukan_atas_pembelian-Akun PPN Masukan Atas Pembelian");
        $accountingSettingsBuilder->addSuperCommandAction("akun_ppn_masukan_atas_pembelian", "kode_akun_pajak");
        $accountingSettingsBuilder->addSuperCommandArray("akun_ppn_masukan_atas_pembelian", "akun-ppn-masukan-atas-pembelian", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-biaya-biaya-materai-pembelian", "Akun Biaya Materai Atas Pembelian", "", "chooser-map_akun_persediaan-akun_biaya_materai_pembelian-Akun Biaya Materai Atas Pembelian");
        $accountingSettingsBuilder->addSuperCommandAction("akun_biaya_materai_pembelian", "kode_akun_beban");
        $accountingSettingsBuilder->addSuperCommandArray("akun_biaya_materai_pembelian", "akun-biaya-biaya-materai-pembelian", "akun", true);
    }

    if ($accountingSettingsBuilder->isGroupAdded("non_medis", "Non Medis", "fa fa-users")) {
        $accountingSettingsBuilder->addCurrent("akun-persediaan-atk", "Akun Persediaan ATK", "", "chooser-map_akun_persediaan-akun_persediaan_atk-Kode Akun Persediaan ATK", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_persediaan_atk", "kode_akun_persediaan");
        $accountingSettingsBuilder->addSuperCommandArray("akun_persediaan_atk", "akun-persediaan-atk", "akun", true);
    }

    $accountingSettingsBuilder->setPartialLoad(true);
    $response = $accountingSettingsBuilder->init();
?>