<?php
    require_once ("smis-framework/smis/api/SettingsBuilder.php");
    require_once ("smis-base/smis-include-service-consumer.php");
    require_once ("accounting/class/settings/AkuntingSettingsBuilder.php");
    global $db;

    $accountingSettingBuilder = new AkuntingSettingsBuilder($db, "accounting", "accounting", "map_akun_penerimaan", "Map Akun Penerimaan");
    if ($accountingSettingBuilder->isGroupAdded("kasir", "Kasir", "fa fa-users")) {
        $accountingSettingBuilder->addCurrent("akun-penerimaan-tunai-kasir", "Penerimaan Tunai", "", "chooser-map_akun_penerimaan-akun_penerimaan_tunai_kasir-Kode Akun Penerimaan Tunai", "");
        $accountingSettingBuilder->addSuperCommandAction("akun_penerimaan_tunai_kasir", "kode_akun_penerimaan");
        $accountingSettingBuilder->addSuperCommandArray("akun_penerimaan_tunai_kasir", "akun-penerimaan-tunai-kasir", "akun", true);

        $serv = new ServiceConsumer($db,"get_bank",NULL,"kasir");
        $serv->execute();
        $bank = $serv->getContent();
        $accountingSettingBuilder->addSection("kasir","Bank");
        foreach($bank as $b){
            $accountingSettingBuilder->addCurrent("akun-penerimaan-bank-kasir-".$b['id'], "Penerimaan Bank ".$b['bank']." ( ".$b['rekening']." ) - ".$b['nama'], "", "chooser-map_akun_penerimaan-akun_penerimaan_bank_kasir_".$b['id']."-Kode Akun Penerimaan Bank", "");
            $accountingSettingBuilder->addSuperCommandAction("akun_penerimaan_bank_kasir_".$b['id']."", "kode_akun_penerimaan");
            $accountingSettingBuilder->addSuperCommandArray("akun_penerimaan_bank_kasir_".$b['id']."", "akun-penerimaan-bank-kasir-".$b['id'], "akun", true);
        }
    }
    $accountingSettingBuilder->setPartialLoad(true);
    $accountingSettingBuilder->init();
?>