<?php 
require_once 'smis-framework/smis/api/SettingsBuilder.php';
require_once ("smis-base/smis-include-service-consumer.php");
require_once 'accounting/class/settings/AkuntingSettingsBuilder.php';
$smis= new AkuntingSettingsBuilder( $db, "accounting", "accounting","map_akun_pendapatan", "Map Akun Pendapatan" );
if($smis->isGroupAdded("pendaftaran","Pendaftaran","fa fa-users")){
    $smis   ->addCurrent("akun-pendapatan-pendaftaran","Pendaftaran","","chooser-map_akun_pendapatan-akun_pendapatan_pendaftaran-Kode Akun Pendaftaran ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_pendaftaran","kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_pendaftaran","akun-pendapatan-pendaftaran","nomor",true);
}

if($smis->isGroupAdded("rawat_jalan","Rawat Jalan","fa fa-users")){
    $urjip = new ServiceConsumer ( $db, "get_urjip", array () );
    $urjip->setMode ( ServiceConsumer::$MULTIPLE_MODE );
    $urjip->setCached(true,"get_urjip");
    $urjip->execute ();
    $content = $urjip->getContent ();
    foreach ( $content as $autonomous => $ruang ) {
        foreach ( $ruang as $nama_ruang => $jip ) {
            if ($nama_ruang != "igd") {
                $RUANGAN [$nama_ruang] = $jip [$nama_ruang];
            }
        }
    }
    foreach ( $RUANGAN as $r => $jip ) {
        if ($jip == "URJ") {
            $smis  ->addSectionCurrent(ArrayAdapter::format("unslug",  $r ));

            $smis   ->addCurrent("akun-pendapatan-konsul-dokter-".$r,"Konsul Dokter","","chooser-map_akun_pendapatan-akun_pendapatan_konsul_dokter_".$r."-Kode Konsul Dokter ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_konsul_dokter_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_konsul_dokter_".$r,"akun-pendapatan-konsul-dokter-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-tindakan-dokter-".$r,"Tindakan Dokter","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_dokter_".$r."-Kode Tindakan Dokter ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_dokter_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_dokter_".$r,"akun-pendapatan-tindakan-dokter-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-tindakan-perawat-".$r,"Tindakan Perawat","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_perawat_".$r."-Kode Tindakan Perawat ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_perawat_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_perawat_".$r,"akun-pendapatan-tindakan-perawat-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-alkesbhp-".$r,"Alkes & BHP","","chooser-map_akun_pendapatan-akun_pendapatan_alkesbhp_".$r."-Kode Pendapatan Alkes & BHP ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_alkesbhp_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_alkesbhp_".$r,"akun-pendapatan-alkesbhp-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-oksigen_central-".$r,"Oksigen Central","","chooser-map_akun_pendapatan-akun_pendapatan_oksigen_central_".$r."-Kode Oksigen Central ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_oksigen_central_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_oksigen_central_".$r,"akun-pendapatan-oksigen_central-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-lainya-".$r,"Pendapatan Lainya","","chooser-map_akun_pendapatan-akun_pendapatan_lainya_".$r."-Kode Pendapatan Lainya ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_lainya_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_lainya_".$r,"akun-pendapatan-lainya-".$r,"nomor",true);
            
        }
    }
}


if($smis->isGroupAdded("rawat_inap","Rawat Inap","fa fa-users")){
    $urjip = new ServiceConsumer ( $db, "get_urjip", array () );
    $urjip->setMode ( ServiceConsumer::$MULTIPLE_MODE );
    $urjip->setCached(true,"get_urjip");
    $urjip->execute ();
    $content = $urjip->getContent ();
    foreach ( $content as $autonomous => $ruang ) {
        foreach ( $ruang as $nama_ruang => $jip ) {
            $RUANGAN [$nama_ruang] = $jip [$nama_ruang];
        }
    }
    foreach ( $RUANGAN as $r => $jip ) {
        if ($jip == "URI") {
            $smis  ->addSectionCurrent(ArrayAdapter::format("unslug",  $r ));
            $smis   ->addCurrent("akun-pendapatan-sewa-kamar-".$r,"Sewa Kamar","","chooser-map_akun_pendapatan-akun_pendapatan_sewa_kamar_".$r."-Kode Sewa Kamar ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_sewa_kamar_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_sewa_kamar_".$r,"akun-pendapatan-sewa-kamar-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-konsul-dokter-".$r,"Konsul Dokter","","chooser-map_akun_pendapatan-akun_pendapatan_konsul_dokter_".$r."-Kode Konsul Dokter ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_konsul_dokter_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_konsul_dokter_".$r,"akun-pendapatan-konsul-dokter-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-tindakan-dokter-".$r,"Tindakan Dokter","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_dokter_".$r."-Kode Tindakan Dokter ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_dokter_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_dokter_".$r,"akun-pendapatan-tindakan-dokter-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-tindakan-perawat-".$r,"Tindakan Perawat","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_perawat_".$r."-Kode Tindakan Perawat ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_perawat_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_perawat_".$r,"akun-pendapatan-tindakan-perawat-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-alkesbhp-".$r,"Alkes & BHP","","chooser-map_akun_pendapatan-akun_pendapatan_alkesbhp_".$r."-Kode Pendapatan Alkes & BHP ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_alkesbhp_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_alkesbhp_".$r,"akun-pendapatan-alkesbhp-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-oksigen_central-".$r,"Oksigen Central","","chooser-map_akun_pendapatan-akun_pendapatan_oksigen_central_".$r."-Kode Oksigen Central ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_oksigen_central_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_oksigen_central_".$r,"akun-pendapatan-oksigen_central-".$r,"nomor",true);

            $smis   ->addCurrent("akun-pendapatan-lainya-".$r,"Pendapatan Lainya","","chooser-map_akun_pendapatan-akun_pendapatan_lainya_".$r."-Kode Pendapatan Lainya ","");
            $smis   ->addSuperCommandAction("akun_pendapatan_lainya_".$r,"kode_akun_pendapatan");
            $smis   ->addSuperCommandArray("akun_pendapatan_lainya_".$r,"akun-pendapatan-lainya-".$r,"nomor",true);
        }
    }
}

if($smis->isGroupAdded("igd","IGD","fa fa-users")){
    $r = "igd";
    $urjip = new ServiceConsumer ( $db, "get_urjip", array () );
    $urjip->setMode ( ServiceConsumer::$MULTIPLE_MODE );
    $urjip->setCached(true,"get_urjip");
    $urjip->execute ();
    $content = $urjip->getContent ();
    $option = new OptionBuilder();
    $option ->add("","",""==$rg?"1":"0");
    foreach ( $content as $autonomous => $ruang ) {
        foreach ( $ruang as $nama_ruang => $jip ) {            
            $option ->add(ArrayAdapter::format("unslug",  $nama_ruang ),$nama_ruang);
        }
    }
    
    $smis   ->addCurrent("slug-ruangan-".$r,"Pilih Ruangan",$option->getContent(),"select","");

    $smis   ->addCurrent("akun-pendapatan-sewa-kamar-".$r,"Sewa Kamar","","chooser-map_akun_pendapatan-akun_pendapatan_sewa_kamar_".$r."-Kode Sewa Kamar ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_sewa_kamar_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_sewa_kamar_".$r,"akun-pendapatan-sewa-kamar-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-tindakan-dokter-".$r,"Tindakan Dokter","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_dokter_".$r."-Kode Tindakan Dokter ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_dokter_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_dokter_".$r,"akun-pendapatan-tindakan-dokter-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-tindakan-perawat-".$r,"Tindakan Perawat","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_perawat_".$r."-Kode Tindakan Perawat ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_perawat_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_perawat_".$r,"akun-pendapatan-tindakan-perawat-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-alkesbhp-".$r,"Alkes & BHP","","chooser-map_akun_pendapatan-akun_pendapatan_alkesbhp_".$r."-Kode Pendapatan Alkes & BHP ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_alkesbhp_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_alkesbhp_".$r,"akun-pendapatan-alkesbhp-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-oksigen_central-".$r,"Oksigen Central","","chooser-map_akun_pendapatan-akun_pendapatan_oksigen_central_".$r."-Kode Oksigen Central ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_oksigen_central_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_oksigen_central_".$r,"akun-pendapatan-oksigen_central-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-lainya-".$r,"Pendapatan Lainya","","chooser-map_akun_pendapatan-akun_pendapatan_lainya_".$r."-Kode Pendapatan Lainya ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_lainya_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_lainya_".$r,"akun-pendapatan-lainya-".$r,"nomor",true);
}

if ($smis->isGroupAdded("farmasi", "Farmasi", "fa fa-users")) {
    $smis->addCurrent("akun-pendapatan-penjualan_obat-farmasi", "Penjualan Obat", "", "chooser-map_akun_pendapatan-akun_pendapatan_penjualan_obat_farmasi-Akun Penjualan Obat Farmasi ", "");
    $smis->addSuperCommandAction("akun_pendapatan_penjualan_obat_farmasi", "kode_akun_pendapatan");
    $smis->addSuperCommandArray("akun_pendapatan_penjualan_obat_farmasi", "akun-pendapatan-penjualan_obat-farmasi", "nomor", true);

    $smis->addCurrent("akun-pendapatan-penjualan_alkes-farmasi", "Penjualan Alkes", "", "chooser-map_akun_pendapatan-akun_pendapatan_penjualan_alkes_farmasi-Akun Penjualan Alkes Farmasi ", "");
    $smis->addSuperCommandAction("akun_pendapatan_penjualan_alkes_farmasi", "kode_akun_pendapatan");
    $smis->addSuperCommandArray("akun_pendapatan_penjualan_alkes_farmasi", "akun-pendapatan-penjualan_alkes-farmasi", "nomor", true);

    $smis->addCurrent("akun-pendapatan-biaya_retur_obat-farmasi", "Biaya Retur Obat", "", "chooser-map_akun_pendapatan-akun_pendapatan_biaya_retur_obat_farmasi-Akun Biaya Retur Obat Farmasi ", "");
    $smis->addSuperCommandAction("akun_pendapatan_biaya_retur_obat_farmasi", "kode_akun_beban");
    $smis->addSuperCommandArray("akun_pendapatan_biaya_retur_obat_farmasi", "akun-pendapatan-biaya_retur_obat-farmasi", "akun", true);

    $smis->addCurrent("akun-pendapatan-biaya_retur_alkes-farmasi", "Biaya Retur Alkes", "", "chooser-map_akun_pendapatan-akun_pendapatan_biaya_retur_alkes_farmasi-Akun Biaya Retur Alkes Farmasi ", "");
    $smis->addSuperCommandAction("akun_pendapatan_biaya_retur_alkes_farmasi", "kode_akun_beban");
    $smis->addSuperCommandArray("akun_pendapatan_biaya_retur_alkes_farmasi", "akun-pendapatan-biaya_retur_alkes-farmasi", "akun", true);

    $smis->addCurrent("akun-pendapatan-lainya-farmasi", "Pendapatan Lainya", "", "chooser-map_akun_pendapatan-akun_pendapatan_lainya_farmasi-Akun Pendapatan Lainya Farmasi ", "");
    $smis->addSuperCommandAction("akun_pendapatan_lainya_farmasi", "kode_akun_pendapatan");
    $smis->addSuperCommandArray("akun_pendapatan_lainya_farmasi", "akun-pendapatan-lainya-farmasi", "nomor", true);

    $smis->addCurrent("akun-ppn-keluaran-atas-penjualan-farmasi", "PPN Keluaran Atas Penjualan", "", "chooser-map_akun_pendapatan-akun_ppn_keluaran_atas_penjualan_farmasi-Akun PPN Keluaran Atas Penjualan Farmasi ", "");
    $smis->addSuperCommandAction("akun_ppn_keluaran_atas_penjualan_farmasi", "kode_akun_hutang");
    $smis->addSuperCommandArray("akun_ppn_keluaran_atas_penjualan_farmasi", "akun-ppn-keluaran-atas-penjualan-farmasi", "akun", true);
}

if($smis->isGroupAdded("laboratorium","Laboratorium","fa fa-users")){
    $smis   ->addCurrent("akun-pendapatan-pemeriksaan-laboratorium","Pendapatan Pemeriksaan","","chooser-map_akun_pendapatan-akun_pendapatan_pemeriksaan_laboratorium-Kode Akun Pemeriksaaan ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_pemeriksaan_laboratorium","kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_pemeriksaan_laboratorium","akun-pendapatan-pemeriksaan-laboratorium","nomor",true);

    $smis   ->addCurrent("akun-pendapatan-lainya-laboratorium","Pendapatan Lainya","","chooser-map_akun_pendapatan-akun_pendapatan_lainya_laboratorium-Kode Akun Pendapatan Lainya ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_lainya_laboratorium","kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_lainya_laboratorium","akun-pendapatan-lainya-laboratorium","nomor",true);
}

if($smis->isGroupAdded("radiology","Radiology","fa fa-users")){
    $smis   ->addCurrent("akun-pendapatan-pemeriksaan-radiology","Pendapatan Pemeriksaan","","chooser-map_akun_pendapatan-akun_pendapatan_pemeriksaan_radiology-Kode Akun Pemeriksaaan ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_pemeriksaan_radiology","kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_pemeriksaan_radiology","akun-pendapatan-pemeriksaan-radiology","nomor",true);

    $smis   ->addCurrent("akun-pendapatan-lainya-radiology","Pendapatan Lainya","","chooser-map_akun_pendapatan-akun_pendapatan_lainya_radiology-Kode Akun Pendapatan Lainya ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_lainya_radiology","kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_lainya_radiology","akun-pendapatan-lainya-radiology","nomor",true);
}


if($smis->isGroupAdded("ok","Kamar Operasi","fa fa-users")){
    $r = "ok";
    $urjip = new ServiceConsumer ( $db, "get_urjip", array () );
    $urjip->setMode ( ServiceConsumer::$MULTIPLE_MODE );
    $urjip->setCached(true,"get_urjip");
    $urjip->execute ();
    $content = $urjip->getContent ();
    $option = new OptionBuilder();
    $rg = getSettings($db,"pilih-ruangan-".$r);
    $option ->add("","",""==$rg?"1":"0");
    foreach ( $content as $autonomous => $ruang ) {
        foreach ( $ruang as $nama_ruang => $jip ) {            
            $option ->add(ArrayAdapter::format("unslug",  $nama_ruang ),$nama_ruang);
        }
    }
    
    $smis   ->addCurrent("slug-ruangan-".$r,"Pilih Ruangan",$option->getContent(),"select","");

    $smis   ->addCurrent("akun-pendapatan-sewa-kamar-".$r,"Sewa Kamar","","chooser-map_akun_pendapatan-akun_pendapatan_sewa_kamar_".$r."-Kode Sewa Kamar ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_sewa_kamar_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_sewa_kamar_".$r,"akun-pendapatan-sewa-kamar-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-tindakan-dokter-".$r,"Tindakan Dokter","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_dokter_".$r."-Kode Tindakan Dokter ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_dokter_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_dokter_".$r,"akun-pendapatan-tindakan-dokter-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-tindakan-perawat-".$r,"Tindakan Perawat","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_perawat_".$r."-Kode Tindakan Perawat ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_perawat_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_perawat_".$r,"akun-pendapatan-tindakan-perawat-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-alkesbhp-".$r,"Alkes & BHP","","chooser-map_akun_pendapatan-akun_pendapatan_alkesbhp_".$r."-Kode Pendapatan Alkes & BHP ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_alkesbhp_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_alkesbhp_".$r,"akun-pendapatan-alkesbhp-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-lainya-".$r,"Pendapatan Lainya","","chooser-map_akun_pendapatan-akun_pendapatan_lainya_".$r."-Kode Pendapatan Lainya ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_lainya_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_lainya_".$r,"akun-pendapatan-lainya-".$r,"nomor",true);

    $smis   ->addCurrent("akun-pendapatan-tindakan_operasi-".$r,"Pendapatan Tindakan Operasi","","chooser-map_akun_pendapatan-akun_pendapatan_tindakan_operasi_".$r."-Kode Pendapatan Tindakan Operasi ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_tindakan_operasi_".$r,"kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_tindakan_operasi_".$r,"akun-pendapatan-tindakan_operasi-".$r,"nomor",true);
}


if($smis->isGroupAdded("ambulance","Ambulance","fa fa-users")){
    $smis   ->addCurrent("akun-pendapatan-ambulance","Ambulance","","chooser-map_akun_pendapatan-akun_pendapatan_ambulance-Kode Akun Ambulance ","");
    $smis   ->addSuperCommandAction("akun_pendapatan_ambulance","kode_akun_pendapatan");
    $smis   ->addSuperCommandArray("akun_pendapatan_ambulance","akun-pendapatan-ambulance","nomor",true);
}


if ($smis->isGroupAdded("gizi", "Gizi", "fa fa-users")) {
    $smis->addCurrent("akun-pendapatan-gizi", "Gizi", "", "chooser-map_akun_pendapatan-akun_pendapatan_gizi-Akun Pendapatan Gizi ", "");
    $smis->addSuperCommandAction("akun_pendapatan_gizi", "kode_akun_pendapatan");
    $smis->addSuperCommandArray("akun_pendapatan_gizi", "akun-pendapatan-gizi", "nomor", true);
}

if ($smis->isGroupAdded("asuransi", "Pendapatan Asuransi", "fa fa-users")) {
    global $db;
    $uitable = new Table(array(),"");
    require_once 'smis-base/smis-include-service-consumer.php';
    $serv = new ServiceConsumer($db,"get_asuransi_pasien",NULL,"registration");
    $serv ->execute();
    $res  = $serv->getContent();
    foreach($res as $x){
        $smis   ->addCurrent("akun-pendapatan-asuransi-".$x['value'],"Pendapatan ".$x['name'],"","chooser-map_akun_pendapatan-akun_pendapatan_asuransi_".$x['value']."-Kode Akun ".$x['name'],"");
        $smis   ->addSuperCommandAction("akun_pendapatan_asuransi_".$x['value'],"kode_akun_pendapatan");
        $smis   ->addSuperCommandArray("akun_pendapatan_asuransi_".$x['value'],"akun-pendapatan-asuransi-".$x['value'],"nomor",true);
    }
}

if ($smis->isGroupAdded("perusahaan", "Pendapatan Perusahaan", "fa fa-users")) {
    global $db;
    $uitable = new Table(array(),"");
    require_once 'smis-base/smis-include-service-consumer.php';
    $serv = new ServiceConsumer($db,"get_perusahaan_pasien",NULL,"registration");
    $serv ->execute();
    $res  = $serv->getContent();
    foreach($res as $x){
        $smis   ->addCurrent("akun-pendapatan-perusahaan-".$x['value'],"Pendapatan ".$x['name'],"","chooser-map_akun_pendapatan-akun_pendapatan_perusahaan_".$x['value']."-Kode Akun ".$x['name'],"");
        $smis   ->addSuperCommandAction("akun_pendapatan_perusahaan_".$x['value'],"kode_akun_pendapatan");
        $smis   ->addSuperCommandArray("akun_pendapatan_perusahaan_".$x['value'],"akun-pendapatan-perusahaan-".$x['value'],"nomor",true);
    }
}

if ($smis->isGroupAdded("perusahaan", "Pendapatan Perusahaan", "fa fa-users")) {
    global $db;
    $uitable = new Table(array(),"");
    require_once 'smis-base/smis-include-service-consumer.php';
    $serv = new ServiceConsumer($db,"get_perusahaan_pasien",NULL,"registration");
    $serv ->execute();
    $res  = $serv->getContent();
    foreach($res as $x){
        $smis   ->addCurrent("akun-pendapatan-perusahaan-".$x['value'],"Pendapatan ".$x['name'],"","chooser-map_akun_pendapatan-akun_pendapatan_perusahaan_".$x['value']."-Kode Akun ".$x['name'],"");
        $smis   ->addSuperCommandAction("akun_pendapatan_perusahaan_".$x['value'],"kode_akun_pendapatan");
        $smis   ->addSuperCommandArray("akun_pendapatan_perusahaan_".$x['value'],"akun-pendapatan-perusahaan-".$x['value'],"nomor",true);
    }
}

if ($smis->isGroupAdded("diskon", "Pendapatan Diskon", "fa fa-percent")) {
    $smis->addCurrent("akun-pendapatan-diskon", "Pendapatan Diskon Atas Pembelian", "", "chooser-map_akun_pendapatan-akun_pendapatan_diskon-Akun Pendapatan Diskon Atas Pembelian", "");
    $smis->addSuperCommandAction("akun_pendapatan_diskon", "kode_akun_pendapatan");
    $smis->addSuperCommandArray("akun_pendapatan_diskon", "akun-pendapatan-diskon", "nomor", true);
}


if ($smis->isGroupAdded("naik_kelas", "Naik Kelas", "fa fa-percent")) {
    $smis->addCurrent("akun-pendapatan-naik-kelas", "Pendapatan Naik Kelas & Usaha Lainnya", "", "chooser-map_akun_pendapatan-akun_pendapatan_naik_kelas-Akun Pendapatan NaiK kelas dan Usaha Lainya", "");
    $smis->addSuperCommandAction("akun_pendapatan_naik_kelas", "kode_akun_pendapatan");
    $smis->addSuperCommandArray("akun_pendapatan_naik_kelas", "akun-pendapatan-naik-kelas", "nomor", true);
}

$smis->setPartialLoad(true);
$response = $smis->init ();