<?php
    require_once("smis-framework/smis/api/SettingsBuilder.php");
    require_once("smis-base/smis-include-service-consumer.php");
    require_once("accounting/class/settings/AkuntingSettingsBuilder.php");
    global $db;
    
    $accountingSettingsBuilder = new AkuntingSettingsBuilder( $db, "accounting", "accounting", "map_akun_hpp", "Map Akun HPP" );
    
    if ($accountingSettingsBuilder->isGroupAdded("hpp", "Medis", "fa fa-file")) {
        $accountingSettingsBuilder->addCurrent("akun-hpp-obat", "Akun HPP Obat", "", "chooser-map_akun_hpp-akun_hpp_obat-Akun HPP Obat");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_obat", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_obat", "akun-hpp-obat", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-alkes", "Akun HPP Alkes", "", "chooser-map_akun_hpp-akun_hpp_alkes-Akun HPP Alkes");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_alkes", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_alkes", "akun-hpp-alkes", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-tindakan-operasi", "Akun HPP Tindakan Operasi", "", "chooser-map_akun_hpp-akun_hpp_tindakan_operasi-Akun HPP Tindakan Operasi");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_tindakan_operasi", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_tindakan_operasi", "akun-hpp-tindakan-operasi", "akun", true);
    }

    if ($accountingSettingsBuilder->isGroupAdded("non_medis", "Non Medis", "fa fa-users")) {
        $accountingSettingsBuilder->addCurrent("akun-hpp-registrasi", "Akun HPP Registrasi", "", "chooser-map_akun_hpp-akun_hpp_registrasi-Kode Akun Persediaan ATK", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_registrasi", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_registrasi", "akun-hpp-registrasi", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-jasa-lab", "Akun HPP Jasa Lab", "", "chooser-map_akun_hpp-akun_hpp_jasa_lab-Kode Akun HPP Jasa Lab", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_jasa_lab", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_jasa_lab", "akun-hpp-jasa-lab", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-lab", "Akun HPP Laborarium", "", "chooser-map_akun_hpp-akun_hpp_lab-Kode Akun Laboratorium", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_lab", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_lab", "akun-hpp-lab", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-rad", "Akun HPP Radiology", "", "chooser-map_akun_hpp-akun_hpp_rad-Kode Akun Radiology", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_rad", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_rad", "akun-hpp-rad", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-tindakan-perawat", "Akun HPP Tindakan Keperawatan", "", "chooser-map_akun_hpp-akun_hpp_tindakan_keperawatan-Kode Akun Tindakan Keperawatan", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_tindakan_keperawatan", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_tindakan_keperawatan", "akun-hpp-tindakan-perawat", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-tindakan-dokter", "Akun HPP Tindakan Dokter", "", "chooser-map_akun_hpp-akun_hpp_tindakan_dokter-Kode Akun Tindakan Dokter", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_tindakan_dokter", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_tindakan_dokter", "akun-hpp-tindakan-dokter", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-konsul-dokter", "Akun HPP Konsul Dokter", "", "chooser-map_akun_hpp-akun_hpp_konsul_dokter-Kode Akun Konsul Dokter", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_konsul_dokter", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_konsul_dokter", "akun-hpp-konsul-dokter", "akun", true);

        $accountingSettingsBuilder->addCurrent("akun-hpp-ambulance", "Akun HPP Ambulance", "", "chooser-map_akun_hpp-akun_hpp_ambulance-Kode Akun Ambulance", "");
        $accountingSettingsBuilder->addSuperCommandAction("akun_hpp_ambulance", "kode_akun_hpp");
        $accountingSettingsBuilder->addSuperCommandArray("akun_hpp_ambulance", "akun-hpp-ambulance", "akun", true);
    }

    $accountingSettingsBuilder->setPartialLoad(true);
    $response = $accountingSettingsBuilder->init();
?>