<?php
    global $db;

    $table = new Table(
        array("No.", "No. Jurnal", "Tgl. Jurnal", "Uraian", "Nilai"),
        "",
        null,
        true
    );
    $table->setName("jurnal_umum");
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setAddButtonEnable(false);
    $add_button = new Button("", "", "Jurnal");
    $add_button->setClass("btn btn-primary");
    $add_button->setAction("jurnal_umum.new_ij_umum()");
    $add_button->setIcon("fa fa-plus");
    $add_button->setIsButton(Button::$ICONIC_TEXT);
    $table->addHeaderButton($add_button);
    $table->setPrintElementButtonEnable(true);
    $table->setFooterVisible(false);

    if (isset($_POST['command'])) {
        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("Uraian", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai", "nilai", "money");
        $adapter->add("No. Jurnal", "nomor");
        $adapter->add("Tgl. Jurnal", "tanggal", "date d-m-Y");
        $adapter->add("No. - Nama Akun", "akun");
        $adapter->add("Uraian", "uraian");
        $adapter->add("Nilai", "nilai", "money");
        $dbtable = new DBTable($db, "smis_ac_transaksi");

        if ($_POST['command'] == "list") {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");

            $query_value = "
                SELECT
                    b.id, b.nomor, b.tanggal, b.keterangan as uraian, a.debet nilai
                FROM
                    smis_ac_transaksi_detail a
                        LEFT JOIN smis_ac_transaksi b ON a.id_transaksi = b.id
                        LEFT JOIN smis_ac_account c ON a.nomor_account = c.nomor
                WHERE
                    a.prop = ''
                        AND b.prop = ''
                        AND DATE(b.tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(b.tanggal) <= '" . $tanggal_sampai . "'
                        AND b.j_jurnal='Umum'
                        AND a.debet > a.kredit
                        AND a.debet > 0
                ORDER BY
                    b.tanggal ASC, a.id ASC
            ";
            $query_count = "
                SELECT
                    COUNT(*)
                FROM 
                    (" . $query_value . ") v
            ";
            $dbtable->setPreferredQuery(true, $query_value, $query_count);
            $dbtable->setShowAll(true);
        }
        require_once("accounting/class/responder/KBPenerimaanDBResponder.php");
        $dbresponder = new KBPenerimaanDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $form = new Form("", "", "Jurnal Umum");
    $tanggal_dari_text = new Text("kb_pt_tanggal_dari", "kb_pt_tanggal_dari", "01" . date("-m-Y"));
    $tanggal_dari_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_dari_text->setClass("mydate");
    $form->addElement("Dari Tgl.", $tanggal_dari_text);
    $tanggal_sampai_text = new Text("kb_pt_tanggal_sampai", "kb_pt_tanggal_sampai", date("d-m-Y"));
    $tanggal_sampai_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_sampai_text->setClass("mydate");
    $form->addElement("Sampai Tgl.", $tanggal_sampai_text);
    $proses_button = new Button("", "", "Proses");
    $proses_button->setClass("btn btn-primary");
    $proses_button->setAction("jurnal_umum.view()");
    $proses_button->setIcon("icon-white icon-repeat");
    $proses_button->setIsButton(Button::$ICONIC);
    $download_excel_button = new Button("", "", "Download XLS");
    $download_excel_button->setClass("btn btn-success");
    $download_excel_button->setAction("jurnal_umum.export_xls()");
    $download_excel_button->setIcon("fa fa-file-excel-o");
    $download_excel_button->setIsButton(Button::$ICONIC);
    $download_pdf_button = new Button("", "", "Download PDF");
    $download_pdf_button->setClass("btn btn-danger");
    $download_pdf_button->setAction("jurnal_umum.export_pdf()");
    $download_pdf_button->setIcon("fa fa-file-pdf-o");
    $download_pdf_button->setIsButton(Button::$ICONIC);
    $button_group = new ButtonGroup();
    $button_group->addButton($proses_button);
    $button_group->addButton($download_excel_button);
    $button_group->addButton($download_pdf_button);
    $form->addElement("", $button_group);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var jurnal_umum;
    $(document).ready(function() {
        $(".mydate").datepicker();
        jurnal_umum = new TableAction(
            "jurnal_umum",
            "accounting",
            "jurnal_umum",
            new Array()
        );
        jurnal_umum.addRegulerData = function(data) {
            data['tanggal_dari'] = $("#kb_pt_tanggal_dari").val();
            data['tanggal_sampai'] = $("#kb_pt_tanggal_sampai").val();
            return data;
        };
        jurnal_umum.new_ij_umum = function(data) {
            var dt = {
                page:"accounting",
                action:"ij_umum",
                prototype_name:"",
                prototype_slug:"",
                prototype_implement:""
            };
            LoadSmisPage(dt);
        };
        jurnal_umum.export_xls = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            postForm(data);
            dismissLoading();
        };
        jurnal_umum.export_pdf = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_pdf";
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        jurnal_umum.printelement = function(id) {
            var data = this.getRegulerData();
            data['command'] = "print_jurnal";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        jurnal_umum.show_add_form = function() {
            var data = this.getRegulerData();
            data['action'] = "jurnal_umum_form";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        jurnal_umum.edit = function(id) {
            var dt = {
                page:"accounting",
                action:"ij_umum",
                prototype_name:"",
                prototype_slug:"",
                prototype_implement:"",
                id_transaksi:id,                
            };
            LoadSmisPage(dt);
        };
        jurnal_umum.view();
    });
</script>