<?php
    global $db;

    $table = new Table(
        array("No.", "Tanggal", "Nomor", "Jenis Jurnal", "Keterangan", "Nilai", "Status"),
        "Acc. Jurnal Keuangan",
        null,
        true
    );
    $table->setName("daftar_draft_jurnal");
    $table->setAddButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setEditButtonEnable(false);
    $table->setDelButtonEnable(false);
    $button = new Button("", "", "Lihat");
    $button->setClass("btn-inverse");
    $button->setIsButton(Button::$ICONIC_TEXT);
    $button->setIcon("icon-eye-open icon-white");
    $table->addContentButton("detail", $button);

    if (isset($_POST['command'])) {
        $adapter = new SimpleAdapter(true, "No.");
        $adapter->add("Tanggal", "tanggal", "date d-m-Y");
        $adapter->add("Nomor", "nomor");
        $adapter->add("Jenis Jurnal", "j_jurnal");
        $adapter->add("Keterangan", "keterangan");
        $adapter->add("Nilai", "nilai", "money");
        $adapter->add("Status", "lock_acc", "trivial_0_Belum Disetujui_Sudah Disetujui");
        $dbtable = new DBTable($db, "smis_ac_draft_jurnal");
        $dbtable->addCustomKriteria("lock_draft", " = 1 ");
        $dbtable->setOrder(" lock_acc ASC, id DESC ");
        require_once("accounting/class/responder/DraftJurnalDBResponder.php");
        $dbresponder = new DraftJurnalDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $modal = new Modal("draft_jurnal_modal", "", "Draft Jurnal");
    $modal->setClass(Modal::$HALF_MODEL);
    $id_hidden = new Hidden("draft_jurnal_id", "draft_jurnal_id", "");
    $modal->addElement("", $id_hidden);
    $modal->addHTML("<div id='draft_jurnal_content'></div>", "before");
    $button = new Button("", "", "Setuju");
    $button->setAtribute("id='acc_button'");
    $button->setClass("btn-success");
    $button->setIsButton(Button::$ICONIC_TEXT);
    $button->setIcon("fa fa-check");
    $button->setAction("daftar_draft_jurnal.accept()");
    $modal->addFooter($button);
    $button = new Button("", "", "Kembalikan");
    $button->setAtribute("id='unlock_button'");
    $button->setClass("btn-inverse");
    $button->setIsButton(Button::$ICONIC_TEXT);
    $button->setIcon("fa fa-unlock");
    $button->setAction("daftar_draft_jurnal.unlock()");
    $modal->addFooter($button);
    $button = new Button("", "", "OK");
    $button->setAtribute("id='ok_button'");
    $button->setClass("btn-inverse");
    $button->setAction("$($(this).data('target')).smodal('hide')");
    $modal->addFooter($button);

    echo $modal->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var daftar_draft_jurnal;
    $(document).ready(function() {
        daftar_draft_jurnal = new TableAction(
            "daftar_draft_jurnal",
            "accounting",
            "daftar_draft_jurnal",
            new Array()
        );
        daftar_draft_jurnal.detail = function(id) {
            var data = this.getRegulerData();
            data['id'] = id;
            data['command'] = "edit";
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#draft_jurnal_content").html(json.html);
                    $("#draft_jurnal_id").val(id);
                    if (json.readonly == 1) {
                        $("#ok_button").show();
                        $("#acc_button").hide();
                        $("#unlock_button").hide();
                    } else {
                        $("#ok_button").hide();
                        $("#acc_button").show();
                        $("#unlock_button").show();
                    }
                    $("#draft_jurnal_modal").smodal("show");
                    dismissLoading();
                }
            );
        };
        daftar_draft_jurnal.accept = function() {
            var self = this;
            var data = this.getRegulerData();
            data['id'] = $("#draft_jurnal_id").val();
            data['lock_acc'] = 1;
            data['command'] = "save";
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#draft_jurnal_modal").smodal("hide");
                    self.view();
                    dismissLoading();
                }
            );
        };
        daftar_draft_jurnal.unlock = function() {
            var self = this;
            var data = this.getRegulerData();
            data['id'] = $("#draft_jurnal_id").val();
            data['lock_draft'] = 0;
            data['command'] = "save";
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#draft_jurnal_modal").smodal("hide");
                    self.view();
                    dismissLoading();
                }
            );
        };
        daftar_draft_jurnal.view();
    });
</script>