<?php 
require_once "smis-libs-class/MasterTemplate.php";
require_once "smis-libs-class/MasterSlaveTemplate.php";
require_once "accounting/class/table/AllNotifyNewTable.php";

class NotifyNewTemplate extends MasterSlaveTemplate{
    private $is_archive   = true;
    private $is_own_jenis = "";
    public function setArchive($enable){
        $this->is_archive = $enable;
        return $this;
    }

    public function setJenis($jns){
        $this->is_own_jenis = $jns;
        return $this; 
    }

    public function initialize(){
        $this->setDateTimeEnable(true);
        
        $post = new Button("","","Post");
        $post->setClass("btn btn-success");
        $post->setIcon(" fa fa-download");
        $post->setIsButton(Button::$ICONIC_TEXT);
        $post->setAction($_POST['action'].".post_all()");

        $un_post = new Button("","","Un Post");
        $un_post->setClass("btn btn-danger");
        $un_post->setIcon(" fa fa-upload");
        $un_post->setIsButton(Button::$ICONIC_TEXT);
        $un_post->setAction($_POST['action'].".un_post_all()");

        $archive = null;
        $action_archive= "";
        $dbtable = $this->getDBTable();
        if($this->is_archive){
            $archive = new Button("","","Archive");
            $archive->setClass("btn btn-danger");
            $archive->setIcon(" fa fa-upload");
            $archive->setIsButton(Button::$ICONIC_TEXT);
            $archive->setAction($_POST['action'].".archive_all()");  
            $dbtable->addCustomKriteria(" archive ","='0' ");
            $action_archive = "archive";
        }else{
            $archive = new Button("","","Un Archive");
            $archive->setClass("btn btn-primary");
            $archive->setIcon(" fa fa-upload");
            $archive->setIsButton(Button::$ICONIC_TEXT);
            $archive->setAction($_POST['action'].".un_archive_all()");
            $dbtable->addCustomKriteria(" archive ","='1' ");
            $action_archive = "un_archive";
        }
        $alltable = new AllNotifyNewTable(array("No.","Nomor Jurnal","Tanggal","Ruangan","Uraian","Nilai","Info","Status","Status Pasien"));
        $alltable->setName($this->action);
        $alltable->setDelButtonEnable(false);
        $this->getUITable()->setDelButtonEnable(false);

        
        if($this->getDBResponder()->isView()){
            $dbtable = $this ->getDBTable();
            if(isset($_POST['dari']) && $_POST['dari']!="")
                $dbtable->addCustomKriteria(" tanggal>= ","'".$_POST['dari']."'");
                
            if(isset($_POST['sampai']) && $_POST['sampai']!="")
                $dbtable->addCustomKriteria(" tanggal< ","'".$_POST['sampai']."'");    
            
            if(isset($_POST['ruangan']) && $_POST['ruangan']!="")
                $dbtable->addCustomKriteria(" entity ","='".$_POST['ruangan']."'");
            
            if(isset($_POST['status']) && $_POST['status']!="")
                $dbtable->addCustomKriteria(" status ","='".$_POST['status']."'");
            
            if(isset($_POST['id']) && $_POST['id']!="")
                $dbtable->addCustomKriteria(" id ","='".$_POST['id']."'");

            if(isset($_POST['info']) && $_POST['info']!="")
                $dbtable->addCustomKriteria(" ket "," LIKE '%".$_POST['info']."%'");

            if(isset($_POST['noreg_pasien']) && $_POST['noreg_pasien']!="")
                $dbtable->addCustomKriteria(" uraian "," LIKE '%".$_POST['noreg_pasien']."%'");
                
            if(isset($_POST['action']) && $_POST['action']!="all_notify" && $_POST['action']!="archive_notify"){
                if($this->is_own_jenis!=""){
                    $dbtable->addCustomKriteria(" jenis_data ","='".$this->is_own_jenis."'");    
                }else{
                    $jenis = str_replace("_notify","",$_POST['action']);
                    $dbtable->addCustomKriteria(" jenis_data ","='".$jenis."'");    
                }
            }    
        }
        
        $this->setUITable($alltable);
        $responder = $this   ->getDBResponder();
        $responder->setUITable($alltable);


        $status = new OptionBuilder();
        $status ->add("","",1)
                ->add("Posted","1")
                ->add("Un Posted","0");
        $info  = new OptionBuilder();
        $info  ->add("","",1)
                ->add("Removed","Removed","0")
                ->add("Updated","Updated","0")
                ->add("Ignored","Ignored","0");
        
        $ruangan = new OptionBuilder();
        $ruangan ->add("","","1");
        if($this->getDBResponder()->isPreload()){
            $query = "SELECT DISTINCT entity FROM smis_ac_notify";
            $hasil = $this->getDBTable()->get_db()->get_result($query);
            foreach($hasil as $x){
                $ruangan ->add(ArrayAdapter::format("unslug",$x->entity),$x->entity);
            }    
        }

        
        $alltable ->addModal("dari","datetime","Dari","")
                 ->addModal("sampai","datetime","Sampai","")
                 ->addModal("status","select","Status",$status->getContent())
                 ->addModal("info","select","Info",$info->getContent())
                 ->addModal("ruangan","select","Ruangan",$ruangan->getContent())
                 ->addModal("id_search","text","ID","")
                 ->addModal("noreg_search","text","No. Register","");
        
        $form   = $this->getForm();
        $this   ->getUItable()
                ->clearContent();        
        $this   ->setDateEnable(true);
        $this   ->getUItable()
                ->setAddButtonEnable(false)
                ->setDelButtonEnable(true)
                ->setEditButtonEnable(false)
                ->setPrintButtonEnable(false)
                ->setReloadButtonEnable(false)
                ->addHeaderButton($post)
                //->addHeaderButton($un_post)
                ->addHeaderButton($archive)
                ->addContentButton("post_akunting",$post)
                //->addContentButton("un_post_akunting",$un_post)
                ->addContentButton($action_archive,$archive);

        
        $button = new Button("","","");
        $button ->setClass("btn-primary")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-search")
                ->setAction($_POST['action'].".view()");
        $form   ->addElement("",$button);
        
        $this   ->getUItable()
                ->addModal("id","hidden","","")
                ->addModal("entity","text","Ruangan","")
                ->addModal("tanggal","datetime","Tanggal","")
                ->addModal("jenis_akun","text","Jenis Akun","")
                ->addModal("jenis_data","text","Jenis Data","")
                ->addModal("status","checkbox","Status","");
                
        $adapter = $this ->getAdapter();
        $adapter->setUseNumber(true,"No.","back.")
                ->add("Tanggal","tanggal","date d M Y H:i")
                ->add("Ruangan","entity","unslug")
                ->add("Nomor Jurnal","code","strtoupper")
                ->add("Info","ket")
                ->add("Uraian","uraian")
                ->add("Nilai","nilai","money Rp.")
                ->add("Data","jenis_data","unslug")
                ->add("Transaksi","jenis_akun","unslug")
                ->add("Status","status","trivial_1_<i class='fa fa-check'></i>_")
                ->add("Status Pasien","p_status","trivial_1_<span class='badge badge-warning'>Telah Pulang</span>_");
        
        $this->setModalTitle("Accounting Notify");    
        $this->addResouce("js","accounting/resource/js/notify.js");
        $this->addResouce("js","smis-base-js/smis-base-loading.js");
        $this->addRegulerData("id","id_search","id-value");
        $this->addRegulerData("ruangan","ruangan","id-value");
        $this->addRegulerData("status","status","id-value");
        $this->addRegulerData("info","info","id-value");
        $this->addRegulerData("dari","dari","id-value");
        $this->addRegulerData("sampai","sampai","id-value");
        $this->addRegulerData("noreg_pasien","noreg_search","id-value");
        
        $this->setAutoReload(true);
        parent::initialize();
    }
}

?>