<?php 
require_once "accounting/function/get_akun_pendapatan.php";
class JurnalCreator {

    private $noreg;
    private $nrm;
    private $carabayar;
    private $urji;
    private $id_asuransi;
    private $id_perusahaan;
    protected $db;
    private $slug_igd;
    private $slug_ok;
    protected $ltransaksi;
    protected $current_header;
    protected $current_detail;
    private $name_asuransi;
    private $name_perusahaan;
    private $is_piutang_hpp;
    public function __construct(Database $db,$noreg){
       
        $dbtable = new DBTable($db,"smis_rg_layananpasien");
        
        $row     = $dbtable ->select($noreg);
        $this->carabayar = $row->carabayar;
        $this->id_asuransi = $row->asuransi;
        $this->id_perusahaan = $row->nama_perusahaan;
        $this->urji = $row->uri;
        $this->db = $db;
        $this->nrm = $row->nrm;
        $this->noreg = $row->id;
        $this->slug_igd = $this->getSlugIGD();
        $this->slug_ok = $this->getSlugOK();
        $this->current_header=array();
        $this->current_detail=array();
        $this->ltransaksi=array();
        $this->is_piutang_hpp = false;

        $dbtablex = new DBTable($db,"smis_rg_asuransi");
        $asuransi = $dbtablex->select( $this->id_asuransi);
        if($asuransi!=null){
            $this->name_asuransi = $asuransi->nama;
            if($asuransi->is_hpp=="1"){
                $this->is_piutang_hpp = true;
            }
        }else{
            $this->name_asuransi = "";
        }

        $dbtablex = new DBTable($db,"smis_rg_perusahaan");
        $perusahaan = $dbtablex->select( $this->id_perusahaan );
        if($perusahaan!=null){
            $this->name_perusahaan = $perusahaan->nama;
            if($perusahaan->is_hpp=="1" && $asuransi==null){ /**diutamakan asuransi */
                $this->is_piutang_hpp = true;
            }
        }else{
            $this->name_perusahaan = "";
        }
    }

    public function isPiutangHPP(){
        return $this->is_piutang_hpp;
    }


    public function getAsuransiPerusahaan(){
        $final = "";
        if($this->name_asuransi!=""){
            $final = $this->name_asuransi;
        }

        if($this->name_perusahaan!=""){
            if($final!=""){
                $final .= "/".$this->name_perusahaan;
            }else{
                $final = $this->name_perusahaan;
            }
        }

        if($final!=""){
            $final = " - ".$final;
        }

        return $final;
    }

    public function getURJIPasien(){
        return $this->urji;
    }

    public function isBPJSKesehatan(){
        return strtoupper($this->name_asuransi)=="BPJS KESEHATAN" && strtolower($this->carabayar=="bpjs");
    }

    public function isUmum(){
        return strtolower($this->carabayar=="umum");
    }

    public function getCaraBayar(){
        return $this->carabayar;
    }

    public function getURIPendaftaran() {
        return $this->urji;
    }

    public function getCarabayarPendaftaran() {
        return $this->carabayar;
    }

    public function getIDAsuransiPendaftaran() {
        return $this->id_asuransi;
    }

    public function getIDPerusahaanPendaftaran() {
        return $this->id_perusahaan;
    }

    public function getNameAsuransiPendaftaran() {
        return $this->name_asuransi;
    }

    public function getNamePerusahaanPendaftaran() {
        return $this->name_perusahaan;
    }
    
    public function commit(){
        $this->ltransaksi[] = array(
            "header"=>$this->current_header,
            "detail"=>$this->current_detail
        );
        $this->current_header=array();
        $this->current_detail=array();
    }

    public function setHeader($layanan,$nilai,$keterangan,$create=true,$is_jurnal_balik=0,$j_jurnal="Pendapatan"){
        if(!$create){
            $nilai = $nilai*(-1);
        }
        global $user;
        $this->current_header = array(
            'j_jurnal'=>$j_jurnal,
            'operator' =>$user->getNameOnly(),
            //'jenis'=>$create?"create":"batal",
            'keterangan'=>$keterangan,
            'nilai'=>$nilai,
            'is_jurnal_balik'=>$is_jurnal_balik
        );
    }

    public function addDetail($akun,$keterangan,$debet,$kredit){
        $this->current_detail[] = array(
            "nomor_account"=>$akun,
            "keterangan"=>$keterangan,
            "debet"=>$debet,
            "kredit"=>$kredit,
        );
    }

    private function getSlugIGD(){
        $query = "SELECT prototype FROM smis_ac_map_akun WHERE nama_map = 'slug-ruangan-igd'  AND prop!='del' ";
        return $this->db->get_var($query);
    }

    private function getSlugOK(){
        $query = "SELECT prototype FROM smis_ac_map_akun WHERE nama_map = 'slug-ruangan-ok'  AND prop!='del' ";
        return $this->db->get_var($query);
    }

    public function getAkunPiutang(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"piutang-pasien-asuransi-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"piutang-pasien-perusahaan-".$this->id_perusahaan);
        }else{
            return  get_akun_pendapatan($this->db,"piutang-pasien-".$this->carabayar);
        }
    }

    public function getAkunPiutangDiajukan(){
        if($this->urji==1){
            return $this->getAkunPiutangRanap();
        }else{
            return $this->getAkunPiutangRajal();
        }
    }

    public function getAkunPiutangDiverivikasi(){
        if($this->urji==1){
            if($this->id_asuransi*1!=0){
                return get_akun_pendapatan($this->db,"piutang-pasien-asuransi-ri-diverivikasi-".$this->id_asuransi);
            }else if($this->id_perusahaan*1!=0){
                return get_akun_pendapatan($this->db,"piutang-pasien-perusahaan-ri-diverivikasi-".$this->id_perusahaan);
            }else{
                return  get_akun_pendapatan($this->db,"piutang-pasien-ri-".$this->carabayar);
            }
        }else{
            if($this->id_asuransi*1!=0){
                return get_akun_pendapatan($this->db,"piutang-pasien-asuransi-rj-diverivikasi-".$this->id_asuransi);
            }else if($this->id_perusahaan*1!=0){
                return get_akun_pendapatan($this->db,"piutang-pasien-perusahaan-rj-diverivikasi-".$this->id_perusahaan);
            }else{
                return  get_akun_pendapatan($this->db,"piutang-pasien-rj-".$this->carabayar);
            }
        }
    }

    public function getAkunPiutangRajal(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"piutang-pasien-asuransi-rj-diajukan-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"piutang-pasien-perusahaan-rj-diajukan-".$this->id_perusahaan);
        }else{
            return  get_akun_pendapatan($this->db,"piutang-pasien-rj-".$this->carabayar);
        }
    }

    public function getAkunPiutangRanap(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"piutang-pasien-asuransi-ri-diajukan-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"piutang-pasien-perusahaan-ri-diajukan-".$this->id_perusahaan);
        }else{
            return  get_akun_pendapatan($this->db,"piutang-pasien-ri-".$this->carabayar);
        }
    }


    public function getNamaAkunPiutangRanap(){
        if($this->id_asuransi*1!=0){
            return get_nama_akun($this->db,"piutang-pasien-asuransi-ri-diajukan-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_nama_akun($this->db,"piutang-pasien-perusahaan-ri-diajukan-".$this->id_perusahaan);
        }else{
            return  get_nama_akun($this->db,"piutang-pasien-ri-".$this->carabayar);
        }
    }

    public function getNamaAkunPiutangRajal(){
        if($this->id_asuransi*1!=0){
            return get_nama_akun($this->db,"piutang-pasien-asuransi-rj-diajukan-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_nama_akun($this->db,"piutang-pasien-perusahaan-rj-diajukan-".$this->id_perusahaan);
        }else{
            return  get_nama_akun($this->db,"piutang-pasien-rj-".$this->carabayar);
        }
    }

    public function getAkunLaboratory(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-asuransi-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-perusahaan-".$this->id_perusahaan);
        }else{
            return get_akun_pendapatan($this->db,"akun-pendapatan-pemeriksaan-laboratorium");
        }
        
    }

    public function getAkunPendapatanNonUmum(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-asuransi-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-perusahaan-".$this->id_perusahaan);
        }else{
            return "";
        }
        
    }

    public function getAkunRadiology(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-asuransi-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-perusahaan-".$this->id_perusahaan);
        }else{
            return get_akun_pendapatan($this->db,"akun-pendapatan-pemeriksaan-radiology");
        }
        
    }

    public function getAkunLaboratoryLain(){
        return get_akun_pendapatan($this->db,"akun-pendapatan-lainya-laboratorium");
    }

    public function getAkunHPPJasaLab(){
        return get_akun_pendapatan($this->db,"akun-hpp-jasa-lab");
    }

    public function getAkunHPPLab(){
        return get_akun_pendapatan($this->db,"akun-hpp-lab");
    }

    public function getAkunHutangVendorLab(){
        return get_akun_pendapatan($this->db,"akun-hutang-vendor-lab");
    }

    public function getAkunHPPRad(){
        return get_akun_pendapatan($this->db,"akun-hpp-rad");
    }

    public function getAkunPersediaanAlkes(){
        return get_akun_pendapatan($this->db,"akun-persediaan-alkes");
    }
    public function getAkunPersediaanObat(){
        return get_akun_pendapatan($this->db,"akun-persediaan-obat");
    }

    public function getAkunAcruelUtangJasaLab(){
        return get_akun_pendapatan($this->db,"akun-hutang-jasa-dokter");
    }

    public function getAkunAcruelUtangJasaOperator(){
        return get_akun_pendapatan($this->db,"akun-hutang-jasa-operator");
    }


    public function getAkunRadiologyLain(){
        return get_akun_pendapatan($this->db,"akun-pendapatan-lainya-radiology");
    }

    public function getAkunAmbulan(){
        return get_akun_pendapatan($this->db,"akun-pendapatan-ambulance");
    }

    public function getAkunGizi(){
        return get_akun_pendapatan($this->db,"akun-pendapatan-gizi");
    }

    public function getAkunPendaftaran(){
        if($this->id_asuransi*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-asuransi-".$this->id_asuransi);
        }else if($this->id_perusahaan*1!=0){
            return get_akun_pendapatan($this->db,"akun-pendapatan-perusahaan-".$this->id_perusahaan);
        }else{
            return  get_akun_pendapatan($this->db,"akun-pendapatan-pendaftaran");
        }
    }

    public function getAkunHPPRegistrasi(){
        return get_akun_pendapatan($this->db,"akun-hpp-registrasi");
    }

    private function fixPrototype($prototype){
        if($prototype==$this->slug_igd){
            $prototype = "igd";
        }else if($prototype==$this->slug_ok){
            $prototype = "ok";
        }
        return $prototype;
    } 


    public function getAkunHPPTindakanDokter(){
        return get_akun_pendapatan($this->db,"akun-hpp-tindakan-dokter");
    }

    public function getAkunHPPKonsulDokter(){
        return get_akun_pendapatan($this->db,"akun-hpp-konsul-dokter");
    }

    public function getAkunHPPTindakanKeperawatan(){
        return get_akun_pendapatan($this->db,"akun-hpp-tindakan-perawat");
    }

    public function getAkunHutangTindakanKeperawatan(){
        return get_akun_pendapatan($this->db,"akun-hutang-jasa-perawat");
    }

    public function getAkunSewaKamar($prototype){
        return get_akun_pendapatan($this->db,"akun-pendapatan-sewa-kamar-".$this->fixPrototype($prototype));
    }

    public function getAkunTindakanDokter($prototype){
        return get_akun_pendapatan($this->db,"akun-pendapatan-tindakan-dokter-".$this->fixPrototype($prototype));
    }

    public function getAkunKonsulDokter($prototype){
        return get_akun_pendapatan($this->db,"akun-pendapatan-konsul-dokter-".$this->fixPrototype($prototype));
    }


    public function getAkunTindakanPerawat($prototype){
        return get_akun_pendapatan($this->db,"akun-pendapatan-tindakan-perawat-".$this->fixPrototype($prototype));
    }

    public function getAkunAlkesBHP($prototype){
        return get_akun_pendapatan($this->db,"akun-pendapatan-alkesbhp-".$this->fixPrototype($prototype));
    }

    public function getAkunOksigenCentral($prototype) {
        return get_akun_pendapatan($this->db, "akun-pendapatan-oksigen_central-" . $this->fixPrototype($prototype));
    }

    public function getAkunATK(){
        return get_akun_pendapatan($this->db,"akun-persediaan-atk");
    }

    public function getAkunKas(){
        return get_akun_pendapatan($this->db,"akun-penerimaan-tunai-kasir");
    }

    public function getAkunBank($id_bank){
        return get_akun_pendapatan($this->db,"akun-penerimaan-bank-kasir-".$id_bank);
    }

    public function getAkunPendapatanNaikKelas(){
        return get_akun_pendapatan($this->db,"akun-pendapatan-naik-kelas");
    }

    public function getAkunLainya($prototype){
        return get_akun_pendapatan($this->db,"akun-pendapatan-lainya-".$this->fixPrototype($prototype));
    }

    public function execute(){
        if(getSettings($this->db,"accounting-activate-jurnal-pendapatan","1")=="0"){
            return;
        }
        if(count($this->ltransaksi)==0){
            return;
        }
        require_once "smis-base/smis-include-service-consumer.php";
        $data['ltransaksi'] = $this->ltransaksi;
        $serv=new ServiceConsumer($this->db,"push_jurnal",$data,"accounting");
		$serv->execute();
    }

    public function BuatJurnalBalikRajalKeRanap(){
        $key =  " - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - ";

        $query = "  SELECT * FROM smis_ac_transaksi WHERE is_jurnal_balik=0
                    AND  keterangan LIKE '%(RJ -%$key%' ";
        $list = $this->db->get_result($query);

        $semuajurnal = array();
        $listid = array();
        $nilaibalik = 0;
        foreach($list as $x){
            $nilaibalik += $x->nilai;
            $semuajurnal[$x->id] = array();
            $semuajurnal[$x->id]['h'] = $x;
            $semuajurnal[$x->id]['d'] = array();
            $listid[] = $x->id;
        }
        $nilaibalik = $nilaibalik*(-1);
        $deskripsi = "Jurnal Balik RJ ke RI (RJ - ".ArrayAdapter::format("unslug",$this->carabayar)." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - create)";
        $this->setHeader("-",$nilaibalik,$deskripsi,true,1);

        $query = "  SELECT * FROM smis_ac_transaksi_detail WHERE id_transaksi = ".(implode(" OR id_transaksi = ",$listid))." ";
        $detail = $this->db->get_result($query);
        foreach($detail as $d){
            $semuajurnal[$d->id_transaksi]['d'][] = $d;
            $this->addDetail($d->nomor_account,$d->keterangan,$d->kredit,$d->debet);
        }
        /**commit jurnal baliknya */
        $this->commit();

        /**menginapkan semua jurnal */
        $akun_piutang_rajal = $this->getAkunPiutangRajal();
        $akun_piutang_ranap = $this->getAkunPiutangRanap();
                
        foreach($semuajurnal as $jur){
            $header = $jur['h'];
            $detail = $jur['d'];
            $this->setHeader(" - ",$header->nilai,str_replace("(RJ - ","(RI - ",$header->keterangan),true,1);
            foreach($detail as $d){
                $noaccount = $d->nomor_account;
                if($noaccount == $akun_piutang_rajal){
                    $noaccount = $akun_piutang_ranap;
                }    
                $this->addDetail($noaccount,str_replace("(RJ - ","(RI - ",$d->keterangan),$d->debet,$d->kredit);
            }
            $this->commit();

        }

    }

    public function BuatJurnalBalikRanapKeRajal(){
        $key =  " - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - ";

        $query = "  SELECT * FROM smis_ac_transaksi WHERE is_jurnal_balik=0
                    AND  keterangan LIKE '%(RJ -%$key%' ";
        $list = $this->db->get_result($query);

        $semuajurnal = array();
        $listid = array();
        $nilaibalik = 0;
        foreach($list as $x){
            $nilaibalik += $x->nilai;
            $semuajurnal[$x->id] = array();
            $semuajurnal[$x->id]['h'] = $x;
            $semuajurnal[$x->id]['d'] = array();
            $listid[] = $x->id;
        }
        //$nilaibalik = $nilaibalik*(-1); tidak di kali (-1) karena akan dibuat untuk membalik yang jurna ranap
        $deskripsi = "Jurnal Balik RI ke RJ (RI - ".ArrayAdapter::format("unslug",$this->carabayar)." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - create)";
        $this->setHeader("-",$nilaibalik,$deskripsi,true,1);

        $query = "  SELECT * FROM smis_ac_transaksi_detail WHERE id_transaksi = ".(implode(" OR id_transaksi = ",$listid))." ";
        $detail = $this->db->get_result($query);
        foreach($detail as $d){
            $semuajurnal[$d->id_transaksi]['d'][] = $d;
            $this->addDetail($d->nomor_account,$d->keterangan,$d->debet,$d->kredit);
        }
        /**commit jurnal baliknya */
        $this->commit();

        /**mendouble rawat jalan semua jurnal */
        foreach($semuajurnal as $jur){
            $header = $jur['h'];
            $detail = $jur['d'];
            $this->setHeader(" - ",$header->nilai,$header->keterangan,true,1);
            foreach($detail as $d){
                $this->addDetail($d->nomor_account,$d->keterangan,$d->debet,$d->kredit);
            }
            $this->commit();
        }
        
    }

    public function UpdateJurnalRajalKeRanap(){
        $key =  " - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - ";
        $akun_piutang_rajal = $this->getAkunPiutangRajal();
        $akun_piutang_ranap = $this->getAkunPiutangRanap();
        $nama_akun_piutang_ranap = $this->getNamaAkunPiutangRanap();

        $query = "  UPDATE smis_ac_transaksi_detail set 
                    nomor_account = '$akun_piutang_ranap', 
                    nama_account = '$nama_akun_piutang_ranap' 
                    WHERE keterangan LIKE '%$key%' AND nomor_account='$akun_piutang_rajal' ";       
        $this->db->query($query);

        $query = "  UPDATE smis_ac_transaksi set 
                    keterangan = replace(keterangan,'(RJ -','(RI -')
                    WHERE keterangan LIKE '%$key%' ";
        $this->db->query($query);

        $query = "  UPDATE smis_ac_transaksi_detail set 
                    keterangan = replace(keterangan,'(RJ -','(RI -')
                    WHERE keterangan LIKE '%$key%' ";
        $this->db->query($query);
    }

    public function UpdateurnalRanapKeRajal(){
        $key =  " - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - ";
        $akun_piutang_rajal = $this->getAkunPiutangRajal();
        $akun_piutang_ranap = $this->getAkunPiutangRanap();
        $nama_akun_piutang_rajal = $this->getNamaAkunPiutangRajal();

        $query = "  UPDATE smis_ac_transaksi_detail set 
                    nomor_account = '$akun_piutang_rajal', 
                    nama_account = '$nama_akun_piutang_rajal' 
                    WHERE keterangan LIKE '%$key%' AND nomor_account='$akun_piutang_ranap' ";       
        $this->db->query($query);

        $query = "  UPDATE smis_ac_transaksi set 
                    keterangan = replace(keterangan,'(RI -','(RJ -')
                    WHERE keterangan LIKE '%$key%' ";
        $this->db->query($query);

        $query = "  UPDATE smis_ac_transaksi_detail set 
                    keterangan = replace(keterangan,'(RI -','(RJ -')
                    WHERE keterangan LIKE '%$key%' ";
        $this->db->query($query);
    }



    /**CREATE DESKRIPSI */
    public function createDeskripsiPiutang($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi  = "Piutang Pasien ".$this->carabayar;
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }

    public function createDeskripsiHPP($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi  = "HPP Registrasi Pasien ".$this->carabayar;
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }


    public function createDeskripsiATK($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi  = "Persediaan ATK Pasien ".$this->carabayar;
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()."  - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }

    public function createDeskripsiPersediaanAlkes($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi  = "Persediaan Alkes ".$this->carabayar;
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }

    public function createDeskripsiPersediaanObat($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi  = "Persediaan Obat ".$this->carabayar;
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }

    public function createDeskripsiPendapatan($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        if(strpos($layanan,"Pembatalan")!==false){
            $deskripsi  = $layanan;
        }else{
            $deskripsi  = "Pendapatan ".$layanan;
        }
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }

    public function createHPPJasa($ruangan,$layanan,$nama_tindakan,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        if(strpos($layanan,"Pembatalan")!==false){
            $deskripsi  = $layanan;
        }else{
            $deskripsi  = "HPP ".$layanan;
        }
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }

    public function createUtangAcruel($ruangan,$layanan,$nama_tindakan,$nama_dokter,$uri=-1,$is_create=true,$id_tindakan=0){
        $nama_tindakan = str_replace($layanan,"",$nama_tindakan);
        $nama_tindakan = $layanan." - ".$nama_tindakan;
        $create = $is_create?"Create":"Batal";

        if($nama_dokter!=""){
            $nama_dokter = " - ".$nama_dokter;
        }

        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        if(strpos($layanan,"Pembatalan")!==false){
            $deskripsi  = $layanan;
        }else{
            $deskripsi  = "Utang Acruel ".$layanan;
        }
        $id_tindakan = ($id_tindakan>0)?" - ".$id_tindakan:"";
        $deskripsi .= " ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".$nama_tindakan." - ".ArrayAdapter::format("unslug",$ruangan).$id_tindakan." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg).$nama_dokter." - $create)";
        return $deskripsi;
    }


    /**
     * $deskripsi Pembayaran Kas/Bank
     * $ruangan Kasir
     * $cara Tunai / Bank
     */
    public function createDeskripsi($deskripsi,$ruangan,$cara,$is_create=true,$uri=-1){
        $create = $is_create?"Create":"Batal";
        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi = $deskripsi." ($uri - ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." - ".ArrayAdapter::format("unslug",$ruangan)." - ".$cara." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }


    public function createDeskripsiPiutangKasir($deskripsi,$ruangan,$cara,$is_create=true,$uri=-1){
        $create = $is_create?"Create":"Batal";
        if($uri==-1){
            $uri = $this->urji==1?"RI":"RJ";
        }else{
            $uri = $uri==1?"RI":"RJ";
        }
        $deskripsi = $deskripsi." ".ArrayAdapter::format("unslug",$this->carabayar).$this->getAsuransiPerusahaan()." ($uri - ".ArrayAdapter::format("unslug",$this->carabayar)." - ".ArrayAdapter::format("unslug",$ruangan)." - ".$cara." - ".ArrayAdapter::format("only-digit6",$this->nrm)." - ".ArrayAdapter::format("only-digit6",$this->noreg)." - $create)";
        return $deskripsi;
    }


}