<?php 

class TrialBalanceDBReport extends DBReport{
    
    protected $filename;
    
    public function setFileName($name){
        $this->filename=$name;
        return $this;
    }
   
    
    public function excel(){
        date_default_timezone_set ( "Asia/Jakarta" );
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        
        $file    = new PHPExcel ();
        $sheet   = $file->getActiveSheet();
        $periode = ArrayAdapter::dateFormat("date d M Y H:i",$_POST['from_date'])." - ".ArrayAdapter::dateFormat("date d M Y H:i",$_POST['to_date']);
        
        $sheet->mergeCells("B1:J1")->setCellValue("B1","NERACA SALDO");
        $sheet->mergeCells("B2:J2")->setCellValue("B2",$periode); 
        
        $sheet->mergeCells("B3:B4")->setCellValue("B3","No.");
        $sheet->mergeCells("C3:C4")->setCellValue("C3","Nomor Rekening");
        $sheet->mergeCells("D3:D4")->setCellValue("D3","Nama Rekening");
        
        $sheet->mergeCells("E3:F3")->setCellValue("E3","Saldo Awal");
        $sheet->mergeCells("G3:H3")->setCellValue("G3","Perubahan");
        $sheet->mergeCells("I3:J3")->setCellValue("I3","Saldo Akhir");
        
        $sheet->setCellValue("E4","Debet");
        $sheet->setCellValue("F4","Kredit");
        $sheet->setCellValue("G4","Debet");
        $sheet->setCellValue("H4","Kredit");
        $sheet->setCellValue("I4","Debet");
        $sheet->setCellValue("J4","Kredit");
        
        $data=$this->dbtable->view("",0);
        $list = $data['data'];
        $no=4;
        $iter=0;
        
        foreach($list as $onerow){
            $iter++;
            $no++;
             
            $sheet->setCellValue("B".$no,$iter.". ");
            $sheet->setCellValue("C".$no,$onerow['nomor']." ");
            $sheet->setCellValue("D".$no,$onerow['nama']);            
            $sheet->setCellValue("E".$no,$onerow['sad']);
            $sheet->setCellValue("F".$no,$onerow['sak']);            
            $sheet->setCellValue("G".$no,$onerow['td']);
            $sheet->setCellValue("H".$no,$onerow['tk']);
            $grand = $onerow['sad']+$onerow['td']-$onerow['sak']-$onerow['tk'];
            $sheet->setCellValue("I".$no,$grand>0?$grand:0);
            $sheet->setCellValue("J".$no,$grand<0?$grand*-1:0);           
        }
        $last_number=$no;
        $no++;
        $sheet->setCellValue("D".$no,"Total");
        $sheet->setCellValue("E".$no,"=SUM(E5:E".$last_number.")");
        $sheet->setCellValue("F".$no,"=SUM(F5:F".$last_number.")");
        $sheet->setCellValue("G".$no,"=SUM(G5:G".$last_number.")");
        $sheet->setCellValue("H".$no,"=SUM(H5:H".$last_number.")");
        $sheet->setCellValue("I".$no,"=SUM(I5:I".$last_number.")");
        $sheet->setCellValue("J".$no,"=SUM(J5:J".$last_number.")");
        $no++;
        
        
        $thin['borders']['top']['style']=PHPExcel_Style_Border::BORDER_THIN;
        $all['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN;        
        $fillheader['fill']['type']=PHPExcel_Style_Fill::FILL_SOLID;
        $fillheader['fill']['color']['rgb']='EEEEEE';
        
        $sheet->getStyle ( "B3:J3" )->applyFromArray ( $thin );
        $sheet->getStyle ( "B5:J5" )->applyFromArray ( $thin );
        $sheet->getStyle ( "B".($last_number+1).":J".($last_number+1) )->applyFromArray ( $thin );        
        $sheet->getStyle('E4:J'.$no)->getNumberFormat()->setFormatCode('#,##0.00');
        
        $sheet->getColumnDimension("B")->setAutoSize(true);
        $sheet->getColumnDimension("C")->setAutoSize(true);
        $sheet->getColumnDimension("D")->setAutoSize(true);
        $sheet->getColumnDimension("E")->setAutoSize(true);
        $sheet->getColumnDimension("F")->setAutoSize(true);
        $sheet->getColumnDimension("G")->setAutoSize(true);
        $sheet->getColumnDimension("H")->setAutoSize(true);
        $sheet->getColumnDimension("I")->setAutoSize(true);
        $sheet->getColumnDimension("J")->setAutoSize(true);
         
        /*start - BLOCK UNTUK TEXT ALIGN*/
        $center = array();
        $center ['alignment']=array();
        $center ['alignment']['horizontal']=PHPExcel_Style_Alignment::HORIZONTAL_CENTER;
        $sheet->getStyle ( 'B1:J3' )->applyFromArray ($center);
        $sheet->getStyle('B'.($last_number+1).':J'.($last_number+2) )->getFont()->setBold(true);
        
        $sheet->getStyle('B1:J4')->getFont()->setBold(true);
        $sheet->getStyle("B1:J2")->getFont()
                                    ->getColor()->setRGB('2222BB');
        $sheet->getStyle("B1:J1")->getFont()
                                    ->setSize(15);
        
                                
        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="'.$this->filename.'.xls"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
        return;
    }
    
}

?>