<?php 

class TrialBalanceDBTable extends DBTable{
    protected $from;
    protected $to;
    public function setRange($from,$to){
        $this->from= $from;
        $this->to = $to;
    }

    public function view($term,$page){
        global $db;
        $data = array();

        $query = "SELECT * FROM smis_ac_account ORDER BY nomor ASC";
        $list = $db->get_result($query);
        foreach($list as $x){
            if(!isset($data[$x->nomor])){
                $data[$x->nomor] = array(
                    "nomor"=>$x->nomor,
                    "nama"=>$x->nama,
                    "sad"=>0,
                    "sak"=>0,
                    "td"=>0,
                    "tk"=>0
                );
            }

            if($x->nilai_saldo_awal*1!=0 && $x->tgl_saldo_awal<=$this->to){
                $debet = $x->dk*$x->nilai_saldo_awal*(-1);
                $kredit = $x->dk*$x->nilai_saldo_awal;
                $debet = $debet>0?$debet:0;
                $kredit = $kredit>0?$kredit:0;

                if($x->tgl_saldo_awal<=$this->from){
                    $data[$x->nomor]['sad'] = $debet;
                    $data[$x->nomor]['sak'] = $kredit;
                }else{
                    $data[$x->nomor]['td'] = $debet;
                    $data[$x->nomor]['tk'] = $kredit;
                }
            }
        }

        $query = "SELECT nomor_account,
                    SUM(IF(DATE(tanggal)<='".$this->from."',debet,0)) as sad,
                    SUM(IF(DATE(tanggal)<='".$this->from."',kredit,0)) as sak,
                    SUM(IF(DATE(tanggal)>'".$this->from."',debet,0)) as td,
                    SUM(IF(DATE(tanggal)>'".$this->from."',kredit,0)) as tk
                    FROM smis_ac_transaksi_detail 
                    WHERE DATE(tanggal) <= '".$this->to."' 
                    GROUP BY nomor_account ORDER BY nomor_account
                    ";
        $list = $db->get_result($query);
        foreach($list as $x){
            $data[$x->nomor_account]['sad'] += $x->sad;
            $data[$x->nomor_account]['sak'] += $x->sak;
            $data[$x->nomor_account]['td'] += $x->td;
            $data[$x->nomor_account]['tk'] += $x->tk;
        }

		$pack['page']=1;
		$pack['data']=$data;
		$pack['max_page']=1;	
		return $pack;
	}
}