<?php 

class TrialBalanceAdapter extends ArrayAdapter {
	private $debet 			= 0;
	private $kredit 		= 0;
	private $sa_debet		= 0;
	private $sa_kredit		= 0;
	private $ta_debet		= 0;
	private $ta_kredit		= 0;
	
	public function adapt($onerow) {
		$array             		 = array ();
		$array ['Nomor']   		 = $onerow['nomor'];
		$array ['Nama']    		 = $onerow['nama'];
		$array ['SA_Debet']      = self::format ( 'money ',$onerow['sad']);
		$array ['SA_Kredit']     = self::format ( 'money ',$onerow['sak']);
		$array ['TA_Debet']      = self::format ( 'money ',$onerow['td']);
		$array ['TA_Kredit']     = self::format ( 'money ',$onerow['tk']);
		$grand = $onerow['sad']+$onerow['td']-$onerow['sak']-$onerow['tk'];
		if($grand>=0){
			$array ['Debet']      = self::format ( 'money ',$grand);
			$this->debet += $grand;
		}else{
			$grand = $grand*-1;
			$array ['Kredit']      = self::format ( 'money ',$grand);
			$this->kredit += $grand;
		}
		$this->sa_debet += $onerow['sad'];
		$this->sa_kredit += $onerow['sak'];
		$this->ta_debet += $onerow['td'];
		$this->ta_kredit += $onerow['tk'];
		return $array;
	}

	public function getContent($d) {
		$data                   = parent::getContent ( $d );
		$array ['Nama']         = "<strong>Grand Total</strong>";
		$array ['SA_Debet']     = self::format ( 'money ',$this->sa_debet);
		$array ['SA_Kredit']    = self::format ( 'money ',$this->sa_kredit);
		$array ['TA_Debet']     = self::format ( 'money ',$this->ta_debet);
		$array ['TA_Kredit']    = self::format ( 'money ',$this->ta_kredit);
		$array ['Debet']        = "<strong>" . self::format ( 'money ', $this->debet ) . "</strong>";
		$array ['Kredit']       = "<strong>" . self::format ( 'money ', $this->kredit ) . "</strong>";
		$data  []               = $array;
		return $data;
	}
}

?>