<?php 
    class JournalAdapter extends ArrayAdapter{
        private $saldo_akhir = 0;
        private $db;
        private $account;
        private $dari;
        private $included=false;
        private $saldo_awal=false;
        private $sum_debet = 0;
        private $sum_kredit = 0;
        private $dk;
        private $tgl_saldo_awal;
        private $nilai_saldo_awal;
        
        private $no_saldo_awal=0;
        private $no_saldo_awal_debet=0;
        private $no_saldo_awal_kredit=0;
        public function setDB($db){
            $this->db=$db;
            return $this;
        }
        
        public function setAccount($account){
            $this->account = $account;
            $query = "SELECT dk,tgl_saldo_awal,nilai_saldo_awal  FROM smis_ac_account WHERE  prop!='del' AND nomor='".$account."' ";
            $row = $this->db->get_row($query);
            if($row!=null){
                $this->dk = $row->dk*(-1);
                $this->tgl_saldo_awal = $row->tgl_saldo_awal;
                $this->nilai_saldo_awal = $row->nilai_saldo_awal;                
            }
            return $this;
        }
        
        public function setDari($dari){
            $this->dari=$dari;
            return $this;
        }
        
        public function setIncluded($included){
            $this->included=$included;
            return $this;
        }
        
        public function adapt($onerow) {
            $this->number++;
            $array = array ();
            $array ['id_notify']    = $onerow->id_notify;
            $array ['id']           = $onerow->id;
            $array ['No. Ref']      = self::format ( 'only-digit8', $onerow->id );
            $array ['No. Jurnal']   = $onerow->nomor;
            $array ['No.']          = $this->number.".";
            $array ['Tanggal']      = self::format ( 'date d-m-Y', $onerow->tanggal );
            $array ['Nomor']        = $onerow->nomor;
            $array ['Grup']         = self::format("unslug",$onerow->grup);
            $array ['Jenis']        = self::format("unslug",$onerow->jenis);
            $array ['Keterangan']   = $onerow->keterangan;
            $array ['Account']      = $onerow->nomor_account . " " . $onerow->nama_account;
            $array ['Uraian']       = $onerow->uraian;            
            if($onerow->jenis!="saldo_awal"){
                $array ['Debet']             = self::format ( 'money ', $onerow->debet );
                $array ['Kredit']            = self::format ( 'money ', $onerow->kredit );

                $array ['nDebet']             = $onerow->debet;
                $array ['nKredit']            = $onerow->kredit;
                
                $this->no_saldo_awal        += $onerow->debet - $onerow->kredit;
                $this->no_saldo_awal_debet  += $onerow->debet;
                $this->no_saldo_awal_kredit += $onerow->kredit;
            }else{
                $array ['Debet']        = self::format ( 'money ', "0" );
                $array ['Kredit']       = self::format ( 'money ', "0");  
                $array ['nDebet']       = 0;
                $array ['nKredit']      = 0;                  
                $this->saldo_awal       = true;            
            }
            $array ['Code']         = $onerow->code;
            $this->saldo_akhir            = $this->saldo_akhir + ($onerow->debet * $this->dk) - ($onerow->kredit * $this->dk);
            $this->sum_debet        += $onerow->debet;
            $this->sum_kredit        += $onerow->kredit;
            $array ['Saldo']  = self::format ( 'money ', $this->saldo_akhir );
            $array ['nSaldo']  = $this->saldo_akhir;
            
            //$array ['Saldo Debet']  = $this->saldo_akhir > 0 ? self::format ( 'money Rp.', $this->saldo_akhir ) : self::format ( 'money Rp.', "0" );
            //$array ['Saldo Kredit'] = $this->saldo_akhir < 0 ? self::format ( 'money Rp.', $this->saldo_akhir * (- 1) ) : self::format ( 'money Rp.', "0" );
            return $array;
        }
        
        public function getSummary($db,$noakun,$dari,$included=true){
            if($db==null || substr($noakun, 0, 1)*1  >=4){
                return 0;
            }
            
            $query="SELECT SUM(smis_ac_transaksi_detail.debet) as debet, 
                    SUM(smis_ac_transaksi_detail.kredit) as kredit 
                    FROM smis_ac_transaksi
                    LEFT JOIN smis_ac_transaksi_detail 
                    ON smis_ac_transaksi.id = smis_ac_transaksi_detail.id_transaksi
                    WHERE smis_ac_transaksi.tanggal<'".$dari."' 
                    AND smis_ac_transaksi.prop!='del'
                    AND smis_ac_transaksi_detail.prop!='del' 
                    AND smis_ac_transaksi.prop!='del' 
                    AND nomor_account ".($included ?" LIKE '".$noakun."%' ":" = '".$noakun."' ").";";
            $hasil=$db->get_row($query);
            $summary = $this->nilai_saldo_awal*$this->dk;
            if($hasil!=null){
                $summary = $summary + ($hasil->debet-$hasil->kredit)*$this->dk;
            }
            return $summary;
        }
        
        public function getContent($data){
            $saldo_awal=$this->getSummary($this->db,$this->account,$this->dari,$this->included);
            $this->saldo_akhir=$saldo_awal;
            $result=parent::getContent($data);            
            if($this->saldo_awal===false || $saldo_awal!=0){
                $array                  = array ();
                $array ['Account']      = $this->account;
                $array ['Uraian']       = "Saldo Awal";  
                $array ['Debet']        = "";
                $array ['Kredit']       = "";          
                //$array ['Saldo Debet']  = $saldo_awal > 0 ? self::format ( 'money Rp.', $saldo_awal ) : self::format ( 'money Rp.', "0" );
                //$array ['Saldo Kredit'] = $saldo_awal < 0 ? self::format ( 'money Rp.', $saldo_awal * (- 1) ) : self::format ( 'money Rp.', "0" );
                $array ['Saldo'] = self::format ( 'money ', $saldo_awal );
                $array ['nSaldo'] = $saldo_awal;
                array_unshift($result,$array);                    
            }     
            /**saldo akhisr */       
            $array                  = array ();
            $array ['Uraian']       = "Saldo Akhir";  
            $array ['Saldo']        = self::format ( 'money ', $this->saldo_akhir );
            $array ['Debet']        = self::format ( 'money ', $this->sum_debet );
            $array ['Kredit']       = self::format ( 'money ', $this->sum_kredit); 

            $array ['nSaldo']        = $this->saldo_akhir;
            $array ['nDebet']        = $this->sum_debet;
            $array ['nKredit']       = $this->sum_kredit;
            //$array ['Debet']        = $this->no_saldo_awal_debet > 0 ? self::format ( 'money Rp.', $this->no_saldo_awal_debet ) : self::format ( 'money Rp.', "0" );
            //$array ['Kredit']       = $this->no_saldo_awal_kredit > 0 ? self::format ( 'money Rp.', $this->no_saldo_awal_kredit  ) : self::format ( 'money Rp.', "0" );    
            $result[]               = $array;
            return $result;
        }
    }
?>