<?php 
class AccountingChildSummaryAdapter extends SimpleAdapter{	
	protected $sum_array;
	protected $sum_value;
	protected $sum_format;
    protected $name_transaction;	
	
	protected $c_kode_akun;
	protected $c_debet;
	protected $c_kredit;
	protected $c_nama_akun;
	protected $c_uraian;

	public function __construct($use_number=false,$number_name="",$transaction_name="transaction"){
		parent::__construct($use_number,$number_name);
		$this->sum_array		= array();
		$this->sum_value		= array();
		$this->sum_format		= array();
		$this->name_transaction	= $transaction_name;
		
		$this->c_kode_akun 	 = new Select("kode_akun","kode_akun",array());
		$this->c_debet 	 	 = new Text("debet","debet","");
		$this->c_kredit 	 = new Text("kredit","kredit","");
		$this->c_uraian 	 = new Text("uraian","uraian","");
		$this->c_nama_akun 	 = new Text("nama_akun","nama_akun","");
	}
	
	public function addSummary($name,$dbname,$format="text"){
		$this->sum_array[$name]		= $dbname;
		$this->sum_format[$name]	= $format;
		return $this;
	}
	
	public function addFixValue($name,$value){
		$this->sum_value[$name]		= $value;
		return $this;
	}
	
	public function adapt($d){
		$this->number++;
		$ar		= array();
		if(is_array($d)){
			$ar = $d;
		}else{
			$ar	= get_object_vars($d);
		}
		//$array=parent::adapt($ar);

		$this->c_debet->setValue($ar['debet']);
		$this->c_kredit->setValue($ar['kredit']);
		$this->c_uraian->setValue($ar['keterangan']);
		$this->c_nama_akun->setValue($ar['nama_account']);

		$array["id"] 				= $ar['id'];
		$array["No."] 				= $this->number;
		$array["Nomor Account"] 	= $this->c_kode_akun->getHtml();
		$array["Account"] 			= $this->c_debet->getHtml();
		$array["Debet"] 			= $this->c_debet->getHtml();
		$array["Kredit"] 			= $this->c_kredit->getHtml();
		$array["Keterangan"] 		= $this->c_uraian->getHtml();
		foreach($this->sum_array as $name=>$dbname){
			if(!isset($this->sum_value[$name]))
				$this->sum_value[$name]	 = 0;
			$this->sum_value[$name]		+= $ar[$dbname];
		}
		
		return $array;
	}
	
	public function getContent($data){
		$content					= parent::getContent($data);
		$sum_debit					= $this->sum_value["Debet"];
		$sum_kredit					= $this->sum_value["Kredit"];
		foreach($this->sum_format as $name=>$format){
			if($format=="text") continue;
			$value					= $this->sum_value[$name];
			$this->sum_value[$name]	= self::format($format, $value);
		}
		if($sum_debit!=$sum_kredit){
			$this->sum_value["Debet"]	= "<font id='".$this->name_transaction."_red_block' class='red_text'>".self::format("money Rp.", $sum_debit)."</font>";
			$this->sum_value["Kredit"]	= "<font class='red_text'>".self::format("money Rp.", $sum_kredit)."</font>";
		}
		$content[]	= $this->sum_value;
		return $content;
	}
}
?>