<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\AjaxRequestController;
use App\Http\Controllers\CredentialsAntrianController;
use App\Http\Controllers\AntrianPendaftaranController;
use App\Http\Controllers\AntrianPoliController;
use App\Http\Controllers\AntrianFarmasiController;
use App\Http\Controllers\AntrianOperasiController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\CheckinController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DashboardAntrianController;
use App\Http\Controllers\DokumenRmController;
use App\Http\Controllers\GuestRegistrationController;
use App\Http\Controllers\HakAksesController;
use App\Http\Controllers\JadwalPoliLocalController;
use App\Http\Controllers\JadwalPoliBpjsController;
use App\Http\Controllers\LaporanHutangPoController;
use App\Http\Controllers\LaporanHutangNonPoController;
use App\Http\Controllers\HppController;
use App\Http\Controllers\OPLJasaController;
use App\Http\Controllers\PenggunaController;
use App\Http\Controllers\ProfilController;
use App\Http\Controllers\RuanganIgdController;
use App\Http\Controllers\ResumeMedisController;
use App\Http\Controllers\ReferensiDokterController;
use App\Http\Controllers\ReferensiPoliController;
use App\Http\Controllers\RekapAntrianController;
use App\Http\Controllers\SettingAsuransiController;
use App\Http\Controllers\WaktuTaskIdController;
use App\Http\Controllers\AntrianManualController;
use App\Http\Controllers\DataIndukKepegawaian\BagianController;
use App\Http\Controllers\DataIndukKepegawaian\BankPegawaiController;
use App\Http\Controllers\DataIndukKepegawaian\GolonganController;
use App\Http\Controllers\DataIndukKepegawaian\PendidikanController;
use App\Http\Controllers\DataIndukKepegawaian\PendidikanProfesiController;
use App\Http\Controllers\DataIndukKepegawaian\RuanganPegawaiController;
use App\Http\Controllers\DataIndukKepegawaian\StatusPegawaiController;
use App\Http\Controllers\DataIndukKepegawaian\UnitKerjaController;
use App\Http\Controllers\DataIndukPendaftaran\AsuransiController;
use App\Http\Controllers\DataIndukPendaftaran\BahasaController;
use App\Http\Controllers\DataIndukPendaftaran\FasilitasKesehatanController;
use App\Http\Controllers\DataIndukPendaftaran\JenisKontakController;
use App\Http\Controllers\DataIndukPendaftaran\JenisKunjunganController;
use App\Http\Controllers\DataIndukPendaftaran\JenisPasienController;
use App\Http\Controllers\DataIndukPendaftaran\KabupatenController;
use App\Http\Controllers\DataIndukPendaftaran\KecamatanController;
use App\Http\Controllers\DataIndukPendaftaran\KelurahanController;
use App\Http\Controllers\DataIndukPendaftaran\PerujukController;
use App\Http\Controllers\DataIndukPendaftaran\PerusahaanController;
use App\Http\Controllers\DataIndukPendaftaran\PpkRujukanController;
use App\Http\Controllers\DataIndukPendaftaran\ProvinsiController;
use App\Http\Controllers\DataIndukPendaftaran\SpesialisPpkController;
use App\Http\Controllers\DataIndukPendaftaran\SukuController;
use App\Http\Controllers\DiskonPenjualanObatDokterController;
use App\Http\Controllers\JasaDokterBpjsController;
use App\Http\Controllers\LaporanTindakanDetailDokterController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan\AsesmenKebidananController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan\AsesmenMedisAwalRawatJalanController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan\AsesmenMedisAwalRawatJalanGigiController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan\CatatanPerkembanganPasienController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan\PengkajianKeperawatanRawatJalanController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenPasien\PendaftaranRawatJalanController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenPasien\PersetujuanUmumRawatJalanController;
use App\Http\Controllers\MedicalRecord\ERekamMedis\ERekamMedisController;
use App\Http\Controllers\PemeriksaanPcrAntigenController;
use App\Http\Controllers\PenerimaanKasirController;
use App\Http\Controllers\SatuSehat\LocationController;
use App\Http\Controllers\SatuSehat\OrganizationController;
use App\Http\Controllers\SatuSehat\PractionerController;
use App\Http\Controllers\SatuSehat\RawatJalanController;
use App\Http\Controllers\SuratKeteranganSehatController;
use App\Http\Controllers\SuratSakitController;
use App\Http\Controllers\TukarTandaTerimaController;
use Illuminate\Support\Facades\Route;
use App\Models\Banner;
use App\Models\JadwalOperasiRs;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'guest'], function () {
    Route::get('/', [AuthController::class, 'loginpage'])->name('loginpage');
    Route::post('do_login', [AuthController::class, 'do_login']);

    Route::controller(AntrianManualController::class)->group(function () {
        Route::group(['prefix' => 'antrian_manual'], function () {
            Route::get('/', 'index')->name('antrian_manual.index');
            Route::post('ambil/{lantai}', 'getAntrian')->name('antrian_manual.ambil');
            Route::get('download', 'download')->name('kunjungan_bayi_anak.download');
        });
    });
});

Route::get('cetak_antrian', [GuestRegistrationController::class, 'cetak_antrian']);

Route::get('auth_from_simrs', [AuthController::class, 'auth_from_simrs']);
Route::get('logout_from_simrs', [AuthController::class, 'logout_from_simrs']);

Route::group(['prefix' => 'ajax_request'], function () {
    Route::get('dokter_pcare', [JadwalPoliLocalController::class, 'dokter_pcare']);
    Route::get('poli_pcare', [JadwalPoliLocalController::class, 'poli_pcare']);
    Route::get('datatable_dokter', [AjaxRequestController::class, 'datatable_dokter']);
    Route::get('datatable_karyawan', [AjaxRequestController::class, 'datatable_karyawan']);
    Route::post('pesanan_lab_store', [AjaxRequestController::class, 'pesanan_lab_store']);
    Route::get('pesanan_lab_by_noreg', [AjaxRequestController::class, 'pesanan_lab_by_noreg']);
    Route::get('pesanan_lab_by_id', [AjaxRequestController::class, 'pesanan_lab_by_id']);
    Route::get('diagnosa_by_noreg', [AjaxRequestController::class, 'diagnosa_by_noreg']);
    Route::get('diagnosa_by_id', [AjaxRequestController::class, 'diagnosa_by_id']);
    Route::get('autocomplete_diagnosa', [AjaxRequestController::class, 'autocomplete_diagnosa']);
    Route::post('update_diagnosa', [AjaxRequestController::class, 'update_diagnosa']);
    Route::get('employee', [AjaxRequestController::class, 'employee']);
    Route::get('pasien_by_nrm', [AjaxRequestController::class, 'pasien_by_nrm']);
    Route::get('dokumen_kunjungan_by_noreg', [AjaxRequestController::class, 'dokumen_kunjungan_by_noreg']);
    Route::get('create_dokumen_kunjungan', [AjaxRequestController::class, 'create_dokumen_kunjungan']);
    Route::get('perujuk', [AjaxRequestController::class, 'perujuk']);
    Route::get('perujuk_by_kodedokter', [AjaxRequestController::class, 'perujuk_by_kodedokter']);
    Route::post('tambah_pasien_umum', [AjaxRequestController::class, 'tambah_pasien_umum']);
    Route::post('tambah_pasien_bpjs', [AjaxRequestController::class, 'tambah_pasien_bpjs']);
    Route::post('pasien_daftar', [AjaxRequestController::class, 'pasien_daftar']);
    Route::get('data_master_form_pendaftaran', [AjaxRequestController::class, 'data_master_form_pendaftaran']);
    Route::get('get_antrian_selesai_poli', [AjaxRequestController::class, 'get_antrian_selesai_poli']);
    Route::get('get_kabupaten', [GuestRegistrationController::class, 'ajax_request_kabupaten']);
    Route::get('get_kecamatan', [GuestRegistrationController::class, 'ajax_request_kecamatan']);
    Route::get('get_kelurahan', [GuestRegistrationController::class, 'ajax_request_kelurahan']);
    Route::get('get_pasien_by_nrm_or_ktp', [GuestRegistrationController::class, 'ajax_request_pasien']);
    Route::get('get_pasien_by_bpjs_rujukan', [GuestRegistrationController::class, 'ajax_request_pasien_bpjs']);
    Route::get('dokter_by_poli', [GuestRegistrationController::class, 'ajax_request_dokter_by_poli']);
    Route::get('jam_praktek_by_dokter', [GuestRegistrationController::class, 'ajax_request_jam_praktek_by_dokter']);
    Route::get('set_session', [AuthController::class, 'set_session']);
    Route::get('jumlah_kunjungan', [DashboardController::class, 'ajax_jumlah_kunjungan']);
    Route::get('jumlah_kunjungan_berdasarkan_cara_bayar', [DashboardController::class, 'ajax_jumlah_kunjungan_berdasarkan_cara_bayar']);
    Route::get('jumlah_kunjungan_berdasarkan_jenis_kelamin', [DashboardController::class, 'ajax_jumlah_kunjungan_berdasarkan_jenis_kelamin']);
    Route::get('jumlah_kunjungan_tertinggi_kecamatan', [DashboardController::class, 'ajax_jumlah_kunjungan_tertinggi_kecamatan']);
    Route::get('jumlah_kunjungan_terendah_kecamatan', [DashboardController::class, 'ajax_jumlah_kunjungan_terendah_kecamatan']);
    Route::get('jumlah_kunjungan_berdasarkan_baru_lama', [DashboardController::class, 'ajax_jumlah_kunjungan_berdasarkan_baru_lama']);
    Route::get('jumlah_kunjungan_rawat_jalan', [DashboardController::class, 'ajax_jumlah_kunjungan_rawat_jalan']);
    Route::get('jumlah_kunjungan_rawat_inap', [DashboardController::class, 'ajax_jumlah_kunjungan_rawat_inap']);
    Route::get('jumlah_kunjungan_tertinggi_diagnosa', [DashboardController::class, 'ajax_jumlah_kunjungan_tertinggi_diagnosa']);
    Route::get('filter_resume_medis', [ResumeMedisController::class, 'ajax_filter_resume_medis']);
    Route::get('filter_dokumen_rm', [DokumenRmController::class, 'ajax_filter_dokumen_rm']);
    Route::get('search/menu', [AuthController::class, 'ajax_search_menu']);
    Route::get('select/user', [PenggunaController::class, 'ajax_select_user']);
    Route::get('search_vendor', [LaporanHutangPoController::class, 'ajaxSearchVendor']);
    Route::get('prepare_excel', [LaporanHutangPoController::class, 'ajax_prepare_excel']);
    Route::get('write_excel', [LaporanHutangPoController::class, 'ajaxWriteExcel']);
    Route::post('write_excel', [LaporanHutangPoController::class, 'ajaxWriteExcel']);
    Route::get('doing_filter_laporan_hutang_po', [LaporanHutangPoController::class, 'ajaxDoingFilter']);
    Route::get('doing_filter_laporan_hutang_non_po', [LaporanHutangNonPoController::class, 'ajaxDoingFilter']);
    Route::get('prepare_excel/laporan_hutang_non_po', [LaporanHutangNonPoController::class, 'ajax_prepare_excel']);
    Route::post('write_excel/laporan_hutang_non_po', [LaporanHutangNonPoController::class, 'ajaxWriteExcel']);
    Route::get('hpp', [HppController::class, 'ajax_get_hpp']);
    Route::get('update_referensi_dokter', [ReferensiDokterController::class, 'update_dokter']);
    Route::get('select_jadwal_poli', [JadwalPoliLocalController::class, 'ajax_request_select_jadwal_poli']);
    Route::post('post_credentials_antrian', [CredentialsAntrianController::class, 'post_credentials']);
    Route::get('referensi_jadwal_dokter', [JadwalPoliBpjsController::class, 'referensi_jadwal_dokter']);
    Route::get('dashboard_bpjs_per_tanggal', [DashboardAntrianController::class, 'ajax_per_tanggal']);
    Route::get('dashboard_bpjs_per_bulan', [DashboardAntrianController::class, 'ajax_per_bulan']);
    Route::get('antrian_by_kode_booking', [CheckinController::class, 'antrian_by_kode_booking']);
    Route::get('antrian_by_nrm', [CheckinController::class, 'antrian_by_nrm']);
    Route::get('checkin', [CheckinController::class, 'checkin']);
    Route::post('send_broadcast', [GuestRegistrationController::class, 'send_broadcast']);
    Route::get('filter_antrian_poli', [AntrianPoliController::class, 'filter']);
    Route::get('layani_poli', [AntrianPoliController::class, 'layani_antrian']);
    Route::get('selesai_poli', [AntrianPoliController::class, 'selesai_antrian']);
    Route::get('antrian_operasi_rs', [AntrianOperasiController::class, 'ajax_request_antrian_operasi']);
    Route::get('refresh_operasi', [AntrianOperasiController::class, 'ajax_request_refresh_operasi']);
    Route::get('get_operasi', [AntrianOperasiController::class, 'ajax_get_operasi']);
    Route::get('list_task_id', [WaktuTaskIdController::class, 'ajax_request_list_task_id']);
    Route::get('antrian_pendaftaran', [AntrianPendaftaranController::class, 'ajax_request_antrian']);
    Route::get('antrian_farmasi', [AntrianFarmasiController::class, 'ajax_request_antrian']);
    Route::get('datatable_pasien', [AntrianOperasiController::class, 'datatable_pasien']);
    Route::get('select_mjkn_patient', [AjaxRequestController::class, 'select_mjkn_patient']);
    Route::put('update_mjkn', [AjaxRequestController::class, 'update_mjkn']);
    Route::get('mjkn_patient', [AjaxRequestController::class, 'pasien_mjkn']);
    Route::get('antrian_obat', [AjaxRequestController::class, 'antrian_obat']);
    Route::get('antrian_manual', [AjaxRequestController::class, 'antrian_manual']);
    Route::get('ambil_antrian_farmasi', [AjaxRequestController::class, 'ambil_antrian_farmasi']);
    Route::get('update_poli', [ReferensiPoliController::class, 'update_poli']);
    Route::get('pasien_mjkn_daftar', [AntrianPendaftaranController::class, 'pasien_mjkn_daftar']);
    Route::get('hapus_mjkn', [AntrianPendaftaranController::class, 'hapus_mjkn']);

    Route::group(['prefix' => 'observasi_pasca_operasi'], function () {
        Route::get('/', [AjaxRequestController::class, 'observasi_pasca_operasi']);
        Route::post('create', [AjaxRequestController::class, 'create_observasi_pasca_operasi']);
        Route::get('delete', [AjaxRequestController::class, 'delete_observasi_pasca_operasi']);
        Route::get('select', [AjaxRequestController::class, 'select_observasi_pasca_operasi']);
        Route::put('update', [AjaxRequestController::class, 'update_observasi_pasca_operasi']);
    });

    Route::group(['prefix' => 'resep'], function(){
        Route::get('select', [AjaxRequestController::class, 'select_resep']);
        Route::get('list_obat', [AjaxRequestController::class, 'list_obat']);
        Route::get('autocomplete_obat', [AjaxRequestController::class, 'autocomplete_obat']);
        Route::get('harga_obat', [AjaxRequestController::class, 'harga_obat']);
        Route::post('store', [AjaxRequestController::class, 'resep_store']);
        Route::patch('lock', [AjaxRequestController::class, 'resep_lock']);
    });
});

Route::get('pendaftaran_display', function () {
    return view('antrian.display_pendaftaran');
});

Route::get('poli_display', function () {
    return view('antrian.display_poli');
});

Route::get('farmasi_display', function () {
    return view('antrian.display_farmasi');
});

Route::get('operasi_display', function () {
    $data['antrian'] = JadwalOperasiRs::join('smis_rg_patient', 'jadwal_operasi_rs.nopeserta', 'smis_rg_patient.nobpjs')
        ->select('jadwal_operasi_rs.*', 'smis_rg_patient.nama', 'smis_rg_patient.id as id_pasien', 'smis_rg_patient.alamat')->where('smis_rg_patient.prop', '')->where('tanggaloperasi', date('Y-m-d'))->paginate(10);
    return view('antrian.display_operasi', $data);
});

Route::group(['middleware' => 'auth'], function () {
    Route::group(['prefix' => "guest_registration"], function () {
        Route::get('/', [GuestRegistrationController::class, 'index']);
        Route::get('pasien_umum', [GuestRegistrationController::class, 'umum']);
        Route::post('pasien_umum/create', [GuestRegistrationController::class, 'tambah_pasien']);
        Route::post('pasien_bpjs/create', [GuestRegistrationController::class, 'tambah_pasien_bpjs']);
        Route::get('pasien_umum/daftar', [GuestRegistrationController::class, 'daftar_pasien_umum']);
        Route::get('pasien_bpjs/daftar', [GuestRegistrationController::class, 'daftar_pasien_bpjs']);
        Route::post('pasien_umum/daftar/post', [GuestRegistrationController::class, 'pasien_umum_daftar_post']);
        Route::post('pasien_bpjs/daftar/post', [GuestRegistrationController::class, 'pasien_umum_daftar_post']);
        Route::get('pasien_bpjs', [GuestRegistrationController::class, 'bpjs']);
        Route::get('hasil_antrian', [GuestRegistrationController::class, 'hasil']);
        Route::get('farmasi', function () {
            return view('guest.farmasi');
        });
    });

    Route::get('checkin', [CheckinController::class, 'index']);
    Route::get('guest_home', function () {
        return view('guest.super');
    });

    Route::group(['prefix' => 'antrian'], function () {
        Route::controller(AntrianPendaftaranController::class)->group(function () {
            Route::group(['prefix' => 'pendaftaran'], function () {
                Route::get('/', 'index');
                Route::get('batal_antrian', 'batal_antrian');
                Route::get('ajax_antrian_manual', 'ajax_antrian_manual');
                Route::get('panggil_antrian', 'panggil_antrian');
                Route::get('checkin', 'checkin');
            });
            Route::get('datatable/antrian_online', 'datatable_antrian_online');
            Route::get('datatable/pasien_baru', 'datatable_pasien_baru');
        });

        Route::controller(AntrianPoliController::class)->group(function () {
            Route::group(['prefix' => 'poli'], function () {
                Route::get('/', 'index');
                Route::get('batal_antrian', 'batal_antrian');
            });
        });

        Route::controller(RekapAntrianController::class)->group(function () {
            Route::get('rekap', 'index');
            Route::get('datatable_rekap_antrian/{dari}/{sampai}', 'datatable_rekap_antrian');
            Route::get('rekap/export', 'export');
        });
    });

    Route::get('/home', function () {
        $data['banner'] = Banner::first();
        return view('home', $data);
    });

    Route::group(['prefix' => 'dashboard'], function () {
        Route::get('pelayanan', [DashboardController::class, 'index']);
        Route::get('antrian', [DashboardAntrianController::class, 'index']);
    });

    Route::group(['prefix' => 'profil'], function () {
        Route::get('/', [ProfilController::class, 'index']);
        Route::post('create', [ProfilController::class, 'store']);
    });

    Route::group(['prefix' => 'banner'], function () {
        Route::get('/', [BannerController::class, 'index']);
        Route::post('create', [BannerController::class, 'store']);
    });

    Route::group(['prefix' => 'hak_akses'], function () {
        Route::get('/', [HakAksesController::class, 'index']);
        Route::get('cari', [HakAksesController::class, 'search']);
        Route::get('create', [HakAksesController::class, 'create']);
        Route::post('create', [HakAksesController::class, 'store']);
    });

    Route::group(['prefix' => 'pengguna'], function () {
        Route::get('/', [PenggunaController::class, 'index']);
        Route::get('/cari', [PenggunaController::class, 'search']);
        Route::post('create', [PenggunaController::class, 'store']);
        Route::put('update', [PenggunaController::class, 'update']);
        Route::get('ajax_request/select/user', [PenggunaController::class, 'ajax_select_pengguna']);
        Route::get('delete', [PenggunaController::class, 'delete']);
    });

    Route::get('logout', [AuthController::class, 'logout']);

    Route::group(['prefix' => 'nama_ruangan_igd'], function () {
        Route::get('/', [RuanganIgdController::class, 'index']);
        Route::post('create', [RuanganIgdController::class, 'store']);
    });

    Route::group(['prefix' => 'medical_record'], function () {
        Route::group(['prefix' => 'resume_medis'], function () {
            Route::get('/', [ResumeMedisController::class, 'index']);
            Route::get('download', [ResumeMedisController::class, 'download']);
        });

        Route::group(['prefix' => 'dokumen_rm'], function () {
            Route::get('/', [DokumenRmController::class, 'index']);
            Route::get('download', [DokumenRmController::class, 'download']);
        });

        Route::group(['prefix' => 'e_rekam_medis'], function () {
            Route::controller(ERekamMedisController::class)->group(function () {
                Route::get('/', 'index');

                Route::group(['prefix' => 'ajax'], function () {
                    Route::get('cari_pasien', 'ajax_cari_pasien');
                    Route::get('history_kunjungan', 'ajax_history_kunjungan');
                    Route::get('dokumen_pasien', 'ajax_dokumen_pasien');
                    Route::get('dokumen_kunjungan', 'ajax_dokumen_kunjungan');
                    Route::post('create_dokumen_pasien', 'ajax_create_dokumen_pasien');
                    Route::post('create_dokumen_kunjungan', 'ajax_create_dokumen_kunjungan');
                });
            });

            Route::controller(PendaftaranRawatJalanController::class)->group(function () {
                Route::group(['prefix' => 'pendaftaran_rawat_jalan'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });

            Route::controller(PersetujuanUmumRawatJalanController::class)->group(function () {
                Route::group(['prefix' => 'persetujuan_umum_rawat_jalan'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });

            Route::controller(AsesmenMedisAwalRawatJalanController::class)->group(function () {
                Route::group(['prefix' => 'asesmen_medis_awal_rawat_jalan'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });

            Route::controller(AsesmenMedisAwalRawatJalanGigiController::class)->group(function () {
                Route::group(['prefix' => 'asesmen_medis_awal_rawat_jalan_gigi'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });

            Route::controller(AsesmenKebidananController::class)->group(function () {
                Route::group(['prefix' => 'asesmen_kebidanan'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });

            Route::controller(PengkajianKeperawatanRawatJalanController::class)->group(function () {
                Route::group(['prefix' => 'pengkajian_keperawatan_rawat_jalan'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });

            Route::controller(CatatanPerkembanganPasienController::class)->group(function () {
                Route::group(['prefix' => 'catatan_perkembangan_pasien'], function () {
                    Route::get('/', 'index');
                    Route::post('store', 'store');
                });
            });
        });


        Route::controller(SuratKeteranganSehatController::class)->group(function () {
            Route::group(['prefix' => 'surat_keterangan_sehat'], function () {
                Route::get('/', 'index')->name('surat_keterangan_sehat.index');
                Route::get('/create', 'create')->name('surat_keterangan_sehat.create');
                Route::post('/store', 'store')->name('surat_keterangan_sehat.store');
                Route::get('/edit/{id}', 'edit')->name('surat_keterangan_sehat.edit');
                Route::delete('/destory/{id}', 'destroy')->name('surat_keterangan_sehat.destory');
                Route::get('/download/{id}', 'download')->name('surat_keterangan_sehat.download');
                Route::get('/cari', 'index')->name('surat_keterangan_sehat.cari');

                Route::get('/pasien', 'getPasien')->name('surat_keterangan_sehat.pasien');
            });
        });

        Route::get('surat_sakit/download/{id}', [SuratSakitController::class, 'download'])->name('surat_sakit.download');
        Route::get('surat_sakit/diagnosa', [SuratSakitController::class, 'diagnosa'])->name('surat_sakit.diagnosa');
        Route::resource('surat_sakit', SuratSakitController::class);

        Route::resource('pemeriksaan_pcr_antigen', PemeriksaanPcrAntigenController::class);
    });

    Route::group(['prefix' => 'laporan_keuangan'], function () {
        Route::get('laporan_hutang_po', [LaporanHutangPoController::class, 'index']);
        Route::get('laporan_hutang_po/download_excel', [LaporanHutangPoController::class, 'downloadExcel'])->name('download.excel');
        Route::get('laporan_hutang_non_po', [LaporanHutangNonPoController::class, 'index']);
        Route::get('laporan_hutang_non_po/download_excel', [LaporanHutangNonPoController::class, 'downloadExcel'])->name('download.excel.laporan_hutang_non_po');
    });

    Route::group(['prefix' => 'kasir'], function () {
        Route::get('hpp', [HppController::class, 'index']);
        Route::get('hpp/download', [HppController::class, 'download']);

        Route::controller(PenerimaanKasirController::class)->group(function () {
            Route::group(['prefix' => 'penerimaan_kasir'], function () {
                Route::get('/', 'index')->name('penerimaan_kasir.index');
                Route::get('filter', 'filter')->name('penerimaan_kasir.filter');
                Route::get('download', 'download')->name('penerimaan_kasir.download');
            });
        });

        Route::controller(LaporanTindakanDetailDokterController::class)->group(function () {
            Route::group(['prefix' => 'laporan_tindakan_detail_dokter'], function () {
                Route::get('/', 'index')->name('laporan_tindakan_detail_dokter.index');
                Route::get('filter', 'filter')->name('laporan_tindakan_detail_dokter.filter');
                Route::get('download', 'download')->name('laporan_tindakan_detail_dokter.download');
            });
        });

        Route::controller(DiskonPenjualanObatDokterController::class)->group(function () {
            Route::group(['prefix' => 'diskon_penjualan_obat_dokter'], function () {
                Route::get('/', 'index')->name('diskon_penjualan_obat_dokter.index');
                Route::get('filter', 'filter')->name('diskon_penjualan_obat_dokter.filter');
                Route::get('download', 'download')->name('diskon_penjualan_obat_dokter.download');
            });
        });

        Route::controller(JasaDokterBpjsController::class)->group(function () {
            Route::group(['prefix' => 'jasa_dokter_bpjs'], function () {
                Route::get('/', 'index')->name('jasa_dokter_bpjs.index');
                Route::get('filter', 'filter')->name('jasa_dokter_bpjs.filter');
                Route::get('download', 'download')->name('jasa_dokter_bpjs.download');
            });
        });
    });

    Route::controller(OPLJasaController::class)->group(function () {
        Route::group(['prefix' => 'pembelian/po-jasa'], function () {
            //ajax
            Route::get('vendor', 'getVendor');
            Route::get('barang', 'getBarang');
            //index
            Route::get('/', 'index');
            Route::get('po-mandiri', 'OPLMandiri');
            Route::get('lihat', 'detailOPL');
            //edit
            Route::get('edit', 'editOPL');
            //store
            Route::post('opl-mandiri/store', 'storeOplMandiri');

            Route::get('hapus', 'hapus');
            Route::get('hapus-detail', 'hapusDetail');

            Route::get('cari', 'search');
            // Route::get('hpp/download', [HppController::class, 'download']);
        });
    });

    Route::group(['prefix' => 'jadwal_poli'], function () {
        Route::get('referensi_poli', [ReferensiPoliController::class, 'index']);
        Route::get('referensi_dokter', [ReferensiDokterController::class, 'index']);
        Route::get('local', [JadwalPoliLocalController::class, 'index']);
        Route::post('create', [JadwalPoliLocalController::class, 'post_jadwal_poli']);
        Route::put('update', [JadwalPoliLocalController::class, 'update_jadwal_poli']);
        Route::get('delete', [JadwalPoliLocalController::class, 'delete_jadwal_poli']);
        Route::get('bpjs', [JadwalPoliBpjsController::class, 'index']);
        Route::get('credentials', [CredentialsAntrianController::class, 'index']);
    });

    Route::group(['prefix' => 'asuransi'], function () {
        Route::get('/', [SettingAsuransiController::class, 'index']);
        Route::get('select', [SettingAsuransiController::class, 'select']);
    });

    Route::group(['prefix' => 'keuangan_kas_bank'], function () {
        Route::get('tukar_tanda_terima/download/{id}', [TukarTandaTerimaController::class, 'download'])->name('tukar_tanda_terima.download');
        Route::resource('tukar_tanda_terima', TukarTandaTerimaController::class);
    });

    Route::group(['prefix' => 'registration'], function () {
        Route::group(['prefix' => 'data_induk'], function () {
            Route::get('/', [JenisKunjunganController::class, 'index'])->name('jenis_kunjungan.index');

            Route::get('/jenis_kunjungan/search', [JenisKunjunganController::class, 'search'])->name('jenis_kunjungan.search');
            Route::get('/jenis_kunjungan/download', [JenisKunjunganController::class, 'download'])->name('jenis_kunjungan.download');
            Route::resource('jenis_kunjungan', JenisKunjunganController::class);

            Route::get('/jenis_kontak/search', [JenisKontakController::class, 'search'])->name('jenis_kontak.search');
            Route::get('/jenis_kontak/download', [JenisKontakController::class, 'download'])->name('jenis_kontak.download');
            Route::resource('jenis_kontak', JenisKontakController::class);

            Route::get('/bahasa/search', [BahasaController::class, 'search'])->name('bahasa.search');
            Route::get('/bahasa/download', [BahasaController::class, 'download'])->name('bahasa.download');
            Route::resource('bahasa', BahasaController::class);

            Route::get('/suku/search', [SukuController::class, 'search'])->name('suku.search');
            Route::get('/suku/download', [SukuController::class, 'download'])->name('suku.download');
            Route::resource('suku', SukuController::class);

            Route::get('/perusahaan/search', [PerusahaanController::class, 'search'])->name('perusahaan.search');
            Route::get('/perusahaan/download', [PerusahaanController::class, 'download'])->name('perusahaan.download');
            Route::resource('perusahaan', PerusahaanController::class);

            Route::get('/ppk_rujukan/search', [PpkRujukanController::class, 'search'])->name('ppk_rujukan.search');
            Route::get('/ppk_rujukan/download', [PpkRujukanController::class, 'download'])->name('ppk_rujukan.download');
            Route::resource('ppk_rujukan', PpkRujukanController::class);

            Route::get('/ppk_speisalis/search', [SpesialisPpkController::class, 'search'])->name('ppk_speisalis.search');
            Route::get('/ppk_speisalis/download', [SpesialisPpkController::class, 'download'])->name('ppk_speisalis.download');
            Route::resource('ppk_speisalis', SpesialisPpkController::class);

            Route::get('/asuransi/search', [AsuransiController::class, 'search'])->name('asuransi.search');
            Route::get('/asuransi/download', [AsuransiController::class, 'download'])->name('asuransi.download');
            Route::resource('asuransi', AsuransiController::class);

            Route::get('/jenis_pasien/search', [JenisPasienController::class, 'search'])->name('jenis_pasien.search');
            Route::get('/jenis_pasien/download', [JenisPasienController::class, 'download'])->name('jenis_pasien.download');
            Route::resource('jenis_pasien', JenisPasienController::class);

            Route::get('/fasilitas_kesehatan/search', [FasilitasKesehatanController::class, 'search'])->name('fasilitas_kesehatan.search');
            Route::get('/fasilitas_kesehatan/download', [FasilitasKesehatanController::class, 'download'])->name('fasilitas_kesehatan.download');
            Route::resource('fasilitas_kesehatan', FasilitasKesehatanController::class);

            Route::get('/provinsi/search', [ProvinsiController::class, 'search'])->name('provinsi.search');
            Route::get('/provinsi/download', [ProvinsiController::class, 'download'])->name('provinsi.download');
            Route::resource('provinsi', ProvinsiController::class);

            Route::get('/kabupaten/search', [KabupatenController::class, 'search'])->name('kabupaten.search');
            Route::get('/kabupaten/download', [KabupatenController::class, 'download'])->name('kabupaten.download');
            Route::resource('kabupaten', KabupatenController::class);

            Route::get('/kecamatan/search', [KecamatanController::class, 'search'])->name('kecamatan.search');
            Route::get('/kecamatan/download', [KecamatanController::class, 'download'])->name('kecamatan.download');
            Route::get('/kecamatan/get_kabupaten/{id}', [KecamatanController::class, 'getKabupaten'])->name('kecamatan.get_kabupaten');
            Route::resource('kecamatan', KecamatanController::class);

            Route::get('/kelurahan/search', [KelurahanController::class, 'search'])->name('kelurahan.search');
            Route::get('/kelurahan/download', [KelurahanController::class, 'download'])->name('kelurahan.download');
            Route::get('/kelurahan/get_kecamatan/{id}', [KelurahanController::class, 'getKecamatan'])->name('kelurahan.get_kecamatan');
            Route::resource('kelurahan', KelurahanController::class);

            Route::get('/perujuk/search', [PerujukController::class, 'search'])->name('perujuk.search');
            Route::get('/perujuk/download', [PerujukController::class, 'download'])->name('perujuk.download');
            Route::resource('perujuk', PerujukController::class);
        });
    });

    Route::group(['prefix' => 'hrd'], function () {
        Route::group(['prefix' => 'data_induk_kepegawaian'], function () {
            Route::get('/', [BagianController::class, 'index']);
            Route::get('bagian/cari', [BagianController::class, 'search'])->name('bagian.search');
            Route::get('bagian/download', [BagianController::class, 'download'])->name('bagian.download');
            Route::resource('bagian', BagianController::class);

            Route::get('golongan/cari', [GolonganController::class, 'search'])->name('golongan.search');
            Route::get('golongan/download', [GolonganController::class, 'download'])->name('golongan.download');
            Route::resource('golongan', GolonganController::class);

            Route::get('pendidikan_profesi/cari', [PendidikanProfesiController::class, 'search'])->name('pendidikan_profesi.search');
            Route::get('pendidikan_profesi/download', [PendidikanProfesiController::class, 'download'])->name('pendidikan_profesi.download');
            Route::resource('pendidikan_profesi', PendidikanProfesiController::class);

            Route::get('ruangan_pegawai/cari', [RuanganPegawaiController::class, 'search'])->name('ruangan_pegawai.search');
            Route::get('ruangan_pegawai/download', [RuanganPegawaiController::class, 'download'])->name('ruangan_pegawai.download');
            Route::resource('ruangan_pegawai', RuanganPegawaiController::class);

            Route::get('bank_pegawai/cari', [BankPegawaiController::class, 'search'])->name('bank_pegawai.search');
            Route::get('bank_pegawai/download', [BankPegawaiController::class, 'download'])->name('bank_pegawai.download');
            Route::resource('bank_pegawai', BankPegawaiController::class);

            Route::get('status_pegawai/cari', [StatusPegawaiController::class, 'search'])->name('status_pegawai.search');
            Route::get('status_pegawai/download', [StatusPegawaiController::class, 'download'])->name('status_pegawai.download');
            Route::resource('status_pegawai', StatusPegawaiController::class);

            Route::get('pendidikan/cari', [PendidikanController::class, 'search'])->name('pendidikan.search');
            Route::get('pendidikan/download', [PendidikanController::class, 'download'])->name('pendidikan.download');
            Route::resource('pendidikan', PendidikanController::class);

            Route::get('unit_kerja/cari', [UnitKerjaController::class, 'search'])->name('unit_kerja.search');
            Route::get('unit_kerja/download', [UnitKerjaController::class, 'download'])->name('unit_kerja.download');
            Route::resource('unit_kerja', UnitKerjaController::class);
        });
    });

    Route::group(['prefix' => 'satu_sehat'], function () {
        Route::controller(OrganizationController::class)->group(function () {
            Route::group(['prefix' => 'organization'], function () {
                Route::get('/', 'index');
                Route::get('datatable', 'datatable');
                Route::get('select', 'select_organisasi');
                Route::get('datatable_referensi', 'datatable_referensi');
                Route::get('referensi_update', 'update_referensi');
                Route::put('update', 'update');
                Route::post('store', 'store');
            });
        });

        Route::controller(LocationController::class)->group(function () {
            Route::group(['prefix' => 'location'], function () {
                Route::get('/', 'index');
                Route::get('datatable', 'datatable');
                Route::get('select', 'select_location');
                Route::get('datatable_referensi', 'datatable_referensi');
                Route::get('referensi_update', 'update_referensi');
                Route::put('update', 'update');
                Route::post('store', 'store');
            });
        });

        Route::controller(RawatJalanController::class)->group(function () {
            Route::group(['prefix' => 'rawat_jalan'], function () {
                Route::get('', 'index');
                Route::get('filter', 'filter');
                Route::get('datatable', 'datatable');
                Route::get('send', 'send');
                Route::post('export', 'export');
            });
        });

        Route::controller(PractionerController::class)->group(function () {
            Route::group(['prefix' => 'practioner'], function () {
                Route::get('/', 'index');
                Route::get('datatable', 'datatable');
                Route::patch('update_ihs', 'update_ihs');
            });
        });
    });
});
