@extends('layouts.app')
<!-- Main Content -->
@section('content')
    <div class="main-content">
        <section class="section">
            <div class="section-header" style="">
                <div class="text-left">
                    <h1>Tukar Tanda Terima</h1>
                </div>
            </div>

            <div class="section-body">
                <div class="card">
                    @if ($errors->any())
                        <div class="col-lg-12 mt-3">
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif
                    <div class="card-body">
                        <div class="form-group">
                            <form action="{{route('tukar_tanda_terima.show',0)}}" method="get">
                                @csrf
                                <div class="col-lg-12 row">
                                    <div class="col-lg-4 mt-2">
                                        <a class="btn btn-primary" href="{{ route('tukar_tanda_terima.create') }}">Tambah
                                            Tanda Terima</a>
                                    </div>
                                    <div class="col-lg-4"></div>
                                    <div class="col-lg-4 row">
                                        <div class="col-lg-4"></div>
                                        <div class="col-lg-8">
                                            <div class="input-group">
                                                <input name="cari" type="text" class="form-control" placeholder="Cari">
                                                <button class="btn btn-primary ml-3">Cari</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Nomor Tanda Terima</th>
                                    <th>Tanggal</th>
                                    <th>Nama Supplier</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="">
                                @forelse ($tanda_terimas as $tanda_terima)
                                    <tr>
                                        <td>{{ $loop->index + 1 }}</td>
                                        <td>{{ $tanda_terima->no }}</td>
                                        <td>@date($tanda_terima->tanggal)</td>
                                        <td>{{ $tanda_terima->nama_supplier }}</td>
                                            <td>
                                                <form action="{{ route('tukar_tanda_terima.destroy', $tanda_terima->id) }}"
                                                    method="post" accept-charset="utf-8" style="margin-right: -10px;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <a href="{{ route('tukar_tanda_terima.edit', $tanda_terima->id)}}"
                                                        class="btn btn-success"><i class="fas fa-eye"></i></a>
                                                    <a href="{{ route('tukar_tanda_terima.download', $tanda_terima->id)}}"
                                                        class="btn btn-dark"><i class="fas fa-download"></i></a>
                                                    <button class="btn btn-danger"
                                                        onclick="confirm('Apakah anda yakin ingin menghapus data?')"><i
                                                            class="fas fa-trash"></i></button>
                                                </form>
                                            </td>
                                    </tr>
                                    @empty
                                    <tr>
<td colspan="4" class="text-center">Data tidak ditemukan</td>
</tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="row mt-3" style="width: 100%; margin-left:0;">
                    </div>
                </div>
            </div>
        </section>
    </div>
    <script>
        function downloadExcel() {
            var date = $('input[name=date]').val();
            var url = "{{ URL::to('finance/rekap_honor_dokterr/download') }}/?date=" + date + ""
            if (confirm("Apakah anda ingin mendownload data ini?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }
    </script>
@endsection
@push('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.full.min.js"
        integrity="sha512-AIOTidJAcHBH2G/oZv9viEGXRqDNmfdPVPYOYKGy3fti0xIplnlgMHUGfuNRzC6FkzIo0iIxgFnr9RikFxK+sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/jquery-datetimepicker/2.5.20/jquery.datetimepicker.css"
        integrity="sha512-bYPO5jmStZ9WI2602V2zaivdAnbAhtfzmxnEGh9RwtlI00I9s8ulGe4oBa5XxiC6tCITJH/QG70jswBhbLkxPw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script charset="utf-8">
        jQuery.datetimepicker.setLocale('id');
        jQuery('.datetimepicker').datetimepicker({
            format: 'd-m-Y H:i',
            defaultTime: '00:00',
            step: 1
        });
    </script>
@endpush
