@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modal_pasien" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pilih Pasien</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 table-responsive">
                            <table class="table table-hover table-striped" style="font-size: 13px;" id="tabelListPasien">
                                <thead>
                                    <tr>
                                        <th scope="col">No. RM</th>
                                        <th scope="col">Nama</th>
                                        <th scope="col">Tempat Lahir</th>
                                        <th scope="col">Tanggal Lahir</th>
                                        <th scope="col">Jenis Kelamin</th>
                                        <th scope="col">Alamat</th>
                                        <th scope="col">Pekerjaan</th>
                                        <th scope="col">Umur</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

 <div class="modal fade" id="modal_diagnosa" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pilih Diagnosa</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 table-responsive">
                            <table class="table table-hover table-striped" style="font-size: 13px;" id="tabelListDiagnosa">
                                <thead>
                                    <tr>
                                        <th scope="col">Icd</th>
                                        <th scope="col">Diagnosa</th>
                                        <th scope="col">Sebab</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Surat Keterangan Sakit</h1>
            </div>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="section-body">
                <form action="{{ route('surat_sakit.store') }}" method="POST">
                    <div class="card" style="align-items: center;">
                        @csrf
                        <input type="hidden" value="{{ $data_surat->nrm ?? '' }}" name="nrm" id="nrm" />
                        <input type="hidden" value="{{ $data_surat->id_surat ?? '' }}" name="id" id="id" />
                        <input type="hidden" value="{{ $data_surat->tgl_ttd ?? $tanggal }}" name="tgl_ttd"
                            id="tgl_ttd" />
                        <input type="hidden" value="{{ $data_surat->no_surat ?? $no_surat }}" name="no_surat"
                            id="no_surat" />
                        <div style="width: 90%; color: black;" class="mt-2">
                            <div class="container mt-3">
                                <div class="row">
                                    <div class="col-md-3 col-sm-12 text-right">
                                        <img src="{{ asset('filelogo/logo_new.png') }}" alt="Logo"
                                            style="margin-top: -13px; float: right; height:130px; width:auto;">
                                    </div>
                                    <div class="col-md-6 col-sm-12 text-center">
                                        <p style="margin: -2px; font-weight: bold; font-size: 16pt;">KLINIK UTAMA
                                            DHARMAHUSADA
                                            PREMIER
                                        </p>
                                        <p style="margin: -2px;">Jl. Raya Dharma Husada Indah No.26, Mojo, Kec. Gubeng,
                                            Surabaya
                                        </p>
                                        <p style="margin: -2px;">No. Telp : (031)5921101 | Whatsapp : 0852-3366-4118</p>
                                        <p style="margin: -2px;"> Email: klinik.dharmahusadapremier@gmail.com |
                                            Website:dhpclinic.id</p>
                                    </div>
                                    <div class="col-md-3 col-sm-12 text-right">
                                    </div>
                                </div>
                            </div>
                            <div style="border-top: 1px solid black; margin-top: -15px;">
                                <div style="text-align: center;">
                                    <p
                                        style="margin-bottom: -2pt; margin-top: 3pt; font-size: 16pt; font-weight: bold; text-decoration: underline;">
                                        Surat
                                        Keterangan Sakit</p>
                                    <p style="margin-top: -2pt; margin-bottom: 2px;">No.:
                                        {{ $data_surat->no_surat ?? $no_surat }}</p>
                                </div>
                                <div>
                                    <p>Yang bertanda tangan di bawah ini,menerangkan bahwa:</p>
                                    <div style="margin-left: 30pt; font-weight: bold;">
                                        <table style="width: 100%;">
                                            <tr>
                                                <td style="width: 25%;">Nama</td>
                                                <td>:</td>
                                                <td style="width: 75%;">
                                                    <div class="input-group mb-1">
                                                        <input type="text" class="form-control"
                                                            onclick="openPasienModal()" id="nama" name="nama"
                                                            value="{{ $data_surat->nama ?? '' }}" readonly
                                                            style="width: 300px;" required>
                                                        <a href="#" class="btn btn-info" onclick="openPasienModal()"
                                                            data-toggle="tooltip" title="Pilih Klien"><i
                                                                class="fas fa-list"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Tempat/Tanggal Lahir</td>
                                                <td>:</td>
                                                <td id="ttl_td" style="border-bottom: 1px dashed black;">
                                                    {{ ($data_surat->tempat_lahir ?? '') == '' ? '-' : $data_surat->tempat_lahir }}
                                                    ,{{ isset($data_surat->tgl_lahir) ? date('d-m-Y', strtotime($data_surat->tgl_lahir)) : '' }}</td>
                                            </tr>
                                            <tr>
                                                <td>Umur</td>
                                                <td>:</td>
                                                <td id="umur_td" style="border-bottom: 1px dashed black;">
                                                    {{ $data_surat->age ?? '-' }} Tahun</td>
                                            </tr>
                                            <tr>
                                                <td>Jenis Kelamin</td>
                                                <td>:</td>
                                                <td id="kelamin_td" style="border-bottom: 1px dashed black;">
                                                    {{ isset($data_surat->kelamin) ? ($data_surat->kelamin == '0' ? 'Laki-Laki' : 'Perempuan') : '' }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td style="vertical-align: top;">Alamat</td>
                                                <td style="vertical-align: top;">:</td>
                                                <td id="alamat_td" style="border-bottom: 1px dashed black;">
                                                    {{ $data_surat->alamat ?? '' }}</td>
                                            </tr>
                                            <tr>
                                                <td>Pekerjaan</td>
                                                <td>:</td>
                                                <td>
                                                    <input class="form-control mb-1 mt-1" type="text"
                                                        value="{{ $data_surat->pekerjaan ?? '' }}" name="pekerjaan"
                                                        id="pekerjaan" placeholder="Silahkan isi Pekerjaan" required />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Diagnosa</td>
                                                <td>:</td>
                                                <td>
                                                    <div class="input-group mb-1">
                                                        <input type="text" class="form-control"
                                                            onclick="openDiagnosaModal()" id="diagnosa" name="diagnosa"
                                                            value="{{ $data_surat->diagnosa ?? '' }}" readonly
                                                            style="width: 300px;" required>
                                                        <a href="#" class="btn btn-info" onclick="openDiagnosaModal()"
                                                            data-toggle="tooltip" title="Pilih Diagnosa"><i
                                                                class="fas fa-list"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <p style="margin-bottom: 2pt;">Oleh karena S A K I T, perlu diberikan I S T I R A H A T
                                        selama
                                        <input readonly type="text" value="{{ $data_surat->hari ?? '' }} "
                                            name="hari" id="hari" /> hari
                                        terhitung
                                        mulai tanggal
                                        <input onchange="hitungHari()" class="dateformat" type="text"
                                            value="{{ $data_surat->dari_tanggal ?? $tanggal }}" name="dari_tanggal"
                                            id="dari_tanggal" required /> &nbsp;s/d &nbsp;
                                        <input onchange="hitungHari()" class="dateformat" type="text"
                                            value="{{ $data_surat->sampai_tanggal ?? "" }}" name="sampai_tanggal"
                                            id="sampai_tanggal" required />
                                    </p>

                                    <div style="">
                                        <p>Demikian surat keterangan ini dibuat dengan sebenarnya dan untuk dipergunakan
                                            semestinya.
                                        </p>
                                    </div>
                                </div>
                                <div style="float: right; margin-top: 10pt;">
                                    <div style="text-align: center;">
                                        <p>{{ $address->value }}, {{ $data_surat->tgl_ttd ?? $tanggal }}</p>
                                        <p>Dokter yang memeriksa</p>
                                        <select name="nama_dokter" id="nama_dokter" class="form-control" required>
                                            <option value="">--Pilh Pilihan--</option>
                                            @foreach ($dokters as $dokter)
                                                <option
                                                    {{ ($data_surat->nama_dokter ?? '') == $dokter->nama_dokter ? 'selected' : '' }}
                                                    value="{{ $dokter->nama_dokter }}">{{ $dokter->nama_dokter }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div style="clear: both;"></div>
                            </div>
                        </div>
                        <div class="col-lg-12 mb-4" style="text-align: center;">
                            <div style="margin-top: 32px;">
                                <a class="btn btn-dark" href="{{ route('surat_sakit.index') }}"
                                    onclick="return confirm('Semua perubahan data tidak akan tersimpan, apakah anda yakin?')">Kembali</a>
                                <button name="action" value="cetak" class="btn btn-success">Download</button>
                                <button name="action" value="simpan" class="btn btn-primary">Simpan</button>
                            </div>
                        </div>
                </form>
            </div>
    </div>
    </section>
    </div>
@endsection
@push('scripts')
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css"
        rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.id.min.js">
    </script>
    <script>
        $(document).ready(function() {
            hitungHari();
            $('#nama_dokter').select2({
                templateSelection: function(data) {
                    var $result = $(
                        '<span class="select2-selection__rendered pt-1">' +
                        data.text +
                        '</span>'
                    );

                    return $result;
                },
            });

            $(".dateformat")
                .datepicker({
                    format: "dd MM yyyy",
                    autoclose: true,
                    language: 'id'
                });
        });

        function openDiagnosaModal() {
            $('#tabelListDiagnosa').dataTable().fnClearTable();
            $('#tabelListDiagnosa').dataTable().fnDestroy();

            $('#tabelListDiagnosa').DataTable({
                serverSide: 'true',
                processing: 'true',
                pagingType: "full",
                deferRender: 'true',
                ajax: "{{ route('surat_sakit.diagnosa') }}", // memanggil route yang menampilkan data json
                columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                        data: 'icd',
                        name: 'icd'
                    },
                    {
                        data: 'nama',
                        name: 'nama'
                    },
                    {
                        data: 'sebab',
                        name: 'sebab'
                    },
                    {
                        data: 'id',
                        name: 'id',
                        render: function(data, type, row, meta) {
                            return '<div class="text-center"><button onclick="setDiagnosa(' + "'" + row.icd + "', '" + row.nama + "')" + '"class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                        }
                    }
                ]
            });
            $('#modal_diagnosa').modal('show');
        }

        function setDiagnosa(icd, nama){
            document.getElementById("diagnosa").value = icd + " - " + nama;
            $('#modal_diagnosa').modal('hide');
        }

        function openPasienModal() {
            $('#tabelListPasien').dataTable().fnClearTable();
            $('#tabelListPasien').dataTable().fnDestroy();

            $('#tabelListPasien').DataTable({
                serverSide: 'true',
                processing: 'true',
                pagingType: "full",
                deferRender: 'true',
                ajax: "{{ route('surat_keterangan_sehat.pasien') }}", // memanggil route yang menampilkan data json
                columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nama',
                        name: 'nama'
                    },
                    {
                        data: 'tempat_lahir',
                        name: 'tempat_lahir'
                    },
                    {
                        data: 'tgl_lahir',
                        name: 'tgl_lahir',
                        render: function(data, type, row) {
                            var tmp2 = data.split('-');
                            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
                        }
                    },
                    {
                        data: 'kelamin',
                        name: 'kelamin',
                        render: function(data, type, row) {
                            if (data == 1) {
                                return 'Perempuan'
                            } else if (data == 0) {
                                return 'Laki-Laki'
                            }
                        }
                    },
                    {
                        data: 'alamat',
                        name: 'alamat'
                    },
                    {
                        data: 'pekerjaan',
                        name: 'pekerjaan'
                    },
                    {
                        data: 'umur',
                        name: 'umur'
                    },
                    {
                        data: 'id',
                        name: 'id',
                        render: function(data, type, row, meta) {
                            return '<div class="text-center"><button onclick="setPasien(' + "'" + row.nama +
                                "', '" + row.tempat_lahir + "', '" + row.tgl_lahir + "', '" + row.kelamin +
                                "', '" + row.alamat + "', '" + row.pekerjaan + "', '" + row.umur + "','" +
                                data + "'" +
                                ')" class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                        }
                    }
                ]
            });
            $('#modal_pasien').modal('show');
        }

        function setPasien(nama, tempat_lahir, tgl_lahir, jenis_kelamin, alamat, pekerjaan, umur, nrm) {
            document.getElementById("nama").value = nama;
            {{-- document.getElementById("ttl").value = tempat_lahir + " " + convTanggal(tgl_lahir); --}}
            {{-- document.getElementById("umur").value = hitungUmur(tgl_lahir); --}}
            {{-- document.getElementById("kelamin").value = jenis_kelamin == 1 ? "Perempuan" : "Laki-Laki"; --}}
            {{-- document.getElementById("alamat").value = alamat; --}}
            document.getElementById("pekerjaan").value = pekerjaan;
            document.getElementById("nrm").value = nrm;

            document.getElementById("ttl_td").innerHTML = tempat_lahir + " " + convTanggal(tgl_lahir);
            document.getElementById("umur_td").innerHTML = hitungUmur(tgl_lahir);
            document.getElementById("kelamin_td").innerHTML = jenis_kelamin == 1 ? "Perempuan" : "Laki-Laki";
            document.getElementById("alamat_td").innerHTML = alamat;

            $('#modal_pasien').modal('hide');
        }

        function convTanggal(param) {
            var tmp2 = param.split('-');
            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
        }

        function hitungHari() {

            // Mengambil tanggal hari ini
            const today = new Date();

            // Mengambil tanggal besok
            const tomorrow = new Date();
            tomorrow.setDate(today.getDate() + 1);

            // Mengubah format tanggal ke "d-m-Y"
            const options = {
                day: "numeric",
                month: "numeric",
                year: "numeric"
            };
            const formattedToday = today.toLocaleDateString("id-ID", options);
            const formattedTomorrow = tomorrow.toLocaleDateString("id-ID", options);

            var tanggalAwal = moment($("#dari_tanggal").val(), "DD MMMM YYYY").toDate();
            var tanggalAkhir = moment($("#sampai_tanggal").val(), "DD MMMM YYYY").toDate();

            var selisihWaktu = tanggalAkhir.getTime() - tanggalAwal.getTime();

            var jumlahHari = Math.round(selisihWaktu / (1000 * 60 * 60 * 24));
            if (jumlahHari < 1) {
                alert('Hari terhitung mulai tidak boleh setelah atau sama dengan hari s/d');
            }
            $("#hari").val(jumlahHari);
        }

        function hitungUmur(tanggal_lahir) {
            var today = new Date();
            var birthday = new Date(tanggal_lahir);
            var umur = today.getFullYear() - birthday.getFullYear();
            var bulan = today.getMonth() - birthday.getMonth();
            if (bulan < 0 || (bulan === 0 && today.getDate() < birthday.getDate())) {
                umur--;
            }
            return umur;
        }
    </script>
@endpush
