@extends('layouts.app')
@section('content')
<div class="modal fade" id="modal_add" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Tambah Organisasi</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ url('satu_sehat/organization/store') }}" method="post">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Tipe Organisasi</label>
                        <select name="tipe" id="tipe" class="form-control" required>
                            <option value="">--Select Here--</option>
                            @foreach($referensi as $ref)
                            <option value="{{$ref->id}}">{{$ref->display}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Organisasi</label>
                        <input type="text" name="nama" id="nama" class="form-control" placeholder="Tambahkan nama organisasi disini.." required>
                    </div>
                    <div class="form-group">
                        <label for="">Active</label>
                        <select name="active" id="active" class="form-control" required>
                            <option value="">--Select Here--</option>
                            <option value="1">Ya</option>
                            <option value="0">Tidak</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Telepon</label>
                        <input type="number" min="0" name="telepon" id="telepon" class="form-control" placeholder="Tambahkan telepon organisasi disini.." required>
                    </div>
                    <div class="form-group">
                        <label for="">Email</label>
                        <input type="email" name="email" id="email" class="form-control" placeholder="Tambahkan email organisasi disini.." required>
                    </div>
                    <div class="form-group">
                        <label for="">Alamat</label>
                        <textarea class="form-control" name="alamat" id="alamat" cols="30" rows="5" placeholder="Tambahkan alamat organisasi disini.." style="height: 100%;"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="">Sub Bagian Dari</label>
                        <select name="part_of" id="part_of" class="form-control" required>
                            <option value="">--Select Here--</option>
                            <option value="{{env('IHS_RS')}}">{{env('NAMA_RS')}}</option>
                            @foreach($all_organisasi as $org)
                            <option value="{{$org->id_organisasi}}">{{$org->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Ubah Organisasi</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ url('satu_sehat/organization/update') }}" method="post">
                @csrf
                <input type="hidden" name="id" id="edit_id">
                <input type="hidden" name="id_organisasi" id="edit_id_organisasi">
                <input type="hidden" name="_method" value="put">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="">Tipe Organisasi</label>
                        <select name="tipe" id="edit_tipe" class="form-control" required>
                            <option value="">--Select Here--</option>
                            @foreach($referensi as $ref)
                            <option value="{{$ref->id}}">{{$ref->display}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Nama Organisasi</label>
                        <input type="text" name="nama" id="edit_nama" class="form-control" placeholder="Tambahkan nama organisasi disini.." required>
                    </div>
                    <div class="form-group">
                        <label for="">Active</label>
                        <select name="active" id="edit_active" class="form-control" required>
                            <option value="">--Select Here--</option>
                            <option value="1">Ya</option>
                            <option value="0">Tidak</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Telepon</label>
                        <input type="number" min="0" name="telepon" id="edit_telepon" class="form-control" placeholder="Tambahkan telepon organisasi disini.." required>
                    </div>
                    <div class="form-group">
                        <label for="">Email</label>
                        <input type="email" name="email" id="edit_email" class="form-control" placeholder="Tambahkan email organisasi disini.." required>
                    </div>
                    <div class="form-group">
                        <label for="">Alamat</label>
                        <textarea class="form-control" name="alamat" id="edit_alamat" cols="30" rows="5" placeholder="Tambahkan alamat organisasi disini.." style="height: 100%;"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="">Sub Bagian Dari</label>
                        <select name="part_of" id="edit_part_of" class="form-control" required>
                            <option value="">--Select Here--</option>
                            <option value="{{env('IHS_RS')}}">{{env('NAMA_RS')}}</option>
                            @foreach($all_organisasi as $org)
                            <option value="{{$org->id_organisasi}}">{{$org->nama}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Organization</h1>
        </div>

        <div class="section-body">
            <div class="card pt-3 pb-3">
                <div class="row" style="width: 100%; margin-left: 0;">
                    @if(Session::has('sukses'))
                    <div class="col-lg-12">
                        <div class="alert alert-success">
                            {{Session::get("sukses")}};
                        </div>
                    </div>
                    @endif
                    @if(Session::has('gagal'))
                    <div class="col-lg-12">
                        <div class="alert alert-danger">
                            {{Session::get("gagal")}};
                        </div>
                    </div>
                    @endif
                    @if ($errors->any())
                    <div class="col-lg-12">
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    @endif
                    <div class="col-lg-12">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="organisasi-tab" data-toggle="tab" data-target="#organisasi" type="button" role="tab" aria-controls="organisasi" aria-selected="true">Organisasi</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="reference-tab" data-toggle="tab" data-target="#reference" type="button" role="tab" aria-controls="reference" aria-selected="false">Referensi</button>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="organisasi" role="tabpanel" aria-labelledby="organisasi-tab">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <button class="btn btn-success" onclick="open_modal_add()"><i class="fas fa-plus"></i> Tambah</button>
                                    </div>
                                    <div class="col-lg-12 pt-3 table-responsive">
                                        <table class="table table-striped" id="tabel_organisasi">
                                            <thead class="text-center">
                                                <tr>
                                                    <th>No.</th>
                                                    <th>Tipe Organisasi</th>
                                                    <th>Sub Bagian Dari</th>
                                                    <th>Nama Organisasi</th>
                                                    <th>Status</th>
                                                    <th>Telepon</th>
                                                    <th>Email</th>
                                                    <th>Alamat</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="reference" role="tabpanel" aria-labelledby="reference-tab">
                                <div class="row">
                                    <div class="col-lg-12 pb-3">
                                        <button onclick="update_referensi()" class="btn btn-warning"><i class="fas fa-refresh"></i> Update</button>
                                    </div>
                                    <div class="col-lg-12">
                                        <table class="table table-striped" id="tabel_referensi">
                                            <thead class="text-center">
                                                <tr>
                                                    <th>No.</th>
                                                    <th>Kode Organisasi</th>
                                                    <th>Tipe Organisasi</th>
                                                    <th>Keterangan</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('scripts')
<script>
    $(document).ready(function() {
        get_data();
        get_referensi();
    })

    function open_modal_add() {
        $('#modal_add').modal('show');
    }

    function update_referensi() {
        toastr.warning('Sedang mengupdate data, harap tunggu...');
        $.ajax({
            url: "{{ url('satu_sehat/organization/referensi_update') }}",
            success: function(response) {
                if (response.status) {
                    toastr.success(response.message);
                    return;
                }
                toastr.error(response.message);
                get_referensi();
            }
        })
    }

    function open_modal_edit(param) {
        $.ajax({
            url: "{{ url('satu_sehat/organization/select') }}",
            data: {
                id: param
            },
            success: function(response) {
                if (response == null) {
                    return;
                }
                $('#edit_id').val(response.id);
                $('#edit_id_organisasi').val(response.id_organisasi);
                $("#edit_tipe option:contains(" + response.tipe + ")").attr('selected', true);
                $('#edit_nama').val(response.nama);
                $('#edit_active').val(response.aktif);
                $('#edit_telepon').val(response.telepon);
                $('#edit_email').val(response.email);
                $('#edit_alamat').val(response.alamat);
                $('#edit_part_of').val(response.part_of);
                $('#modal_edit').modal('show');
            }
        })
    }

    function get_data() {
        if ($.fn.DataTable.isDataTable("#mytable")) {
            $('#tabel_organisasi').DataTable().clear().destroy();
        }
        $('#tabel_organisasi').DataTable({
            processing: true,
            serverSide: true,
            bAutoWidth: false,
            bLengthChange: false,
            ajax: "{{ url('satu_sehat/organization/datatable') }}", // memanggil route yang menampilkan data json
            columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                    data: null,
                    name: 'id',
                    orderable : false,
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' + (meta.row + meta.settings._iDisplayStart +
                            1) + '</div>';
                    }
                },
                {
                    data: 'tipe',
                    name: 'tipe'
                },
                {
                    data: 'part_of',
                    name: 'part_of',
                    render: function(data, type, row, meta) {
                        if (data == '{{ env("IHS_RS") }}') {
                            return '{{ env("NAMA_RS") }}';
                        }
                        return row.bagian_dari;
                    }
                },
                {
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'aktif',
                    name: 'aktif',
                    render: function(data, type, row, meta) {
                        return data == 1 ? 'Aktif' : 'Tidak Aktif';
                    }
                },
                {
                    data: 'telepon',
                    name: 'telepon'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'alamat',
                    name: 'alamat'
                },
                {
                    data: 'id',
                    name: 'id',
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' +
                            '<button class="btn btn-warning" onclick="open_modal_edit(' + "'" + data + "'" + ')"><i class="fa fa-pencil"></i></button>' +
                            '</div>';
                    }
                }
            ],
        })
    }

    function get_referensi() {
        if ($.fn.DataTable.isDataTable("#mytable")) {
            $('#tabel_referensi').DataTable().clear().destroy();
        }

        $('#tabel_referensi').DataTable({
            processing: true,
            serverSide: true,
            bAutoWidth: false,
            bLengthChange: false,
            ajax: "{{ url('satu_sehat/organization/datatable_referensi') }}", // memanggil route yang menampilkan data json
            columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                    data: null,
                    name: 'id',
                    orderable : false,
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' + (meta.row + meta.settings._iDisplayStart +
                            1) + '</div>';
                    }
                },
                {
                    data: 'code',
                    name: 'code'
                },
                {
                    data: 'display',
                    name: 'display'
                },
                {
                    data: 'definition',
                    name: 'definition'
                }
            ],
        })
    }
</script>
@endpush