@extends('layouts.app')
@section('content')
    <div class="modal fade" id="modal_pasien" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Pilih Pasien</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12 table-responsive">
                            <table class="table table-hover table-striped" style="font-size: 13px;" id="tabelListPasien">
                                <thead>
                                    <tr>
                                        <th scope="col">No. RM</th>
                                        <th scope="col">Nama</th>
                                        <th scope="col">Tempat Lahir</th>
                                        <th scope="col">Tanggal Lahir</th>
                                        <th scope="col">Jenis Kelamin</th>
                                        <th scope="col">Alamat</th>
                                        <th scope="col">Pekerjaan</th>
                                        <th scope="col">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Surat Hasil Pemeriksaan PCR & Antigen</h1>
            </div>

            <div class="section-body">
                <div class="card">
                    <div class="row pt-3" style="width: 100%; margin-left: 0;">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="">Masukan Nama / No RM</label>
                                <form action="{{ route('pemeriksaan_pcr_antigen.index') }}" method="GET"
                                    accept-charset="utf-8">
                                    <div class="form-inline">
                                        <div class="input-group">
                                            <input type="text" class="form-control" onclick="openPasienModal()"
                                                id="nama_pasien" name="keyword" value="{{$keyword}}" readonly="true" style="width: 300px;">
                                            <a href="#" class="btn btn-info" onclick="openPasienModal()"
                                                data-toggle="tooltip" title="Pilih Klien"><i class="fas fa-list"></i></a>
                                        </div>
                                        <button class="btn btn-primary ml-2" id="btn_cari"><i class="fas fa-search"></i>
                                            Cari</button> 
                                        <a class="ml-2 btn btn-dark" href="{{route('pemeriksaan_pcr_antigen.index')}}"><i class="fas fa-refresh"></i></a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <table class="table table-bordered table-stripped">
                            <thead>
                                <th>No</th>
                                <th>Nama</th>
                                <th>JK</th>
                                <th>Alamat</th>
                                <th>Jenis Pemeriksaan</th>
                                <th class="text-center"><a class="btn btn-primary" style="font-size: 18px;"
                                        data-toggle="tooltip" title="Tambah Data"
                                        href="{{ route('pemeriksaan_pcr_antigen.create') }}">+</a></th>
                            </thead>
                            <tbody>
                                @forelse ($datas as $key => $data)
                                    <tr>
                                        <td>{{ $key + $datas->firstItem() }}</td>
                                        <td>{{ $data->nama }}</td>
                                        <td>{{ $data->kelamin == 1 ? 'P' : 'L' }}</td>
                                        <td>{{ $data->alamat }}</td>
                                        <td>{{ $data->pemeriksaan }}</td>
                                        <td class="text-center">
                                            <form action="{{ route('pemeriksaan_pcr_antigen.destroy', $data->id_surat) }}"
                                                method="POST">
                                                @csrf
                                                @method('DELETE')
                                                <a class="btn btn-warning" style="font-size: 18px;" data-toggle="tooltip"
                                                    title="Ubah Data"
                                                    href="{{ route('pemeriksaan_pcr_antigen.edit', $data->id_surat) }}"><i
                                                        class="fas fa-edit"></i></a>
                                                <a class="btn btn-success" style="font-size: 18px;" data-toggle="tooltip"
                                                    title="Download Data"
                                                    href="{{ route('pemeriksaan_pcr_antigen.show', $data->id_surat) }}"><i
                                                        class="fas fa-download"></i></a>
                                                <button class="btn btn-danger" style="font-size: 18px;"
                                                    data-toggle="tooltip" title="Hapus Data" href=""
                                                    onclick="return confirm('Data akan dihapus, apakah anda yakin?')"><i
                                                        class="fas fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">Data tidak tersedia</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="row mt-5" style="width: 100%; margin-left:0;">
                        <div class="col-lg-6" style="display: flex; align-items: center;">
                        </div>
                        <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                            {{ isset($datas) ? $datas->appends(Request::only('keyword'))->links('pagination::bootstrap-4') : '' }}
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.js"></script>
    <script>
        function openPasienModal() {
            $('#tabelListPasien').dataTable().fnClearTable();
            $('#tabelListPasien').dataTable().fnDestroy();

            $('#tabelListPasien').DataTable({
                serverSide: 'true',
                processing: 'true',
                pagingType: "full",
                deferRender: 'true',
                ajax: "{{ route('surat_keterangan_sehat.pasien') }}", // memanggil route yang menampilkan data json
                columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'nama',
                        name: 'nama'
                    },
                    {
                        data: 'tempat_lahir',
                        name: 'tempat_lahir'
                    },
                    {
                        data: 'tgl_lahir',
                        name: 'tgl_lahir',
                        render: function(data, type, row) {
                            var tmp2 = data.split('-');
                            return tmp2[2] + '-' + tmp2[1] + '-' + tmp2[0];
                        }
                    },
                    {
                        data: 'kelamin',
                        name: 'kelamin',
                        render: function(data, type, row) {
                            if (data == 1) {
                                return 'Perempuan'
                            } else if (data == 0) {
                                return 'Laki-Laki'
                            }
                        }
                    },
                    {
                        data: 'alamat',
                        name: 'alamat'
                    },
                    {
                        data: 'pekerjaan',
                        name: 'pekerjaan'
                    },
                    {
                        data: 'id',
                        name: 'id',
                        render: function(data, type, row, meta) {
                            return '<div class="text-center"><button onclick="setPasien(' + "'" + row.nama +
                                "'" + ')" class="btn btn-dark"><i class="fas fa-check"></i></button></div>';
                        }
                    }
                ]
            });
            $('#modal_pasien').modal('show');
        }

        function setPasien(param) {
            $('#nama_pasien').val(param);
            $('#modal_pasien').modal('hide');
        }
    </script>
@endpush
