@extends('layouts.app')
@section('content')
<style>
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }

    #tabel_identitas tr td {
        line-height: 40px;
    }

    #tabel_identitas td {
        white-space: nowrap;
    }
</style>

<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>E-Rekam Medis</h1>
        </div>

        <div class="section-body">
            <div class="row" style="width: 100%; margin-left: 0;">
                <div class="col-lg-5 pl-0">
                    <form class="card p-3" id="form_pencarian">
                        <p style="font-weight: bold">Pencarian Pasien</p>
                        <div class="form-group">
                            <label for="">No. RM</label>
                            <input type="number" name="nrm" id="nrm" min="1" class="form-control">
                        </div>
                        <table id="tabel_identitas" style="border-collapse: collapse;">
                            <tr>
                                <td style="width:20%">Nama</td>
                                <td style="width:5%"> : </td>
                                <td id="box_nama">
                                </td>
                            </tr>
                            <tr>
                                <td style="width:20%">Tgl. Lahir</td>
                                <td style="width:5%"> : </td>
                                <td id="box_tanggal_lahir">
                                </td>
                            </tr>
                            <tr>
                                <td style="width:20%">Kelamin</td>
                                <td style="width:5%"> : </td>
                                <td id="box_kelamin">
                                </td>
                            </tr>
                            <tr>
                                <td style="width:20%">Alamat</td>
                                <td style="width:5%"> : </td>
                                <td id="box_alamat">
                                </td>
                            </tr>
                        </table>
                    </form>
                    <div class="card p-3 table-responsive">
                        <table class="table table-striped" id="tabel_history_kunjungan">
                            <thead>
                                <tr class="text-center">
                                    <th>Tgl. Kunjungan</th>
                                    <th>Noreg</th>
                                    <th>Ruangan</th>
                                    <th>Dignosa</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <div class="col-lg-7 pl-0 pr-0">
                    <div class="card p-3">
                        <p style="border-bottom: 0; font-weight: bold;">Dokumen Pasien</p>
                        <form class="row" id="form_dokumen_pasien" style="width: 100%; margin-left: 0;">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <input type="hidden" name="nrm">
                            <div class="col-md-6 pl-0">
                                <select name="dokumen" class="form-control">
                                    <option value="Pendaftaran Rawat Jalan">Pendaftaran Rawat Jalan</option>
                                    <option value="Persetujuan Umum Rawat Jalan">Persetujuan Umum Rawat Jalan</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <button class="btn btn-success" type="submit">Create</button>
                            </div>
                        </form>
                        <table class="table table-striped mt-1" id="tabel_dokumen_pasien">
                            <thead>
                                <tr class="text-center">
                                    <th>No</th>
                                    <th>Nama Dokumen</th>
                                    <th>Status</th>
                                    <th>Tanggal Update</th>
                                    <th>Verifikator</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="card p-3">
                        <p style="border-bottom: 0; font-weight: bold;" id="label_tanggal_dokumen_kunjungan"></p>
                        <form id="form_dokumen_kunjungan" class="row">

                        </form>
                        <table class="table table-striped mt-1" id="tabel_dokumen_kunjungan">
                            <thead>
                                <tr class="text-center">
                                    <th>No</th>
                                    <th>Nama Dokumen</th>
                                    <th>Status</th>
                                    <th>Tanggal Update</th>
                                    <th>Verifikator</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('scripts')
<script>
    let selected_noreg = '';
    let selected_nrm = '';

    const dokumen = [
        'Asesmen Medis Awal Rawat Jalan',
        'Asesmen Medis Awal Rawat Jalan (Gigi)',
        'Catatan Perkembangan Pasien',
        'Pengkajian Keperawatan Rawat Jalan',
        // 'Asesmen Kebidanan',
    ]

    $(document).ready(function() {
        $('[name=dokumen]').select2();
        $('#tabel_history_kunjungan').DataTable({
            bLengthChange: false,
            searching: false,
            columns: [{
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                }
            ]
        });

        $('#tabel_dokumen_kunjungan').DataTable({
            bLengthChange: false,
            orderable: false,
            columns: [{
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                },
                {
                    data: '',
                    orderable: false,
                }
            ]
        });
    })

    $('#form_pencarian').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang mencari pasien, harap tunggu...');

        $('#box_nama').html('');
        $('#box_tanggal_lahir').html('');
        $('#box_kelamin').html('');
        $('#box_alamat').html('');

        selected_noreg = '';
        selected_nrm = '';

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/ajax/cari_pasien') }}",
            data: $('#form_pencarian').serialize(),
            success: function(response) {
                if (Object.keys(response).length === 0) {
                    toastr.error('Pasien tidak ditemukan');
                    return;
                }

                $('#box_nama').html(response.nama);
                $('#box_tanggal_lahir').html(response.tgl_lahir.split("-").reverse().join("-"));
                $('#box_kelamin').html(response.kelamin == 0 ? 'Laki-Laki' : (response.kelamin == 1 ? 'Perempuan' : ''));
                $('#box_alamat').html(response.alamat);

                selected_nrm = $('#nrm').val();
                $('[name=nrm]').val(selected_nrm);

                get_dokumen_pasien();
                get_dokumen_kunjungan(selected_noreg, '');
                get_history_kunjungan(response.id)
            }
        })
    })

    function get_dokumen_pasien() {
        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/ajax/dokumen_pasien') }}",
            data: {
                nrm: selected_nrm
            },
            success: function(response) {
                render_dokumen_pasien(response);
            }
        })
    }

    function render_dokumen_pasien(data) {
        if ($.fn.DataTable.isDataTable("#tabel_dokumen_pasien")) {
            $('#tabel_dokumen_pasien').DataTable().clear().destroy();
        }

        $('#tabel_dokumen_pasien').DataTable({
            bLengthChange: false,
            data: data,
            columns: [{
                    data: 'id',
                    orderable: false,
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</div>';
                    }
                },
                {
                    data: 'nama_dokumen',
                    orderable: false,
                },
                {
                    data: 'status',
                    orderable: false,
                    render: function(data, type, row) {
                        return data == 0 ? 'Belum diverifikasi' : 'Sudah diverifikasi';
                    }
                },
                {
                    data: 'tanggal_update',
                    orderable: false,
                    render: function(data, type, row) {
                        let temp = data.split(' ');
                        return '<div class="text-center">' + temp[0].split("-").reverse().join("-") + '</div>';
                    }
                },
                {
                    data: 'nama_verifikator',
                    orderable: false,
                },
                {
                    data: 'id',
                    orderable: false,
                    render: function(data, type, row) {
                        return '<div class="text-center">' +
                            `<a class="btn btn-success btn-sm" target="_blank" href="{{ url('medical_record/e_rekam_medis') }}/` + row.nama_dokumen.replaceAll(' ', '_').replaceAll('(', '').replaceAll(')', '').toLowerCase() + `?dokumen=` + data + `">` +
                            '<i class="fa fa-eye"></i>' +
                            '</a>' +
                            '</div>';
                    }
                }
            ]
        });
    }

    $('#form_dokumen_pasien').submit(function(e) {
        e.preventDefault();
        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/ajax/create_dokumen_pasien') }}",
            data: $('#form_dokumen_pasien').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                get_dokumen_pasien();
            }
        })
    })

    function get_history_kunjungan(id_pasien) {
        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/ajax/history_kunjungan') }}",
            data: {
                id: id_pasien
            },
            success: function(response) {
                console.log(response);
                render_tabel_history_kunjungan(response);
            }
        })
    }

    function render_tabel_history_kunjungan(data) {
        if ($.fn.DataTable.isDataTable("#tabel_history_kunjungan")) {
            $('#tabel_history_kunjungan').DataTable().clear().destroy();
        }

        $('#tabel_history_kunjungan').DataTable({
            bLengthChange: false,
            searching: false,
            ordering : false,
            order: [1, 'desc'],
            data: data,
            pageLength: 5,
            columns: [{
                    data: 'tanggal',
                    render: function(data, type, row) {
                        return '<div class="text-center" onclick="get_dokumen_kunjungan(' + "'" + row.id + "','" + data + "'" + ')">' +
                            ymdhi_to_dmy(data) +
                            '</div>';
                    }
                },
                {
                    data: 'id',
                    render: function(data, type, row) {
                        return data;
                    }
                },
                {
                    data: 'jenislayanan',
                    render: function(data, type, row) {
                        return ucwords(data.replaceAll('_{{ env("slug_klinik") }}', ' ')).replaceAll('_', ' ');
                    }
                },
                {
                    data: 'id',
                    render: function(data, type, row) {
                        if (row.diagnosa) {
                            return row.diagnosa.kode_icd + ' - ' + row.diagnosa.nama_icd;
                        }
                        return '';
                    }
                }
            ]
        });
    }

    function ymdhi_to_dmy(data) {
        if (data == '') {
            return '';
        }

        let temp = data.split(' ');
        return temp[0].split("-").reverse().join("-");
    }

    function ucwords(words) {
        let temp = words.split(' ');
        for (let i = 0; i < temp.length; i++) {
            temp[i] = temp[i].charAt(0).toUpperCase() + temp[i].substr(1);
        }

        return temp.join(' ');
    }

    function get_dokumen_kunjungan(noreg, tanggal) {
        selected_noreg = noreg;
        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/ajax/dokumen_kunjungan') }}",
            data: {
                noreg: noreg
            },
            success: function(response) {
                $('#label_tanggal_dokumen_kunjungan').html(tanggal == '' ? '' : 'Dokumen kunjungan tanggal : ' + ymdhi_to_dmy(tanggal));
                render_tabel_dokumen_kunjungan(response, tanggal);
            }
        })
    }

    function render_tabel_dokumen_kunjungan(data, tanggal) {
        const list_dokumen = dokumen.map(doc => {
            return `<option value="${doc}">${doc}</option>`;
        }).join();
        var form_dokumen_kunjungan = '<div class="col-lg-6">' +
            '<input type="hidden" name="noreg" value="' + selected_noreg + '"/>' +
            '<input type="hidden" name="_token" value="{{ csrf_token() }}"/>' +
            '<select class="form-control" name="dokumen">' +
            list_dokumen +
            '</select>' +
            '</div>' +
            '<div class="col-lg-6 pl-0 pt-1">' +
            '<button class="btn btn-success" type="submit">Create</button>' +
            '</div>';
        $('#form_dokumen_kunjungan').html(tanggal == '' ? '' : form_dokumen_kunjungan);
        $('[name=dokumen]').select2();

        if ($.fn.DataTable.isDataTable("#tabel_dokumen_kunjungan")) {
            $('#tabel_dokumen_kunjungan').DataTable().clear().destroy();
        }

        $('#tabel_dokumen_kunjungan').DataTable({
            bLengthChange: false,
            data: data,
            columns: [{
                    data: 'id',
                    orderable: false,
                    render: function(data, type, row, meta) {
                        return '<div class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</div>';
                    }
                },
                {
                    data: 'nama_dokumen',
                    orderable: false,
                },
                {
                    data: 'status',
                    orderable: false,
                    render: function(data, type, row) {
                        return data == 0 ? 'Belum diverifikasi' : 'Sudah diverifikasi';
                    }
                },
                {
                    data: 'tanggal_update',
                    orderable: false,
                    render: function(data, type, row) {
                        let temp = data.split(' ');
                        return '<div class="text-center">' + temp[0].split("-").reverse().join("-") + '</div>';
                    }
                },
                {
                    data: 'nama_verifikator',
                    orderable: false,
                },
                {
                    data: 'id',
                    orderable: false,
                    render: function(data, type, row) {
                        return '<div class="text-center">' +
                            `<a class="btn btn-success btn-sm" target="_blank" href="{{ url('medical_record/e_rekam_medis') }}/` + row.nama_dokumen.replaceAll(' ', '_').replaceAll('(', '').replaceAll(')', '').toLowerCase() + `?dokumen=` + data + `">` +
                            '<i class="fa fa-eye"></i>' +
                            '</a>' +
                            '</div>';
                    }
                }
            ]
        });
    }

    $('#form_dokumen_kunjungan').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang membuat dokumen, harap tunggu...');

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/ajax/create_dokumen_kunjungan') }}",
            method: 'post',
            data: $('#form_dokumen_kunjungan').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }

                toastr.success(response.message);
                get_dokumen_kunjungan(response.data.id, response.data.tanggal);
            }
        })
    })
</script>
@endpush