<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pendaftaran Rawat Jalan</title>

    <link rel="stylesheet" type="text/css" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('app-assets/css/select2-bootstrap.min.css') }}">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet" />

    <style>
        .tabel_layout {
            width: 100%;
            border-collapse: collapse;
        }

        #tabel_identitas tr td {
            line-height: 2.5;
        }

        .inputan {
            border: none;
            border-bottom: 1px dotted;
        }

        .main_table tr td {
            padding-bottom: 10px;
        }
    </style>
</head>

<body>
    <div class="modal fade" id="modal_verifikasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form_verifikasi">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Password</label>
                            <input type="password" id="password" class="form-control" placeholder="Masukkan password anda">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_tanda_tangan_pasien" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Tanda tangan pasien</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="form_tanda_tangan">
                    <div class="modal-body">
                        <div class="form-group text-center">
                            <label for="">Nama Lengkap</label>
                            <input style="border: 2px solid;" class="form-control" id="nama_pasien" placeholder="Nama Lengkap">
                            <h6>Signature :</h6>
                            <canvas style="border: 2px solid;" id="tanda_tangan_pasien" class="signature-pad" width=400 height=200></canvas>
                        </div>
                        <div class="form-group text-center">
                            <button id="btn_clear" type="button" class="btn btn-danger btn-sm">Clear Signature</button>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <form id="form_dokumen" class="p-2">
        @csrf
        <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
        <input type="hidden" name="jenis_verifikasi">
        <input type="hidden" name="nama_pasien">
        <input type="hidden" name="password">
        <textarea hidden name="signed"></textarea>
        <table class="tabel_layout" border="1">
            <tr>
                <td style="width: 60%;" class="pl-2">
                    <div style="display: flex; flex-direction: row;">
                        <img src="{{ asset('filelogo/logo_new.jpg') }}" alt="" style="width: 15%;">
                        <p style="margin-bottom: 0px; padding-top: 30px; padding-left: 20px;">
                            <b>{{ env('NAMA_KLINIK') }}</b>
                            <br>
                            {{ env('ALAMAT_KLINIK') }}
                        </p>
                    </div>
                </td>
                <td rowspan="2" style="width: 40%;" class="pl-2">
                    <table style="border-collapse:collapse;" id="data_diri_header">
                        <tr>
                            <td style="width: 20%;">No RM</td>
                            <td style="padding-left:10px; padding-right:10px"> : </td>
                            <td>{{ $pasien->nrm ?? '' }}</td>
                        </tr>
                        <tr>
                            <td style="width: 20%;">NIK</td>
                            <td style="padding-left:10px; padding-right:10px"> : </td>
                            <td>{{ $pasien->ktp ?? '' }}</td>
                        </tr>
                        <tr>
                            <td style="width: 20%;">Nama</td>
                            <td style="padding-left:10px; padding-right:10px"> : </td>
                            <td>{{ $pasien->nama ?? '' }} ({{ $pasien ? ($pasien->kelamin == 0 ? 'L' : ($pasien->kelamin == 1 ? 'P' : '')) : '' }})</td>
                        </tr>
                        <tr>
                            <td style="width: 20%;">Tgl Lahir</td>
                            <td style="padding-left:10px; padding-right:10px"> : </td>
                            <td>{{ $pasien ? date('d-m-Y', strtotime($pasien->tgl_lahir)) : '' }}</td>
                        </tr>
                        <tr>
                            <td style="width: 20%; vertical-align:top;">Alamat</td>
                            <td style="padding-left:10px; vertical-align:top; padding-right:10px"> : </td>
                            <td>
                                @if($pasien)
                                {{ $pasien->alamat }}, RT {{ $pasien->rt }} RW {{ $pasien->rw }},
                                {{ $pasien->nama_kelurahan }}, {{ $pasien->nama_kecamatan }},
                                {{ $pasien->nama_kabupaten }}
                                @endif
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td class="text-center pt-2 pb-2">
                    <b>PENDAFTARAN RAWAT JALAN (REGISTRASI)</b>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="text-center">
                    <b>DATA IDENTITAS PASIEN (diisi lengkap oleh pasien / keluarga)</b>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="p-2">
                    <table class="tabel_layout main_table">
                        <tr>
                            <td style="width: 40%;">Nomor Identitas Lain (Khusus WNA) : Nomor Paspor / KITAS</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="nomor_identitas_lain" value="{{ $data->nomor_identitas_lain ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Tempat Lahir</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="tempat_lahir" value="{{ $data->tempat_lahir ?? ($pasien->tempat_lahir ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Nama Ibu Kandung</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="nama_ibu_kandung" value="{{ $data->nama_ibu_kandung ?? ($pasien->ibu ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Jenis Kelamin</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="jenis_kelamin" value="{{ $data->jenis_kelamin ?? ($pasien ? $pasien->kelamin == 0 ? 'Laki-laki' : 'Perempuan' : '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>No. BPJS Kesehatan</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="no_bpjs_kesehatan" value="{{ $data->no_bpjs_kesehatan ?? ($pasien->nobpjs ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>No. BPJS TK</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="no_bpjs_tk" value="{{ $data->no_bpjs_tk ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Status Perkawinan</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="status_perkawinan" value="{{ $data->status_perkawinan ?? ($pasien->status ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Agama / Kepercayaan</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="agama_kepercayaan" value="{{ $data->agama_kepercayaan ?? ($pasien->agama ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Suku</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="suku" class="inputan" value="{{ $data->suku ?? ($pasien->suku ?? '') }}" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Bahasa yang dikuasai</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="bahasa" class="inputan" value="{{ $data->bahasa ?? ($pasien->bahasa ?? '') }}" style="width: 100%;">
                            </td>
                        </tr>
                        <?php
                        $alamat = $pasien->alamat ?? '';
                        if ($pasien && $pasien->nama_kelurahan != '') {
                            $alamat .= ', ' . $pasien->nama_kelurahan;
                        }
                        if ($pasien && $pasien->nama_kecamatan != '') {
                            $alamat .= ', ' . $pasien->nama_kecamatan;
                        }
                        if ($pasien && $pasien->nama_kabupaten != '') {
                            $alamat .= ', ' . $pasien->nama_kabupaten;
                        }
                        if ($pasien && $pasien->nama_provinsi != '') {
                            $alamat .= ', ' . $pasien->nama_provinsi;
                        }
                        ?>
                        <tr>
                            <td>Alamat lengkap sesuai identitas</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="alamat_sesuai_identitas" value="{{ $data->alamat_sesuai_identitas ?? $alamat }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Alamat domisili</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="alamat_domisili" value="{{ $data->alamat_domisili ?? $alamat }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Nomor Telepon rumah / tempat tinggal</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="no_telepon_rumah" value="{{ $data->no_telepon_rumah ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Nomor Telepon seluler pasien</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="no_telepon_seluler" value="{{ $data->no_telepon_seluler ?? ($pasien->telpon ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Pendidikan</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="pendidikan" value="{{ $data->pendidikan ?? ($pasien->pendidikan ?? '') }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align:top;">Pekerjaan Pasien</td>
                            <td style="text-align: center; width: 2%; vertical-align:top;"> : </td>
                            <td class="pt-1">
                                <?php $pekerjaan = $data ? json_decode($data->pekerjaan) : null; ?>
                                <input type="hidden" name="pekerjaan">
                                <table class="tabel_layout">
                                    <tr>
                                        <td>
                                            <input type="checkbox" value="Tidak Bekerja" {{ $pekerjaan && $pekerjaan->value == 'Tidak Bekerja' ? 'checked' : '' }} id="tidak_bekerja"> Tidak Bekerja
                                        </td>
                                        <td>
                                            <input type="checkbox" value="PNS" {{ $pekerjaan && $pekerjaan->value == 'PNS' ? 'checked' : '' }} id="pns"> PNS
                                        </td>
                                        <td>
                                            <input type="checkbox" value="TNI/POLRI" {{ $pekerjaan && $pekerjaan->value == 'TNI/POLRI' ? 'checked' : '' }} id="tni_polri"> TNI/POLRI
                                        </td>
                                        <td>
                                            <input type="checkbox" value="BUMN" {{ $pekerjaan && $pekerjaan->value == 'BUMN' ? 'checked' : '' }} id="bumn"> BUMN
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <input type="checkbox" value="Pegawai Swasta / Wirausaha" {{ $pekerjaan && $pekerjaan->value == 'Pegawai Swasta / Wirausaha' ? 'checked' : '' }} id="swasta_wirausaha"> Pegawai Swasta / Wirausaha
                                        </td>
                                        <td colspan="2">
                                            <input type="checkbox" value="Lain lain" {{ $pekerjaan && $pekerjaan->value == 'Lain lain' ? 'checked' : '' }} id="pekerjaan_lain_lain"> Lain lain
                                            <input type="text" class="inputan" value="{{ $pekerjaan->isian ?? '' }}" id="isian_pekerjaan_lain_lain">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>Nama Tempat Kerja</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="nama_tempat_kerja" value="{{ $data->nama_tempat_kerja ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Alamat Tempat Kerja</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="alamat_tempat_kerja" value="{{ $data->alamat_tempat_kerja ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Telepon/HP tempat kerja</td>
                            <td style="text-align: center; width: 2%;"> : </td>
                            <td>
                                <input type="text" name="telepon_tempat_kerja" value="{{ $data->telepon_tempat_kerja ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="text-center">
                    <b>ANGGOTA KELUARGA TERDEKAT YANG DAPAT DIHUBUNGI</b>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="p-2">
                    <table class="tabel_layout main_table">
                        <tr>
                            <td style="width: 15%;">Nama</td>
                            <td style="width: 2%; text-align: center;"> : </td>
                            <td>
                                <input type="text" name="nama_keluarga" value="{{ $data->nama_keluarga ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Hubungan Keluarga</td>
                            <td style="width: 2%; text-align: center;"> : </td>
                            <td>
                                <input type="text" name="hubungan_keluarga" value="{{ $data->hubungan_keluarga ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Alamat</td>
                            <td style="width: 2%; text-align: center;"> : </td>
                            <td>
                                <input type="text" name="alamat_keluarga" value="{{ $data->alamat_keluarga ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                        <tr>
                            <td>Telepon/HP</td>
                            <td style="width: 2%; text-align: center;"> : </td>
                            <td>
                                <input type="text" name="telepon_keluarga" value="{{ $data->telepon_keluarga ?? '' }}" class="inputan" style="width: 100%;">
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="border: 1px solid transparent; border-top: 1px solid;" class="pt-5">
                    <table class="tabel_layout">
                        <tr>
                            <td style="width: 50%;" class="text-center">
                                Petugas,
                                <div id="box_ttd_petugas" onclick="open_modal_verifikasi()">
                                    @if($data && $data->id_petugas != 0)
                                    <img src="{{ env('SMIS_UPLOAD_URL').'/'.($employee->nama ?? '') }}" style="width: 4cm; height:2.5cm;" alt="">
                                    <br>
                                    ({{ $employee->nama ?? '' }})
                                    @else
                                    <br>
                                    <br>
                                    Simpan & tanda tangan
                                    <br>
                                    <br>
                                    (__________________________________________)
                                    @endif
                                </div>
                            </td>
                            <td style="width: 50%;" class="text-center">
                                Batam,
                                <br>
                                Pasien/Keluarga,
                                <div id="box_ttd_pasien" onclick="open_modal_tanda_tangan_pasien()">
                                    @if($data && $data->ttd_pasien != '')
                                    <img src="{{ asset('signature_patient/'.($data->ttd_pasien ?? '')) }}" style="width: 4cm; height:2.5cm;" alt="">
                                    <br>
                                    ({{ $data->nama_pasien ?? '' }})
                                    @else
                                    <br>
                                    <br>
                                    Simpan & tanda tangan
                                    <br>
                                    <br>
                                    (__________________________________________)
                                    @endif
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </form>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script type="text/javascript" src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>
<script>
    function open_modal_verifikasi() {
        $('#modal_verifikasi').modal('show');
    }

    function open_modal_tanda_tangan_pasien() {
        $('#modal_tanda_tangan_pasien').modal('show');
    }

    const signaturePad = new SignaturePad(document.getElementById('tanda_tangan_pasien'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    $('#btn_clear').click(function(e) {
        e.preventDefault();
        signaturePad.clear();
    });

    $('#form_verifikasi').submit(function(e) {
        e.preventDefault();
        $('[name=jenis_verifikasi]').val('petugas');
        $('[name=password]').val($('#password').val());
        $('#modal_verifikasi').modal('hide');
        $('#form_verifikasi')[0].reset();
        $('#form_dokumen').submit();
    })

    $('#form_tanda_tangan').submit(function(e) {
        e.preventDefault();
        $('[name=jenis_verifikasi]').val('pasien');
        $('[name=nama_pasien]').val($('#nama_pasien').val());
        $('[name=signed]').val(signaturePad.toDataURL('image/png'));
        $('#modal_tanda_tangan_pasien').modal('hide');
        $('#form_tanda_tangan')[0].reset();
        signaturePad.clear();
        $('#form_dokumen').submit();
    })

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();

        let pekerjaan = {
            'value': $('#tidak_bekerja').is(':checked') ? $('#tidak_bekerja').val() : $('#pns').is(':checked') ? $('#pns').val() : $('#tni_polri').is(':checked') ? $('#tni_polri').val() : $('#bumn').is(':checked') ? $('#bumn').val() : $('#swasta_wirausaha').is(':checked') ? $('#swasta_wirausaha').val() : $('#pekerjaan_lain_lain').is(':checked') ? $('#pekerjaan_lain_lain').val() : '',
            'isian': $('#isian_pekerjaan_lain_lain').val()
        }

        $('[name=pekerjaan]').val(JSON.stringify(pekerjaan));

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/pendaftaran_rawat_jalan/store') }}",
            method: 'post',
            data: $('#form_dokumen').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }

                toastr.success(response.message);
                render_tanda_tangan($('[name=jenis_verifikasi]').val() == 'pasien' ? response.data : response.employee);
            }
        })
    })

    function render_tanda_tangan(data) {
        switch ($('[name=jenis_verifikasi]').val()) {
            case 'petugas':
                $('#box_ttd_petugas').html(
                    `<img src="{{ env('SMIS_UPLOAD_URL') }}/` + (data ? data.ttd : '') + `" alt="" style="width: 4cm; height:2.5cm">` +
                    '<br>' +
                    '<span style="border-bottom:1px solid;">(' + (data ? data.nama : '') + ')</span>'
                );
                break;
            case 'pasien':
                $('#box_ttd_pasien').html(
                    `<img src="{{ asset('signature_patient') }}/` + (data ? data.ttd_pasien : '') + `" alt="" style="width: 4cm; height:2.5cm">` +
                    '<br>' +
                    '<span style="border-bottom:1px solid;">(' + (data ? data.nama_pasien : '') + ')</span>'
                );
                break;

            default:
                break;
        }
    }
</script>

</html>