<script>
    //DIAGNOSA
    let id_diagnosa = '{{ $data->id_diagnosa ?? ($diagnosa->id ?? 0) }}'

    function open_modal_list_diagnosa(param) {
        $('#tipe_diagnosa').val(param);
        $('#modal_list_diagnosa').modal('show');
    }

    function get_data_diagnosa() {
        window.event.preventDefault();
        if ($.fn.DataTable.isDataTable("#tabel_list_diagnosa")) {
            $('#tabel_list_diagnosa').DataTable().clear().destroy();
        }
        $.ajax({
            'url': "{{ url('ajax_request/autocomplete_diagnosa') }}",
            'method': "GET",
            'contentType': 'application/json',
            'data': $('#form_cari_diagnosa').serialize()
        }).done(function(data) {
            $('#tabel_list_diagnosa').dataTable({
                "aaData": data,
                "bLengthChange": false,
                "searching": false,
                'pageLength': 5,
                "pagingType": 'simple',
                "columns": [{
                        data: 'kdDiag'
                    },
                    {
                        data: 'nmDiag'
                    },
                    {
                        data: 'nonSpesialis',
                        render: function(data, type, row) {
                            return data ? 'Non Spesialis' : 'Spesialis';
                        }
                    },
                    {
                        data: 'nmDiag',
                        render: function(data, type, row) {
                            return '<div class="text-center"><button class="btn btn-dark" onclick="set_diagnosa_pcare(`' + data + '`,`' + row.kdDiag + '`,`' + row.nonSpesialis + '`)"><i class="fa fa-check"></i></button></div>';
                        }
                    }
                ]
            })
        })
    }

    function set_diagnosa_pcare(diagnosa, kode, spesialis) {

        if ($('#tipe_diagnosa').val() == 'primer') {
            $('#spesialis').val(spesialis == 'true' ? 1 : 0);
        }

        $('#diagnosa_' + $('#tipe_diagnosa').val()).val(diagnosa);
        $('#kode_diagnosa_' + $('#tipe_diagnosa').val()).val(kode);
        $('#tipe_diagnosa').val('');
        $('#modal_list_diagnosa').modal('hide');
    }

    $('#modal_list_diagnosa').on('hidden.bs.modal', function() {
        $('#modal_tambah_diagnosa').modal('show');
    })

    $('#modal_list_diagnosa').on('show.bs.modal', function() {
        $('#modal_tambah_diagnosa').modal('hide');
    })

    $('#form_asesmen').submit(function(e) {
        e.preventDefault();
        if ($('#tanggal').val() == '') {
            toastr.error('Pilih tanggal dahulu');
            return;
        }
        if ($('#penyebab').val() == '') {
            toastr.error('Pilih diagnosa dahulu');
            return;
        }
        $.ajax({
            url: "{{ url('ajax_request/update_diagnosa') }}",
            method: 'post',
            data: $('#form_asesmen').serialize(),
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                let data = response.data;

                $('#box_diagnosa').html(data.kode_icd != '' ? data.kode_icd + ' - ' + data.nama_icd : data.nama_icd);
                $('#box_diagnosa_sekunder').html(data.kode_icd_sekunder != '' ? data.kode_icd_sekunder+' - '+data.nama_icd_sekunder : data.nama_icd_sekunder);
                
                $('#box_diagnosa').val(data.kode_icd != '' ? data.kode_icd + ' - ' + data.nama_icd : data.nama_icd);
                $('#box_diagnosa_sekunder').val(data.kode_icd_sekunder != '' ? data.kode_icd_sekunder+' - '+data.nama_icd_sekunder : data.nama_icd_sekunder);

                $('#box_button_diagnosa').html(
                    '<button class="btn btn-warning btn-sm" type="button" onclick="open_form_diagnosa()" style="color:#fff; font-weight: bold;"><i class="fa fa-pencil"></i></button>'
                );
                $("#tmp_catatan_diagnosa").val(data.diagnosa);

                $('#modal_tambah_diagnosa').modal('hide');

                id_diagnosa = data.id;
                $('[name=id_diagnosa]').val(id_diagnosa);
                $('#form_dokumen').submit();
            }
        })
    })

    function open_form_diagnosa() {
        $('#id_diagnosa').val(id_diagnosa);
        $.ajax({
            url: "{{ url('ajax_request/diagnosa_by_id') }}",
            data: {
                id: id_diagnosa,
            },
            success: function(response) {
                console.log(response);
                if (Object.keys(response).length !== 0) {
                    if (response != null) {
                        $('#tanggal').val(response.tanggal);
                        if (response.nama_dokter != null && response.nama_dokter != "") {
                            $('#dokter').val(response.nama_dokter);
                            $('#nip_dokter').val(response.id_dokter);
                            $('#id_dokter').val(response.id_dokter);
                        }

                        // response.diagnosa.kkl == 1 ? $('#kasus_lama_baru').attr('checked', true) : $('#kasus_lama_baru').removeAttr('checked');
                        $('#catatan_diagnosa').val(response.diagnosa);
                        $('#diagnosa_primer').val(response.nama_icd);
                        $('#diagnosa_sekunder_satu').val(response.nama_icd_sekunder);
                        $('#icd').val(response.nama_icd);
                        $('#kode_icd').val(response.kode_icd);
                    }
                }
                $('#diagnosa_dinkes').select2({
                    dropdownParent: $("#modal_tambah_diagnosa .modal-body")
                });
                $('#modal_tambah_diagnosa').modal('show');
            }
        })
    }

    function set_dokter_diagnosa(dokter, id, nip) {
        $('#dokter').val(dokter);
        $('#nip_dokter').val(id);
        $('#id_dokter').val(id);
        $('#modal_dokter').modal('hide');
        $('#modal_tambah_diagnosa').modal('show');
    }

    function set_diagnosa(nama, icd, penyebab, url) {
        $('#diagnosa_' + url).val(nama);

        if (url == 'primer') {
            $('#icd').val(nama);
            $('#kode_icd').val(icd);
            $('#penyebab').val(penyebab);
        }

        $('#modal_diagnosa').modal('hide');
        $('#modal_tambah_diagnosa').modal('show');
    }
    //END OF DIAGNOSA
</script>