@extends('medical_record.e_rekam_medis.dokumen_kunjungan.layout')
@section('content')
<style>
    .inputan {
        border: none;
        border-bottom: 1px dotted;
    }

    p {
        margin-bottom: 0;
    }

    #tabel_riwayat_kehamilan tr th {
        text-align: center;
    }
</style>

<div class="modal fade" id="modal_yth" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Kepada Yth.</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table id="tabel_kepada" class="table table-striped mt-2">
                    <thead>
                        <tr class="text-center">
                            <th>No</th>
                            <th>Nama</th>
                            <th>Jabatan</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_tambah_asesmen" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Pilih</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="form_ppa">
                <div class="modal-body">
                    @csrf
                    <div class="row">
                        <div class="col-md-12 pt-2" style="display: inline-flex; align-items: center;">
                            <p style="width: 30%; padding-left:18px ;">Jenis PPA : </p>
                            <div class="pl-2 pr-2" style="margin-top: -15px; width:70%;">
                                <select id="jenis_ppa" class="form-control">
                                    <option value="" selected disabled>Pilih Salah Satu</option>
                                    <option value="ns">Ns</option>
                                    <option value="dr">Dr</option>
                                    <option value="fp">Fp</option>
                                    <option value="apt">Apt</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Buat Form</button>
                </div>
            </form>
        </div>
    </div>
</div>

<form class="container pl-0 pr-0" id="form_dokumen" style="border:1px solid;">
    @csrf
    <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
    <input type="hidden" name="password">
    <input type="hidden" name="id_diagnosa" value="{{ $data->id_diagnosa ?? 0 }}">
    <input type="hidden" name="id_lab" value="{{ $data->id_lab ?? 0 }}">
    <input type="hidden" name="id_resep" value="{{ $data->id_resep ?? 0 }}">
    @include('medical_record.e_rekam_medis.dokumen_kunjungan.kop')
    <div class="row" style="width: 100%; margin-left: 0;">
        <div class="col-md-12 pb-3 pt-3">
            <button type="button" class="btn btn-success pull-right" onclick="open_modal_tambah_asesmen()"><i class="fa fa-plus"></i> Tambah Assesmen</button>
        </div>
        <div class="col-md-12 pb-2">
            <table style="font-size: 12px; width: 100%; border-collapse: collapse; border-color:#111;" border="1">
                <thead>
                    <tr class="text-center">
                        <th style="vertical-align: middle; width: 10%">Tgl/Pkl</th>
                        <th style="vertical-align: middle; width: 20%">PPA</th>
                        <th style="vertical-align: middle; width: 35%">HASIL PEMERIKSAAN, ANALISA/ASESMEN
                            RENCANA PENATALAKSANAAN PASIEN – IAR
                        </th>
                        <th style="vertical-align: middle; width: 25%">
                            Intruksi PPA termasuk Pasca
                            Bedah
                        </th>
                        <th style="vertical-align: middle; width: 10%">
                            Verifikasi DPJP
                        </th>
                    </tr>
                </thead>
                <tbody id="box_form_ppa">
                    <tr>
                        <td colspan="5">
                            <div class="row">
                                <div class="col-3" style="text-align: right">PPA:</div>
                                <div class="col-2">Dr: Dokter</div>
                                <div class="col-2">Ns: Perawat</div>
                                <div class="col-2">Fp: Fisioterapist</div>
                                <div class="col-3">Apt: Apoteker</div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <input type="hidden" name="ppa_submit">
    <input type="hidden" name="active_form">
    <input type="hidden" name="ns">
    <input type="hidden" name="dr">
    <input type="hidden" name="fp">
    <input type="hidden" name="apt">
</form>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.popup_verifikasi')
<?php
$rpd = '';
if ($rpd == '') {
    if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
        $rpd = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_penyakit_dahulu;
    } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
        $rpd = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_penyakit_dahulu;
    } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
        $rpd = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_penyakit_dahulu;
    }
}

$rpk = '';
if ($rpk == '') {
    if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
        $rpk = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_penyakit_keluarga;
    } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
        $rpk = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_penyakit_keluarga;
    } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
        $rpk = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_penyakit_keluarga;
    }
}

$rao = '';
if ($rao == '') {
    if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
        $rao = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_alergi_obat;
    } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
        $rao = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_alergi_obat;
    } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
        $rao = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_alergi_obat;
    }
}

$ck = '';
if ($ck == '') {
    if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
        $ck = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->catatan_khusus_ns;
        if ($ck == '') {
            $ck = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->catatan_khusus_dr;
        }
    }
}
?>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.resep')
@endsection
@push('scripts')
<script>
    function dmyhi_to_dmy(data) {
        if (data == '' || data == null) {
            return '';
        }

        let temp = data.split(' ');
        return temp[0];
    }

    function dmyhi_to_hi(data) {
        if (data == '' || data == null) {
            return '';
        }

        let temp = data.split(' ');
        return temp[1];
    }

    let data_ns = <?php echo $data && $data->ns != '' ? $data->ns : 'null' ?>;
    let data_dr = <?php echo $data && $data->dr != '' ? $data->dr : 'null' ?>;
    let data_fp = <?php echo $data && $data->fp != '' ? $data->fp : 'null' ?>;
    let data_apt = <?php echo $data && $data->apt != '' ? $data->apt : 'null' ?>;

    var element_html_ns = '<tr>' +
        '        <td colspan="5" class="text-center">' +
        '            <span style="font-size: 20px"><b>Ns</b></span>' +
        '        </td>' +
        '    </tr>' +
        '    <tr>' +
        '        <td style="vertical-align: text-top; text-align: center;">' +
        `            <span id="tgl_ns">` + (data_ns ? dmyhi_to_dmy(data_ns.tanggal) : '') + `</span>` +
        '            <br>' +
        `            <span id="jam_ns">` + (data_ns ? dmyhi_to_hi(data_ns.tanggal) : '') + `</span>` +
        '        </td>' +
        '        <td style="vertical-align: text-top;" class="p-1">' +
        '            <div class="input-group">' +
        '                <input type="text" hidden id="id_ppa_ns" value="' + (data_ns ? data_ns.ppa.id : `{{ $employee_auth ? $employee_auth->id : '' }}`) + '">' +
        `                <input type="text" readonly value="` + (data_ns ? data_ns.ppa.nama : `{{ $employee_auth ? $employee_auth->nama : '' }}`) + `" id="ppa_ns" class="form-control">` +
        '                <div class="input-group-append">' +
        '                    <button class="btn btn-dark" type="button" onclick="open_modal_yth(`ns`)"><i class="fa fa-list"></i></button>' +
        '                </div>' +
        '            </div>' +
        '        </td>' +
        '        <td class="p-1">' +
        '            @if(!isset($data))' +
        '                <button type="button" class="btn btn-success" onclick="ambil_data_sebelumnya()"><i class="fa fa-plus"></i> Ambil data sebelumnya</button>' +
        '                <br>' +
        '            @endif' +
        '            <span style="font-size: 20px"><b>Subjective :</b></span>' +
        '            <br>' +
        '            <textarea id="subjective_ns" onkeyup="cek_subjective()" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_ns ? data_ns.subjective : '') + '</textarea>' +
        '            <br>' +
        '            <span>Catatan Khusus</span>' +
        '            <input type="text" onkeyup="cek_catatan_khusus()" value="' + (data_ns ? data_ns.catatan_khusus : '{{ $ck }}') + '" id="catatan_khusus_ns" class="form-control">' +
        '            <br>' +
        '            <br>' +
        '            <span style="font-size: 20px"><b>Objective :</b></span>' +
        '            <div class="row">' +
        '                <div class="col-md-12" style="display: inline-flex;"">' +
        '                    <span style="width: 30%;">Keadaan Umum <span style="float: right; padding-right: 5px">: </span></span>' +
        '                    <span id="keadaan_umum_ns"></span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; align-items: center;">' +
        '                    <span style="width: 30%;">Kesadaran <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                    <span id="kesadaran_ns">{{ $diagnosa ? $diagnosa->kesadaran : ' - ' }}</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex;">' +
        '                    <span style="width: 30%;">Berat badan <span style="float: right; padding-right: 5px">: </span> </span>' +
        `                    <span>{{ $diagnosa ? $diagnosa->berat_badan : '0' }}</span>` +
        '                    <span class="pl-2" style="width:20%;">kg</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; ">' +
        '                    <span style="width: 30%;">Tinggi badan <span style="float: right; padding-right: 5px">: </span> </span>' +
        `                    <span>{{ $diagnosa ? $diagnosa->tinggi_badan : '0' }}</span>` +
        '                    <span class="pl-2" style="width:20%;">cm</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; align-items: center;">' +
        '                    <span style="width: 30%;">Status Gizi <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                    <span id="status_gizi_ns">{{ $diagnosa ? ((double) $diagnosa->imt < 18.5 ? "Kurang" : ((double) $diagnosa->imt > 18.5 && (double) $diagnosa->imt < 24.9 ? "Normal" : "Lebih" )  ) : ' - ' }}</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; ">' +
        '                    <span style="width: 30%;">Tensi <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                    <span style={{ $diagnosa && (int)$diagnosa->sistole > 140 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->sistole."/".$diagnosa->diastole : ' - ' }}</span>' +
        '                    <span class="pl-2" style="width:20%;">mmHg</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; ">' +
        '                    <span style="width: 30%;">Nadi <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                    <span style={{ $diagnosa && (int)$diagnosa->nadi > 90 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->nadi : ' - ' }}</span>' +
        '                    <span class="pl-2" style="width:20%;">x/mnt</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; ">' +
        '                    <span style="width: 30%;">Suhu <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                    <span style={{ $diagnosa && (int)$diagnosa->suhu > 37 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->suhu : ' - ' }}</span>' +
        '                    <span class="pl-2" style="width:20%;">&deg;C</span>' +
        '                </div>' +
        '                <div class="col-md-12" style="display: inline-flex; ">' +
        '                    <span style="width: 30%;">RR <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                    <span style={{ $diagnosa && (int)$diagnosa->rr > 25 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->rr : ' - ' }}</span>' +
        '                    <span class="pl-2" style="width:20%;">x/mnt</span>' +
        '                </div>' +
        '            </div>' +
        '            <br>' +
        '            <span style="font-size: 20px"><b>Assesmen : </b></span>' +
        '            <br>' +
        '            <textarea id="assesmen_ns" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_ns ? data_ns.assesmen : '') + '</textarea>' +
        '            <br>' +
        '            <br>' +
        '            <span style="font-size: 20px"><b>Planning :</b></span>' +
        '            <br>' +
        '            <textarea id="planning_ns" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_ns ? data_ns.planning : '') + '</textarea>' +
        '        </td>' +
        '        <td class="p-1" style="vertical-align:top;">' +
        '            <textarea id="intruksi_ns" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_ns ? data_ns.intruksi : '') + '</textarea>' +
        '        </td>' +
        '        <td style="text-align: center; vertical-align:top;" class="p-1" id="box_ttd_ns">' +
        '            @if ($dokumen->status == 1)' +
        '                @if($employee_ns)' +
        `                    <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee_ns->ttd_foto ?? '') }}" style="height: 2cm; width: 4cm;" alt="">` +
        '                @else' +
        '                    <img src="" style="height: 2cm; width: 4cm;" alt="">' +
        '                @endif' +
        '                {{ $employee_ns->nama ?? "" }}' +
        '            @endif' +
        '            <a href="#" onclick="open_modal_verifikasi(`ns`)" class="btn btn-primary col-md-12">' +
        '                SIMPAN' +
        '            </a>' +
        '        </td>' +
        '    </tr>';

    var element_html_dr = '<tr>' +
        '    <td colspan="5" class="text-center">' +
        '        <span style="font-size: 20px"><b>Dr</b></span>' +
        '    </td>' +
        '</tr>' +
        '<tr>' +
        '    <td style="vertical-align: text-top; text-align: center;">' +
        `        <span id="tgl_dr">` + (data_dr ? dmyhi_to_dmy(data_dr.tanggal) : '') + `</span>` +
        '        <br>' +
        `        <span id="jam_dr">` + (data_dr ? dmyhi_to_hi(data_dr.tanggal) : '') + `</span>` +
        '    </td>' +
        '    <td style="vertical-align: text-top">' +
        '        <div class="input-group">' +
        '            <input type="text" hidden id="id_ppa_dr" value="' + (data_dr ? data_dr.ppa.id : `{{ $employee_auth ? $employee_auth->id : '' }}`) + '">' +
        `            <input type="text" readonly value="` + (data_dr ? data_dr.ppa.nama : `{{ $employee_auth ? $employee_auth->nama : '' }}`) + `" id="ppa_dr" class="form-control">` +
        '            <div class="input-group-append">' +
        '                <button class="btn btn-dark" type="button" onclick="open_modal_yth(`dr`)"><i class="fa fa-list"></i></button>' +
        '            </div>' +
        '        </div>' +
        '    </td>' +
        '    <td class="p-1">' +
        '        <span style="font-size: 20px"><b>Subjective :</b></span>' +
        '        <br>' +
        '        <textarea id="subjective_dr" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_dr ? data_dr.subjective : '') + '</textarea>' +
        '        <br>' +
        '        <span>Riwayat Penyakit Dahulu</span>' +
        '        <input type="text" value="' + (data_dr && data_dr.riwayat_penyakit_dahulu != '' ? data_dr.riwayat_penyakit_dahulu : '{{ $rpd }}') + '" id="riwayat_penyakit_dahulu" class="form-control">' +
        '        <br>' +
        '        <span>Riwayat Penyakit Kronis</span>' +
        `        <input type="text" value="` + (data_dr && data_dr.riwayat_penyakit_dahulu != '' ? data_dr.riwayat_penyakit_dahulu : `{{ ($dokumen2 && $dokumen2->asesmen_medis_awal_rajal ? $dokumen2->asesmen_medis_awal_rajal->riwayat_penyakit_kronis : ($asesmen_rajal_gigi && $asesmen_rajal_gigi->asesmen_medis_awal_rajal_gigi ? $asesmen_rajal_gigi->asesmen_medis_awal_rajal_gigi->riwayat_penyakit_kronis : '')) }}`) + `" id="riwayat_penyakit_kronis" class="form-control">` +
        '        <br>' +
        '        <span>Riwayat Penyakit Keluarga</span>' +
        '        <input type="text" value="' + (data_dr && data_dr.riwayat_penyakit_keluarga != '' ? data_dr.riwayat_penyakit_keluarga : '{{ $rpk }}') + '" id="riwayat_penyakit_keluarga" class="form-control">' +
        '        <br>' +
        '        <span style="color: red;">Riwayat Alergi Obat</span>' +
        '        <input type="text" style="color: red;" value="' + (data_dr && data_dr.riwayat_alergi_obat != '' ? data_dr.riwayat_alergi_obat : '{{ $rao }}') + '" id="riwayat_alergi_obat" class="form-control">' +
        '        <br>' +
        '        <span style="color: red;">Catatan Khusus</span>' +
        `        <input type="text" style="color: red;" value="` + (data_dr && data_dr.catatan_khusus != '' ? data_dr.catatan_khusus : (data_ns ? data_ns.catatan_khusus : '')) + `" id="catatan_khusus_dr" class="form-control">` +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Objective :</b></span>' +
        '        <div class="row">' +
        '            <div class="col-md-12" style="display: inline-flex;"">' +
        '                <span style="width: 30%;">Keadaan Umum <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span id="keadaan_umum_dr"></span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; align-items: center;">' +
        '                <span style="width: 30%;">Kesadaran <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span id="kesadaran_dr">{{ $diagnosa ? $diagnosa->kesadaran : ' - ' }}</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex;">' +
        '                <span style="width: 30%;">Berat badan <span style="float: right; padding-right: 5px">: </span> </span>' +
        `                <span>{{ $diagnosa ? $diagnosa->berat_badan : '0' }}</span>` +
        '                <span class="pl-2" style="width:20%;">kg</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; ">' +
        '                <span style="width: 30%;">Tinggi badan <span style="float: right; padding-right: 5px">: </span> </span>' +
        `                <span>{{ $diagnosa ? $diagnosa->tinggi_badan : '0' }}</span>` +
        '                <span class="pl-2" style="width:20%;">cm</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; align-items: center;">' +
        '                <span style="width: 30%;">Status Gizi <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span id="status_gizi_dr">{{ $diagnosa ? ((double) $diagnosa->imt < 18.5 ? "Kurang" : ((double) $diagnosa->imt > 18.5 && (double) $diagnosa->imt < 24.9 ? "Normal" : "Lebih" )  ) : ' - ' }}</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; ">' +
        '                <span style="width: 30%;">Tensi <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span style={{ $diagnosa && (int)$diagnosa->sistole > 140 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->sistole."/".$diagnosa->diastole : ' - ' }}</span>' +
        '                <span class="pl-2" style="width:20%;">mmHg</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; ">' +
        '                <span style="width: 30%;">Nadi <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span style={{ $diagnosa && (int)$diagnosa->nadi > 90 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->nadi : ' - ' }}</span>' +
        '                <span class="pl-2" style="width:20%;">x/mnt</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; ">' +
        '                <span style="width: 30%;">Suhu <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span style={{ $diagnosa && (int)$diagnosa->suhu > 37 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->suhu : ' - ' }}</span>' +
        '                <span class="pl-2" style="width:20%;">&deg;C</span>' +
        '            </div>' +
        '            <div class="col-md-12" style="display: inline-flex; ">' +
        '                <span style="width: 30%;">RR <span style="float: right; padding-right: 5px">: </span> </span>' +
        '                <span style={{ $diagnosa && (int)$diagnosa->rr > 25 ? "color:red" : "color:black" }}>{{ $diagnosa ? $diagnosa->rr : ' - ' }}</span>' +
        '                <span class="pl-2" style="width:20%;">x/mnt</span>' +
        '            </div>' +
        '            <div class="col-md-12 pt-2">' +
        '                <p>Dokumen Penunjang Eksternal : </p>' +
        '                <input type="file" id="penunjang_eksternal_file" style="margin-bottom:10px">' +
        '                <br>' +
        (data_dr == null || data_dr.dokumen_penunjang_eksternal == '' ?
            '                    <button class="btn btn-warning" id="penunjang_eksternal" onclick="open_modal_upload_dokumen_kunjungan()">Ubah Gambar</button>' +
            '                    <br>' +
            `                    File : ` + (data_dr ? data_dr.dokumen_penunjang_eksternal : '') +
            `                    <a href="{{ url('e_rekam_medis/catatan_perkembangan_pasien/download_dokumen_penunjang_eksternal?dokumen=' . $dokumen->id) }}" target="_blank" class="btn btn-info mt-2" type="button" data-toggle="tooltip" title="Download"><i class="fa fa-arrow-down"></i></a>` :
            '') +
        '                <br>' +
        '                <br>' +
        '                <p>Pemeriksaan Fisik </p>' +
        '                <textarea id="pemeriksaan_fisik_dr" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_dr ? data_dr.pemeriksaan_fisik : '') + '</textarea>' +
        '            </div>' +
        '        </div>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Assesmen : </b></span>' +
        '        <br>' +
        '        Diagnosa' +
        `        <textarea rows="3" style="height: 100%" type="text" id="tmp_catatan_diagnosa" disabled class="form-control">{{ $diagnosa ? $diagnosa->diagnosa : '' }}</textarea>` +
        '        <br>' +
        '        <div style="display: flex; flex-direction: row">' +
        '            <div id="box_button_diagnosa">' +
        '                @if ($diagnosa == null)' +
        '                    <button type="button" class="btn btn-success btn-sm" onclick="open_form_diagnosa()"><i class="fa fa-plus"></i></button>' +
        '                @else' +
        '                    <button type="button" class="btn btn-warning btn-sm" onclick="open_form_diagnosa()" style="color:#fff; font-weight: bold;"><i class="fa fa-pencil"></i></button>' +
        '                @endif' +
        '            </div>' +
        '            <div>' +
        '               <div id="box_diagnosa" class="pl-2">' +
        `                   {{ $diagnosa ? $diagnosa->kode_icd . ' - ' . $diagnosa->nama_icd : '' }}` +
        '               </div>' +
        '               <div id="box_diagnosa_sekunder" class="pl-2">' +
        `                        <?php
                                    if ($diagnosa && $diagnosa->nama_icd_sekunder != '') {
                                        echo $diagnosa->kode_icd_sekunder . ' - ' . $diagnosa->nama_icd_sekunder;
                                    }
                                    ?>` +
        '                </div>' +
        '            </div>' +
        '        </div>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Planning :</b></span>' +
        '        <br>' +
        '        Terapi' +
        '        <br>' +
        '        <div id="box_btn_terapi">' +
        '               @if ($resep == null)' +
        '                   <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_resep()"><i class="fa fa-plus"></i></button>' +
        '               @else' +
        '                   @if ($resep->locked == 0)' +
        '                       <button class="btn btn-warning btn-sm" type="button" onclick="open_modal_resep()"><i class="fa fa-pencil" style="color:#fff;"></i></button>' +
        '                       <button class="btn btn-info btn-sm" type="button" onclick="lock_terapi()">Kirim ke farmasi</button>' +
        '                   @endif' +
        '                   <button class="btn btn-info btn-sm" type="button" onclick="preview_terapi()">Preview</button>' +
        '               @endif' +
        '               <br>No. Resep Elektronik' +
        '               @if ($resep)' +
        '                   {{ $resep->id }}' +
        '               @endif' +
        '               <table style="border-collapse: collapse; width:100%;">' +
        '                   @if ($resep)' +
        '                       @foreach ($resep->detail as $ar_det)' +
        '                           <tr>' +
        '                               <td style="width:20px;">R/</td>' +
        '                               <td>{{ $ar_det->nama_obat }}</td>' +
        '                               <td>{{ $ar_det->signa }}</td>' +
        `                               <td style="padding-left: 20px;">{{ $ar_det->jumlah . ' ' . $ar_det->satuan }}</td>` +
        '                           </tr>' +
        '                       @endforeach' +
        '                   @endif' +
        '               </table>' +
        '               @if ($resep)' +
        `                     @php $cor = ''; $temp_catatan = $resep->catatan_obat_racikan ? substr(PHP_OS, 0, 3) == 'WIN' ? explode("\r\n", $resep->catatan_obat_racikan) : explode("\r\n", $resep->catatan_obat_racikan) : []; @endphp` +
        '                     @for ($i =0; $i < sizeof($temp_catatan); $i++)' +
        '                     @if($i > 0)' +
        '                         {{ $temp_catatan[$i] }}' + '<br>' +
        '                     @else' +
        "                         {{ $temp_catatan[$i] }}<br>" +
        '                     @endif' +
        '                     @endfor' +
        '               @endif' +
        '           </div>' +
        '        <br>' +
        '        <span>Tindak Lanjut</span>' +
        '        <textarea id="tindak_lanjut_dr" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_dr ? data_dr.tindak_lanjut : '') + '</textarea>' +
        '        <br>' +
        '        <span>Status Pulang</span>' +
        '        <select id="status_pulang_dr" class="form-control">' +
        `            <option value="">--Select Here--</option>` +
        `            <option ` + (data_dr && data_dr.status_pulang == '1' ? 'selected' : `{{ $diagnosa && $diagnosa->kode_status_pulang == '1' ? 'selected' : '' }}`) + ` value="1">Meninggal</option>` +
        `            <option ` + (data_dr && data_dr.status_pulang == '3' ? 'selected' : `{{ $diagnosa && $diagnosa->kode_status_pulang == '3' ? 'selected' : '' }}`) + ` value="3">Berobat Jalan</option>` +
        `            <option ` + (data_dr && data_dr.status_pulang == '4' ? 'selected' : `{{ $diagnosa && $diagnosa->kode_status_pulang == '4' ? 'selected' : '' }}`) + ` value="4">Rujuk Vertikal</option>` +
        `            <option ` + (data_dr && data_dr.status_pulang == '6' ? 'selected' : `{{ $diagnosa && $diagnosa->kode_status_pulang == '6' ? 'selected' : '' }}`) + ` value="6">Rujuk Horizontal</option>` +
        `        </select>` +
        '        <br>' +
        '    </td>' +
        '    <td class="p-1" style="vertical-align:top;">' +
        '        <textarea id="intruksi_dr" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_dr ? data_dr.intruksi : '') + '</textarea>' +
        '    </td>' +
        '    <td style="text-align: center; vertical-align:top;" class="p-1" id="box_ttd_dr">' +
        '        @if ($dokumen->status == 1)' +
        '            @if($employee_dr)' +
        `                <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee_dr->ttd_foto ?? '') }}" style="height: 2cm; width: 4cm;" alt="">` +
        '            @else' +
        '                <img src="" style="height: 2cm; width: 4cm;" alt="">' +
        '            @endif' +
        '            {{ $employee_dr->nama ?? "" }}' +
        '        @endif' +
        '        <a href="#" onclick="open_modal_verifikasi(`dr`)" class="btn btn-primary col-md-12">' +
        '            SIMPAN' +
        '        </a>' +
        '    </td>' +
        '</tr>';

    var element_html_fp = '<tr>' +
        '    <td colspan="5" class="text-center">' +
        '        <span style="font-size: 20px"><b>Fp</b></span>' +
        '    </td>' +
        '</tr>' +
        '<tr>' +
        '    <td style="vertical-align: text-top; text-align: center;">' +
        `        <span id="tgl_fp">` + (data_fp ? dmyhi_to_dmy(data_fp.tanggal) : '') + `</span>` +
        '        <br>' +
        `        <span id="jam_fp">` + (data_fp ? dmyhi_to_hi(data_fp.tanggal) : '') + `</span>` +
        '    </td>' +
        '    <td class="text-center p-1" style="vertical-align: text-top;">' +
        '        <div class="input-group">' +
        '            <input type="text" hidden id="id_ppa_fp" value="' + (data_fp ? data_fp.ppa.id : `{{ $employee_auth ? $employee_auth->id : '' }}`) + '">' +
        `            <input type="text" readonly value="` + (data_fp ? data_fp.ppa.nama : `{{ $employee_auth ? $employee_auth->nama : '' }}`) + `" id="ppa_fp" class="form-control">` +
        '            <div class="input-group-append">' +
        '                <button class="btn btn-dark" type="button" onclick="open_modal_yth(`fp`)"><i class="fa fa-list"></i></button>' +
        '            </div>' +
        '        </div>' +
        '    </td>' +
        '    <td class="p-1">' +
        '        <span style="font-size: 20px"><b>Subjective :</b></span>' +
        '        <br>' +
        '        <textarea id="subjective_fp" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_fp ? data_fp.subjective : '') + '</textarea>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Objective :</b></span>' +
        '        <br>' +
        '        <textarea id="objective_fp" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_fp ? data_fp.objective : '') + '</textarea>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Assesmen :</b></span>' +
        '        <br>' +
        '        <textarea id="assesmen_fp" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_fp ? data_fp.assesmen : '') + '</textarea>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Planning :</b></span>' +
        '        <br>' +
        '        <textarea id="planning_fp" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_fp ? data_fp.planning : '') + '</textarea>' +
        '    </td>' +
        '    <td class="p-1" style="vertical-align:top;">' +
        '        <textarea id="intruksi_fp" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_fp ? data_fp.intruksi : '') + '</textarea>' +
        '    </td>' +
        '    <td style="text-align: center; vertical-align:top;" class="p-1" id="box_ttd_fp">' +
        '        @if ($dokumen->status == 1)' +
        '            @if($employee_fp)' +
        `                <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee_fp->ttd_foto ?? '') }}" style="height: 2cm; width: 4cm;" alt="">` +
        '            @else' +
        '                <img src="" style="height: 2cm; width: 4cm;" alt="">' +
        '            @endif' +
        '            {{ $employee_fp->nama ?? "" }}' +
        '        @endif' +
        '        <a href="#" onclick="open_modal_verifikasi(`fp`)" class="btn btn-primary col-md-12">' +
        '            SIMPAN' +
        '        </a>' +
        '    </td>' +
        '</tr>';

    var element_html_apt = '<tr>' +
        '    <td colspan="5" class="text-center">' +
        '        <span style="font-size: 20px"><b>apt</b></span>' +
        '    </td>' +
        '</tr>' +
        '<tr>' +
        '    <td style="vertical-align: text-top; text-align: center;">' +
        `        <span id="tgl_apt">` + (data_apt ? dmyhi_to_dmy(data_apt.tanggal) : '') + `</span>` +
        '        <br>' +
        `        <span id="jam_apt">` + (data_apt ? dmyhi_to_hi(data_apt.tanggal) : '') + `</span>` +
        '    </td>' +
        '    <td class="text-center p-1" style="vertical-align: text-top;">' +
        '        <div class="input-group">' +
        '            <input type="text" hidden id="id_ppa_apt" value="' + (data_apt ? data_apt.ppa.id : `{{ $employee_auth ? $employee_auth->id : '' }}`) + '">' +
        `            <input type="text" readonly value="` + (data_apt ? data_apt.ppa.nama : `{{ $employee_auth ? $employee_auth->nama : '' }}`) + `" id="ppa_apt" class="form-control">` +
        '            <div class="input-group-append">' +
        '                <button class="btn btn-dark" type="button" onclick="open_modal_yth(`apt`)"><i class="fa fa-list"></i></button>' +
        '            </div>' +
        '        </div>' +
        '    </td>' +
        '    <td class="p-1">' +
        '        <span style="font-size: 20px"><b>Subjective :</b></span>' +
        '        <br>' +
        '        <textarea id="subjective_apt" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_apt ? data_apt.subjective : '') + '</textarea>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Objective :</b></span>' +
        '        <br>' +
        '        <textarea id="objective_apt" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_apt ? data_apt.objective : '') + '</textarea>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Assesmen :</b></span>' +
        '        <br>' +
        '        <textarea id="assesmen_apt" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_apt ? data_apt.assesmen : '') + '</textarea>' +
        '        <br>' +
        '        <br>' +
        '        <span style="font-size: 20px"><b>Planning :</b></span>' +
        '        <br>' +
        '        <textarea id="planning_apt" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_apt ? data_apt.planning : '') + '</textarea>' +
        '    </td>' +
        '    <td class="p-1" style="vertical-align:top;">' +
        '        <textarea id="intruksi_apt" cols="30" rows="3" class="form-control" style="width: 100%;">' + (data_apt ? data_apt.intruksi : '') + '</textarea>' +
        '    </td>' +
        '    <td style="text-align: center; vertical-align:top;" class="p-1" id="box_ttd_apt">' +
        '        @if ($dokumen->status == 1)' +
        '            @if($employee_apt)' +
        `                <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee_apt->ttd_foto ?? '') }}" style="height: 2cm; width: 4cm;" alt="">` +
        '            @else' +
        '                <img src="" style="height: 2cm; width: 4cm;" alt="">' +
        '            @endif' +
        '            {{ $employee_apt->nama ?? "" }}' +
        '        @endif' +
        '        <a href="#" onclick="open_modal_verifikasi(`apt`)" class="btn btn-primary col-md-12">' +
        '            SIMPAN' +
        '        </a>' +
        '    </td>' +
        '</tr>';
</script>
<script>
    let active_form = <?php echo $data ? $data->active_form : '[]' ?>;

    $(document).ready(function() {
        for (let i = 0; i < active_form.length; i++) {
            switch (active_form[i]) {
                case 'ns':
                    var tmp_subjective_ns = data_ns ? data_ns.subjective : `{{ ($diagnosa ? preg_replace('/\s+/', ' ', preg_replace('/\n+/', '|', trim($diagnosa->keluhan))) : "") }}`;
                    reformat_newline(tmp_subjective_ns, 'subjective_ns');
                    var tmp_keadaan_umum = `{{ $diagnosa ? preg_replace('/\s+/', ' ', preg_replace('/\n+/', '|', trim($diagnosa->anamnesa))) : ''}}`;
                    reformat_newline(tmp_keadaan_umum, 'keadaan_umum_ns', 'span');
                    $('#box_form_ppa').prepend(element_html_ns);
                    break;
                case 'dr':
                    var tmp_subjective_dr = data_dr ? data_dr.subjective : `{{ ($diagnosa ? preg_replace('/\s+/', ' ', preg_replace('/\n+/', '|', trim($diagnosa->keluhan))) : "") }}`;
                    reformat_newline(tmp_subjective_dr, 'subjective_dr');
                    var tmp_keadaan_umum = `{{ $diagnosa ? preg_replace('/\s+/', ' ', preg_replace('/\n+/', '|', trim($diagnosa->anamnesa))) : ''}}`;
                    reformat_newline(tmp_keadaan_umum, 'keadaan_umum_dr', 'span');
                    $('#box_form_ppa').prepend(element_html_dr);
                    break;
                case 'fp':
                    $('#box_form_ppa').prepend(element_html_fp);
                    break;
                case 'apt':
                    $('#box_form_ppa').prepend(element_html_apt);
                    break;
                default:
                    break;
            }
        }

        $('#pesan_pemeriksaan').select2();
    })

    function simpan() {
        let ns = {
            'tanggal': $('#tgl_ns').html() + ' ' + $('#jam_ns').html(),
            'ppa': {
                'id': $('#id_ppa_ns').val(),
                'nama': $('#ppa_ns').val()
            },
            'subjective': $('#subjective_ns').val(),
            'catatan_khusus': $('#catatan_khusus_ns').val(),
            'assesmen': $('#assesmen_ns').val(),
            'planning': $('#planning_ns').val(),
            'intruksi': $('#intruksi_ns').val(),
        }

        let dr = {
            'tanggal': $('#tgl_dr').html() + ' ' + $('#jam_dr').html(),
            'ppa': {
                'id': $('#id_ppa_dr').val(),
                'nama': $('#ppa_dr').val()
            },
            'subjective': $('#subjective_dr').val(),
            'riwayat_penyakit_dahulu': $('#riwayat_penyakit_dahulu').val(),
            'riwayat_penyakit_kronis': $('#riwayat_penyakit_kronis').val(),
            'riwayat_penyakit_keluarga': $('#riwayat_penyakit_keluarga').val(),
            'riwayat_alergi_obat': $('#riwayat_alergi_obat').val(),
            'catatan_khusus': $('#catatan_khusus_dr').val(),
            'pemeriksaan_fisik': $('#pemeriksaan_fisik_dr').val(),
            'tindak_lanjut': $('#tindak_lanjut_dr').val(),
            'status_pulang': $('#status_pulang_dr').val(),
            'intruksi': $('#intruksi_dr').val(),
        }

        let fp = {
            'tanggal': $('#tgl_fp').html() + ' ' + $('#jam_fp').html(),
            'ppa': {
                'id': $('#id_ppa_fp').val(),
                'nama': $('#ppa_fp').val()
            },
            'subjective': $('#subjective_fp').val(),
            'objective': $('#objective_fp').val(),
            'assesmen': $('#assesmen_fp').val(),
            'planning': $('#planning_fp').val(),
            'intruksi': $('#intruksi_fp').val(),
        }

        let apt = {
            'tanggal': $('#tgl_apt').html() + ' ' + $('#jam_apt').html(),
            'ppa': {
                'id': $('#id_ppa_apt').val(),
                'nama': $('#ppa_apt').val()
            },
            'subjective': $('#subjective_apt').val(),
            'objective': $('#objective_apt').val(),
            'assesmen': $('#assesmen_apt').val(),
            'planning': $('#planning_apt').val(),
            'intruksi': $('#intruksi_apt').val(),
        }

        if (active_form.includes('ns')) {
            $('[name=ns]').val(JSON.stringify(ns));
        }

        if (active_form.includes('dr')) {
            $('[name=dr]').val(JSON.stringify(dr));
        }

        if (active_form.includes('fp')) {
            $('[name=fp]').val(JSON.stringify(fp));
        }

        if (active_form.includes('apt')) {
            $('[name=apt]').val(JSON.stringify(apt));
        }

        $('[name=active_form]').val(JSON.stringify(active_form));

        toastr.warning('Sedang menyimpan dokumen, harap tunggu...');

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/catatan_perkembangan_pasien/store') }}",
            data: $('#form_dokumen').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                $('#box_ttd_'+$('[name=ppa_submit]').val()).html(
                    `<img src="{{ env('SMIS_UPLOAD_URL') }}/`+ (response.employee ? response.employee.ttd_foto : '') +`" style="height: 2cm; width: 4cm;" alt="">` +
                    '<br>' +
                    (response.employee ? response.employee.nama : '') + 
                    '<a href="#" onclick="open_modal_verifikasi(`'+$('[name=ppa_submit]').val()+'`)" class="btn btn-primary col-md-12">' +
                    'SIMPAN' +
                    '</a>'
                );
                $('[name=jenis_ppa]').val('');
            }
        })
    }

    $('#form_ppa').submit(function(e) {
        e.preventDefault();

        if ($('#jenis_ppa').val() == '' || $('#jenis_ppa').val() == null) {
            toastr.error('Pilih jenis ppa dahulu');
            return;
        }

        if (active_form.includes($('#jenis_ppa').val())) {
            toastr.error('Form ' + $('#jenis_ppa').val().toUpperCase() + ' sudah pernah ditambahkan');
            return;
        }

        let now = new Date();
        let date = (now.getDate() < 10 ? '0' : '') + now.getDate() + "-" + ((now.getMonth() + 1) < 10 ? '0' : '') + (now.getMonth() + 1) + "-" + now.getFullYear();
        let time = now.getHours() + ":" + ((now.getMinutes() < 10 ? '0' : '') + now.getMinutes());

        let jenis_ppa = $('#jenis_ppa').val();
        active_form.push(jenis_ppa);

        switch (jenis_ppa) {
            case 'ns':
                var tmp_subjective_ns = data_ns ? data_ns.subjective : `{{ ($diagnosa ? preg_replace('/\s+/', ' ', preg_replace('/\n+/', '|', trim($diagnosa->keluhan))) : "") }}`;
                reformat_newline(tmp_subjective_ns, 'subjective_ns');
                var tmp_keadaan_umum = `{{ $diagnosa ? preg_replace('/\s+/', ' ', preg_replace('/\n+/', '|', trim($diagnosa->anamnesa))) : ''}}`;
                reformat_newline(tmp_keadaan_umum, 'keadaan_umum_ns', 'span');
                $('#box_form_ppa').prepend(element_html_ns);
                break;
            case 'dr':

                $('#box_form_ppa').prepend(element_html_dr);
                break;
            case 'fp':
                $('#box_form_ppa').prepend(element_html_fp);
                break;
            case 'apt':
                $('#box_form_ppa').prepend(element_html_apt);
                break;
            default:
                break;
        }

        $('#tgl_' + jenis_ppa).html(date);
        $('#jam_' + jenis_ppa).html(time);

        $('#modal_tambah_asesmen').modal('hide');
    })

    $('#modal_tambah_asesmen').on('hidden.bs.modal', function(e) {
        $('#form_ppa')[0].reset();
    })

    function open_modal_tambah_asesmen() {
        $("#modal_tambah_asesmen").modal('show');
    }

    function open_modal_verifikasi(jenis_ppa) {
        $('[name=ppa_submit]').val(jenis_ppa);
        $('#modal_verifikasi').modal('show');
    }

    $('#modal_verifikasi').submit(function(e) {
        e.preventDefault();
        $('[name=password]').val($('#pass').val());
        $('#modal_verifikasi').modal('hide');
        $('#form_verifikasi')[0].reset();
        $('#form_dokumen').submit();
    })

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();
        simpan();
    })

    function reformat_newline(value, tx_name, tipe) {
        var dataWithNewlines = value;

        // Split the data by newline characters to create an array
        var lines = dataWithNewlines.split("|");

        // Get the textarea element
        var textarea = $("#" + tx_name);

        if (tipe == 'span') {
            textarea.html(lines.join('<br>'));
        } else {
            // Iterate through the array of lines and append each line to the textarea
            for (var i = 0; i < lines.length; i++) {
                textarea.append(lines[i]);

                // Append a newline character after each line except the last one
                if (i < lines.length - 1) {
                    textarea.append("\n");
                }
            }
        }
    }
</script>
<script>
    function getDataEmloyee(tipe) {
        if ($.fn.DataTable.isDataTable('#tabel_kepada')) {
            $('#tabel_kepada').dataTable().fnClearTable();
            $('#tabel_kepada').dataTable().fnDestroy();
        }

        $('#tabel_kepada').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ url("ajax_request/datatable_karyawan") }}', // memanggil route yang menampilkan data json
            columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                    data: 'id',
                    name: 'id',
                    render(data, type, row, meta) {
                        return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
                    }
                },
                {
                    data: 'nama',
                    name: 'nama'
                },
                {
                    data: 'jabatan',
                    name: 'jabatan',
                    render(data, type, row) {
                        return '<p class="text-center">' + data + '</p>';
                    }
                },
                {
                    data: 'id',
                    name: 'id',
                    render(data, type, row) {
                        var fungsi_set = 'set_kepada(' + "'" + data + "','" + row.nama + "','" + row.nama_jabatan + "','" + tipe + "'" + ')';
                        return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                    }
                }
            ]
        });
    }

    function set_kepada(id, nama, jabatan, tipe) {
        $('#ppa_' + tipe).val(nama);
        $('#id_ppa_' + tipe).val(id);
        $('#modal_yth').modal('hide');
    }

    function open_modal_yth(tipe) {
        getDataEmloyee(tipe);
        $('#modal_yth').modal('show');
    }
</script>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.resep')
@endpush