@extends('medical_record.e_rekam_medis.dokumen_kunjungan.layout')
@section('content')
<form style="border:1px solid;" class="container pl-0 pr-0" id="form_dokumen">
    @csrf
    <input type="hidden" name="dokumen" value="{{ $dokumen->id }}">
    <input type="hidden" name="password">
    <input type="hidden" name="id_diagnosa" value="{{ $data->id_diagnosa ?? ($diagnosa->id ?? 0) }}">
    <input type="hidden" name="id_lab" value="{{ $data->id_lab ?? 0 }}">
    <input type="hidden" name="id_resep" value="{{ $data->id_resep ?? 0 }}">
    @include('medical_record.e_rekam_medis.dokumen_kunjungan.kop')
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-4">
            <p>Pemeriksaan tanggal {{ date('d-m-Y', strtotime($dokumen->created_at)) }} Jam {{ date('H:i', strtotime($dokumen->created_at)) }}<br>BB {{ $diagnosa ? $diagnosa->berat_badan : '....' }} kg</p>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-2">
            <h6 style="text-decoration: underline;">Subyektif</h6>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <tr>
                    <td style="width: 20%;">Keluhan Utama</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data ? $data->keluhan_utama : ($diagnosa ? $diagnosa->keluhan : '')}}" id="keluhan_utama" name="keluhan_utama">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Sekarang</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $data ? $data->riwayat_penyakit_sekarang : ($pengkajian_keperawatan_rawat_jalan ? $pengkajian_keperawatan_rawat_jalan->riwayat_kesehatan : '') }}" id="riwayat_penyakit_sekarang" name="riwayat_penyakit_sekarang">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Dahulu</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $rpd = $dokumen && $data ? $data->riwayat_penyakit_dahulu : '';
                        if ($rpd == '') {
                            if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
                                $rpd = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_penyakit_dahulu;
                            } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
                                $rpd = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_penyakit_dahulu;
                            } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $rpd = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_penyakit_dahulu;
                            }
                        }
                        ?>
                        <input type="text" class="form-control" value="{{ $dokumen && $data && $data->riwayat_penyakit_dahulu ? $data->riwayat_penyakit_dahulu : $rpd }}" id="riwayat_penyakit_dahulu" name="riwayat_penyakit_dahulu">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Kronis</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $dokumen  ? ($data ? $data->riwayat_penyakit_kronis : '') : '' }}" id="riwayat_penyakit_kronis" name="riwayat_penyakit_kronis">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Penyakit Keluarga</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $rpk = $dokumen && $data ? $data->riwayat_penyakit_keluarga : '';
                        if ($rpk == '') {
                            if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
                                $rpk = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_penyakit_keluarga;
                            } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
                                $rpk = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_penyakit_keluarga;
                            } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $rpk = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_penyakit_keluarga;
                            }
                        }
                        ?>
                        <input type="text" class="form-control" value="{{ $dokumen && $data && $data != '' ? $data->riwayat_penyakit_keluarga : $rpk }}" id="riwayat_penyakit_keluarga" name="riwayat_penyakit_keluarga">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Riwayat Alergi Obat</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $rao = $dokumen && $data ? $data->riwayat_alergi_obat : '';
                        if ($rao == '') {
                            if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']) {
                                $rao = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan']->riwayat_alergi_obat;
                            } else if ($dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']) {
                                $rao = $dokumen_kunjungan_sebelumnya['asesmen_medis_awal_rawat_jalan_gigi']->riwayat_alergi_obat;
                            } else if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $rao = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->riwayat_alergi_obat;
                            }
                        }
                        ?>
                        <input type="text" class="form-control" value="{{ $dokumen && $data && $data->riwayat_alergi_obat != '' ? $data->riwayat_alergi_obat : $rao }}" id="riwayat_alergi_obat" name="riwayat_alergi_obat">
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Catatan Khusus</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <?php
                        $ck = '';
                        if ($ck == '') {
                            if ($dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']) {
                                $ck = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->catatan_khusus_ns;
                                if ($ck == '') {
                                    $ck = $dokumen_kunjungan_sebelumnya['catatan_perkembangan_pasien']->catatan_khusus_dr;
                                }
                            }
                        }
                        ?>
                        <input type="text" readonly class="form-control" value="{{ $ck }}" id="catatan_khusus">
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row" style="width:100%; margin-left: 0;">
        <div class="col-md-12 pt-2">
            <h6 style="text-decoration: underline;">Obyektif</h6>
            <h6>Tanda Vital</h6>
        </div>
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="width: 20%; text-align: center;">
                    <p>TD {{ $diagnosa ? $diagnosa->sistole."/".$diagnosa->diastole : '..../....' }} mmHg</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>RR {{ $diagnosa ? $diagnosa->rr : '....' }} x/menit</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>Nadi {{ $diagnosa ? $diagnosa->nadi : '....' }} x/menit</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>Suhu {{ $diagnosa ? $diagnosa->suhu : '....' }} ᵒC</p>
                </td>
                <td style="width: 20%; text-align: center;">
                    <p>Skala nyeri {{ $diagnosa ? $diagnosa->nyeri : '....' }} </p>
                </td>
            </tr>
        </table>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <tr>
                    <td style="width: 20%;">Keadaan Umum</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input type="text" class="form-control" value="{{ $diagnosa ? $diagnosa->anamnesa : '' }}" readonly>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12 pt-2">
            <h6>Status Generalis</h6>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <tr>
                    <td style="width: 20%; vertical-align:top;">Kepala / Leher</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input onclick="cek_radio_kepala()" {{ $data ? $data->kepala == 'Normal' ? 'checked' : '' : 'checked'}} type="radio" value="Normal" name="radio_kepala"> Normal
                        <input onclick="cek_radio_kepala()" {{ $data ? $data->kepala == 'Tidak Normal' ? 'checked' : '' : ''}} type="radio" value="Tidak Normal" name="radio_kepala" class="ml-4"> Tidak Normal
                        <input type="text" class="form-control" name="tn_kepala" value="{{ $data ? $data->tn_kepala : ''}}" id="kepala" {{ $data ? $data->kepala == 'Tidak Normal' ? '' : 'readonly' : 'readonly'}}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%; vertical-align:top;">Thorax</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input onclick="cek_radio_thorax()" {{ $data ? $data->thorax == 'Normal' ? 'checked' : '' : 'checked'}} type="radio" value="Normal" name="radio_thorax"> Normal
                        <input onclick="cek_radio_thorax()" {{ $data ? $data->thorax == 'Tidak Normal' ? 'checked' : '' : ''}} type="radio" value="Tidak Normal" name="radio_thorax" class="ml-4"> Tidak Normal
                        <input type="text" class="form-control" name="tn_thorax" value="{{ $data ? $data->tn_thorax : ''}}" id="thorax" {{ $data ? $data->thorax == 'Tidak Normal' ? '' : 'readonly' : 'readonly'}}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%; vertical-align:top;">Abdomen</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input onclick="cek_radio_abdomen()" {{ $data ? $data->abdomen == 'Normal' ? 'checked' : '' : 'checked'}} type="radio" value="Normal" name="radio_abdomen"> Normal
                        <input onclick="cek_radio_abdomen()" {{ $data ? $data->abdomen == 'Tidak Normal' ? 'checked' : '' : ''}} type="radio" value="Tidak Normal" name="radio_abdomen" class="ml-4"> Tidak Normal
                        <input type="text" class="form-control" name="tn_abdomen" value="{{ $data ? $data->tn_abdomen : ''}}" id="abdomen" {{ $data ? $data->abdomen == 'Tidak Normal' ? '' : 'readonly' : 'readonly'}}>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%; vertical-align:top;">Ekstremitas</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <input onclick="cek_radio_ekstremitas()" {{ $data ? $data->ekstremitas == 'Normal' ? 'checked' : '' : 'checked'}} type="radio" value="Normal" name="radio_ekstremitas"> Normal
                        <input onclick="cek_radio_ekstremitas()" {{ $data ? $data->ekstremitas == 'Tidak Normal' ? 'checked' : '' : ''}} type="radio" value="Tidak Normal" name="radio_ekstremitas" class="ml-4"> Tidak Normal
                        <input type="text" class="form-control" name="tn_ekstremitas" value="{{ $data ? $data->tn_ekstremitas : ''}}" id="ekstremitas" {{ $data ? $data->ekstremitas == 'Tidak Normal' ? '' : 'readonly' : 'readonly'}}>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12 pt-4">
            <h6 style="text-decoration: underline;">Asesmen</h6>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <tr>
                    <td style="width: 20%; vertical-align:top;">Diagnosa</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <textarea rows="3" style="height: 100%" type="text" id="tmp_catatan_diagnosa" disabled class="form-control">{{ $diagnosa ? $diagnosa->diagnosa : '' }}</textarea>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%; vertical-align: top;">Diagnosa utama</td>
                    <td style="width:5%; vertical-align: top; text-align: center;"> : </td>
                    <td style="width: 75%;">
                        <div style="display: flex; flex-direction: row" class="pt-2">
                            <div id="box_button_diagnosa">
                                @if ($diagnosa == null)
                                <button class="btn btn-success btn-sm" type="button" onclick="open_form_diagnosa()">
                                    <i class="fa fa-plus"></i>
                                </button>
                                @else
                                <button class="btn btn-warning btn-sm" type="button" onclick="open_form_diagnosa()" style="color:#fff; font-weight: bold;">
                                    <i class="fa fa-pencil"></i>
                                </button>
                                @endif
                            </div>
                            <div id="box_diagnosa" class="ml-2">
                                {{ $diagnosa ? ($diagnosa->kode_icd != '' ? $diagnosa->kode_icd . ' - ' . $diagnosa->nama_icd : $diagnosa->nama_icd) : '' }}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="width: 20%;">Diagnosa sekunder</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 75%;" id="box_diagnosa_sekunder">
                        <?php
                        if ($diagnosa && $diagnosa->nama_icd_sekunder != '') {
                            echo $diagnosa->kode_icd_sekunder . ' - ' . $diagnosa->nama_icd_sekunder;
                        }
                        ?>
                    </td>
                </tr>
            </table>
        </div>
        <div class="col-md-12 pt-2">
            <h6 style="text-decoration: underline;">Planning</h6>
            <p>Pemeriksaan Penunjang</p>
        </div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; width:100%;" id="tabel_subyektif">
                <!-- <tr>
                    <td style="width: 25%; vertical-align: top;">A. Laboratorium</td>
                    <td style="width:5%; text-align: center; vertical-align: top;"> : </td>
                    <td style="width: 70%; vertical-align: top;">
                        <div style="display: flex; flex-direction: row" class="pb-2">
                            <div id="box_button_pesanan_lab" class="mr-2">
                                @if($laboratorium)
                                <button class="btn btn-warning btn-sm" type="button" style="color: #fff" onclick="open_modal_lab()">
                                    <i class="fa fa-pencil"></i>
                                </button>
                                <button class="btn btn-info btn-sm" type="button" style="color: #fff" onclick="open_modal_hasil_lab()">
                                    <i class="fa fa-book"></i>
                                </button>
                                @else
                                <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_lab()">
                                    <i class="fa fa-plus"></i>
                                </button>
                                @endif
                            </div>
                            <div id="list_pesanan_lab">
                                <?php
                                if ($laboratorium) {
                                    $temp = '';
                                    $iteration = 0;
                                    $json = (array) json_decode($laboratorium->periksa);

                                    for ($i = 0; $i < sizeof($pemeriksaan); $i++) {
                                        if ($json[$pemeriksaan[$i]->slug] == 1) {
                                            $temp .= ($iteration > 0 ? ', ' : '') . $pemeriksaan[$i]->nama;
                                            $iteration++;
                                        }
                                    }
                                ?>
                                    {{ $laboratorium->no_lab }} - {{ $temp }}
                                <?php } ?>
                            </div>
                        </div>
                    </td>
                </tr> -->
                <tr>
                    <td style="width: 25%;">A. Pemeriksaan Penunjang Lain</td>
                    <td style="width:5%; text-align: center;"> : </td>
                    <td style="width: 70%;">
                        <input type="text" class="form-control mb-2" value="{{ $data ? $data->penunjang_lain : '' }}" id="penunjang_lain" name="penunjang_lain">
                    </td>
                </tr>
                <tr>
                    <td style="width: 25%; vertical-align:top;">Terapi</td>
                    <td style="width:5%; vertical-align:top; text-align: center;"> : </td>
                    <td style="width: 70%;" class="pb-2">
                        <div id="box_btn_terapi">
                            @if ($resep == null)
                            <button class="btn btn-dark btn-sm" type="button" onclick="open_modal_resep()">
                                <i class="fa fa-plus"></i>
                            </button>
                            @else
                            @if ($resep->locked == 0)
                            <button class="btn btn-warning btn-sm" type="button" onclick="open_modal_resep()">
                                <i class="fa fa-pencil" style="color:#fff;"></i>
                            </button>
                            <button class="btn btn-info btn-sm" type="button" onclick="lock_terapi()">Kirim ke farmasi</button>
                            @endif
                            <button class="btn btn-info btn-sm" type="button" onclick="preview_terapi()">Preview</button>
                            No. Resep Elektronik {{ $resep->id ?? '' }}
                            <table style="border-collapse: collapse; width:50%;">
                                @foreach ($resep->detail as $ar_det)
                                <tr>
                                    <td style="width:20px;">{{ 'R/' }}</td>
                                    <td>{{ $ar_det->nama_obat }}</td>
                                    <td>{{ $ar_det->signa }}</td>
                                    <td style="padding-left: 20px;">
                                        {{ $ar_det->jumlah . ' ' . $ar_det->satuan }}
                                    </td>
                                </tr>
                                @endforeach
                            </table>
                            {{ $resep->catatan_obat_racikan }}
                            @endif
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="vertical-align: top;">Tindakan Medis</td>
                    <td style="text-align: center; vertical-align: top;"> : </td>
                    <td>
                        <textarea rows="3" name="tindakan_medis" style="height: 100%" class="form-control">{{ $data ? $data->tindakan_medis : '' }}</textarea>
                    </td>
                </tr>
                <tr>
                    <td style="vertical-align: top;">Tindak lanjut</td>
                    <td style="text-align: center; vertical-align: top;"> : </td>
                    <td>
                        <textarea rows="3" name="tindak_lanjut" style="height: 100%" class="form-control">{{ $data ? $data->tindak_lanjut : '' }}</textarea>
                    </td>
                </tr>
                <tr>
                    <td>Status Pulang</td>
                    <td style="text-align: center"> : </td>
                    <td>
                        <select name="status_pulang" class="form-control">
                            <option value="">--Select Here--</option>
                            <option {{ $data && $data->status_pulang == '1' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '1' ? 'selected' : '') }} value="1">Meninggal</option>
                            <option {{ $data && $data->status_pulang == '3' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '3' ? 'selected' : '') }} value="3">Berobat Jalan</option>
                            <option {{ $data && $data->status_pulang == '4' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '4' ? 'selected' : '') }} value="4">Rujuk Vertikal</option>
                            <option {{ $data && $data->status_pulang == '6' ? 'selected' : ($diagnosa && $diagnosa->kode_status_pulang == '6' ? 'selected' : '') }} value="6">Rujuk Horizontal</option>
                        </select>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-4 pb-5" style="width:100%; margin-left: 0; ">
        <table style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="width: 50%;"></td>
                <td style="width: 50%; text-align: center; font-weight: bold;" onclick="open_modal_verifikasi()">
                    <p>&nbsp;</p>
                    <p>Dokter Penanggung Jawab Pelayanan</p>
                    <div id="box_ttd">
                        @if ($dokumen->status == 0)
                        <br>
                        Simpan & verifikasi
                        <br>
                        <br>
                        (.................................................)
                        <br>Tanda tangan & nama terang
                        @else
                        <img src="{{ env('SMIS_UPLOAD_URL') . '/' . ($employee->ttd_foto ?? '') }}" style="height: 2.5cm; width: 5cm;" alt="">
                        <br>{{ $dokumen->nama_verifikator }}
                        @endif
                    </div>
                </td>
            </tr>
        </table>
    </div>
</form>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.popup_verifikasi')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.resep')
@endsection
@push('scripts')
<script>
    function open_modal_verifikasi() {
        $('#modal_verifikasi').modal('show');
    }

    $('#modal_verifikasi').submit(function(e) {
        e.preventDefault();
        $('[name=password]').val($('#pass').val());
        $('#modal_verifikasi').modal('hide');
        $('#form_verifikasi')[0].reset();
        $('#form_dokumen').submit();
    })

    $('#form_dokumen').submit(function(e) {
        e.preventDefault();

        toastr.warning('Sedang menyimpan dokumen, harap tunggu...');

        $.ajax({
            url: "{{ url('medical_record/e_rekam_medis/asesmen_medis_awal_rawat_jalan/store') }}",
            data: $('#form_dokumen').serialize(),
            method: 'post',
            success: function(response) {
                if (!response.status) {
                    toastr.error(response.message);
                    return;
                }
                toastr.success(response.message);
                console.log(response.employee);
                $('#box_ttd').html(
                    `<img src="{{ env('SMIS_UPLOAD_URL') }}/` + (response.employee ? response.employee.ttd : ``) + `" style="height: 2.5cm; width: 5cm;" alt="">` +
                    '<br>' +
                    (response.employee ? response.employee.nama : '')
                );
            }
        })
    })

    function cek_radio_kepala() {
        if ($('[name="radio_kepala"]:checked').val() == 'Tidak Normal') {
            $('#kepala').removeAttr('readonly');
        } else {
            $('#kepala').attr('readonly', true);
            $('#kepala').val('');
        }
    }

    function cek_radio_thorax() {
        if ($('[name="radio_thorax"]:checked').val() == 'Tidak Normal') {
            $('#thorax').removeAttr('readonly');
        } else {
            $('#thorax').attr('readonly', true);
            $('#thorax').val('');
        }
    }

    function cek_radio_ekstremitas() {
        if ($('[name="radio_ekstremitas"]:checked').val() == 'Tidak Normal') {
            $('#ekstremitas').removeAttr('readonly');
        } else {
            $('#ekstremitas').attr('readonly', true);
            $('#ekstremitas').val('');
        }
    }

    function cek_radio_abdomen() {
        if ($('[name="radio_abdomen"]:checked').val() == 'Tidak Normal') {
            $('#abdomen').removeAttr('readonly');
        } else {
            $('#abdomen').attr('readonly', true);
            $('#abdomen').val('');
        }
    }

    $(document).ready(function() {
        $('#pesan_pemeriksaan').select2();
    })
</script>
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.laboratorium')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.diagnosa')
@include('medical_record.e_rekam_medis.dokumen_kunjungan.script.resep')
@endpush