@extends('layouts.app')
@section('content')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Laporan Penerimaan Kasir</h1>
            </div>
            <div class="section-body">
                <div class="card">
                    @if ($errors->any())
                        <div class="col-lg-12 mt-3">
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="card">
                    <div class="mt-3">
                        <form method="get" action="{{ route('penerimaan_kasir.filter') }}">
                            <div class="col-lg-12 row">
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="">Tanggal Dari :</label>
                                        <input type="text" id="tanggal_dari" name="tanggal_dari"
                                            class="datetimepicker form-control col-lg-12" placeholder="Pilih Tanggal"
                                            value="@date($tanggal_dari)">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <label for="">Tanggal Sampai :</label>
                                        <input type="text" id="tanggal_sampai" name="tanggal_sampai"
                                            class="datetimepicker form-control col-lg-12" placeholder="Pilih Tanggal"
                                            value="@date($tanggal_sampai)">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group" style="margin-top: 30px;">
                                        <button class="btn btn-primary" type="submit">
                                            Cari</button>
                                        <a onclick="downloadExcel()" class="btn btn-success" data-toggle="tooltip"
                                            data-placement="top" title="Download Data"
                                            style="margin-left:8px ; color:white; cursor:pointer;">Download Excel</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="table-responsive" style="overflow-x:auto;">
                        <table class="table table-bordered table-striped" style="" id="myTable">
                            <thead class="text-center">
                                <th>No</th>
                                <th>Tanggal</th>
                                <th>No.Invoice</th>
                                <th>Nama</th>
                                <th>Nama Poli</th>
                                <th>Nama Dokter</th>
                                <th>Status</th>
                                <th>Item</th>
                                <th>Total Tagihan</th>
                                <th>Payment Method</th>
                                <th>Terbayar</th>
                                <th>Cash</th>
                                <th>Asuransi</th>
                                <th>QR</th>
                                <th>TF</th>
                                {{-- <th>Setoran Tunai</th> --}}
                                <th>Debit</th>
                                <th>Kredit</th>
                            </thead>
                            <tbody>
                                @if (isset($data))
                                    @forelse ($data as $key => $dt)
                                        <tr>
                                            <td class="align-top">{{ $key + $data->firstItem() }}</td>
                                            <td class="align-top">@date($dt->tanggal)</td>
                                            <td class="align-top">
                                                @foreach (App\Services\PenerimaanKasirService::getNoInvoice($dt->id, $dt->tanggal) as $invoice)
                                                    <span> {{ $invoice->no_kwitansi }}</span> <br>
                                                @endforeach
                                            </td>
                                            <td class="align-top">{{ $dt->nama_pasien }}</td>
                                            <td class="align-top">@parse_($dt->jenislayanan)</td>
                                            <td class="align-top">{{$dt->nama_dokter}}</td>
                                            <td class="align-top">
                                                {{ $dt->total_tagihan - $dt->nilai_diskon <= $dt->total_bayar ? 'Lunas' : 'Belum Lunas' }}
                                            </td>
                                            <td>
                                                @if ($dt->metode == 'bank_resep' || $dt->metode == 'cash_resep')
                                                    <span> - </span>
                                                @else
                                                    @foreach (App\Services\PenerimaanKasirService::getItemByFilter($dt->id) as $item)
                                                        <span> {{ '- ' . $item->nama_tagihan }}</span> <br>
                                                    @endforeach
                                                @endif

                                            </td>
                                            <td class="align-top tagihan">@currency($dt->metode == 'cash_resep' || $dt->metode == 'bank_resep'  ?  $dt->total_bayar  : $dt->total_tagihan - $dt->nilai_diskon)</td>
                                            <td class="align-top">
                                                @php
                                                    $cash = false;
                                                    $bank = false;
                                                    $asuransi = false;
                                                    $getPayment = App\Services\PenerimaanKasirService::getPaymentByFilter($dt->id, $dt->tanggal);
                                                @endphp
                                                @foreach ($getPayment['payment'] as $payment)
                                                    @if ($payment[0] === 'cash')
                                                        Langsung
                                                        @php
                                                            $cash = true;
                                                        @endphp
                                                    @endif
                                                    @if ($payment[0] === 'bank')
                                                        {{ $cash || $asuransi ? ',' : ' ' }} {{ $payment[3] }} -
                                                        {{ $payment[1] }}
                                                        @php
                                                            $bank = true;
                                                        @endphp
                                                    @endif
                                                    @if ($payment[0] === 'asuransi')
                                                        {{ $bank || $cash ? ',' : ' ' }}{{ strtoupper($dt->carabayar) }}
                                                        @php
                                                            $asuransi = true;
                                                        @endphp
                                                    @endif
                                                @endforeach
                                            </td>
                                            <td class="align-top terbayar">@currency($dt->total_bayar)</td>
                                            <td class="align-top cash">@currency($getPayment['cash'])
                                            </td>
                                            <td class="align-top asuransi">@currency($getPayment['asuransi'])
                                            </td>
                                            <td class="align-top qr">@currency($getPayment['qr'])</td>
                                            <td class="align-top tf">
                                                @currency($getPayment['transfer'])
                                            </td>
                                            {{-- <td class="align-top tunai"> --}}
                                            {{--     @currency($getPayment['setoran_tunai']) --}}
                                            {{-- </td> --}}
                                            <td class="align-top debit">
                                                @currency($getPayment['bank_kartu_debit'])
                                            </td>
                                            <td class="align-top kredit">
                                                @currency($getPayment['bank_kartu_kredit'])
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="16" class="text-center">Data tidak ditemukan pada tanggal
                                                @date($tanggal_dari) s/d @date($tanggal_sampai)</td>
                                        </tr>
                                    @endforelse
                                @else
                                    <tr>
                                        <th colspan="16" class="text-center">Silahkan gunakan fitur cari untuk menampilkan
                                            data</th>
                                    </tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="8" class="text-right">TOTAL : </th>
                                    <th class="column-tagihan-total">0</th>
                                    <th>-</th>
                                    <th class="column-terbayar-total">0</th>
                                    <th class="column-cash-total">0</th>
                                    <th class="column-asuransi-total">0</th>
                                    <th class="column-qr-total">0</th>
                                    <th class="column-tf-total">0</th>
                                    {{-- <th class="column-tunai-total">0</th> --}}
                                    <th class="column-debit-total">0</th>
                                    <th class="column-kredit-total">0</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <div class="row mt-5" style="width: 100%; margin-left:0;">
                        <div class="col-lg-6" style="display: flex; align-items: center;">
                        </div>
                        <div class="col-lg-6" style="justify-content: flex-end; display: flex;">
                            {{ isset($data) ? $data->appends(Request::only('tanggal_dari', 'tanggal_sampai'))->links('pagination::bootstrap-4') : '' }}
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h4>Rekap Tindakan Dokter</h4>
                    </div>
                    <div class="col-lg-12">
                        <table class="table table-bordered table-striped" style="" id="myTable">
                            <thead>
                                <th>No</th>
                                <th>Tindakan Dokter</th>
                                <th>Jumlah</th>
                                <th>Total</th>
                            </thead>
                            <tbody>
                                @if (isset($rekap_tindakan_dokter))
                                    @forelse ($rekap_tindakan_dokter as $rtd)
                                        <tr>
                                            <td>{{ $loop->index + 1 }}</td>
                                            <td>{{ $rtd->tindakan_dokter }}</td>
                                            <td>{{ $rtd->jumlah }}</td>
                                            <td>@currency($rtd->total)</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="4" class="text-center">Tidak ada data yang tersedia</td>
                                        </tr>
                                    @endforelse
                                @else
                                    <tr>
                                        <th colspan="4" class="text-center">Silahkan gunakan fitur cari untuk menampilkan
                                            data</th>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    {{-- <div class="row mt-5" style="width: 100%; margin-left:0;"> --}}
                    {{--     <div class="col-lg-6" style="display: flex; align-items: center;"> --}}
                    {{--     </div> --}}
                    {{--     <div class="col-lg-6" style="justify-content: flex-end; display: flex;"> --}}
                    {{--         {{ isset($rekap_tindakan_dokter) ? $rekap_tindakan_dokter->appends(array_merge(Request::only('tanggal_dari', 'tanggal_sampai'), ['card' => 2]))->links('pagination::bootstrap-4') : '' }} --}}
                    {{--     </div> --}}
                    {{-- </div> --}}
                </div>
            </div>
    </div>
    </div>
    </section>
    </div>

    <script src="https://code.jquery.com/jquery-3.3.1.min.js"
        integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.26.0/moment.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/css/datepicker.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.2.0/js/bootstrap-datepicker.min.js"></script>

    <script>
        $(".datetimepicker")
            .datepicker({
                format: "dd-mm-yyyy",
                startView: "day",
                minViewMode: "day",
                autoclose: true,
            });

        function downloadExcel() {

            var tanggal_dari = $('input[name=tanggal_dari]').val();
            var tanggal_sampai = $('input[name=tanggal_sampai]').val();
            var url = "{{ route('penerimaan_kasir.download') }}?tanggal_dari=" + tanggal_dari +
                "&tanggal_sampai=" + tanggal_sampai
            if (confirm("Apakah anda ingin melanjutkan download ?")) {
                window.location.href = url;
            } else {
                return false;
            }
        }

        $(document).ready(function() {
            var columnTagihanTotal = 0;
            var columnTerbayarTotal = 0;
            var columnCashTotal = 0;
            var columnAsuransiTotal = 0;
            var columnQrTotal = 0;
            var columnTfTotal = 0;
            var columnDebitTotal = 0;
            var columnTunaiTotal = 0;
            var columnKreditTotal = 0;

            $("#myTable tr").each(function() {
                var columnTagihanValue = $(this).find(".tagihan").text();
                var columnTerbayarValue = $(this).find(".terbayar").text();
                var columnCashValue = $(this).find(".cash").text();
                var columnAsuransiValue = $(this).find(".asuransi").text();
                var columnQrValue = $(this).find(".qr").text();
                var columnTfValue = $(this).find(".tf").text();
                var columnDebitValue = $(this).find(".debit").text();
                //var columnTunaiValue = $(this).find(".tunai").text();
                var columnKreditValue = $(this).find(".kredit").text();
                if (columnTagihanValue.length > 0) {
                    columnTagihanTotal += hapusRibuan(columnTagihanValue);
                }
                if (columnTerbayarValue.length > 0) {
                    columnTerbayarTotal += hapusRibuan(columnTerbayarValue);
                }
                if (columnDebitValue.length > 0) {
                    columnDebitTotal += hapusRibuan(columnDebitValue);
                }
                if (columnCashValue.length > 0) {
                    columnCashTotal += hapusRibuan(columnCashValue);
                }
                if (columnAsuransiValue.length > 0) {
                    columnAsuransiTotal += hapusRibuan(columnAsuransiValue);
                }
                if (columnQrValue.length > 0) {
                    columnQrTotal += hapusRibuan(columnQrValue);
                }
                if (columnTfValue.length > 0) {
                    columnTfTotal += hapusRibuan(columnTfValue);
                }
                //if (columnTunaiValue.length > 0) {
                //   columnTunaiTotal += hapusRibuan(columnTunaiValue);
                //}
                if (columnKreditValue.length > 0) {
                    columnKreditTotal += hapusRibuan(columnKreditValue);
                }
            });

            $(".column-terbayar-total").text(buatRibuan(columnTerbayarTotal));
            $(".column-tagihan-total").text(buatRibuan(columnTagihanTotal));
            $(".column-debit-total").text(buatRibuan(columnDebitTotal));
            $(".column-cash-total").text(buatRibuan(columnCashTotal));
            $(".column-asuransi-total").text(buatRibuan(columnAsuransiTotal));
            $(".column-qr-total").text(buatRibuan(columnQrTotal));
            $(".column-tf-total").text(buatRibuan(columnTfTotal));
            //$(".column-tunai-total").text(buatRibuan(columnTunaiTotal));
            $(".column-kredit-total").text(buatRibuan(columnKreditTotal));
        });

        function hapusRibuan(param) {
            var inputValue = param;
            var parsedValue = parseFloat(inputValue.replace(/\./g, ''));
            return parsedValue;
        }

        function buatRibuan(param) {
            var inputValue = param;
            var parsedValue = inputValue.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
            return parsedValue;
        }
    </script>
@endsection
