<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Asesmen Medis Rawat Jalan</title>

    <title>Asesmen Rawat Jalan</title>

    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">
    
    <style>
        * {
            font-family: sans-serif;
        }

        .pagebreak {
            page-break-before: always;
        }

        /* Clear floats after the columns */
        .row:after {
            content: "";
            display: table;
            clear: both;
        }

        #main_table tr th {
            border: 1px solid;
            padding: 10px;
        }

        #main_table tr td {
            border-left: 1px solid;
            border-right: 1px solid;
            vertical-align: top;
            padding: 10px;
        }
    </style>
</head>

<body>
    <div class="row" style="width: 100%;">
        <div style="float: left; width:100%; height: 90px; text-align: center; margin-top:-50px;">
            <p style="color: #111; font-weight: bold; font-size: 18px;">
                ASESMEN RAWAT JALAN
            </p>
        </div>
    </div>
    <div class="row">
        <div style="float: left; width: 100%; margin-top:-20px;">
            <table style="width:100%; border-collapse:collapse; font-size:16px;" id="main_table">
                <thead>
                    <tr class="text-center">
                        <th style="width: 12.5%;">Tanggal</th>
                        <th style="width: 12.5%;">Keluhan Utama</th>
                        <th style="width: 12.5%;">Pemeriksaan Fisik</th>
                        <th style="width: 12.5%;">Pemeriksaan Penunjang</th>
                        <th style="width: 12.5%;">Diagnosa / Kode ICD</th>
                        <th style="width: 12.5%;">Tindakan Dokter</th>
                        <th style="width: 12.5%;">Terapi</th>
                        <th style="width: 12.5%;">Dokter Jaga</th>
                    </tr>
                </thead>
                <tbody>
                    @if(sizeof($layanan) < 1) <tr class="text-center">
                    <td colspan="8" style="border-bottom:1px solid; text-align:center;">Data tidak ditemukan</td>
                        </tr>
                        @else
                        @php
                        $i = 0;
                        $len = count($layanan);
                        @endphp
                        @foreach($layanan as $doc)
                        <tr>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">{{date('d-m-Y', strtotime($doc->tanggal_diagnosa))}}</td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">{{$doc->keluhan}}</td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">Tensi : {{$doc->sistole.'/'.$doc->diastole}} mm/Hg<br>Nadi : {{$doc->nadi}} x/menit<br>Respirasi : {{$doc->rr}} x/menit<br>Suhu : {{$doc->suhu}} °C<br>Pemeriksaan Fisik : {{$doc->anamnesa}}</td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">
                                <ul style="margin-left: -15px; list-style-type: lower-alpha;">
                                    <?php
                                    $lab = json_decode($doc->periksa, true);
                                    if ($lab != null) {
                                        foreach ($lab as $key => $value) {
                                            if ($value == 1) {
                                    ?>
                                                <li style="text-transform: capitalize;">{{ str_replace('_',' ', $key)}}</li>
                                    <?php
                                            }
                                        }
                                    }
                                    ?>
                                </ul>
                            </td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">{{$doc->kode_icd.' - '.$doc->nama_icd}}</td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">@if(isset($doc->tindakan))@if($doc->tindakan != null){{$doc->tindakan->nama_tindakan}}@endif @endif {{$doc->terapi_non_obat}}</td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">
                                @foreach($doc->resep as $r)
                                <span style="border-bottom: 2px solid;">{{ 'R/ '.$r->nomor_resep }}</span><br>
                                @if(isset($r->obat_jadi))
                                @foreach($r->obat_jadi as $oj)
                                <span>{{'- '.$oj->nama_obat}}</span><br>
                                @endforeach
                                @endif
                                @if(isset($r->obat_racik))
                                @foreach($r->obat_racik as $or)
                                @foreach($or->bahan as $ba)
                                <span>{{'- '.$ba->nama_obat}}</span><br>
                                @endforeach
                                @endforeach
                                @endif
                                <br>
                                <br>
                                @endforeach
                            </td>
                            <td style="<?php if ($i == $len - 1) {
                                            echo 'border-bottom:1px solid';
                                        } ?>">{{$doc->nama_dokter}}<br>@if($doc->ttd_foto != null) <img src="{{ env('SMIS_UPLOAD_URL').'/'.$doc->ttd_foto->ttd_foto }}" alt="" style="height: 2.5cm; width: 5cm;"> @endif</td>
                        </tr>
                        @php $i++ @endphp
                        @endforeach
                        @endif
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>