<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Konsultasi Poli Lain</title>

    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.7/css/jquery.dataTables.min.css">
    <!-- <link type="text/css" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/south-street/jquery-ui.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" type="text/css" href="//keith-wood.name/css/jquery.signature.css"> -->
    <style>
        #data_diri tr th {
            vertical-align: top;
        }

        #konsul tr th {
            vertical-align: top;
        }
    </style>
</head>

<body class="container">
    <div class="modal fade" id="modal_yth" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Kepada Yth.</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table id="tabel_kepada" class="table table-striped mt-2">
                        <thead>
                            <tr class="text-center">
                                <th>No</th>
                                <th>Nama</th>
                                <th>Jabatan</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">{{$error}}</div>
    @endforeach
    @endif
    @if(Session::get('sukses'))
    <script>
        alert('{{ Session::get("sukses") }}')
    </script>
    @endif
    @if(Session::get('gagal'))
    <script>
        alert('{{ Session::get("gagal") }}')
    </script>
    @endif
    <div class="modal fade" id="modal_konsultasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Konsultasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" onsubmit="return cek_konsul()" action="{{ url('medical_record/e_rekam_medis/konsultasi_poli_lain/save') }}">
                    @csrf
                    <input type="hidden" name="dokumen" value="{{$dokumen->id}}">
                    <input type="hidden" name="tanggal" id="hide_tanggal">
                    <input type="hidden" name="tanggal_periksa" id="hide_tanggal_periksa">
                    <input type="hidden" name="jam_awal" id="hide_jam_awal">
                    <input type="hidden" name="jenis" id="hide_jenis">
                    <input type="hidden" name="jam" id="hide_jam">
                    <input type="hidden" name="kepada" id="hide_kepada">
                    <input type="hidden" name="id_kepada" value="{{ $dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->id_kepada : '' }}" id="hide_id_kepada">
                    <input type="hidden" name="keterangan" id="hide_keterangan">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Password :</label>
                            <input type="password" name="pass" placeholder="Input your password" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_jawaban" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Jawaban Konsultasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" onsubmit="return cek_jawaban()" action="{{ url('medical_record/e_rekam_medis/konsultasi_poli_lain/save_jawaban') }}">
                    @csrf
                    <input type="hidden" name="id_dokumen" value="{{$dokumen->id}}">
                    <input type="hidden" name="konsultasi" value="{{ $dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->id : '' }}">
                    <input type="hidden" name="jawaban" id="hide_jawaban">
                    <input type="hidden" name="saran" id="hide_saran">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Password :</label>
                            <input type="password" name="pass" placeholder="Input your password" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row pt-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-2">
            {{-- <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width: 100%;"> --}}
        </div>
        <div class="col-md-4"></div>
        <div class="col-md-6" style="padding-left: 80px;">
            <h4 style="text-transform: uppercase;">KLINIK UTAMA DHARMAHUSADA PREMIER</h4>
            <h6>Jl. Raya Dharma Husada Indah No.26 Surabayar<br>Telp. (031)5921101 website : dhpclinic.id<br>Email : klinik.dharmahusadapremier@gmail.com</h6>
        </div>
        <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
        </div>
    </div>
    <div class="row mt-2" style="width: 100%; margin-left: 0;">
        <div class="col-md-6" style="border: 2px solid;">
            <table style="border-collapse: collapse;" id="data_diri">
                <tr>
                    <th>Tanggal Periksa</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        <input type="date" class="form-control" id="tanggal_periksa" value="{{date('Y-m-d', strtotime($dokumen->created_at))}}">
                    </th>
                </tr>
                <tr>
                    <th>Jam Awal Asesmen</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        <input type="time" class="form-control" id="jam_awal" value="{{date('H:i', strtotime($dokumen->created_at))}}">
                    </th>
                </tr>
                <tr>
                    <th>Jam Akhir Asesmen</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th></th>
                </tr>
            </table>
        </div>
        <div class="col-md-6" style="border: 2px solid;">
            <table style="border-collapse: collapse;">
                <tr>
                    <th>Nama</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{$layanan ? $layanan->nama_pasien : ""}}
                    </th>
                </tr>
                <tr>
                    <th>Tanggal Lahir</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{$pasien ? date('d-m-Y', strtotime($pasien->tgl_lahir)) : ""}}
                    </th>
                </tr>
                <tr>
                    <th>No. Rekam Medis</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{$layanan ? $layanan->nrm : ""}}
                    </th>
                </tr>
                <tr>
                    <th>No. JKN</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>{{$layanan ? $layanan->nobpjs : ""}}</th>
                </tr>
            </table>
        </div>
    </div>
    <div class="row pt-4" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <h3 class="text-center">REKAM MEDIS PASIEN / PENDERITA GAWAT DARURAT</h3>
        </div>
    </div>
    <div class="row pt-3 pb-3" style="width: 100%; margin-left: 0; border:2px solid;">
        <div class="col-md-2 pb-3">
            <p style="font-weight: bold;">Tanggal :</p>
        </div>
        <div class="col-md-2 pb-3">
            <input type="date" class="form-control" id="tanggal" value="{{ $dokumen->konsultasi_poli_lain ? date('Y-m-d', strtotime($dokumen->konsultasi_poli_lain->tanggal)) : date('Y-m-d', strtotime($dokumen->created_at))}}">
        </div>
        <div class="col-md-2 pb-3">
            <p style="font-weight: bold;">Jam :</p>
        </div>
        <div class="col-md-2 pb-3">
            <input type="time" class="form-control" id="jam" value="{{ $dokumen->konsultasi_poli_lain ? date('H:i', strtotime($dokumen->konsultasi_poli_lain->tanggal)) : date('H:i', strtotime($dokumen->created_at))}}">
        </div>
        <div class="col-md-4 pb-3">
            <p style="font-weight: bold;">WIB</p>
        </div>
        <div class="col-md-12 pt-3" style="border-top: 2px solid; padding-bottom:100px">
            <table style="border-collapse: collapse; line-height:2;" id="konsul">
                <tr>
                    <th>Jenis Konsultasi</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        <input value="Elektif" type="radio" {{ $dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->jenis == 'Elektif' ? 'checked' : '' : '' }} name="jenis"> Elektif / <input {{ $dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->jenis == 'Cito' ? 'checked' : '' : '' }} type="radio" value="Cito" name="jenis"> Cito
                    </th>
                </tr>
                <tr>
                    <th>Kepada Yth. TS</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        <div class="input-group">
                            <input type="text" readonly value="{{$dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->kepada : ''}}" id="kepada" class="form-control">
                            <div class="input-group-append">
                                <button class="btn btn-dark" type="button" onclick="open_modal_yth()"><i class="fa fa-list"></i></button>
                            </div>
                        </div>
                    </th>
                </tr>
                <tr>
                    <th colspan="3">Mohon bantuan sejawat untuk konsultasi / rawat bersama / alih rawat</th>
                </tr>
                <tr>
                    <th>Untuk Pasien</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{$layanan ? $layanan->nama_pasien : ""}}
                    </th>
                </tr>
                <tr>
                    <th>Diagnosa Kerja</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        {{$layanan->diagnosa ? $layanan->diagnosa->kode_icd.'-'.$layanan->diagnosa->nama_icd : ""}}
                    </th>
                </tr>
                <tr>
                    <th>Keterangan Klinik terpenting</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>
                        <textarea id="keterangan" class="form-control" style="width: 100%;" cols="90" rows="5">{{$dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->keterangan : ''}}</textarea>
                    </th>
                </tr>
            </table>
        </div>
        <div class="col-md-8">
            <p>&nbsp;</p>
        </div>
        <div class="col-md-4 text-center">
            <p style="font-weight: bold;">
                Hormat Kami<br>
                @if(isset($dokumen->konsultasi_poli_lain))
                @if($dokumen->konsultasi_poli_lain->id_user != 0)
                <img src="{{ env('SMIS_UPLOAD_URL').'/'.$dokumen->konsultasi_poli_lain->ttd }}" style="height: 2.5cm; width: 5cm;" alt="">
            <p>({{$dokumen->konsultasi_poli_lain->nama_user}})</p>
            @else
            <br>
            <br>
            <br>
            <br>
            <br>
            (......................................................)
            @endif
            @else
            <br>
            <br>
            <br>
            <br>
            <br>
            (......................................................)
            @endif
            </p>
        </div>
        <div class="col-md-12 pt-3" style="border-top: 2px solid; padding-bottom:100px">
            <p style="font-weight: bolder;">Jawaban Konsultasi :</p>
            <p style="font-weight: bold;">Sesuai dengan permohonan konsultasi pada kasus ini dijumpai :</p>
            <textarea id="jawaban" cols="30" rows="5" class="form-control" style="width: 100%;">{{ $dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->jawaban ? $dokumen->konsultasi_poli_lain->jawaban->jawaban : '' : '' }}</textarea>
            <p class="mt-3" style="font-weight: bold;">Saran tindakan medis / pengobatan :</p>
            <textarea id="saran" cols="30" rows="5" class="form-control" style="width: 100%;">{{ $dokumen->konsultasi_poli_lain ? $dokumen->konsultasi_poli_lain->jawaban ? $dokumen->konsultasi_poli_lain->jawaban->saran : '' : '' }}</textarea>
        </div>
        <div class="col-md-8">
            <p>&nbsp;</p>
        </div>
        <div class="col-md-4 text-center">
            <p style="font-weight: bold;">
                Surabaya,
                @if($dokumen->status == 0)
                ..................................<br>
                @else
                {{date('d/m/Y', strtotime($dokumen->tanggal_update))}}<br>
                @endif
                Hormat Kami,<br>
                @if(isset($dokumen))
                @if($dokumen->status != 0)
                <img src="{{ env('SMIS_UPLOAD_URL').'/'.$dokumen->ttd }}" style="height: 2.5cm; width: 5cm;" alt="">
            <p>({{$dokumen->nama_verifikator}})</p>
            @else
            <br>
            <br>
            <br>
            <br>
            <p>(.........................................................................)</p>
            @endif
            @else
            <br>
            <br>
            <br>
            <br>
            <p>(.........................................................................)</p>
            @endif
            </p>
        </div>
    </div>
    <div class="row pt-3 pb-3" style="width:100%; margin-left: 0;">
        <div class="col-md-1"></div>
        <div class="col-md-4" onclick="open_modal_konsultasi()" style="border:1px solid; height:250px; display: flex; align-items:center; justify-content: center;">
            <h5>Verifikator Konsultasi</h5>
        </div>
        <div class="col-md-2"></div>
        <div class="col-md-4" onclick="open_modal_jawaban()" style="border:1px solid; height:250px; display: flex; align-items:center; justify-content: center;">
            <h5>Verifikator Jawaban Konsultasi</h5>
        </div>
        <div class="col-md-1"></div>
    </div>
    <div class="row pb-5 pt-5" style="width:100%; margin-left:0;">
        <div style="text-align: center;" class="col-md-12">
            @if($dokumen->id_verifikator != 0)
            <a href="{{ url('medical_record/e_rekam_medis/konsultasi_poli_lain/pdf?dokumen='.$dokumen->id) }}" class="btn btn-success" target="_blank">Download PDF</a>
            @endif
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.10.7/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
    var loading = '<div class="spinner-border spinner-border-sm" role="status">' +
        '<span class="sr-only">Loading...</span>' +
        '</div>';

    $('#tabel_kepada').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ url("ajax_request/employee") }}', // memanggil route yang menampilkan data json
        columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                data: 'id',
                name: 'id',
                render(data, type, row, meta) {
                    return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
                }
            },
            {
                data: 'nama',
                name: 'nama'
            },
            {
                data: 'nama_jabatan',
                name: 'nama_jabatan',
                render(data, type, row) {
                    return '<p class="text-center">' + data + '</p>';
                }
            },
            {
                data: 'id',
                name: 'id',
                render(data, type, row) {
                    var fungsi_set = 'set_kepada(' + "'" + data + "','" + row.nama + "'" + ')';
                    return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                }
            }
        ]
    });

    function set_kepada(id, nama) {
        $('#kepada').val(nama);
        $('#hide_id_kepada').val(id);
        $('#modal_yth').modal('hide');
    }

    function open_modal_yth() {
        $('#modal_yth').modal('show');
    }

    function open_modal_konsultasi() {
        $('#modal_konsultasi').modal('show');
    }

    function open_modal_jawaban() {
        $('#modal_jawaban').modal('show');
    }

    function cek_jawaban() {
        $('#hide_jawaban').val($('#jawaban').val());
        $('#hide_saran').val($('#saran').val());

        console.log($('[name=jawaban]').val());
        console.log($('[name=saran]').val());

        if (!confirm('Yakin simpan jawaban konsultasi?')) {
            return false;
        }
    }

    function cek_konsul() {
        $('#hide_tanggal').val($('#tanggal').val());
        $('#hide_tanggal_periksa').val($('#tanggal_periksa').val());
        $('#hide_jam_awal').val($('#jam_awal').val());
        $('#hide_jam').val($('#jam').val());
        $('#hide_kepada').val($('#kepada').val());
        $('#hide_keterangan').val($('#keterangan').val());
        $('#hide_jenis').val($('[name=jenis]:checked').val());

        if (!confirm('Yakin simpan konsultasi ke poli lain ?')) {
            return false;
        }
    }
</script>

</html>