<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Informed Consent</title>

    <link rel="stylesheet" href="{{ asset('app-assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.7/css/jquery.dataTables.min.css">
    <!-- <link type="text/css" href="//ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/south-street/jquery-ui.css" rel="stylesheet"> -->
    <!-- <link rel="stylesheet" type="text/css" href="//keith-wood.name/css/jquery.signature.css"> -->
    <style>
        #data_diri tr th {
            vertical-align: top;
        }

        .main_table tr th {
            border: 1px solid;
            padding: 5px;
        }

        .main_table {
            width: 100%;
        }

        .main_table tr td {
            border: 1px solid;
            padding: 5px;
        }

        #list_diagnosa li {
            padding-bottom: 10px;
        }
    </style>
</head>

<body class="container">
    <!-- Modal Dokter -->
    <div class="modal fade" id="modal_dokter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Pilih Dokter</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table id="tabel_dokter" class="table table-striped mt-2">
                        <thead>
                            <tr class="text-center">
                                <th>No</th>
                                <th>Nama</th>
                                <th>Jabatan</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>
    <!-- End Modal Dokter -->

    <!-- Modal Pemberi Informasi -->
    <div class="modal fade" id="modal_pemberi_informasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Pilih Pemberi Informasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table id="tabel_pemberi_informasi" class="table table-striped mt-2">
                        <thead>
                            <tr class="text-center">
                                <th>No</th>
                                <th>Nama</th>
                                <th>Jabatan</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <div class="modal-footer">
                </div>
            </div>
        </div>
    </div>
    <!-- End Modal Pemberi Informasi -->
    @if ($errors->any())
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">{{$error}}</div>
    @endforeach
    @endif
    @if(Session::get('sukses'))
    <script>
        alert('{{ Session::get("sukses") }}')
    </script>
    @endif
    @if(Session::get('gagal'))
    <script>
        alert('{{ Session::get("gagal") }}')
    </script>
    @endif
    <div class="modal fade" id="modal_konsultasi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Pemberi Informasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" onsubmit="return cek_pemberi_informasi()" action="{{ url('medical_record/e_rekam_medis/informed_consent/save') }}">
                    @csrf
                    <input type="hidden" name="id_dokumen" value="{{$dokumen->id}}">
                    <input type="hidden" name="tanggal" id="hide_tanggal">
                    <input type="hidden" name="jam_awal" id="hide_jam_awal">
                    <input type="hidden" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->id_dokter_pelaksana : '' }}" name="id_dokter_pelaksana" id="hide_id_dokter_pelaksana">
                    <input type="hidden" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->dokter_pelaksana : '' }}" name="dokter_pelaksana" id="hide_dokter_pelaksana">
                    <input type="hidden" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->id_pemberi_informasi : '' }}" name="id_pemberi_informasi" id="hide_id_pemberi_informasi">
                    <input type="hidden" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->pemberi_informasi : '' }}" name="pemberi_informasi" id="hide_pemberi_informasi">
                    <input type="hidden" name="penerima_informasi" id="hide_penerima_informasi">
                    <input type="hidden" name="hubungan" id="hide_hubungan">
                    <input type="hidden" name="diagnosis" id="hide_diagnosis">
                    <input type="hidden" name="dasar_diagnosis" id="hide_dasar_diagnosis">
                    <input type="hidden" name="tindakan_kedokteran" id="hide_tindakan_kedokteran">
                    <input type="hidden" name="indikasi_tindakan" id="hide_indikasi_tindakan">
                    <input type="hidden" name="tata_cara" id="hide_tata_cara">
                    <input type="hidden" name="tujuan" id="hide_tujuan">
                    <input type="hidden" name="risiko" id="hide_risiko">
                    <input type="hidden" name="komplikasi" id="hide_komplikasi">
                    <input type="hidden" name="prognosis" id="hide_prognosis">
                    <input type="hidden" name="alternatif_resiko" id="hide_alternatif_resiko">
                    <input type="hidden" name="lain_lain" id="hide_lain_lain">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Password :</label>
                            <input type="password" name="pass" placeholder="Input your password" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_jawaban" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Verifikasi Terima Informasi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" onsubmit="return cek_terima_informasi()" action="{{ url('medical_record/e_rekam_medis/informed_consent/terima_informasi') }}">
                    @csrf
                    <input type="hidden" name="id_dokumen" value="{{$dokumen->id}}">
                    <input type="hidden" name="informed" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->id : '' }}">
                    <div class="modal-body">
                        <div class="form-group text-center">
                            <h6>Signature :</h6>
                            <canvas style="border: 2px solid;" id="signature-pad" class="signature-pad" width=400 height=200></canvas>
                            <textarea id="signature64" name="signed" style="display: none"></textarea>
                        </div>
                        <div class="form-group text-center">
                            <button id="clear" type="button" class="btn btn-danger btn-sm">Clear Signature</button>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Verifikasi</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_saksi" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Tanda tangan saksi</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group text-center">
                        <input type="hidden" id="nomor_saksi">
                        <h6>Signature :</h6>
                        <canvas style="border: 2px solid;" id="signature-pad-saksi" class="signature-pad" width=400 height=200></canvas>
                    </div>
                    <div class="form-group text-center">
                        <button id="clear-saksi" type="button" class="btn btn-danger btn-sm">Clear Signature</button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" onclick="set_saksi()" class="btn btn-success">Simpan</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal_menyatakan" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">Menyatakan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form onsubmit="return cek_menyatakan()" action="{{ url('medical_record/e_rekam_medis/informed_consent/save_persetujuan') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group text-center">
                            <textarea id="hide_signature_saksi_satu" name="sign_saksi_satu" style="display: none"></textarea>
                            <textarea id="hide_signature_saksi_dua" name="sign_saksi_dua" style="display: none"></textarea>
                            <textarea id="hide_signature_menyatakan" name="sign_menyatakan" style="display: none"></textarea>
                            <input type="hidden" name="dokumen" value="{{$dokumen->id}}">
                            <input type="hidden" name="informed" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->id : '' }}">
                            <input type="hidden" id="hide_nama_saksi_satu" name="saksi_satu">
                            <input type="hidden" id="hide_nama_saksi_dua" name="saksi_dua">
                            <input type="hidden" id="hide_nama_wali" name="nama_wali">
                            <input type="hidden" id="hide_hubungan_wali" name="hubungan_wali">
                            <input type="hidden" id="hide_usia_wali" name="usia_wali">
                            <input type="hidden" id="hide_kelamin_wali" name="kelamin_wali">
                            <input type="hidden" id="hide_alamat_wali" name="alamat_wali">
                            <input type="hidden" id="hide_wali_menyatakan" name="wali_menyatakan">
                            <h6>Signature :</h6>
                            <canvas style="border: 2px solid;" id="signature-pad-menyatakan" class="signature-pad" width=400 height=200></canvas>
                        </div>
                        <div class="form-group text-center">
                            <button id="clear-menyatakan" type="button" class="btn btn-danger btn-sm">Clear Signature</button>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="row pt-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-2 pl-0">
            {{-- <img src="{{ asset('filelogo/kotakihc.png') }}" alt="" style="width: 50%;"> --}}
        </div>
        <div class="col-md-8" style="text-align: center;">
            <h4 style="text-transform: uppercase;">KLINIK UTAMA DHARMAHUSADA PREMIER</h4>
        </div>
        <div class="col-md-2"></div>
        <div class="col-md-12">
            <table style="border-collapse: collapse; text-align: left; width:100%;">
                <tr>
                    <th>Alamat Kantor</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>Jl. Raya Dharma Husada Indah No.26 Surabaya</th>
                    <th style="padding-left: 30px;">E-mail</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>klinik.dharmahusadapremier@gmail.com</th>
                </tr>
                <tr>
                    <th>Telepon</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>+0315921101</th>
                    <th style="padding-left: 30px;">Whatsapp</th>
                    <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                    <th>085233664118</th>
                </tr>
            </table>
        </div>
        <div class="col-md-12 mt-3" style="border:1px solid; border-width: 1px;">
        </div>
    </div>
    <div class="row mt-2" style="width: 100%; margin-left: 0;">
        <div class="col-md-6 pl-0">
            <div style="border: 2px solid; width:100%; padding:10px;">
                <table style="border-collapse: collapse;" id="data_diri">
                    <tr>
                        <th>Tanggal Periksa</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            <input type="date" class="form-control" id="tanggal" value="{{ $dokumen->informed_consent ? date('Y-m-d', strtotime($dokumen->informed_consent->tanggal)) : date('Y-m-d', strtotime($dokumen->created_at)) }}">
                        </th>
                    </tr>
                    <tr>
                        <th>Jam Awal Asesmen</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            <input type="time" class="form-control" id="jam_awal" value="{{ $dokumen->informed_consent ? date('H:i', strtotime($dokumen->informed_consent->tanggal)) : date('H:i', strtotime($dokumen->created_at)) }}">
                        </th>
                    </tr>
                    <tr>
                        <th>Jam Akhir Asesmen</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{ $dokumen->status == 1 ? date('H:i', strtotime($dokumen->tanggal_update)) : '' }}
                        </th>
                    </tr>
                </table>
            </div>
        </div>
        <div class="col-md-6 pr-0">
            <div style="border: 2px solid; width:100%; padding:10px;">
                <table style="border-collapse: collapse;">
                    <tr>
                        <th>Nama</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$layanan ? $layanan->nama_pasien : ""}}
                        </th>
                    </tr>
                    <tr>
                        <th>Tanggal Lahir</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{ date('d-m-Y', strtotime($pasien->tgl_lahir)) }}
                        </th>
                    </tr>
                    <tr>
                        <th>No. Rekam Medis</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>
                            {{$layanan ? $layanan->nrm : ""}}
                        </th>
                    </tr>
                    <tr>
                        <th>No. JKN</th>
                        <th style="padding-left: 5px; padding-right: 5px;"> : </th>
                        <th>{{$layanan ? $layanan->nobpjs : ""}}</th>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="row pt-4 pb-3" style="width: 100%; margin-left: 0;">
        <div class="col-md-12">
            <h3 class="text-center">PENOLAKAN/PERSETUJUAN TINDAKAN KEDOKTERAN</h3>
        </div>
    </div>
    <div class="row pb-5" style="width: 100%; margin-left: 0; border:2px solid;">
        <table class="main_table">
            <tr>
                <th colspan="3" style="text-align: center;">PEMBERIAN INFORMASI</th>
            </tr>
            <tr>
                <td style="width: 50%;">Dokter Pelaksana Tindakan</td>
                <td style="width: 25%;">
                    <div class="input-group">
                        <input readonly type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->dokter_pelaksana : '' }}" class="form-control" id="dokter_pelaksana">
                        <div class="input-group-append">
                            <button type="button" onclick="open_modal_dokter()" class="btn btn-dark"><i class="fa fa-list"></i></button>
                        </div>
                    </div>
                </td>
                <td></td>
            </tr>
            <tr>
                <td style="width: 50%;">Pemberi Informasi</td>
                <td style="width: 25%;">
                    <div class="input-group">
                        <input readonly type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->pemberi_informasi : '' }}" class="form-control" id="pemberi_informasi">
                        <div class="input-group-append">
                            <button type="button" onclick="open_modal_pemberi_informasi()" class="btn btn-dark"><i class="fa fa-list"></i></button>
                        </div>
                    </div>
                </td>
                <td></td>
            </tr>
            <tr>
                <td style="width: 50%;" rowspan="2">Penerima Informasi / Pemberi Persetujuan</td>
                <td style="width: 25%;">
                    Nama
                </td>
                <td>
                    Hubungan Dengan Pasien
                </td>
            </tr>
            <tr>
                <td style="width: 25%;">
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->penerima_informasi : '' }}" class="form-control" id="penerima_informasi">
                </td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->hubungan : '' }}" class="form-control" id="hubungan_pasien">
                </td>
            </tr>
        </table>
        <table class="main_table">
            <tr>
                <th style="text-align: center; width:7%;">NO.</th>
                <th style="text-align: center; width:43%;">Masalah</th>
                <th style="text-align: center;">ISI INFORMASI</th>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">1.</td>
                <td style="width:43%;">Diagnosis<br>(Kerja dan Diagnosa Banding)</td>
                <td>
                    <ul id="list_diagnosa" style="list-style-type: numeric; margin-left: -15px;">
                        <li>
                            {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd.' - '.$layanan->diagnosa->nama_icd : '' }}
                        </li>
                        <li>
                            {{ $layanan->diagnosa ? $layanan->diagnosa->kode_icd_sekunder.' - '.$layanan->diagnosa->nama_icd_sekunder : '' }}
                        </li>
                    </ul>
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">2.</td>
                <td style="width:43%;">Dasar Diagnosis</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->dasar_diagnosis : '' }}" id="dasar_diagnosis" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">3.</td>
                <td style="width:43%;">Tindakan Kedokteran</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->tindakan_kedokteran : '' }}" id="tindakan_kedokteran" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">4.</td>
                <td style="width:43%;">Indikasi Tindakan</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->indikasi_tindakan : '' }}" id="indikasi_tindakan" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">5.</td>
                <td style="width:43%;">Tata Cara</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->tata_cara : '' }}" id="tata_cara" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">6.</td>
                <td style="width:43%;">Tujuan</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->tujuan : '' }}" id="tujuan" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">7.</td>
                <td style="width:43%;">Risiko</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->risiko : '' }}" id="risiko" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">8.</td>
                <td style="width:43%;">Komplikasi</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->komplikasi : '' }}" id="komplikasi" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">9.</td>
                <td style="width:43%;">Prognosis</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->prognosis : '' }}" id="prognosis" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">10.</td>
                <td style="width:43%;">Alternatif & Resiko Lain-lain</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->alternatif_resiko : '' }}" id="alternatif_resiko" class="form-control">
                </td>
            </tr>
            <tr>
                <td style="text-align: center; width:7%;">11.</td>
                <td style="width:43%;">Lain-lain</td>
                <td>
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->lain_lain : '' }}" id="lain_lain" class="form-control">
                </td>
            </tr>
        </table>
        <table class="main_table">
            <tr>
                <td style="width:70%;">Dengan ini menyatakan bahwa saya telah menerangkan hal-hal di atas secara benar dan jelas dan memberikan kesempatan untuk bertanya dan / atau berdiskusi</td>
                <td style="text-align: center; vertical-align: top;">
                    Tandatangan
                    <div id="box_ttd_pemberi_informasi" onclick="open_modal_konsultasi()">
                        @if($dokumen->status != 0)
                        <img src="{{ env('SMIS_UPLOAD_URL').'/'.$dokumen->ttd }}" style="height: 2.5cm; width: 5cm;" alt="">
                        <p>({{$dokumen->nama_verifikator}})</p>
                        @else
                        <div style="width:100%; border:1px solid transparent; display: flex; justify-content: center;">
                            <div style="height: 2.5cm; width: 5cm; display:flex; justify-content: center; align-items: center;">
                                <p class="text-center;">Klik disini</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </td>
            </tr>
            <tr>
                <td style="width:70%;">Dengan ini menyatakan bahwa saya telah menerima informasi sebagaimana di atas yang saya beri tanda / paraf di kolom kanannya, dan telah memahaminya</td>
                <td style="text-align: center; vertical-align: top;">
                    Tandatangan
                    <div id="box_ttd_penerima_informasi" onclick="open_modal_jawaban()">
                        @if(isset($dokumen->informed_consent))
                        @if($dokumen->informed_consent->signature != '')
                        <img src="{{ asset('signature_patient/'.$dokumen->informed_consent->signature) }}" alt="" style="height: 2.5cm; width:5cm;">
                        <p style="font-size: 18px; font-weight: bold; text-transform:uppercase">({{$dokumen->informed_consent->penerima_informasi}})</p>
                        @else
                        <div style="width:100%; border:1px solid transparent; display: flex; justify-content: center;">
                            <div style="height: 2.5cm; width: 5cm; display:flex; justify-content: center; align-items: center;">
                                <p class="text-center;">Klik disini</p>
                            </div>
                        </div>
                        @endif
                        @else
                        <div style="width:100%; border:1px solid transparent; display: flex; justify-content: center;">
                            <div style="height: 2.5cm; width: 5cm; display:flex; justify-content: center; align-items: center;">
                                <p class="text-center;">Klik disini</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2" style="font-style: italic;">Bila pasien tidak kompeten atau tidak mau menerima informasi, maka penerima informasi adalah wali atau keluarga terdekat.</td>
            </tr>
        </table>
        <table class="main_table mb-5">
            <tr>
                <th style="text-align: center;">PENOLAKAN/PERSETUJUAN TINDAKAN KEDOKTERAN</th>
            </tr>
            <tr>
                <td>
                    Yang bertanda tangan dibawah ini saya, Nama : <input value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->nama : '' : '' }}" type="text" id="nama_wali">, hubungan dengan pasien
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Pasien sendiri' ? 'checked' : '' : '' : '' }} value="Pasien sendiri" name="hubungan_wali"> Pasien sendiri,
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Orang tua' ? 'checked' : '' : '' : '' }} value="Orang tua" name="hubungan_wali"> Orang tua,
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Anak' ? 'checked' : '' : '' : '' }} value="Anak," name="hubungan_wali"> Anak,
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Istri' ? 'checked' : '' : '' : '' }} value="Istri" name="hubungan_wali"> Istri,<br><br>
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Suami' ? 'checked' : '' : '' : '' }} value="Suami" name="hubungan_wali"> Suami,
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Saudara' ? 'checked' : '' : '' : '' }} value="Saudara" name="hubungan_wali"> Saudara,
                    <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->hubungan == 'Pengantar' ? 'checked' : '' : '' : '' }} value="Pengantar" name="hubungan_wali"> Pengantar,
                    Umur <input value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->umur : '' : '' }}" type="number" min="0" id="usia_wali"> Tahun, <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->kelamin == '0' ? 'checked' : '' : '' : '' }} name="kelamin_wali" value="0"> Laki-laki / <input type="radio" value="1" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->kelamin == '1' ? 'checked' : '' : '' : '' }} name="kelamin_wali"> perempuan, alamat
                    <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->alamat : '' : '' }}" id="alamat_wali">
                </td>
            </tr>
            <tr>
                <td>
                    Dengan ini menyatakan <input type="radio" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->menyatakan == '0' ? 'checked' : '' : '' : '' }} value="0" name="menyatakan"> menolak / <input type="radio" name="menyatakan" {{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->menyatakan == '1' ? 'checked' : '' : '' : '' }} value="1"> menyetujui untuk dilakukan tindakan Terhadap saya / ........... saya<br>
                    Bernama {{$layanan->nama_pasien}}, Umur :
                    <?php
                    $date = new DateTime($pasien->tgl_lahir);
                    $now = new DateTime();
                    $age = $now->diff($date);
                    echo $age->y . ', ';
                    ?>
                    {{$pasien->kelamin == 0 ? 'Laki-laki' : 'Perempuan'}}<br>
                    Alamat : {{$pasien->alamat}}, {{$pasien->nama_kelurahan}}, {{$pasien->nama_kecamatan}}, {{$pasien->nama_kabupaten}}
                </td>
            </tr>
            <tr>
                <td style="border-bottom: 1px solid transparent;">
                    Saya memahami betapa perlunya dan manfaat tindakan tersebut sebagaimana telah dijelaskan seperti di atas kepada saya, termasuk risiko dan komplikasi yang mungkin timbul apabila tindakan tidak dilakukan.<br>
                    Saya bertanggung jawab secara penuh atas segala akibat yang mungkin tinbul sebagai akibat tidak dilakukan tindakan kedokteran tersebut.
                </td>
            </tr>
        </table>
        <div class="col-md-4" style="text-align: center;">
            <div id="box_saksi_satu" onclick="open_modal_saksi('satu')">
                @if(isset($dokumen->informed_consent))
                @if(isset($dokumen->informed_consent->persetujuan))
                @if($dokumen->informed_consent->persetujuan->signature_saksi_satu != '')
                <br>
                <p>Saksi 1 (Keluarga Pasien)</p>
                <div id="saksi_satu">
                <img src="{{ asset('signature_patient/'.$dokumen->informed_consent->persetujuan->signature_saksi_satu) }}" alt="" style="height: 2.5cm; width:5cm;">
                </div>
                @else
                <br>
                <p>Saksi 1 (Keluarga Pasien)</p>
                <br>
                <br>
                <div id="saksi_satu">Klik disini</div>
                <br>
                <br>
                @endif
                @else
                <br>
                <p>Saksi 1 (Keluarga Pasien)</p>
                <br>
                <br>
                <div id="saksi_satu">Klik disini</div>
                <br>
                <br>
                @endif
                @else
                <br>
                <p>Saksi 1 (Keluarga Pasien)</p>
                <br>
                <br>
                <div id="saksi_satu">Klik disini</div>
                <br>
                <br>
                @endif
            </div>
            <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->saksi_satu : '' : '' }}" id="nama_saksi_satu" placeholder="Masukkan nama saksi" class="form-control">
        </div>
        <div class="col-md-4" style="text-align: center;">
            <div id="box_saksi_dua" onclick="open_modal_saksi('dua')">
                @if(isset($dokumen->informed_consent))
                @if(isset($dokumen->informed_consent->persetujuan))
                @if($dokumen->informed_consent->persetujuan->signature_saksi_dua != '')
                <br>
                <p>Saksi 2 (Keluarga Pasien)</p>
                <div id="saksi_dua">
                <img src="{{ asset('signature_patient/'.$dokumen->informed_consent->persetujuan->signature_saksi_dua) }}" alt="" style="height: 2.5cm; width:5cm;">
                </div>
                @else
                <br>
                <p>Saksi 2 (Keluarga Pasien)</p>
                <br>
                <br>
                <div id="saksi_dua">Klik disini</div>
                <br>
                <br>
                @endif
                @else
                <br>
                <p>Saksi 2 (Keluarga Pasien)</p>
                <br>
                <br>
                <div id="saksi_dua">Klik disini</div>
                <br>
                <br>
                @endif
                @else
                <br>
                <p>Saksi 2 (Keluarga Pasien)</p>
                <br>
                <br>
                <div id="saksi_dua">Klik disini</div>
                <br>
                <br>
                @endif
            </div>
            <input type="text" value="{{ $dokumen->informed_consent ? $dokumen->informed_consent->persetujuan ? $dokumen->informed_consent->persetujuan->saksi_dua : '' : '' }}" id="nama_saksi_dua" placeholder="Masukkan nama saksi" class="form-control">
        </div>
        <div class="col-md-4" onclick="open_modal_menyatakan()" style="text-align: center;">
            @if(isset($dokumen->informed_consent))
            @if(isset($dokumen->informed_consent->persetujuan))
            <p>Surabaya, {{date('d/m/Y', strtotime($dokumen->informed_consent->persetujuan->tanggal))}} Pukul {{date('H:i', strtotime($dokumen->informed_consent->persetujuan->tanggal))}} <br>Yang menyatakan</p>
            <img src="{{ asset('signature_patient/'.$dokumen->informed_consent->persetujuan->signature) }}" alt="" style="height: 2.5cm; width:5cm;">
            <p>{{ $dokumen->informed_consent->persetujuan->nama }}</p>
            @else
            <p>Surabaya, .............Pukul...............<br>Yang menyatakan</p>
            <br>
            <br>
            <p>Klik disini</p>
            <br>
            <br>
            (..............................................................)
            @endif
            @else
            <p>Surabaya, .............Pukul...............<br>Yang menyatakan</p>
            <br>
            <br>
            <p>Klik disini</p>
            <br>
            <br>
            (..............................................................)
            @endif
        </div>
    </div>
    <!-- <div class="row pt-3 pb-3" style="width:100%; margin-left: 0;">
        <div class="col-md-4" style="padding: 10px;">
            <div style="border:1px solid; height:250px; display: flex; align-items:center; justify-content: center;">
                <h5>Pemberi Informasi</h5>
            </div>
        </div>
        <div class="col-md-4" onclick="open_modal_jawaban()" style="padding:10px;">
            <div style="border:1px solid; height:250px; display: flex; align-items:center; justify-content: center;">
                <h5>Penerima Informasi</h5>
            </div>
        </div>
        <div class="col-md-4" onclick="open_modal_menyatakan()" style="padding:10px">
            <div style="border:1px solid; height:250px; display: flex; align-items:center; justify-content: center;">
                <h5>Menyatakan</h5>
            </div>
        </div>
    </div> -->
    <div class="row pb-5 pt-5" style="width:100%; margin-left:0;">
        <div style="text-align: center;" class="col-md-12">
            @if($dokumen->id_verifikator != 0)
            <a href="{{ url('medical_record/e_rekam_medis/informed_consent/pdf?dokumen='.$dokumen->id) }}" class="btn btn-success" target="_blank">Download PDF</a>
            @endif
        </div>
    </div>
</body>
<script src="https://code.jquery.com/jquery-3.3.1.min.js" integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8=" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/1.10.7/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('app-assets/js/bootstrap.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
    var loading = '<div class="spinner-border spinner-border-sm" role="status">' +
        '<span class="sr-only">Loading...</span>' +
        '</div>';

    $('#tabel_dokter').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ url("ajax_request/employee") }}', // memanggil route yang menampilkan data json
        columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                data: 'id',
                name: 'id',
                render(data, type, row, meta) {
                    return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
                }
            },
            {
                data: 'nama',
                name: 'nama'
            },
            {
                data: 'nama_jabatan',
                name: 'nama_jabatan',
                render(data, type, row) {
                    return '<p class="text-center">' + data + '</p>';
                }
            },
            {
                data: 'id',
                name: 'id',
                render(data, type, row) {
                    var fungsi_set = 'set_dokter(' + "'" + row.nama + "','" + data + "'" + ')';
                    return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                }
            }
        ]
    });

    $('#tabel_pemberi_informasi').DataTable({
        processing: true,
        serverSide: true,
        ajax: '{{ url("ajax_request/employee") }}', // memanggil route yang menampilkan data json
        columns: [{ // mengambil & menampilkan kolom sesuai tabel database
                data: 'id',
                name: 'id',
                render(data, type, row, meta) {
                    return '<p class="text-center">' + (meta.row + meta.settings._iDisplayStart + 1) + '</p>';
                }
            },
            {
                data: 'nama',
                name: 'nama'
            },
            {
                data: 'nama_jabatan',
                name: 'nama_jabatan',
                render(data, type, row) {
                    return '<p class="text-center">' + data + '</p>';
                }
            },
            {
                data: 'id',
                name: 'id',
                render(data, type, row) {
                    var fungsi_set = 'set_pemberi_informasi(' + "'" + row.nama + "','" + data + "'" + ')';
                    return '<div class="text-center"><button type="button" onclick="' + fungsi_set + '" class="btn btn-dark"><i class="fa fa-check"></i></button></div>';
                }
            }
        ]
    });

    function box_ttd(param) {
        return '<br>' +
            '<p>Saksi 2 (Keluarga Pasien)</p>' +
            '<br>' +
            '<br>' +
            '<div id="' + param + '">Klik disini</div>' +
            '<br>' +
            '<br>';
    }

    function get_employee(param, type) {
        $.ajax({
            url: "",
            data: {
                keyword: param
            },
            success: function(response) {
                if (response == null) {
                    $('#list_' + type).html('<tr class="text-center"><td colspan="4">' + ajax.message + '</td></tr>');
                    return;
                }
                let ins = '';
                for (let i = 0; i < response.length; i++) {

                    ins += '<tr>' +
                        '<td class="text-center">' + (i + 1) + '</td>' +
                        '<td>' + response[i].nama + '</td>' +
                        '<td>' + response[i].jabatan + '</td>' +
                        '<td class="text-center"></td>' +
                        '</tr>';
                }
                $('#list_' + type).html(ins);
            }
        })
    }

    function set_dokter(nama, id) {
        $('#hide_id_dokter_pelaksana').val(id);
        $('#dokter_pelaksana').val(nama);
        $('#modal_dokter').modal('hide');
    }

    function set_pemberi_informasi(nama, id) {
        $('#hide_id_pemberi_informasi').val(id);
        $('#pemberi_informasi').val(nama);
        $('#modal_pemberi_informasi').modal('hide');
    }

    function open_modal_dokter() {
        // $('#list_dokter').html('<tr class="text-center"><td colspan="4">' + loading + ' Sedang mengambil data...</td></tr>');
        // get_employee($('#search_dokter').val(), 'dokter');
        $('#modal_dokter').modal('show');
    }

    function open_modal_pemberi_informasi() {
        // $('#list_pemberi_informasi').html('<tr class="text-center"><td colspan="4">' + loading + ' Sedang mengambil data...</td></tr>');
        // get_employee($('#search_pemberi_informasi').val(), 'pemberi_informasi');
        $('#modal_pemberi_informasi').modal('show');
    }

    $('#form_search_dokter').submit(function(e) {
        e.preventDefault();
        $('#list_dokter').html('<tr class="text-center"><td colspan="4">' + loading + ' Sedang mengambil data...</td></tr>');
        get_employee($('#search_dokter').val(), 'dokter');
    })

    $('#form_search_pemberi_informasi').submit(function(e) {
        e.preventDefault();
        $('#list_pemberi_informasi').html('<tr class="text-center"><td colspan="4">' + loading + ' Sedang mengambil data...</td></tr>');
        get_employee($('#search_pemberi_informasi').val(), 'pemberi_informasi');
    })

    const signaturePad = new SignaturePad(document.getElementById('signature-pad'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    const signaturePadSaksi = new SignaturePad(document.getElementById('signature-pad-saksi'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    const signaturePadMenyatakan = new SignaturePad(document.getElementById('signature-pad-menyatakan'), {
        minWidth: 5,
        maxWidth: 10,
        penColor: 'rgb(0, 0, 0)',
        maxWidth: 2
    });

    $('#clear').click(function(e) {
        e.preventDefault();
        signaturePad.clear();
        $("#signature64").val('');
    });

    $('#clear-saksi').click(function(e) {
        e.preventDefault();
        signaturePadSaksi.clear();
    });

    $('#clear-menyatakan').click(function(e) {
        e.preventDefault();
        signaturePadMenyatakan.clear();
        $('#box_saksi_' + $('#nomor_saksi').val()).html(box_ttd('saksi_' + $('#nomor_saksi').val()));
    });

    function open_modal_konsultasi() {
        $('#modal_konsultasi').modal('show');
    }

    function open_modal_jawaban() {
        $('#modal_jawaban').modal('show');
    }

    function open_modal_menyatakan() {
        $('#modal_menyatakan').modal('show');
    }

    function open_modal_saksi(param) {
        $('#nomor_saksi').val(param);
        $('#modal_saksi').modal('show');
    }

    function set_saksi() {
        var temp = signaturePadSaksi.toDataURL('image/png');
        $('#saksi_' + $('#nomor_saksi').val()).html('<img src="' + temp + '" style="height: 2.5cm; width: 5cm;" />');
        $('#hide_signature_saksi_' + $('#nomor_saksi').val()).val(temp);
        $('#modal_saksi').modal('hide');
        signaturePadSaksi.clear();
    }

    function cek_terima_informasi() {
        var data = signaturePad.toDataURL('image/png');
        $('#signature64').val(data);

        if ($('#signature64').val() == '') {
            alert('Tambahkan tanda tangan anda dahulu');
            return false;
        }

        if (!confirm('Dengan ini menyatakan bahwa saya telah menerima informasi sebagaimana di atas yang saya beri tanda / paraf di kolom kanannya, dan telah memahaminya')) {
            return false;
        }
    }

    function cek_pemberi_informasi() {
        $('#hide_tanggal').val($('#tanggal').val());
        $('#hide_jam_awal').val($('#jam_awal').val());
        $('#hide_dokter_pelaksana').val($('#dokter_pelaksana').val());
        $('#hide_pemberi_informasi').val($('#pemberi_informasi').val());
        $('#hide_penerima_informasi').val($('#penerima_informasi').val());
        $('#hide_hubungan').val($('#hubungan_pasien').val());
        $('#hide_dasar_diagnosis').val($('#dasar_diagnosis').val());
        $('#hide_tindakan_kedokteran').val($('#tindakan_kedokteran').val());
        $('#hide_indikasi_tindakan').val($('#indikasi_tindakan').val());
        $('#hide_tata_cara').val($('#tata_cara').val());
        $('#hide_tujuan').val($('#tujuan').val());
        $('#hide_risiko').val($('#risiko').val());
        $('#hide_komplikasi').val($('#komplikasi').val());
        $('#hide_prognosis').val($('#prognosis').val());
        $('#hide_alternatif_resiko').val($('#alternatif_resiko').val());
        $('#hide_lain_lain').val($('#lain_lain').val());

        if (!confirm('Yakin simpan informasi ?')) {
            console.log($('#hide_dokter_pelaksana').val());
            return false;
        }
    }

    function cek_menyatakan() {
        var data = signaturePadMenyatakan.toDataURL('image/png');
        $('#hide_signature_menyatakan').val(data);
        $('#hide_nama_saksi_satu').val($('#nama_saksi_satu').val());
        $('#hide_nama_saksi_dua').val($('#nama_saksi_dua').val());
        $('#hide_nama_wali').val($('#nama_wali').val());
        $('#hide_usia_wali').val($('#usia_wali').val());
        $('#hide_hubungan_wali').val($('[name=hubungan_wali]:checked').val());
        $('#hide_kelamin_wali').val($('[name=kelamin_wali]:checked').val());
        $('#hide_alamat_wali').val($('#alamat_wali').val());
        $('#hide_wali_menyatakan').val($('[name=menyatakan]:checked').val());

        if (!confirm('Yakin ingin melanjutkan ?')) {
            return false;
        }
    }
</script>

</html>