<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title>Jenis Kunjungan</title>
    <style type="text/css" media="screen">
        table {
            border-collapse: collapse;
            width: 100%;
        }

        td,
        th {
            border: 1px solid black;
            padding: 5px;
        }
    </style>
</head>

<body>
    <h3 style="text-align: center;">Data Induk Pendaftaran - Jenis Pasien</h3>
    <table>
        <thead>
            <th>No</th>
            <th>Nama</th>
            <th>Slug</th>
            <th>Keterangan</th>
            <th>BPJS</th>
            <th>Perusahaan</th>
            <th>Asuransi</th>
            <th>Plafon</th>
        </thead>
        <tbody>
            @forelse ($data as $dt)
                <tr class="">
                    <td>{{ $loop->index + 1 }}</td>
                    <td>{{ $dt->nama }}</td>
                    <td>{{ $dt->slug }}</td>
                    <td>{{ $dt->keterangan }}</td>
                    <td>{{ $dt->nobpjs == 1 ? 'X' : '-' }}</td>
                    <td>{{ $dt->nama_perusahaan == 1 ? 'X' : '-' }}</td>
                    <td>{{ $dt->asuransi == 1 ? 'X' : '-' }}</td>
                    <td>@currency($dt->plafon)</td>
                </tr>
            @empty
                <tr class="text-center">
                    <td colspan="10">Data tidak ditemukan</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>

</html>
