@extends('layouts.app')
@section('content')
<div class="modal fade" id="modal_layani" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Pilih jenis obat</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="" onsubmit="layani()">
                <div class="modal-body">
                    <input type="hidden" id="id_layani">
                    <div class="form-group">
                        <label for="">Jenis Obat</label>
                        <select name="" id="jenis_obat" class="form-control">
                            <option value="">--Select Here--</option>
                            <option value="1">Racikan</option>
                            <option value="0">Non Racikan</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Layani</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Antrian Farmasi</h1>
        </div>

        <div class="section-body">
            @if(Session::has('berhasil'))
            <div class="row" style="width:100%; margin-left: 0;">
                <div class="col-lg-12 alert alert-success">
                    {{Session::get('berhasil')}}
                </div>
            </div>
            @endif
            @if(Session::has('gagal'))
            <div class="row" style="width:100%; margin-left: 0;">
                <div class="col-lg-12 alert alert-danger">
                    {{Session::get('gagal')}}
                </div>
            </div>
            @endif
            <div class="card pt-3">
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-4">
                        <!-- <div class="form-group">
                            <select id="lantai" class="form-control">
                                <option value="1">Lantai 1</option>
                                <option value="2">Lantai 2</option>
                            </select>
                        </div> -->
                    </div>
                </div>
                <div class="row" style="width: 100%; margin-left: 0;">
                    <div class="col-lg-12">
                        <form class="col-lg-4 pl-0" onsubmit="search()">
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" id="keyword" placeholder="Cari nrm / nama" class="form-control">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <table class="table table-striped">
                            <thead>
                                <tr class="text-center">
                                    <th>No</th>
                                    <th>Nomor Antrian</th>
                                    <th>Nama Pasien</th>
                                    <th>No. RM</th>
                                    <th>No. BPJS</th>
                                    <th>NIK</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="list_data">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('scripts')
<script>
    function loading(param) {
        return '<div class="spinner-border spinner-border-sm" role="status">' +
            '<span class="sr-only">Loading...</span>' +
            '</div> ' + param;
    }

    $(document).ready(function() {
        get_data('');
    })
    let synth = window.speechSynthesis;
    // let model_suara = [];

    function search() {
        window.event.preventDefault();
        get_data($('#keyword').val());
    }

    function get_data(param) {
        $('#list_data').html('<tr class="text-center"><td colspan="8">' + loading('Sedang mengambil data...') + '</td></tr>');
        $.ajax({
            url: '{{ url("ajax_request/antrian_obat") }}',
            data: {
                keyword: param
            },
            success: function(response) {
                console.log(response);
                if (response.length == 0) {
                    $('#list_data').html('<tr class="text-center"><td colspan="8">Data tidak ditemukan</td></tr>');
                    return;
                }

                let ins = '';
                for (let i = 0; i < response.length; i++) {
                    ins += '<tr>' +
                        '<td class="text-center">' + (i + 1) + '</td>' +
                        '<td>' + response[i].nomorantrean + '</td>' +
                        '<td>' + response[i].pasien + '</td>' +
                        '<td>' + response[i].norm + '</td>' +
                        '<td>' + response[i].nobpjs + '</td>' +
                        '<td>' + response[i].ktp + '</td>' +
                        '<td>' + status(response[i].taskid) + '</td>' +
                        '<td>' + render_button(response[i].taskid, response[i].id, response[i].nomorantrean, response[i].pasien) + '</td>' +
                        '</tr>';
                }
                $('#list_data').html(ins);
            }
        })
    }

    setInterval(function() {
        get_data('');
    }, 120000)

    function status(param) {
        switch (param) {
            case 5:
                return 'Menunggu Dilayani';
                break;
            case 6:
                return 'Sedang Dilayani';
                break;
            case 7:
                return 'Selesai Dilayani';
                break;
            default:
                return '';
                break;
        }
    }

    function open_modal_layani(param) {
        $('#id_layani').val(param);
        $('#modal_layani').modal('show');
    }

    function layani(param) {
        window.event.preventDefault();
        if ($('#jenis_obat').val() == '') {
            alert('Pilih jenis obat dahulu');
            return;
        }
        $.ajax({
            url: '{{ url("antrian/farmasi_layani_antrian") }}',
            data: {
                id: $('#id_layani').val(),
                jenis : $('#jenis_obat').val()
            },
            success: function(response) {
                console.log(response);
                $('#modal_layani').modal('hide');
                if (response.status) {
                    get_data('');
                    return;
                }

                alert(response.message);
            }
        })
    }

    function selesai(param) {
        $.ajax({
            url: '{{ url("antrian/farmasi_selesai_antrian") }}',
            data: {
                id: param
            },
            success: function(response) {
                console.log(response);
                if (response.status) {
                    get_data('');
                    return;
                }

                alert(response.message);
            }
        })
    }

    function render_button(param, id, antrian, pasien) {
        switch (param) {
            case 5:
                return '<div style="display:flex;"><button class="btn btn-warning" onclick="open_modal_layani(' + "'" + id + "'" + ')">Layani</button></div>';
                break;
            case 6:
                return '<div style="display:flex;"><button class="btn btn-dark mr-1" onclick="panggil(' + "'" + antrian + "'" + ',' + "'" + pasien + "'" + ')">Panggil</button><button class="btn btn-success" onclick="selesai(' + "'" + id + "'" + ')">Selesai</button></div>';
                break;
            case 7:
                return '<div style="display:flex;"><button class="btn btn-dark" onclick="panggil(' + "'" + antrian + "'" + ',' + "'" + pasien + "'" + ')">Panggil</button></div>';
                break;
            default:
                return '';
                break;
        }
    }

    function panggil(nomor, pasien) {
        $.ajax({
            url: "{{ url('ajax_request/send_broadcast') }}",
            method: 'post',
            data: {
                loket: '',
                nomor: nomor,
                bagian: 'farmasi',
                _token: '{{ csrf_token() }}',
                pasien: pasien,
                lantai: ''
            },
            success: function(response) {
                console.log(response);
                if (response) {

                }
            }
        })
    }
</script>
@endpush