<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocPengkajianKeperawatanRawatJalanTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_pengkajian_keperawatan_rawat_jalan', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->string('keluhan_utama',255)->default('');
            $table->string('riwayat_kesehatan',255)->default('');
            $table->string('pemeriksaan_fisik',64)->default('');
            $table->string('kesadaran',64)->default('');
            $table->string('catatan_khusus',255)->default('');
            $table->string('riwayat_psikologi',255)->default('');
            $table->double('bb')->nullable();
            $table->double('tb')->nullable();
            $table->double('imt')->nullable();
            $table->string('penurunan_bb', 10)->default('');
            $table->double('jumlah_penurunan_bb')->nullable();
            $table->string('nafsu_makan', 10)->default('');
            $table->string('status_gizi', 32)->default('');
            $table->integer('asesmen_nyeri')->default(0)->unsigned();
            $table->string('penglihatan', 128)->default('');
            $table->string('penciuman', 128)->default('');
            $table->string('pendengaran', 128)->default('');
            $table->string('kebiasaan_bak_bab', 128)->default('');
            $table->integer('riwayat_jatuh')->default(0)->unsigned();
            $table->integer('diagnosis_sekunder')->default(0)->unsigned();
            $table->integer('alat_bantu')->default(0)->unsigned();
            $table->integer('akses_i_v')->default(0)->unsigned();
            $table->integer('gaya_berjalan')->default(0)->unsigned();
            $table->integer('status_mental')->default(0)->unsigned();
            $table->string('pemahaman_penyakit', 32)->default('');
            $table->string('pemahaman_pengobatan', 32)->default('');
            $table->string('pemahaman_perawatan', 32)->default('');
            $table->string('pemahaman_keamanan_penggunaan_alkes', 32)->default('');
            $table->string('pemahaman_nutrisi_diet', 32)->default('');
            $table->string('pemahaman_manajemen_nyeri', 32)->default('');
            $table->string('hambatan', 128)->default('');
            $table->string('pemeriksaan_penunjang', 128)->default('');
            $table->string('masalah_keperawatan', 255)->default('');
            $table->string('implementasi_keperawatan', 255)->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_pengkajian_keperawatan_rawat_jalan');
    }
}
