<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSmisDocPembedahanOperasiKecilTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('smis_doc_pembedahan_operasi_kecil', function (Blueprint $table) {
            $table->id();
            $table->integer('id_dokumen')->unsigned();
            $table->string('keluhan_utama');
            $table->string('rps');
            $table->string('rpd');
            $table->integer('id_operator')->unsigned();
            $table->string('operator');
            $table->integer('id_asisten')->unsigned();
            $table->string('asisten');
            $table->date('tanggal_operasi');
            $table->time('mulai_jam');
            $table->time('selesai_jam');
            $table->string('teknik_operasi');
            $table->string('jenis_anestesi');
            $table->string('jenis_sedatif');
            $table->text('uraian');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('smis_doc_pembedahan_operasi_kecil');
    }
}
