<?php

namespace App\Services;

use App\Models\SuratSakit;
use Illuminate\Support\Facades\DB;

/**
 * Class Services
 * @author rivald 
 */
class SuratSakitService
{
    public function getDiagnosa()
    {
        return DB::table('smis_mr_icd')->where('prop', '')->get();
    }

    public function getNoSk()
    {
        $number = SuratSakit::select('no_surat', DB::raw("SUBSTRING_INDEX(`no_surat`, '/', -1) AS `nomor`"))->where([
            ['prop', ' '],
            [DB::raw("SUBSTRING_INDEX(SUBSTRING_INDEX(`no_surat`, '/', 2), '/', -1)"), date('d.m.Y')]
        ])->orderBy('no_surat', 'DESC')->first();

        if (!isset($number->no_surat)) {
            return "SK.SAKIT/" . date('d.m.Y') . "/1";
        }
        $explode = explode("/", $number->no_surat);

        return $explode[0] . "/" . $explode[1] . "/" . ($explode[2] + 1) ?? "failed get number";
    }

    public function getSuratSakit($param = null)
    {
        $dataSuratSakit = DB::table('surat_sakits as surat')
            ->join('smis_rg_patient as pasien', 'surat.nrm', 'pasien.id')
            ->select('*', 'surat.id as id_surat', DB::raw("TIMESTAMPDIFF(YEAR, pasien.tgl_lahir, CURDATE()) AS age"))
            ->where([
                ['surat.prop', ''],
                ['pasien.prop', '']
            ]);

        if (isset($param)) {
            return $dataSuratSakit->where('pasien.nama', $param);
        }

        return $dataSuratSakit->orderBy('surat.id', 'DESC');
    }

    public function getSuratSakitById($id)
    {
        return DB::table('surat_sakits as surat')
            ->join('smis_rg_patient as pasien', 'surat.nrm', 'pasien.id')
            ->select(
                'pasien.nama',
                'pasien.tempat_lahir',
                'pasien.tgl_lahir',
                'pasien.id as nrm',
                'surat.id as id_surat',
                'pasien.kelamin',
                'pasien.alamat',
                'surat.*',
                DB::raw("TIMESTAMPDIFF(YEAR, pasien.tgl_lahir, CURDATE()) AS age")
            )
            ->where([
                ['surat.prop', ''],
                ['pasien.prop', ''],
                ['surat.id', $id]
            ])->first();
    }

    public function store($param)
    {
        try {
            $idSurat = SuratSakit::updateOrCreate(
                [
                    'id' => $param->id
                ],
                $param->except('id', '_token', '_method', 'nama', 'action')
            )->id;
            return $idSurat;
        } catch (Throwable $e) {
            return $e->getMessage();
        }
    }

    public function delete($id)
    {
        try {
            SuratSakit::where('id', $id)->update(['prop' => 'del']);
            return "sukses";
        } catch (Throwable $e) {
            return $e;
        }
    }
}
