<?php

namespace App\Services;

use App\Models\SMIS_Pasien;
use App\Models\SuratKeteranganSehat;
use Illuminate\Support\Facades\DB;
use Throwable;

/**
 * Class Services
 * @author rivald 
 */
class SuratKeteranganSehatService
{
    public function getAddress()
    {
        return DB::table('smis_adm_settings')->select('value')->where('name', 'smis_autonomous_town')->first();
    }

    public function getPatient()
    {
        return SMIS_Pasien::where('prop', ' ');
    }

    public function getSurateKetSehatById($id)
    {
        return DB::table('surat_keterangan_sehats as surat')
            ->join('smis_rg_patient as pasien', 'surat.nrm', 'pasien.id')
            ->select('*', 'surat.id as id_surat', DB::raw("TIMESTAMPDIFF(YEAR, pasien.tgl_lahir, CURDATE()) AS age"))
            ->where([
                ['surat.prop', ''],
                ['pasien.prop', ''],
                ['surat.id', $id]
            ])->first();
    }

    public function getSurateKetSehat($param = null)
    {
        $dataSuratSehat = DB::table('surat_keterangan_sehats as surat')
            ->join('smis_rg_patient as pasien', 'surat.nrm', 'pasien.id')
            ->select('*', 'surat.id as id_surat', DB::raw("TIMESTAMPDIFF(YEAR, pasien.tgl_lahir, CURDATE()) AS age"))
            ->where([
                ['surat.prop', ''],
                ['pasien.prop', '']
            ]);

        if (isset($param)) {
            return $dataSuratSehat->where('pasien.nama', $param);
        }

        return $dataSuratSehat->orderBy('surat.id', 'desc');
    }

    public function getNoSk()
    {
        $number = SuratKeteranganSehat::select('no_surat', DB::raw("SUBSTRING_INDEX(`no_surat`, '/', -1) AS `nomor`"))->where([
            ['prop', ' '],
            [DB::raw("SUBSTRING_INDEX(SUBSTRING_INDEX(`no_surat`, '/', 2), '/', -1)"), date('d.m.Y')]
        ])->orderBy('no_surat', 'DESC')->first();

        if (!isset($number->no_surat)) {
            return "SK.SEHAT/" . date('d.m.Y') . "/1";
        }
        $explode = explode("/", $number->no_surat);

        return $explode[0] . "/" . $explode[1] . "/" . ($explode[2] + 1) ?? "failed get number";
    }

    public function store($param)
    {
        try {
            SuratKeteranganSehat::updateOrInsert(
                [
                    'id' => $param->id
                ],
                $param->except('id', '_token', '_method')
            );
            //create();
            return "sukses";
        } catch (Throwable $e) {
            return $e->getMessage();
        }
    }

    public function delete($id)
    {
        try {
            SuratKeteranganSehat::where('id', $id)->update(['prop' => 'del']);
            return "sukses";
        } catch (Throwable $e) {
            return $e;
        }
    }

    public function konversiTanggal($tanggal)
    {
        $tgl_arr = explode('-', $tanggal);
        $tahun = $tgl_arr[2];
        $bulan = intval($tgl_arr[1]);
        $tanggal = intval($tgl_arr[0]);

        // daftar nama bulan dalam bahasa Indonesia
        $daftar_bulan = array(
            1 => 'Januari',
            2 => 'Februari',
            3 => 'Maret',
            4 => 'April',
            5 => 'Mei',
            6 => 'Juni',
            7 => 'Juli',
            8 => 'Agustus',
            9 => 'September',
            10 => 'Oktober',
            11 => 'November',
            12 => 'Desember'
        );
        return $tanggal . ' ' . $daftar_bulan[$bulan] . ' ' . $tahun;
    }
}
