<?php

namespace App\Services\SatuSehat;

use App\Models\Antrian;
use App\Models\JadwalPoli;
use App\Models\SatuSehat\Location;
use App\Models\SMIS_Diagnosa;
use App\Models\SMIS_LayananPasien;
use App\Models\Smis_Mr_Icd;
use App\Models\SMIS_Pasien;
use App\Models\SmisHrdEmployee;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class RawatJalanService
{
    private $uuid_encounter = '';
    private $uuid_primer = '';
    private $uuid_sekunder1 = '';
    private $uuid_sekunder2 = '';
    private $uuid_sekunder3 = '';
    private $uuid_sekunder4 = '';
    private $uuid_sekunder5 = '';

    function __construct()
    {
        $this->uuid_encounter = '';
        $this->uuid_primer = '';
        $this->uuid_sekunder1 = '';
        $this->uuid_sekunder2 = '';
        $this->uuid_sekunder3 = '';
        $this->uuid_sekunder4 = '';
        $this->uuid_sekunder5 = '';
    }

    public function send($id_layanan)
    {
        $kunjungan = SMIS_LayananPasien::where('id', $id_layanan)->first();

        if($kunjungan->status_ss == 1){
            return [
                'status' => false,
                'message' => 'Data sudah dikirim',
            ];
        }

        $pasien = SMIS_Pasien::where('id', $kunjungan->id_pasien)->where('prop', '')->first();

        $get_ihs = (new SendRequestService)->get(env('SATU_SEHAT_URL') . '/fhir-r4/v1/Patient?identifier=https://fhir.kemkes.go.id/id/nik|' . $pasien->ktp);

        if ($get_ihs->getStatusCode() == 401) {
            return [
                'status' => false,
                'message' => 'Gagal mendapatkan ihs number, token satu sehat expired',
            ];
        }

        if ($get_ihs->getStatusCode() == 200) {
            $data = json_decode($get_ihs->getBody()->getContents());
            if (sizeof($data->entry) > 0) {
                $this->update_ihs_number($data, $pasien);
            }
        }

        $pasien = SMIS_Pasien::where('id', $kunjungan->id_pasien)->where('prop', '')->first();

        if ($pasien->ihs_number != '') {
            $data = $this->bundle($kunjungan);

            $result = (new SendRequestService)->post(env('SATU_SEHAT_URL') . '/fhir-r4/v1', json_encode($data));

            if ($result->getStatusCode() == 401) {
                $autentikasi = json_decode((new SendRequestService)->auth());
                Session::put('token_satu_sehat', $autentikasi ? $autentikasi->access_token : null);
                $result = (new SendRequestService)->post(env('SATU_SEHAT_URL') . '/fhir-r4/v1', json_encode($data));
            }

            if ($result->getStatusCode() == 200) {
                $data = json_decode($result->getBody()->getContents());
                if (isset($data->entry[0])) {

                    DB::table('smis_rg_layananpasien')->where('id', $id_layanan)->update([
                        'status_ss' => 1,
                        'id_encounter' => $data->entry[0]->response->resourceID
                    ]);
                }
                if (isset($data->entry[1])) {
                    DB::table('smis_mr_diagnosa')->where('noreg_pasien', $id_layanan)->update([
                        'id_diagnosa_primer' => $data->entry[1]->response->resourceID
                    ]);
                }
                if (isset($data->entry[2])) {
                    DB::table('smis_mr_diagnosa')->where('noreg_pasien', $id_layanan)->update([
                        'id_diagnosa_sekunder1' => $data->entry[2]->response->resourceID
                    ]);
                }
                if (isset($data->entry[3])) {
                    DB::table('smis_mr_diagnosa')->where('noreg_pasien', $id_layanan)->update([
                        'id_diagnosa_sekunder2' => $data->entry[3]->response->resourceID
                    ]);
                }
                if (isset($data->entry[4])) {
                    DB::table('smis_mr_diagnosa')->where('noreg_pasien', $id_layanan)->update([
                        'id_diagnosa_sekunder3' => $data->entry[4]->response->resourceID
                    ]);
                }
                if (isset($data->entry[5])) {
                    DB::table('smis_mr_diagnosa')->where('noreg_pasien', $id_layanan)->update([
                        'id_diagnosa_sekunder4' => $data->entry[5]->response->resourceID
                    ]);
                }
                if (isset($data->entry[6])) {
                    DB::table('smis_mr_diagnosa')->where('noreg_pasien', $id_layanan)->update([
                        'id_diagnosa_sekunder5' => $data->entry[6]->response->resourceID
                    ]);
                }
            } else if ($result->getStatusCode() == 400) {
                $err = json_decode($result->getBody()->getContents());
                $temp = '';
                for ($i = 0; $i < sizeof($err->issue); $i++) {
                    if ($i == 0) {
                        $temp .= isset($err->issue[$i]->details->text) ? $err->issue[$i]->details->text . '(' . (isset($err->issue[$i]->expression) ? $err->issue[$i]->expression[0] : (isset($err->issue[$i]->diagnostics) ? $err->issue[$i]->diagnostics : '-')) . ')' : '';
                    } else {
                        $temp .= isset($err->issue[$i]->details->text) ? ', ' . $err->issue[$i]->details->text . '(' . (isset($err->issue[$i]->expression) ? $err->issue[$i]->expression[0] : (isset($err->issue[$i]->diagnostics) ? $err->issue[$i]->diagnostics : '-')) . ')' : '';
                    }
                }
                DB::table('smis_rg_layananpasien')->where('id', $id_layanan)->update([
                    'response_code_satu_sehat' => $result->getStatusCode(),
                    'response_message_satu_sehat' => $temp
                ]);
            }

            return [
                'code' => $result->getStatusCode(),
                'status' => true,
                'message' => $result->getReasonPhrase()
            ];
        }

        return [
            'code' => 200,
            'status' => true,
            'message' => 'IHS Number Pasien Kosong'
        ];
    }

    public function update($id, $encounter)
    {
        $update = Antrian::where('id', $id)->update([
            'id_encounter' => $encounter->id,
        ]);

        return $update;
    }

    function update_ihs_number($data, $pasien)
    {
        $query = DB::table('smis_rg_patient')->where('id', $pasien->id)->update([
            'ihs_number' => $data->entry[0]->resource->id
        ]);
        return $query;
    }

    public function data_add_encounter($layanan, $pasien, $poli)
    {
        $employee = SmisHrdEmployee::where('id', $poli->id_dokter)->first();
        $lokasi = Location::where('nama', $poli->nama_poli)->where('slug_klinik', env('slug_klinik'))->first();
        $data = [
            "resourceType" => "Encounter",
            "status" => 'arrived',
            "class" => json_decode(json_encode([
                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                "code" => "AMB",
                "display" => "ambulatory"
            ])),
            "subject" => json_decode(json_encode([
                "reference" => "Patient/" . $pasien->ihs_number,
                "display" => $pasien->nama
            ])),
            "participant" => [
                json_decode(json_encode([
                    "type" => [
                        json_decode(json_encode([
                            "coding" => [
                                json_decode(json_encode([
                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                    "code" => "ATND",
                                    "display" => "attender"
                                ]))
                            ]
                        ]))
                    ],
                    "individual" => json_decode(json_encode([
                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                        "display" => $employee ? $employee->nama : ''
                    ]))
                ]))
            ],
            "period" => json_decode(json_encode([
                "start" => (new DateTime('now', new \DateTimeZone("Asia/Jakarta")))->format('c')
            ])),
            "location" => [
                json_decode(json_encode([
                    "location" => json_decode(json_encode([
                        "reference" => "Location/" . ($lokasi ? $lokasi->id_lokasi : ''),
                        "display" => $lokasi ? $lokasi->nama : ''
                    ]))
                ]))
            ],
            "statusHistory" => [
                json_decode(json_encode([
                    "status" => "arrived",
                    "period" => json_decode(json_encode([
                        "start" => (new DateTime('now', new \DateTimeZone("Asia/Jakarta")))->format('c')
                    ]))
                ]))
            ],
            "serviceProvider" => json_decode(json_encode([
                "reference" => "Organization/" . env('IHS_RS')
            ])),
            "identifier" => [
                json_decode(json_encode([
                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                    "value" => (string) $layanan['id']
                ]))
            ]
        ];
        return $data;
    }

    public function data_update_inprogress($antrian, $waktu)
    {
        $pasien = SMIS_Pasien::where('id', $antrian->norm)->first();
        $jadwal = JadwalPoli::findOrFail($antrian->jadwal_id);
        $layanan = SMIS_LayananPasien::findOrFail($antrian->noreg);
        $employee = SmisHrdEmployee::where('id', $jadwal->id_dokter)->first();
        $lokasi = Location::where('nama', $jadwal->nama_poli)->where('slug_klinik', env('slug_klinik'))->first();
        $data = [
            "resourceType" => "Encounter",
            "id" => $antrian->id_encounter,
            "identifier" => [
                json_decode(json_encode([
                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                    "value" => (string) $layanan->id
                ]))
            ],
            "status" => 'in-progress',
            "class" => json_decode(json_encode([
                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                "code" => "AMB",
                "display" => "ambulatory"
            ])),
            "subject" => json_decode(json_encode([
                "reference" => "Patient/" . $pasien->ihs_number,
                "display" => $pasien->nama
            ])),
            "participant" => [
                json_decode(json_encode([
                    "type" => [
                        json_decode(json_encode([
                            "coding" => [
                                json_decode(json_encode([
                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                    "code" => "ATND",
                                    "display" => "attender"
                                ]))
                            ]
                        ]))
                    ],
                    "individual" => json_decode(json_encode([
                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                        "display" => $employee ? $employee->nama : ''
                    ]))
                ]))
            ],
            "period" => json_decode(json_encode([
                "start" => (new DateTime(date('Y-m-d H:i:s', ($antrian->waktu_taskid_empat / 1000))))->format('c'),
                "end" => (new DateTime(date('Y-m-d H:i:s', ($waktu / 1000))))->format('c')
            ])),
            "location" => [
                json_decode(json_encode([
                    "location" => json_decode(json_encode([
                        "reference" => "Location/" . ($lokasi ? $lokasi->id_lokasi : ''),
                        "display" => $lokasi ? $lokasi->nama : ''
                    ]))
                ]))
            ],
            "statusHistory" => [
                json_decode(json_encode([
                    "status" => "arrived",
                    "period" => json_decode(json_encode([
                        "start" => (new DateTime(date('Y-m-d H:i:s', ($antrian->waktu_checkin / 1000))))->format('c'),
                        "end" => (new DateTime(date('Y-m-d H:i:s', ($antrian->waktu_taskid_empat / 1000))))->format('c')
                    ]))
                ])),
                json_decode(json_encode([
                    "status" => "in-progress",
                    "period" => json_decode(json_encode([
                        "start" => (new DateTime(date('Y-m-d H:i:s', ($antrian->waktu_taskid_empat / 1000))))->format('c'),
                        "end" => (new DateTime(date('Y-m-d H:i:s', ($waktu / 1000))))->format('c')
                    ]))
                ]))
            ],
            "serviceProvider" => json_decode(json_encode([
                "reference" => "Organization/" . env('IHS_RS')
            ]))
        ];
        return $data;
    }

    function data_update_finished($antrian, $start, $end)
    {
        $pasien = SMIS_Pasien::where('id', $antrian->norm)->first();
        $jadwal = JadwalPoli::findOrFail($antrian->jadwal_id);
        $layanan = SMIS_LayananPasien::findOrFail($antrian->noreg);
        $employee = SmisHrdEmployee::where('id', $jadwal->id_dokter)->first();
        $lokasi = Location::where('nama', $jadwal->nama_poli)->where('slug_klinik', env('slug_klinik'))->first();
        $diagnosa = SMIS_Diagnosa::where('noreg_pasien', $antrian->noreg)->first();
        $iteration = 2;

        $diagnosis = [
            json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "Condition/" . $antrian->id_diagnosa_primer,
                    "display" => $diagnosa->nama_icd
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => 1
            ]))
        ];

        if ($diagnosa->diagnosa_sekunder1 != '') {
            $temp_sekunder1 = json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "Condition/" . $antrian->id_diagnosa_sekunder,
                    "display" => $diagnosa->diagnosa_sekunder1
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => $iteration
            ]));
            array_push($diagnosis, $temp_sekunder1);
            $iteration++;
        }

        if ($diagnosa->diagnosa_sekunder2 != '') {
            $temp_sekunder2 = json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "Condition/" . $antrian->id_diagnosa_sekunder2,
                    "display" => $diagnosa->diagnosa_sekunder2
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => $iteration
            ]));
            array_push($diagnosis, $temp_sekunder2);
            $iteration++;
        }

        if ($diagnosa->diagnosa_sekunder3 != '') {
            $temp_sekunder3 = json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "Condition/" . $antrian->id_diagnosa_sekunder3,
                    "display" => $diagnosa->diagnosa_sekunder3
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => $iteration
            ]));
            array_push($diagnosis, $temp_sekunder3);
            $iteration++;
        }

        if ($diagnosa->diagnosa_sekunder4 != '') {
            $temp_sekunder4 = json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "Condition/" . $antrian->id_diagnosa_sekunder4,
                    "display" => $diagnosa->diagnosa_sekunder4
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => $iteration
            ]));
            array_push($diagnosis, $temp_sekunder4);
            $iteration++;
        }

        if ($diagnosa->diagnosa_sekunder5 != '') {
            $temp_sekunder5 = json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "Condition/" . $antrian->id_diagnosa_sekunder5,
                    "display" => $diagnosa->diagnosa_sekunder5
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => $iteration
            ]));
            array_push($diagnosis, $temp_sekunder5);
            $iteration++;
        }

        $data = json_decode(json_encode([
            "resourceType" => "Encounter",
            "id" => $antrian->id_encounter,
            "identifier" => [
                json_decode(json_encode([
                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                    "value" => $antrian->noreg
                ]))
            ],
            "status" => "finished",
            "class" => json_decode(json_encode([
                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                "code" => "AMB",
                "display" => "ambulatory"
            ])),
            "subject" => json_decode(json_encode([
                "reference" => "Patient/" . $pasien->ihs_number,
                "display" => $pasien->nama
            ])),
            "participant" => [
                json_decode(json_encode([
                    "type" => [
                        json_decode(json_encode([
                            "coding" => [
                                json_decode(json_encode([
                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                    "code" => "ATND",
                                    "display" => "attender"
                                ]))
                            ]
                        ]))
                    ],
                    "individual" => json_decode(json_encode([
                        "reference" => "Practitioner/" . $employee->ihs_number,
                        "display" => $employee->nama
                    ]))
                ]))
            ],
            "period" => json_decode(json_encode([
                "start" => (new DateTime((date('Y-m-d H:i:s', (($start / 1000)))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                "end" => (new DateTime((date('Y-m-d H:i:s', (($end / 1000)))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
            ])),
            "location" => [
                json_decode(json_encode([
                    "location" => json_decode(json_encode([
                        "reference" => "Location/" . $lokasi->id_lokasi,
                        "display" => $lokasi->nama
                    ]))
                ]))
            ],
            "diagnosis" => $diagnosis,
            "statusHistory" => [
                json_decode(json_encode([
                    "status" => "arrived",
                    "period" => json_decode(json_encode([
                        "start" => (new DateTime(date('Y-m-d H:i:s', (($antrian->waktu_checkin / 1000))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                        "end" => (new DateTime(date('Y-m-d H:i:s', (($antrian->waktu_taskid_empat / 1000))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                    ]))
                ])),
                json_decode(json_encode([
                    "status" => "in-progress",
                    "period" => json_decode(json_encode([
                        "start" => (new DateTime(date('Y-m-d H:i:s', (($antrian->waktu_taskid_empat / 1000))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                        "end" => (new DateTime(date('Y-m-d H:i:s', ((($antrian->waktu_taskid_lima == null ? $end : $antrian->waktu_taskid_lima) / 1000))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                    ]))
                ])),
                json_decode(json_encode([
                    "status" => "finished",
                    "period" => json_decode(json_encode([
                        "start" => (new DateTime(date('Y-m-d H:i:s', ((($antrian->waktu_taskid_lima == null ? $end : $antrian->waktu_taskid_lima) / 1000))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                        "end" => (new DateTime(date('Y-m-d H:i:s', (($end / 1000))), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                    ]))
                ]))
            ],
            "serviceProvider" => json_decode(json_encode([
                "reference" => "Organization/" . env('IHS_RS')
            ]))
        ]));
        return $data;
    }

    function str_replace_first($search, $replace, $subject)
    {
        $search = '/' . preg_quote($search, '/') . '/';
        return preg_replace($search, $replace, $subject, 1);
    }

    function bundle($layanan)
    {
        $pasien = SMIS_Pasien::where('id', $layanan->id_pasien)->where('prop', '')->first();
        $diagnosa = SMIS_Diagnosa::where('noreg_pasien', $layanan->id)->where('prop', '')->first();

        $this->uuid_encounter = $this->generate_uuid();

        $data = $this->append_second_diagnosis($layanan, $pasien, $diagnosa);

        return $data;
    }

    function append_second_diagnosis($layanan, $pasien, $diagnosa)
    {
        $employee = SmisHrdEmployee::where('id', $layanan->id_dokter)->where('prop', '')->first();
        $location = Location::where('nama', 'like', '%' . ucwords(str_replace('_', ' ', $layanan->jenislayanan)) . '%')->where('slug_klinik', env('slug_klinik'))->first();
        $rwt = DB::table('smis_rwt_antrian_' . $layanan->jenislayanan)->where('no_register', $layanan->id)->where('prop', '')->first();

        $icd1 = Smis_Mr_Icd::where('nama', 'like', '%' . $diagnosa->diagnosa_sekunder1 . '%')->where('prop', '')->first();
        $icd2 = Smis_Mr_Icd::where('nama', 'like', '%' . $diagnosa->diagnosa_sekunder2 . '%')->where('prop', '')->first();
        $icd3 = Smis_Mr_Icd::where('nama', 'like', '%' . $diagnosa->diagnosa_sekunder3 . '%')->where('prop', '')->first();
        $icd4 = Smis_Mr_Icd::where('nama', 'like', '%' . $diagnosa->diagnosa_sekunder4 . '%')->where('prop', '')->first();
        $icd5 = Smis_Mr_Icd::where('nama', 'like', '%' . $diagnosa->diagnosa_sekunder5 . '%')->where('prop', '')->first();

        //Jika diagnosa sekunder 5 terisi
        if ($diagnosa->diagnosa_sekunder5 != '' && $diagnosa->diagnosa_sekunder5 != null) {
            return json_decode(json_encode([
                "resourceType" => "Bundle",
                "type" => "transaction",
                "entry" => [
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_encounter,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Encounter",
                            "status" => "finished",
                            "class" => json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                                "code" => "AMB",
                                "display" => "ambulatory"
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "participant" => [
                                json_decode(json_encode([
                                    "type" => [
                                        json_decode(json_encode([
                                            "coding" => [
                                                json_decode(json_encode([
                                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                                    "code" => "ATND",
                                                    "display" => "attender"
                                                ]))
                                            ]
                                        ]))
                                    ],
                                    "individual" => json_decode(json_encode([
                                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                                        "display" => $layanan->nama_dokter
                                    ]))
                                ]))
                            ],
                            "period" => json_decode(json_encode([
                                "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                            ])),
                            "location" => [
                                json_decode(json_encode([
                                    "location" => json_decode(json_encode([
                                        "reference" => "Location/" . ($location ? $location->id_lokasi : ''),
                                        "display" => ($location ? $location->deskripsi : '')
                                    ]))
                                ]))
                            ],
                            "diagnosis" => $this->diagnosis($diagnosa),
                            "statusHistory" => [
                                json_decode(json_encode([
                                    "status" => "arrived",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "in-progress",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "finished",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ]))
                            ],
                            "serviceProvider" => json_decode(json_encode([
                                "reference" => "Organization/" . env('IHS_RS')
                            ])),
                            "identifier" => [
                                json_decode(json_encode([
                                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                                    "value" => (string) $layanan->id
                                ]))
                            ]
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Encounter"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_primer,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $diagnosa ? $diagnosa->kode_icd : "",
                                        "display" => $diagnosa ? $diagnosa->nama_icd : ""
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : "") . " di hari " . $this->hari(date("Y-m-d", strtotime($layanan->tanggal))) . ", " . date("d", strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date("m", strtotime($layanan->tanggal))) . " " . date("Y", strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder1,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd1 ? $icd1->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder1 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder2,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd2 ? $icd2->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder2 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder3,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd3 ? $icd3->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder3 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder4,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd4 ? $icd4->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder4 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder5,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd5 ? $icd5->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder5 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ]))
                ]
            ]));
        }

        //Jika diagnosis sekunder 4 terisi
        if ($diagnosa->diagnosa_sekunder4 != '' && $diagnosa->diagnosa_sekunder4 != null) {
            return json_decode(json_encode([
                "resourceType" => "Bundle",
                "type" => "transaction",
                "entry" => [
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_encounter,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Encounter",
                            "status" => "finished",
                            "class" => json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                                "code" => "AMB",
                                "display" => "ambulatory"
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "participant" => [
                                json_decode(json_encode([
                                    "type" => [
                                        json_decode(json_encode([
                                            "coding" => [
                                                json_decode(json_encode([
                                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                                    "code" => "ATND",
                                                    "display" => "attender"
                                                ]))
                                            ]
                                        ]))
                                    ],
                                    "individual" => json_decode(json_encode([
                                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                                        "display" => $layanan->nama_dokter
                                    ]))
                                ]))
                            ],
                            "period" => json_decode(json_encode([
                                "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                            ])),
                            "location" => [
                                json_decode(json_encode([
                                    "location" => json_decode(json_encode([
                                        "reference" => "Location/" . ($location ? $location->id_lokasi : ''),
                                        "display" => ($location ? $location->deskripsi : '')
                                    ]))
                                ]))
                            ],
                            "diagnosis" => $this->diagnosis($diagnosa),
                            "statusHistory" => [
                                json_decode(json_encode([
                                    "status" => "arrived",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "in-progress",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "finished",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ]))
                            ],
                            "serviceProvider" => json_decode(json_encode([
                                "reference" => "Organization/" . env('IHS_RS')
                            ])),
                            "identifier" => [
                                json_decode(json_encode([
                                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                                    "value" => (string) $layanan->id
                                ]))
                            ]
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Encounter"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_primer,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $diagnosa ? $diagnosa->kode_icd : "",
                                        "display" => $diagnosa ? $diagnosa->nama_icd : ""
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : "") . " di hari " . $this->hari(date("Y-m-d", strtotime($layanan->tanggal))) . ", " . date("d", strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date("m", strtotime($layanan->tanggal))) . " " . date("Y", strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder1,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd1 ? $icd1->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder1 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder2,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd2 ? $icd2->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder2 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder3,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd3 ? $icd3->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder3 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder4,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd4 ? $icd4->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder4 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ]))
                ]
            ]));
        }

        //Jika diagnosa sekunder 3 terisi
        if ($diagnosa->diagnosa_sekunder3 != '' && $diagnosa->diagnosa_sekunder3 != null) {
            return json_decode(json_encode([
                "resourceType" => "Bundle",
                "type" => "transaction",
                "entry" => [
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_encounter,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Encounter",
                            "status" => "finished",
                            "class" => json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                                "code" => "AMB",
                                "display" => "ambulatory"
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "participant" => [
                                json_decode(json_encode([
                                    "type" => [
                                        json_decode(json_encode([
                                            "coding" => [
                                                json_decode(json_encode([
                                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                                    "code" => "ATND",
                                                    "display" => "attender"
                                                ]))
                                            ]
                                        ]))
                                    ],
                                    "individual" => json_decode(json_encode([
                                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                                        "display" => $layanan->nama_dokter
                                    ]))
                                ]))
                            ],
                            "period" => json_decode(json_encode([
                                "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                            ])),
                            "location" => [
                                json_decode(json_encode([
                                    "location" => json_decode(json_encode([
                                        "reference" => "Location/" . ($location ? $location->id_lokasi : ''),
                                        "display" => ($location ? $location->deskripsi : '')
                                    ]))
                                ]))
                            ],
                            "diagnosis" => $this->diagnosis($diagnosa),
                            "statusHistory" => [
                                json_decode(json_encode([
                                    "status" => "arrived",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "in-progress",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "finished",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ]))
                            ],
                            "serviceProvider" => json_decode(json_encode([
                                "reference" => "Organization/" . env('IHS_RS')
                            ])),
                            "identifier" => [
                                json_decode(json_encode([
                                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                                    "value" => (string) $layanan->id
                                ]))
                            ]
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Encounter"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_primer,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $diagnosa ? $diagnosa->kode_icd : "",
                                        "display" => $diagnosa ? $diagnosa->nama_icd : ""
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : "") . " di hari " . $this->hari(date("Y-m-d", strtotime($layanan->tanggal))) . ", " . date("d", strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date("m", strtotime($layanan->tanggal))) . " " . date("Y", strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder1,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd1 ? $icd1->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder1 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder2,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd2 ? $icd2->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder2 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder3,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd3 ? $icd3->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder3 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ]))
                ]
            ]));
        }

        //Jika diagnosa sekunder 2 terisi
        if ($diagnosa->diagnosa_sekunder2 != '' && $diagnosa->diagnosa_sekunder2 != null) {
            return json_decode(json_encode([
                "resourceType" => "Bundle",
                "type" => "transaction",
                "entry" => [
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_encounter,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Encounter",
                            "status" => "finished",
                            "class" => json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                                "code" => "AMB",
                                "display" => "ambulatory"
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "participant" => [
                                json_decode(json_encode([
                                    "type" => [
                                        json_decode(json_encode([
                                            "coding" => [
                                                json_decode(json_encode([
                                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                                    "code" => "ATND",
                                                    "display" => "attender"
                                                ]))
                                            ]
                                        ]))
                                    ],
                                    "individual" => json_decode(json_encode([
                                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                                        "display" => $layanan->nama_dokter
                                    ]))
                                ]))
                            ],
                            "period" => json_decode(json_encode([
                                "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                            ])),
                            "location" => [
                                json_decode(json_encode([
                                    "location" => json_decode(json_encode([
                                        "reference" => "Location/" . ($location ? $location->id_lokasi : ''),
                                        "display" => ($location ? $location->deskripsi : '')
                                    ]))
                                ]))
                            ],
                            "diagnosis" => $this->diagnosis($diagnosa),
                            "statusHistory" => [
                                json_decode(json_encode([
                                    "status" => "arrived",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "in-progress",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "finished",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ]))
                            ],
                            "serviceProvider" => json_decode(json_encode([
                                "reference" => "Organization/" . env('IHS_RS')
                            ])),
                            "identifier" => [
                                json_decode(json_encode([
                                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                                    "value" => (string) $layanan->id
                                ]))
                            ]
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Encounter"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_primer,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $diagnosa ? $diagnosa->kode_icd : "",
                                        "display" => $diagnosa ? $diagnosa->nama_icd : ""
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : "") . " di hari " . $this->hari(date("Y-m-d", strtotime($layanan->tanggal))) . ", " . date("d", strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date("m", strtotime($layanan->tanggal))) . " " . date("Y", strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder1,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd1 ? $icd1->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder1 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder2,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd2 ? $icd2->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder2 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ]))
                ]
            ]));
        }

        //Jika diagnosa sekunder 1 terisi
        if ($diagnosa->diagnosa_sekunder1 != '' && $diagnosa->diagnosa_sekunder1 != null) {
            return json_decode(json_encode([
                "resourceType" => "Bundle",
                "type" => "transaction",
                "entry" => [
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_encounter,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Encounter",
                            "status" => "finished",
                            "class" => json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                                "code" => "AMB",
                                "display" => "ambulatory"
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "participant" => [
                                json_decode(json_encode([
                                    "type" => [
                                        json_decode(json_encode([
                                            "coding" => [
                                                json_decode(json_encode([
                                                    "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                                    "code" => "ATND",
                                                    "display" => "attender"
                                                ]))
                                            ]
                                        ]))
                                    ],
                                    "individual" => json_decode(json_encode([
                                        "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                                        "display" => $layanan->nama_dokter
                                    ]))
                                ]))
                            ],
                            "period" => json_decode(json_encode([
                                "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                            ])),
                            "location" => [
                                json_decode(json_encode([
                                    "location" => json_decode(json_encode([
                                        "reference" => "Location/" . ($location ? $location->id_lokasi : ''),
                                        "display" => ($location ? $location->deskripsi : '')
                                    ]))
                                ]))
                            ],
                            "diagnosis" => $this->diagnosis($diagnosa),
                            "statusHistory" => [
                                json_decode(json_encode([
                                    "status" => "arrived",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "in-progress",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ])),
                                json_decode(json_encode([
                                    "status" => "finished",
                                    "period" => json_decode(json_encode([
                                        "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                        "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                    ]))
                                ]))
                            ],
                            "serviceProvider" => json_decode(json_encode([
                                "reference" => "Organization/" . env('IHS_RS')
                            ])),
                            "identifier" => [
                                json_decode(json_encode([
                                    "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                                    "value" => (string) $layanan->id
                                ]))
                            ]
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Encounter"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_primer,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $diagnosa ? $diagnosa->kode_icd : "",
                                        "display" => $diagnosa ? $diagnosa->nama_icd : ""
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ""
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : "") . " di hari " . $this->hari(date("Y-m-d", strtotime($layanan->tanggal))) . ", " . date("d", strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date("m", strtotime($layanan->tanggal))) . " " . date("Y", strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ])),
                    json_decode(json_encode([
                        "fullUrl" => "urn:uuid:" . $this->uuid_sekunder1,
                        "resource" => json_decode(json_encode([
                            "resourceType" => "Condition",
                            "clinicalStatus" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                        "code" => "active",
                                        "display" => "Active"
                                    ]))
                                ]
                            ])),
                            "category" => [
                                json_decode(json_encode([
                                    "coding" => [
                                        json_decode(json_encode([
                                            "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                            "code" => "encounter-diagnosis",
                                            "display" => "Encounter Diagnosis"
                                        ]))
                                    ]
                                ]))
                            ],
                            "code" => json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://hl7.org/fhir/sid/icd-10",
                                        "code" => $icd1 ? $icd1->icd : '',
                                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder1 : ''
                                    ]))
                                ]
                            ])),
                            "subject" => json_decode(json_encode([
                                "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                                "display" => $pasien ? $pasien->nama : ''
                            ])),
                            "encounter" => json_decode(json_encode([
                                "reference" => "urn:uuid:" . $this->uuid_encounter,
                                "display" => "Kunjungan " . ($pasien ? $pasien->nama : '') . " di hari " . $this->hari(date('Y-m-d', strtotime($layanan->tanggal))) . ", " . date('d', strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date('m', strtotime($layanan->tanggal))) . " " . date('Y', strtotime($layanan->tanggal))
                            ]))
                        ])),
                        "request" => json_decode(json_encode([
                            "method" => "POST",
                            "url" => "Condition"
                        ]))
                    ]))
                ]
            ]));
        }

        return json_decode(json_encode([
            "resourceType" => "Bundle",
            "type" => "transaction",
            "entry" => [
                json_decode(json_encode([
                    "fullUrl" => "urn:uuid:" . $this->uuid_encounter,
                    "resource" => json_decode(json_encode([
                        "resourceType" => "Encounter",
                        "status" => "finished",
                        "class" => json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                            "code" => "AMB",
                            "display" => "ambulatory"
                        ])),
                        "subject" => json_decode(json_encode([
                            "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                            "display" => $pasien ? $pasien->nama : ""
                        ])),
                        "participant" => [
                            json_decode(json_encode([
                                "type" => [
                                    json_decode(json_encode([
                                        "coding" => [
                                            json_decode(json_encode([
                                                "system" => "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                                                "code" => "ATND",
                                                "display" => "attender"
                                            ]))
                                        ]
                                    ]))
                                ],
                                "individual" => json_decode(json_encode([
                                    "reference" => "Practitioner/" . ($employee ? $employee->ihs_number : ''),
                                    "display" => $layanan->nama_dokter
                                ]))
                            ]))
                        ],
                        "period" => json_decode(json_encode([
                            "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                            "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                        ])),
                        "location" => [
                            json_decode(json_encode([
                                "location" => json_decode(json_encode([
                                    "reference" => "Location/" . ($location ? $location->id_lokasi : ''),
                                    "display" => ($location ? $location->deskripsi : '')
                                ]))
                            ]))
                        ],
                        "diagnosis" => $this->diagnosis($diagnosa),
                        "statusHistory" => [
                            json_decode(json_encode([
                                "status" => "arrived",
                                "period" => json_decode(json_encode([
                                    "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c'),
                                    "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->format('c')
                                ]))
                            ])),
                            json_decode(json_encode([
                                "status" => "in-progress",
                                "period" => json_decode(json_encode([
                                    "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                    "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                ]))
                            ])),
                            json_decode(json_encode([
                                "status" => "finished",
                                "period" => json_decode(json_encode([
                                    "start" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c'),
                                    "end" => (new DateTime(date('Y-m-d H:i:s', strtotime($layanan->tanggal)), new \DateTimeZone("Asia/Jakarta")))->modify("+10 minutes")->format('c')
                                ]))
                            ]))
                        ],
                        "serviceProvider" => json_decode(json_encode([
                            "reference" => "Organization/" . env('IHS_RS')
                        ])),
                        "identifier" => [
                            json_decode(json_encode([
                                "system" => "http://sys-ids.kemkes.go.id/encounter/" . env('IHS_RS'),
                                "value" => (string) $layanan->id
                            ]))
                        ]
                    ])),
                    "request" => json_decode(json_encode([
                        "method" => "POST",
                        "url" => "Encounter"
                    ]))
                ])),
                json_decode(json_encode([
                    "fullUrl" => "urn:uuid:" . $this->uuid_primer,
                    "resource" => json_decode(json_encode([
                        "resourceType" => "Condition",
                        "clinicalStatus" => json_decode(json_encode([
                            "coding" => [
                                json_decode(json_encode([
                                    "system" => "http://terminology.hl7.org/CodeSystem/condition-clinical",
                                    "code" => "active",
                                    "display" => "Active"
                                ]))
                            ]
                        ])),
                        "category" => [
                            json_decode(json_encode([
                                "coding" => [
                                    json_decode(json_encode([
                                        "system" => "http://terminology.hl7.org/CodeSystem/condition-category",
                                        "code" => "encounter-diagnosis",
                                        "display" => "Encounter Diagnosis"
                                    ]))
                                ]
                            ]))
                        ],
                        "code" => json_decode(json_encode([
                            "coding" => [
                                json_decode(json_encode([
                                    "system" => "http://hl7.org/fhir/sid/icd-10",
                                    "code" => $diagnosa ? $diagnosa->kode_icd : "",
                                    "display" => $diagnosa ? $diagnosa->nama_icd : ""
                                ]))
                            ]
                        ])),
                        "subject" => json_decode(json_encode([
                            "reference" => "Patient/" . ($pasien ? $pasien->ihs_number : ""),
                            "display" => $pasien ? $pasien->nama : ""
                        ])),
                        "encounter" => json_decode(json_encode([
                            "reference" => "urn:uuid:" . $this->uuid_encounter,
                            "display" => "Kunjungan " . ($pasien ? $pasien->nama : "") . " di hari " . $this->hari(date("Y-m-d", strtotime($layanan->tanggal))) . ", " . date("d", strtotime($layanan->tanggal)) . " " . $this->reformat_bulan_indo(date("m", strtotime($layanan->tanggal))) . " " . date("Y", strtotime($layanan->tanggal))
                        ]))
                    ])),
                    "request" => json_decode(json_encode([
                        "method" => "POST",
                        "url" => "Condition"
                    ]))
                ]))
            ]
        ]));
    }

    function diagnosis($diagnosa)
    {
        $diagnosis = [];

        $this->uuid_primer = $this->generate_uuid();
        $this->uuid_sekunder1 = $this->generate_uuid();
        $this->uuid_sekunder2 = $this->generate_uuid();
        $this->uuid_sekunder3 = $this->generate_uuid();
        $this->uuid_sekunder4 = $this->generate_uuid();
        $this->uuid_sekunder5 = $this->generate_uuid();

        if ($diagnosa != null) {
            array_push($diagnosis, json_decode(json_encode([
                "condition" => json_decode(json_encode([
                    "reference" => "urn:uuid:" . $this->uuid_primer,
                    "display" => $diagnosa ? $diagnosa->nama_icd : ""
                ])),
                "use" => json_decode(json_encode([
                    "coding" => [
                        json_decode(json_encode([
                            "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                            "code" => "DD",
                            "display" => "Discharge diagnosis"
                        ]))
                    ]
                ])),
                "rank" => 1
            ])));

            if ($diagnosa->diagnosa_sekunder1 != '' && $diagnosa->diagnosa_sekunder1 != null) {
                array_push($diagnosis, json_decode(json_encode([
                    "condition" => json_decode(json_encode([
                        "reference" => "urn:uuid:" . $this->uuid_sekunder1,
                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder1 : ''
                    ])),
                    "use" => json_decode(json_encode([
                        "coding" => [
                            json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                                "code" => "DD",
                                "display" => "Discharge diagnosis"
                            ]))
                        ]
                    ])),
                    "rank" => 2
                ])));
            }

            if ($diagnosa->diagnosa_sekunder2 != '' && $diagnosa->diagnosa_sekunder2 != null) {
                array_push($diagnosis, json_decode(json_encode([
                    "condition" => json_decode(json_encode([
                        "reference" => "urn:uuid:" . $this->uuid_sekunder2,
                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder2 : ''
                    ])),
                    "use" => json_decode(json_encode([
                        "coding" => [
                            json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                                "code" => "DD",
                                "display" => "Discharge diagnosis"
                            ]))
                        ]
                    ])),
                    "rank" => 3
                ])));
            }

            if ($diagnosa->diagnosa_sekunder3 != '' && $diagnosa->diagnosa_sekunder3 != null) {
                array_push($diagnosis, json_decode(json_encode([
                    "condition" => json_decode(json_encode([
                        "reference" => "urn:uuid:" . $this->uuid_sekunder3,
                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder3 : ''
                    ])),
                    "use" => json_decode(json_encode([
                        "coding" => [
                            json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                                "code" => "DD",
                                "display" => "Discharge diagnosis"
                            ]))
                        ]
                    ])),
                    "rank" => 4
                ])));
            }

            if ($diagnosa->diagnosa_sekunder4 != '' && $diagnosa->diagnosa_sekunder4 != null) {
                array_push($diagnosis, json_decode(json_encode([
                    "condition" => json_decode(json_encode([
                        "reference" => "urn:uuid:" . $this->uuid_sekunder4,
                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder4 : ''
                    ])),
                    "use" => json_decode(json_encode([
                        "coding" => [
                            json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                                "code" => "DD",
                                "display" => "Discharge diagnosis"
                            ]))
                        ]
                    ])),
                    "rank" => 5
                ])));
            }

            if ($diagnosa->diagnosa_sekunder5 != '' && $diagnosa->diagnosa_sekunder5 != null) {
                array_push($diagnosis, json_decode(json_encode([
                    "condition" => json_decode(json_encode([
                        "reference" => "urn:uuid:" . $this->uuid_sekunder5,
                        "display" => $diagnosa ? $diagnosa->diagnosa_sekunder5 : ''
                    ])),
                    "use" => json_decode(json_encode([
                        "coding" => [
                            json_decode(json_encode([
                                "system" => "http://terminology.hl7.org/CodeSystem/diagnosis-role",
                                "code" => "DD",
                                "display" => "Discharge diagnosis"
                            ]))
                        ]
                    ])),
                    "rank" => 6
                ])));
            }
        }
        return $diagnosis;
    }

    function reformat_bulan_indo($param)
    {
        if ($param == '' || $param == null) {
            return '';
        }
        switch ($param) {
            case '01':
                return 'Januari';
                break;
            case '02':
                return 'Februari';
                break;
            case '03':
                return 'maret';
                break;
            case '04':
                return 'April';
                break;
            case '05':
                return 'Mei';
                break;
            case '06':
                return 'Juni';
                break;
            case '07':
                return 'Juli';
                break;
            case '08':
                return 'Agustus';
                break;
            case '09':
                return 'September';
                break;
            case '10':
                return 'Oktober';
                break;
            case '11':
                return 'November';
                break;
            case '12':
                return 'Desember';
                break;
            default:
                return '';
                break;
        }
    }

    function hari($param)
    {
        if ($param == '' || $param == null) {
            return '';
        }

        switch (date('w', strtotime($param))) {
            case '0':
                return 'Minggu';
                break;
            case '1':
                return 'Senin';
                break;
            case '2':
                return 'Selasa';
                break;
            case '3':
                return 'Rabu';
                break;
            case '4':
                return 'Kamis';
                break;
            case '5':
                return "Jum'at";
                break;
            case '6':
                return 'Sabtu';
                break;
            default:
                return '';
                break;
        }
    }

    function generate_uuid()
    {
        $data = openssl_random_pseudo_bytes(16);
        assert(strlen($data) == 16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
        return vsprintf("%s%s-%s-%s-%s-%s%s%s", str_split(bin2hex($data), 4));
    }
}
