<?php

namespace App\Services;

use App\Models\PemeriksaanPcrAntigen;
use Illuminate\Support\Facades\DB;
use Throwable;

/**
 * Class Services
 * @author rivald 
 */
class PemeriksaanPcrAntigenService
{

    public function getPetugas()
    {
        return DB::table('smis_hrd_employee')->where([
            ['prop', ''],
            ['keluar', 0]
        ])->get();
    }

    public function store($param)
    {
        try {
            PemeriksaanPcrAntigen::updateOrInsert(
                [
                    'id' => $param->id
                ],
                $param->except('id', '_token', '_method', 'nama')
            );

            return "sukses";
        } catch (Throwable $e) {
            return $e->getMessage();
        }
    }

    public function getPemeriksaanPcrAntigenById($param)
    {
        $dataSuratSehat = DB::table('pemeriksaan_pcr_antigens as pemeriksaan')
            ->join('smis_rg_patient as pasien', 'pemeriksaan.nrm', 'pasien.id')
            ->select('*', 'pemeriksaan.id as id_surat')
            ->where([
                ['pemeriksaan.prop', ''],
                ['pasien.prop', ''],
                ['pemeriksaan.id', $param]
            ])->first();

        return $dataSuratSehat;
    }

    public function getPemeriksaanPcrAntigen($param = null)
    {
        $dataSuratSehat = DB::table('pemeriksaan_pcr_antigens as pemeriksaan')
            ->join('smis_rg_patient as pasien', 'pemeriksaan.nrm', 'pasien.id')
            ->select('*', 'pemeriksaan.id as id_surat')
            ->where([
                ['pemeriksaan.prop', ''],
                ['pasien.prop', '']
            ]);

        if (isset($param)) {
            return $dataSuratSehat->where('pasien.nama', $param);
        }

        return $dataSuratSehat->orderBy('pemeriksaan.id', 'desc');
    }

    public function delete($id)
    {
        try {
            PemeriksaanPcrAntigen::where('id', $id)->update(['prop' => 'del']);
            return "sukses";
        } catch (Throwable $e) {
            return $e->getMessage();
        }
    }
}
