<?php

namespace App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Models\Smis_Er_Resep;
use App\Services\LaboratoriumService;
use App\Services\MedicalRecord\ERekamMedisService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class PengkajianKeperawatanRawatJalanService {
    function data($req)
    {
        $dokumen = DB::table('dokumen_kunjungan_pasien')->where('id', $req->dokumen)->first();
        $layanan = DB::table('smis_rg_layananpasien')->where('id', $dokumen->noreg)->first();
        $data = DB::table('smis_doc_pengkajian_keperawatan_rawat_jalan')->where('id_dokumen', $req->dokumen)->first();

        $diagnosa = DB::table('smis_mr_diagnosa')->where('id', $data->id_diagnosa ?? 0)->first();

        if (is_null($diagnosa)) {
            $diagnosa = DB::table('smis_mr_diagnosa')->where('noreg_pasien', $layanan->id)->where('prop','')->first();
        }

        return [
            'dokumen' => $dokumen,
            'data' => $data,
            'layanan' => $layanan,
            'pasien' => DB::table('smis_rg_patient')->where('id', $layanan->id_pasien)->first(),
            'diagnosa' => $diagnosa,
            'laboratorium' => (new LaboratoriumService)->last_by_noreg($dokumen->noreg),
            'pemeriksaan' => DB::table('smis_lab_layanan')->where('prop', '')->get(),
            'employee' => DB::table('smis_hrd_employee')->where('nama', $dokumen->nama_verifikator ?? '')->where('prop','')->first()
        ];
    }

    function store($req)
    {
        $arr_ins = $req->all();

        $arr_ins['hambatan'] = $arr_ins['form_hambatan'];
        $arr_ins['pemahaman_penyakit'] = $arr_ins['form_pemahaman_penyakit'];
        $arr_ins['pemahaman_pengobatan'] = $arr_ins['form_pemahaman_pengobatan'];
        $arr_ins['pemahaman_perawatan'] = $arr_ins['form_pemahaman_perawatan'];
        $arr_ins['pemahaman_keamanan_penggunaan_alkes'] = $arr_ins['form_pemahaman_keamanan_penggunaan_alkes'];
        $arr_ins['pemahaman_nutrisi_diet'] = $arr_ins['form_pemahaman_nutrisi_diet'];
        $arr_ins['pemahaman_manajemen_nyeri'] = $arr_ins['form_pemahaman_manajemen_nyeri'];
        $arr_ins['penglihatan'] = $arr_ins['form_penglihatan'];
        $arr_ins['penciuman'] = $arr_ins['form_penciuman'];
        $arr_ins['pendengaran'] = $arr_ins['form_pendengaran'];
        $arr_ins['kebiasaan_bak_bab'] = $arr_ins['form_kebiasaan_bak_bab'];
        $arr_ins['penurunan_bb'] = $arr_ins['form_penurunan_bb'];
        $arr_ins['nafsu_makan'] = $arr_ins['form_nafsu_makan'];
        $arr_ins['status_gizi'] = $arr_ins['form_status_gizi'];
        $arr_ins['pemeriksaan_penunjang'] = $arr_ins['form_pemeriksaan_penunjang'];

        foreach ($arr_ins as $ins => $value) {
            if (is_null($value)) {
                $arr_ins[$ins] = "";
            }
        }

        unset($arr_ins['form_pemeriksaan_penunjang']);
        unset($arr_ins['form_penurunan_bb']);
        unset($arr_ins['form_nafsu_makan']);
        unset($arr_ins['form_status_gizi']);
        unset($arr_ins['form_hambatan']);
        unset($arr_ins['form_pemahaman_penyakit']);
        unset($arr_ins['form_pemahaman_pengobatan']);
        unset($arr_ins['form_pemahaman_perawatan']);
        unset($arr_ins['form_pemahaman_keamanan_penggunaan_alkes']);
        unset($arr_ins['form_pemahaman_nutrisi_diet']);
        unset($arr_ins['form_pemahaman_manajemen_nyeri']);
        unset($arr_ins['form_penglihatan']);
        unset($arr_ins['form_penciuman']);
        unset($arr_ins['form_pendengaran']);
        unset($arr_ins['form_kebiasaan_bak_bab']);
        unset($arr_ins['_token']);
        unset($arr_ins['password']);
        unset($arr_ins['dokumen']);

        $arr_ins['updated_at'] = date('Y-m-d H:i:s');

        $query = DB::table('smis_doc_pengkajian_keperawatan_rawat_jalan')->updateOrInsert([
            'id_dokumen' => $req->dokumen
        ], $arr_ins);

        (new ERekamMedisService)->verifikasi_dokumen_kunjungan($req);

        return $query;
    }
}