<?php

namespace App\Services;

use App\Models\AntrianPendaftaran;

/**
 * Class Services
 * @author mrivaldo 
 */
class AntrianManualService
{
    public function getLastAntrian()
    {
        $lastQueue = AntrianPendaftaran::where([
            ['tanggal', date('Y-m-d')]
        ])->where('unit_kerja', env('NAMA_KLINIK'))->first();
        return $lastQueue;
    }

    public function getAntrian()
    {
        $lastQueue = AntrianPendaftaran::where([
            ['tanggal', date('Y-m-d')],
        ])->where('unit_kerja', env('NAMA_KLINIK'))->first();

        try {
            AntrianPendaftaran::updateOrCreate(
                [
                    'tanggal' => date('Y-m-d'),
                    'unit_kerja' => env('NAMA_KLINIK')
                ],
                [
                    'last_queue' => empty($lastQueue) ? 1 : $lastQueue->last_queue + 1,
                    'last_call' => empty($lastQueue) ? 0 : $lastQueue->last_call
                ]
            );

            return empty($lastQueue) ? 1 : $lastQueue->last_queue + 1;
        } catch (Exception $e) {
            return false;
        }
    }

    function next()
    {
        $data = AntrianPendaftaran::where('tanggal', date('Y-m-d'))->where('unit_kerja', env('NAMA_KLINIK'))->first();
        $query = AntrianPendaftaran::where('tanggal', date('Y-m-d'))->where('unit_kerja', env('NAMA_KLINIK'))
            ->update([
                'last_call' => $data->last_call + 1
            ]);
        return $query;
    }
}
