<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DokumenKunjungan extends Model
{
    use HasFactory;

    protected $table = 'dokumen_kunjungan_pasien';

    protected $guarded = ['id'];

    function konsultasi_poli_lain(){
        return $this->hasOne('App\Models\KonsultasiPoliLain', 'id_dokumen', 'id');
    }

    function informed_consent(){
        return $this->hasOne('App\Models\InformedConsent', 'id_dokumen', 'id');
    }

    function pembedahan_operasi_kecil(){
        return $this->hasOne('App\Models\PembedahanOperasiKecil', 'id_dokumen', 'id');
    }

    function surat_keterangan_sakit(){
        return $this->hasOne('App\Models\SuratKeteranganSakit', 'id_dokumen', 'id');
    }

    function observasi_pasca_operasi(){
        return $this->hasMany('App\Models\ObservasiPascaOperasi', 'id_dokumen');
    }

    function catatan_perkembangan_pasien(){
        return $this->hasOne('App\Models\CatatanPerkembanganPasien', 'id_dokumen', 'id');
    }

    function pengkajian_awal_medis(){
        return $this->hasOne('App\Models\Smis_Doc_Pengkajian_Awal_Medis', 'id_dokumen', 'id');
    }

    function diagnosa(){
        return $this->hasOne('App\Models\SMIS_Diagnosa', 'noreg_pasien', 'noreg');
    }

    function pesanan_lab(){
        return $this->hasMany('App\Models\Smis_Lab_Pesanan', 'noreg_pasien', 'noreg')->where('prop','')->orderBy('id', 'asc');
    }

    function asesmen_medis_awal_rajal()
    {
        return $this->hasOne('App\Models\Smis_Doc_Asesmen_Medis_Awal_Rajal', 'id_dokumen');
    }

    function asesmen_medis_awal_rajal_gigi()
    {
        return $this->hasOne('App\Models\Smis_Doc_Asesmen_Medis_Awal_Rajal_Gigi', 'id_dokumen');
    }

    function pengkajian_keperawatan_rawat_jalan()
    {
        return $this->hasOne('App\Models\Smis_Doc_Pengkajian_Keperawatan_Rawat_Jalan', 'id_dokumen');
    }
}
