<?php

namespace App\Http\Controllers;

use App\Http\Requests\TukarTandaTerimaRequest;
use App\Services\TukarTandaTerimaService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;

class TukarTandaTerimaController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'keuangan_kas_bank')) {
                $arr = (array) $menu->keuangan_kas_bank;
                if ($arr['tukar_tanda_terima'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(TukarTandaTerimaService $tukarTandaTerimaService)
    {
        return view('tukar_tanda_terima.index', [
            'tanda_terimas' => $tukarTandaTerimaService->getTandaTerima()->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(TukarTandaTerimaService $tukarTandaTerimaService)
    {
        return view('tukar_tanda_terima.detail', [
            'nama_suppliers' => $tukarTandaTerimaService->getSupplier(),
            'fakturs' => $tukarTandaTerimaService->getNoFaktur(),
            'no_tt' => $tukarTandaTerimaService->getNoTt()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(TukarTandaTerimaRequest $request, TukarTandaTerimaService $tukarTandaTerimaService)
    {
        $createData = $tukarTandaTerimaService->store($request);
        if ($createData == "sukses") {
            Alert::success("Sukses", "Data Berhasil Diperbarui");
            return redirect(route('tukar_tanda_terima.index'));
        }
        return redirect()->back()->withErrors($createData);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request, TukarTandaTerimaService $tukarTandaTerimaService)
    {
        return view('tukar_tanda_terima.index', [
            'tanda_terimas' => $tukarTandaTerimaService->search($request)->get()
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, TukarTandaTerimaService $tukarTandaTerimaService)
    {
        //dd($tukarTandaTerimaService->getFakturById($id));
        return view('tukar_tanda_terima.detail_edit', [
            'nama_suppliers' => $tukarTandaTerimaService->getSupplier(),
            'fakturs' => $tukarTandaTerimaService->getNoFaktur(),
            'detail_fakturs' => $tukarTandaTerimaService->getFakturById($id),
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, TukarTandaTerimaService $tukarTandaTerimaService)
    {
        $destroyData = $tukarTandaTerimaService->destroy($id);
        if ($destroyData == "sukses") {
            Alert::success("Sukses", "Data Berhasil Dihapus");
            return redirect(route('tukar_tanda_terima.index'));
        }
        return redirect()->back()->withErrors($createData);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function download($id, TukarTandaTerimaService $tukarTandaTerimaService)
    {
        $data = $tukarTandaTerimaService->getFakturById($id);
        $pdf = PDF::loadView('tukar_tanda_terima.pdf', [
            'data' => $data,
        ]);
        return $pdf->download('Tanda Terima Faktur.pdf');
    }
}
