<?php

namespace App\Http\Controllers\MedicalRecord\ERekamMedis\DokumenKunjungan;

use App\Http\Controllers\Controller;
use App\Services\MedicalRecord\ERekamMedis\DokumenKunjungan\AsesmenMedisAwalRawatJalanService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class AsesmenMedisAwalRawatJalanController extends Controller
{
    function index(Request $req)
    {
        return view('medical_record.e_rekam_medis.dokumen_kunjungan.asesmen_medis_awal_rawat_jalan', (new AsesmenMedisAwalRawatJalanService)->data($req));
    }

    function store(Request $req)
    {
        try {
            if (isset($req->password) && (Auth::user()->password != md5($req->password))) {
                return response()->json([
                    'status' => false,
                    'message' => 'Password anda salah',
                    'code' => 401
                ]);
            }

            (new AsesmenMedisAwalRawatJalanService)->store($req);

            return response()->json([
                'status' => true,
                'message' => 'Ok',
                'code' => 200,
                'employee' => DB::table('smis_hrd_employee')->where('nama', Auth::user()->realname ?? '')->where('prop','')->first()
            ]);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => false,
                'message' => $th->getMessage(),
                'code' => 500
            ]);
        }
    }
}
