<?php

namespace App\Http\Controllers;

use App\Exports\LaporanDetailTindakanExport;
use App\Http\Requests\LaporanTindakanDetailRequest;
use App\Services\LaporanTindakanDetailDokterService;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class LaporanTindakanDetailDokterController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'kasir')) {
                $arr = (array) $menu->kasir;
                if ($arr['laporan_tindakan_detail_dokter'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    public function index(LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return view('laporan_tindakan_detail_dokter.index', [
            'tanggal_dari' => date('Y-m-d'),
            'tanggal_sampai' => date('Y-m-d'),
            'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName(),
            'req_nama_dokter' => " "
        ]);
    }

    public function filter(LaporanTindakanDetailRequest $request, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return view('laporan_tindakan_detail_dokter.index', [
            'tanggal_dari' => $request->tanggal_dari_conv,
            'tanggal_sampai' => $request->tanggal_sampai_conv,
            'req_nama_dokter' => $request->nama_dokter,
            'data_operator' => $laporanTindakanDetailDokterService->getDataByFilter($request, "operator")->paginate(10),
            'data_referal' => $laporanTindakanDetailDokterService->getDataByFilter($request, "referal")->paginate(10),
            'referal_lab' => $laporanTindakanDetailDokterService->getDataByFilter($request, "lab")->paginate(10),
            'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName()
        ]);
    }

    public function download(LaporanTindakanDetailRequest $request, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return Excel::download(new LaporanDetailTindakanExport($request), 'Laporan Jasa Dokter ' . $request->nama_dokter . '.xlsx');
    }
}
