<?php

namespace App\Http\Controllers;

use App\Exports\JasaDokterBpjsExport;
use App\Http\Requests\JasaDokterBpjsRequest;
use App\Services\JasaDokterBpjsService;
use App\Services\LaporanTindakanDetailDokterService;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class JasaDokterBpjsController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $menu = json_decode(Auth::user()->menu);
            if (property_exists($menu, 'kasir')) {
                $arr = (array) $menu->kasir;
                if ($arr['jasa_dokter_bpjs'] == 0) {
                    return redirect('home');
                }
            } else {
                return redirect('home');
            }
            return $next($request);
        });
    }

    public function index(LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return view('jasa_dokter_bpjs.index', [
            'tanggal_dari' => date('Y-m-d'),
            'tanggal_sampai' => date('Y-m-d'),
            'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName(),
            'req_nama_dokter' => " "
        ]);
    }

    public function filter(JasaDokterBpjsRequest $request, JasaDokterBpjsService $jasaDokterBpjsService, LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return view('jasa_dokter_bpjs.index', [
            'tanggal_dari' => $request->tanggal_dari_conv,
            'tanggal_sampai' => $request->tanggal_sampai_conv,
            'req_nama_dokter' => $request->nama_dokter,
            'data_operator' => $jasaDokterBpjsService->getDataByFilter($request, "operator")->paginate(10),
            'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName()
        ]);
    }

    public function download(JasaDokterBpjsRequest $request, JasaDokterBpjsService $jasaDokterBpjsService)
    {

        return Excel::download(new JasaDokterBpjsExport($request), 'Laporan Jasa Dokter (BPJS) ' . $request->nama_dokter . '.xlsx');
        return view('jasa_dokter_bpjs.excel', [
            'tanggal_dari' => $request->tanggal_dari_conv,
            'tanggal_sampai' => $request->tanggal_sampai_conv,
            'req_nama_dokter' => $request->nama_dokter,
            'data_operator' => $jasaDokterBpjsService->getDataByFilter($request, "operator")->paginate(10),
            //'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName()
        ]);
    }
}
