<?php

namespace App\Http\Controllers;

use App\Exports\DiskonPenjualanObatDokterExport;
use App\Http\Requests\DiskonPenjualanObatDokterRequest;
use App\Services\DiskonPenjualanObatDokterService;
use App\Services\LaporanTindakanDetailDokterService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class DiskonPenjualanObatDokterController extends Controller
{
    public function index(LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService)
    {
        return view('diskon_penjualan_obat_dokter.index', [
            'tanggal_dari' => date('Y-m-d'),
            'tanggal_sampai' => date('Y-m-d'),
            'req_nama_dokter' => '',
            'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName()->get()
        ]);
    }

    public function filter(
        DiskonPenjualanObatDokterRequest $request,
        DiskonPenjualanObatDokterService $diskonPenjualanObatDokterService,
        LaporanTindakanDetailDokterService $laporanTindakanDetailDokterService
    ) {
        return view('diskon_penjualan_obat_dokter.index', [
            'tanggal_dari' => $request->tanggal_dari,
            'tanggal_sampai' => $request->tanggal_sampai,
            'req_nama_dokter' => $request->nama_dokter,
            'list_nama_dokter' => $laporanTindakanDetailDokterService->getDokterName()->get(),
            'penjualan_resep' => $diskonPenjualanObatDokterService->getPenjualanResep($request)->paginate(10)
        ]);
    }

    public function download(DiskonPenjualanObatDokterRequest $request, DiskonPenjualanObatDokterService $diskonPenjualanObatDokterService)
    {
        return Excel::download(new DiskonPenjualanObatDokterExport($request), 'Laporan Diskon Dokter.xlsx');
        return view('diskon_penjualan_obat_dokter.excel', [
            'tanggal_dari' => $request->tanggal_dari,
            'tanggal_sampai' => $request->tanggal_sampai,
            'req_nama_dokter' => $request->nama_dokter,
            'penjualan_resep' => $diskonPenjualanObatDokterService->getPenjualanResep($request)->get()
        ]);
    }
}
