<?php

namespace App\Http\Controllers\DataIndukPendaftaran;

use App\Http\Controllers\Controller;
use App\Services\DataIndukPendaftaranService;
use Illuminate\Http\Request;
use PDF;
use RealRashid\SweetAlert\Facades\Alert;

class ProvinsiController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.provinsi', [
            'role' => 'provinsi',
            'data' => $dataIndukPendaftaranService->getData('smis_rg_propinsi')->paginate(10),
            'keyword' => ''
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $store = $dataIndukPendaftaranService->createProvinsi($request);
        if ($store == 'sukses') {
            Alert::success('Berhasil', 'Provinsi berhasil ditambahkan');
        } else {
            Alert::error('Gagal', $store);
        }
        return redirect()->route('provinsi.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return response()->json($dataIndukPendaftaranService->getDataById($id, 'smis_rg_propinsi'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $update = $dataIndukPendaftaranService->updateProvinsi($request);
        if ($update == 'sukses') {
            Alert::success('Berhasil', 'Provinsi berhasil diperbarui');
        } else {
            Alert::error('Gagal', $update);
        }
        return redirect()->route('provinsi.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        $delete = $dataIndukPendaftaranService->deleteData($id, 'smis_rg_propinsi');
        if ($delete == 'sukses') {
            Alert::success('Berhasil', 'Provinsi berhasil dihapus');
        } else {
            Alert::error('Gagal', $delete);
        }
        return redirect()->route('provinsi.index');
    }

    public function search(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        return view('data_induk_pendaftaran.provinsi', [
            'role' => 'provinsi',
            'data' => $dataIndukPendaftaranService->getSearchProvinsi($request)->paginate(10),
            'keyword' => $request->keyword
        ]);
    }

    public function download(Request $request, DataIndukPendaftaranService $dataIndukPendaftaranService)
    {
        PDF::setOptions(['dpi' => 150, 'defaultFont' => 'sans-serif']);
        $pdf = PDF::loadView('data_induk_pendaftaran.pdf_provinsi', [
            'data' => $dataIndukPendaftaranService->getSearchProvinsi($request)->get()
        ])->setPaper('a4', 'portrait');
        return $pdf->download('Provinsi.pdf');
    }
}
